/*
 * Decompiled with CFR 0.152.
 */
package androidx.legacy.content;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.Log;
import android.util.SparseArray;

@Deprecated
public abstract class WakefulBroadcastReceiver
extends BroadcastReceiver {
    private static final String EXTRA_WAKE_LOCK_ID = "androidx.contentpager.content.wakelockid";
    private static final SparseArray<PowerManager.WakeLock> sActiveWakeLocks = new SparseArray();
    private static int mNextId = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName startWakefulService(Context context, Intent intent) {
        SparseArray<PowerManager.WakeLock> sparseArray = sActiveWakeLocks;
        synchronized (sparseArray) {
            int id2 = mNextId++;
            if (mNextId <= 0) {
                mNextId = 1;
            }
            intent.putExtra(EXTRA_WAKE_LOCK_ID, id2);
            ComponentName comp = context.startService(intent);
            if (comp == null) {
                return null;
            }
            PowerManager pm = (PowerManager)context.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, "androidx.core:wake:" + comp.flattenToShortString());
            wl.setReferenceCounted(false);
            wl.acquire(60000L);
            sActiveWakeLocks.put(id2, wl);
            return comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean completeWakefulIntent(Intent intent) {
        int id2 = intent.getIntExtra(EXTRA_WAKE_LOCK_ID, 0);
        if (id2 == 0) {
            return false;
        }
        SparseArray<PowerManager.WakeLock> sparseArray = sActiveWakeLocks;
        synchronized (sparseArray) {
            PowerManager.WakeLock wl = sActiveWakeLocks.get(id2);
            if (wl != null) {
                wl.release();
                sActiveWakeLocks.remove(id2);
                return true;
            }
            Log.w("WakefulBroadcastReceiv.", "No active wake lock id #" + id2);
            return true;
        }
    }
}

