/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.core.os.ConfigurationCompat;
import com.google.android.gms.base.R;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.R;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.Locale;
import javax.annotation.concurrent.GuardedBy;

public final class zac {
    @GuardedBy(value="sCache")
    private static final SimpleArrayMap zaa;
    @Nullable
    @GuardedBy(value="sCache")
    private static Locale zab;

    public static String zaa(Context object) {
        String string2 = ((Context)object).getPackageName();
        try {
            String string3 = ((Object)Wrappers.packageManager((Context)object).getApplicationLabel(string2)).toString();
            return string3;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException exception) {
            object = ((Context)object).getApplicationInfo().name;
            if (TextUtils.isEmpty((CharSequence)object)) {
                return string2;
            }
            return object;
        }
    }

    public static String zab(Context context) {
        return context.getResources().getString(R.string.common_google_play_services_notification_channel_name);
    }

    @NonNull
    public static String zac(Context object, int n) {
        object = ((Context)object).getResources();
        switch (n) {
            default: {
                return object.getString(17039370);
            }
            case 3: {
                return object.getString(R.string.common_google_play_services_enable_button);
            }
            case 2: {
                return object.getString(R.string.common_google_play_services_update_button);
            }
            case 1: 
        }
        return object.getString(R.string.common_google_play_services_install_button);
    }

    @NonNull
    public static String zad(Context context, int n) {
        Resources resources = context.getResources();
        String string2 = zac.zaa(context);
        switch (n) {
            case 20: {
                return zac.zah(context, "common_google_play_services_restricted_profile_text", string2);
            }
            case 18: {
                int n2 = R.string.common_google_play_services_updating_text;
                Object[] objectArray = new Object[]{string2};
                return resources.getString(n2, objectArray);
            }
            case 17: {
                return zac.zah(context, "common_google_play_services_sign_in_failed_text", string2);
            }
            case 16: {
                return zac.zah(context, "common_google_play_services_api_unavailable_text", string2);
            }
            case 9: {
                int n3 = R.string.common_google_play_services_unsupported_text;
                Object[] objectArray = new Object[]{string2};
                return resources.getString(n3, objectArray);
            }
            case 7: {
                return zac.zah(context, "common_google_play_services_network_error_text", string2);
            }
            case 5: {
                return zac.zah(context, "common_google_play_services_invalid_account_text", string2);
            }
            case 3: {
                int n4 = R.string.common_google_play_services_enable_text;
                Object[] objectArray = new Object[]{string2};
                return resources.getString(n4, objectArray);
            }
            case 2: {
                if (DeviceProperties.isWearableWithoutPlayStore(context)) {
                    return resources.getString(R.string.common_google_play_services_wear_update_text);
                }
                int n5 = R.string.common_google_play_services_update_text;
                Object[] objectArray = new Object[]{string2};
                return resources.getString(n5, objectArray);
            }
            default: {
                int n6 = R.string.common_google_play_services_unknown_issue;
                Object[] objectArray = new Object[]{string2};
                return resources.getString(n6, objectArray);
            }
            case 1: 
        }
        int n7 = R.string.common_google_play_services_install_text;
        Object[] objectArray = new Object[]{string2};
        return resources.getString(n7, objectArray);
    }

    @NonNull
    public static String zae(Context context, int n) {
        if (n == 6 || n == 19) {
            return zac.zah(context, "common_google_play_services_resolution_required_text", zac.zaa(context));
        }
        return zac.zad(context, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static String zaf(Context context, int n) {
        String string2 = n == 6 ? zac.zai(context, "common_google_play_services_resolution_required_title") : zac.zag(context, n);
        if (string2 == null) {
            return context.getResources().getString(R.string.common_google_play_services_notification_ticker);
        }
        return string2;
    }

    @Nullable
    public static String zag(Context object, int n) {
        Resources resources = ((Context)object).getResources();
        switch (n) {
            default: {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unexpected error code ");
                ((StringBuilder)object).append(n);
                Log.e("GoogleApiAvailability", ((StringBuilder)object).toString());
                return null;
            }
            case 20: {
                Log.e("GoogleApiAvailability", "The current user profile is restricted and could not use authenticated features.");
                return zac.zai((Context)object, "common_google_play_services_restricted_profile_title");
            }
            case 17: {
                Log.e("GoogleApiAvailability", "The specified account could not be signed in.");
                return zac.zai((Context)object, "common_google_play_services_sign_in_failed_title");
            }
            case 16: {
                Log.e("GoogleApiAvailability", "One of the API components you attempted to connect to is not available.");
                return null;
            }
            case 11: {
                Log.e("GoogleApiAvailability", "The application is not licensed to the user.");
                return null;
            }
            case 10: {
                Log.e("GoogleApiAvailability", "Developer error occurred. Please see logs for detailed information");
                return null;
            }
            case 9: {
                Log.e("GoogleApiAvailability", "Google Play services is invalid. Cannot recover.");
                return null;
            }
            case 8: {
                Log.e("GoogleApiAvailability", "Internal error occurred. Please see logs for detailed information");
                return null;
            }
            case 7: {
                Log.e("GoogleApiAvailability", "Network error occurred. Please retry request later.");
                return zac.zai((Context)object, "common_google_play_services_network_error_title");
            }
            case 5: {
                Log.e("GoogleApiAvailability", "An invalid account was specified when connecting. Please provide a valid account.");
                return zac.zai((Context)object, "common_google_play_services_invalid_account_title");
            }
            case 4: 
            case 6: 
            case 18: {
                return null;
            }
            case 3: {
                return resources.getString(R.string.common_google_play_services_enable_title);
            }
            case 2: {
                return resources.getString(R.string.common_google_play_services_update_title);
            }
            case 1: 
        }
        return resources.getString(R.string.common_google_play_services_install_title);
    }

    private static String zah(Context object, String object2, String string2) {
        Object[] objectArray = ((Context)object).getResources();
        if ((object = zac.zai((Context)object, (String)object2)) == null) {
            object = objectArray.getString(R.string.common_google_play_services_unknown_issue);
        }
        object2 = objectArray.getConfiguration();
        object2 = ((Configuration)object2).locale;
        objectArray = new Object[]{string2};
        return String.format((Locale)object2, (String)object, objectArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String zai(Context object, String string2) {
        SimpleArrayMap simpleArrayMap = zaa;
        synchronized (simpleArrayMap) {
            Object object2 = ConfigurationCompat.getLocales(((Context)object).getResources().getConfiguration()).get(0);
            boolean bl = ((Locale)object2).equals(zab);
            if (!bl) {
                zaa.clear();
                zab = object2;
            }
            if ((object2 = (String)zaa.get((Object)string2)) != null) {
                return object2;
            }
            if ((object = GooglePlayServicesUtil.getRemoteResource((Context)object)) == null) {
                return null;
            }
            int n = object.getIdentifier(string2, "string", "com.google.android.gms");
            if (n == 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Missing resource: ");
                ((StringBuilder)object).append(string2);
                Log.w("GoogleApiAvailability", ((StringBuilder)object).toString());
                return null;
            }
            if ((n = (int)(TextUtils.isEmpty((CharSequence)(object = object.getString(n))) ? 1 : 0)) != 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Got empty resource: ");
                ((StringBuilder)object).append(string2);
                Log.w("GoogleApiAvailability", ((StringBuilder)object).toString());
                return null;
            }
            zaa.put((Object)string2, object);
            return object;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static {
        SimpleArrayMap simpleArrayMap;
        zaa = simpleArrayMap = new SimpleArrayMap();
    }
}

