/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.AggregateField;
import com.google.firebase.firestore.AggregateQuerySnapshot;
import com.google.firebase.firestore.AggregateSource;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregateQuery {
    @NonNull
    private final Query query;
    @NonNull
    private final List<AggregateField> aggregateFieldList;

    AggregateQuery(@NonNull Query query, @NonNull List<AggregateField> aggregateFieldList) {
        this.query = query;
        this.aggregateFieldList = aggregateFieldList;
    }

    @NonNull
    public Query getQuery() {
        return this.query;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public List<AggregateField> getAggregateFields() {
        return this.aggregateFieldList;
    }

    @NonNull
    public Task<AggregateQuerySnapshot> get(@NonNull AggregateSource source) {
        Preconditions.checkNotNull(source, "AggregateSource must not be null");
        TaskCompletionSource tcs = new TaskCompletionSource();
        this.query.firestore.getClient().runAggregateQuery(this.query.query, this.aggregateFieldList).continueWith(Executors.DIRECT_EXECUTOR, task -> {
            if (task.isSuccessful()) {
                tcs.setResult(new AggregateQuerySnapshot(this, (Map)task.getResult()));
            } else {
                tcs.setException(task.getException());
            }
            return null;
        });
        return tcs.getTask();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AggregateQuery)) {
            return false;
        }
        AggregateQuery other = (AggregateQuery)object;
        return this.query.equals(other.query) && this.aggregateFieldList.equals(other.aggregateFieldList);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.aggregateFieldList);
    }
}

