/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.AggregateField;
import com.google.firebase.firestore.AggregateQuery;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.UserDataWriter;
import com.google.firebase.firestore.util.Preconditions;
import com.google.firestore.v1.Value;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AggregateQuerySnapshot {
    @Nonnull
    private final AggregateQuery query;
    @Nonnull
    private final Map<String, Value> data;

    AggregateQuerySnapshot(@NonNull AggregateQuery query, @NonNull Map<String, Value> data) {
        Preconditions.checkNotNull(query);
        this.query = query;
        this.data = data;
    }

    static AggregateQuerySnapshot createWithCount(@NonNull AggregateQuery query, long count) {
        return new AggregateQuerySnapshot(query, Collections.singletonMap(AggregateField.count().getAlias(), (Value)Value.newBuilder().setIntegerValue(count).build()));
    }

    @NonNull
    public AggregateQuery getQuery() {
        return this.query;
    }

    public long getCount() {
        return this.get(AggregateField.count());
    }

    @Nullable
    public Object get(@Nonnull AggregateField aggregateField) {
        return this.getInternal(aggregateField);
    }

    public long get(@Nonnull AggregateField.CountAggregateField countAggregateField) {
        Long value = this.getLong(countAggregateField);
        if (value == null) {
            throw new IllegalArgumentException("RunAggregationQueryResponse alias " + countAggregateField.getAlias() + " is null");
        }
        return value;
    }

    @Nullable
    public Double get(@Nonnull AggregateField.AverageAggregateField averageAggregateField) {
        return this.getDouble(averageAggregateField);
    }

    @Nullable
    public Double getDouble(@Nonnull AggregateField aggregateField) {
        Number val = this.getTypedValue(aggregateField, Number.class);
        return val != null ? Double.valueOf(val.doubleValue()) : null;
    }

    @Nullable
    public Long getLong(@Nonnull AggregateField aggregateField) {
        Number val = this.getTypedValue(aggregateField, Number.class);
        return val != null ? Long.valueOf(val.longValue()) : null;
    }

    @Nullable
    private Object getInternal(@Nonnull AggregateField aggregateField) {
        if (!this.data.containsKey(aggregateField.getAlias())) {
            throw new IllegalArgumentException("'" + aggregateField.getOperator() + "(" + aggregateField.getFieldPath() + ")' was not requested in the aggregation query.");
        }
        Value value = this.data.get(aggregateField.getAlias());
        UserDataWriter userDataWriter = new UserDataWriter(this.query.getQuery().firestore, DocumentSnapshot.ServerTimestampBehavior.DEFAULT);
        return userDataWriter.convertValue(value);
    }

    @Nullable
    private <T> T getTypedValue(@Nonnull AggregateField aggregateField, Class<T> clazz) {
        Object value = this.getInternal(aggregateField);
        return this.castTypedValue(value, aggregateField, clazz);
    }

    @Nullable
    private <T> T castTypedValue(Object value, @Nonnull AggregateField aggregateField, Class<T> clazz) {
        if (value == null) {
            return null;
        }
        if (!clazz.isInstance(value)) {
            throw new RuntimeException("AggregateField '" + aggregateField.getAlias() + "' is not a " + clazz.getName());
        }
        return clazz.cast(value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AggregateQuerySnapshot)) {
            return false;
        }
        AggregateQuerySnapshot other = (AggregateQuerySnapshot)object;
        return this.query.equals(other.query) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.data);
    }
}

