/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1;

import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.ValueOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.NullValue;
import com.google.protobuf.Parser;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class Value
extends GeneratedMessageLite<Value, Builder>
implements ValueOrBuilder {
    private int valueTypeCase_ = 0;
    private Object valueType_;
    public static final int NULL_VALUE_FIELD_NUMBER = 11;
    public static final int BOOLEAN_VALUE_FIELD_NUMBER = 1;
    public static final int INTEGER_VALUE_FIELD_NUMBER = 2;
    public static final int DOUBLE_VALUE_FIELD_NUMBER = 3;
    public static final int TIMESTAMP_VALUE_FIELD_NUMBER = 10;
    public static final int STRING_VALUE_FIELD_NUMBER = 17;
    public static final int BYTES_VALUE_FIELD_NUMBER = 18;
    public static final int REFERENCE_VALUE_FIELD_NUMBER = 5;
    public static final int GEO_POINT_VALUE_FIELD_NUMBER = 8;
    public static final int ARRAY_VALUE_FIELD_NUMBER = 9;
    public static final int MAP_VALUE_FIELD_NUMBER = 6;
    private static final Value DEFAULT_INSTANCE;
    private static volatile Parser<Value> PARSER;

    private Value() {
    }

    @Override
    public ValueTypeCase getValueTypeCase() {
        return ValueTypeCase.forNumber(this.valueTypeCase_);
    }

    private void clearValueType() {
        this.valueTypeCase_ = 0;
        this.valueType_ = null;
    }

    @Override
    public boolean hasNullValue() {
        return this.valueTypeCase_ == 11;
    }

    @Override
    public int getNullValueValue() {
        if (this.valueTypeCase_ == 11) {
            return (Integer)this.valueType_;
        }
        return 0;
    }

    @Override
    public NullValue getNullValue() {
        if (this.valueTypeCase_ == 11) {
            NullValue result = NullValue.forNumber((int)((Integer)this.valueType_));
            return result == null ? NullValue.UNRECOGNIZED : result;
        }
        return NullValue.NULL_VALUE;
    }

    private void setNullValueValue(int value) {
        this.valueTypeCase_ = 11;
        this.valueType_ = value;
    }

    private void setNullValue(NullValue value) {
        this.valueType_ = value.getNumber();
        this.valueTypeCase_ = 11;
    }

    private void clearNullValue() {
        if (this.valueTypeCase_ == 11) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasBooleanValue() {
        return this.valueTypeCase_ == 1;
    }

    @Override
    public boolean getBooleanValue() {
        if (this.valueTypeCase_ == 1) {
            return (Boolean)this.valueType_;
        }
        return false;
    }

    private void setBooleanValue(boolean value) {
        this.valueTypeCase_ = 1;
        this.valueType_ = value;
    }

    private void clearBooleanValue() {
        if (this.valueTypeCase_ == 1) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasIntegerValue() {
        return this.valueTypeCase_ == 2;
    }

    @Override
    public long getIntegerValue() {
        if (this.valueTypeCase_ == 2) {
            return (Long)this.valueType_;
        }
        return 0L;
    }

    private void setIntegerValue(long value) {
        this.valueTypeCase_ = 2;
        this.valueType_ = value;
    }

    private void clearIntegerValue() {
        if (this.valueTypeCase_ == 2) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasDoubleValue() {
        return this.valueTypeCase_ == 3;
    }

    @Override
    public double getDoubleValue() {
        if (this.valueTypeCase_ == 3) {
            return (Double)this.valueType_;
        }
        return 0.0;
    }

    private void setDoubleValue(double value) {
        this.valueTypeCase_ = 3;
        this.valueType_ = value;
    }

    private void clearDoubleValue() {
        if (this.valueTypeCase_ == 3) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasTimestampValue() {
        return this.valueTypeCase_ == 10;
    }

    @Override
    public Timestamp getTimestampValue() {
        if (this.valueTypeCase_ == 10) {
            return (Timestamp)this.valueType_;
        }
        return Timestamp.getDefaultInstance();
    }

    private void setTimestampValue(Timestamp value) {
        value.getClass();
        this.valueType_ = value;
        this.valueTypeCase_ = 10;
    }

    private void mergeTimestampValue(Timestamp value) {
        value.getClass();
        this.valueType_ = this.valueTypeCase_ == 10 && this.valueType_ != Timestamp.getDefaultInstance() ? ((Timestamp.Builder)Timestamp.newBuilder((Timestamp)((Timestamp)this.valueType_)).mergeFrom((GeneratedMessageLite)value)).buildPartial() : value;
        this.valueTypeCase_ = 10;
    }

    private void clearTimestampValue() {
        if (this.valueTypeCase_ == 10) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasStringValue() {
        return this.valueTypeCase_ == 17;
    }

    @Override
    public String getStringValue() {
        String ref = "";
        if (this.valueTypeCase_ == 17) {
            ref = (String)this.valueType_;
        }
        return ref;
    }

    @Override
    public ByteString getStringValueBytes() {
        String ref = "";
        if (this.valueTypeCase_ == 17) {
            ref = (String)this.valueType_;
        }
        return ByteString.copyFromUtf8((String)ref);
    }

    private void setStringValue(String value) {
        Class<?> valueClass = value.getClass();
        this.valueTypeCase_ = 17;
        this.valueType_ = value;
    }

    private void clearStringValue() {
        if (this.valueTypeCase_ == 17) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    private void setStringValueBytes(ByteString value) {
        Value.checkByteStringIsUtf8((ByteString)value);
        this.valueType_ = value.toStringUtf8();
        this.valueTypeCase_ = 17;
    }

    @Override
    public boolean hasBytesValue() {
        return this.valueTypeCase_ == 18;
    }

    @Override
    public ByteString getBytesValue() {
        if (this.valueTypeCase_ == 18) {
            return (ByteString)this.valueType_;
        }
        return ByteString.EMPTY;
    }

    private void setBytesValue(ByteString value) {
        Class<?> valueClass = value.getClass();
        this.valueTypeCase_ = 18;
        this.valueType_ = value;
    }

    private void clearBytesValue() {
        if (this.valueTypeCase_ == 18) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasReferenceValue() {
        return this.valueTypeCase_ == 5;
    }

    @Override
    public String getReferenceValue() {
        String ref = "";
        if (this.valueTypeCase_ == 5) {
            ref = (String)this.valueType_;
        }
        return ref;
    }

    @Override
    public ByteString getReferenceValueBytes() {
        String ref = "";
        if (this.valueTypeCase_ == 5) {
            ref = (String)this.valueType_;
        }
        return ByteString.copyFromUtf8((String)ref);
    }

    private void setReferenceValue(String value) {
        Class<?> valueClass = value.getClass();
        this.valueTypeCase_ = 5;
        this.valueType_ = value;
    }

    private void clearReferenceValue() {
        if (this.valueTypeCase_ == 5) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    private void setReferenceValueBytes(ByteString value) {
        Value.checkByteStringIsUtf8((ByteString)value);
        this.valueType_ = value.toStringUtf8();
        this.valueTypeCase_ = 5;
    }

    @Override
    public boolean hasGeoPointValue() {
        return this.valueTypeCase_ == 8;
    }

    @Override
    public LatLng getGeoPointValue() {
        if (this.valueTypeCase_ == 8) {
            return (LatLng)this.valueType_;
        }
        return LatLng.getDefaultInstance();
    }

    private void setGeoPointValue(LatLng value) {
        value.getClass();
        this.valueType_ = value;
        this.valueTypeCase_ = 8;
    }

    private void mergeGeoPointValue(LatLng value) {
        value.getClass();
        this.valueType_ = this.valueTypeCase_ == 8 && this.valueType_ != LatLng.getDefaultInstance() ? ((LatLng.Builder)LatLng.newBuilder((LatLng)this.valueType_).mergeFrom(value)).buildPartial() : value;
        this.valueTypeCase_ = 8;
    }

    private void clearGeoPointValue() {
        if (this.valueTypeCase_ == 8) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasArrayValue() {
        return this.valueTypeCase_ == 9;
    }

    @Override
    public ArrayValue getArrayValue() {
        if (this.valueTypeCase_ == 9) {
            return (ArrayValue)this.valueType_;
        }
        return ArrayValue.getDefaultInstance();
    }

    private void setArrayValue(ArrayValue value) {
        value.getClass();
        this.valueType_ = value;
        this.valueTypeCase_ = 9;
    }

    private void mergeArrayValue(ArrayValue value) {
        value.getClass();
        this.valueType_ = this.valueTypeCase_ == 9 && this.valueType_ != ArrayValue.getDefaultInstance() ? ((ArrayValue.Builder)ArrayValue.newBuilder((ArrayValue)this.valueType_).mergeFrom(value)).buildPartial() : value;
        this.valueTypeCase_ = 9;
    }

    private void clearArrayValue() {
        if (this.valueTypeCase_ == 9) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    @Override
    public boolean hasMapValue() {
        return this.valueTypeCase_ == 6;
    }

    @Override
    public MapValue getMapValue() {
        if (this.valueTypeCase_ == 6) {
            return (MapValue)this.valueType_;
        }
        return MapValue.getDefaultInstance();
    }

    private void setMapValue(MapValue value) {
        value.getClass();
        this.valueType_ = value;
        this.valueTypeCase_ = 6;
    }

    private void mergeMapValue(MapValue value) {
        value.getClass();
        this.valueType_ = this.valueTypeCase_ == 6 && this.valueType_ != MapValue.getDefaultInstance() ? ((MapValue.Builder)MapValue.newBuilder((MapValue)this.valueType_).mergeFrom(value)).buildPartial() : value;
        this.valueTypeCase_ = 6;
    }

    private void clearMapValue() {
        if (this.valueTypeCase_ == 6) {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
        }
    }

    public static Value parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data);
    }

    public static Value parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static Value parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static Value parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(InputStream input) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static Value parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseDelimitedFrom(InputStream input) throws IOException {
        return (Value)Value.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static Value parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Value)Value.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(CodedInputStream input) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static Value parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(Value prototype) {
        return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new Value();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Object[] objects = new Object[]{"valueType_", "valueTypeCase_", MapValue.class, LatLng.class, ArrayValue.class, Timestamp.class};
                String info = "\u0000\u000b\u0001\u0000\u0001\u0012\u000b\u0000\u0000\u0000\u0001:\u0000\u00025\u0000\u00033\u0000\u0005\u023b\u0000\u0006<\u0000\b<\u0000\t<\u0000\n<\u0000\u000b?\u0000\u0011\u023b\u0000\u0012=\u0000";
                return Value.newMessageInfo((MessageLite)DEFAULT_INSTANCE, (String)info, (Object[])objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                GeneratedMessageLite.DefaultInstanceBasedParser parser = PARSER;
                if (parser != null) return parser;
                Class<Value> clazz = Value.class;
                synchronized (Value.class) {
                    parser = PARSER;
                    if (parser != null) return parser;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return parser;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Value getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Value> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        Value defaultInstance;
        DEFAULT_INSTANCE = defaultInstance = new Value();
        GeneratedMessageLite.registerDefaultInstance(Value.class, (GeneratedMessageLite)defaultInstance);
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<Value, Builder>
    implements ValueOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public ValueTypeCase getValueTypeCase() {
            return ((Value)this.instance).getValueTypeCase();
        }

        public Builder clearValueType() {
            this.copyOnWrite();
            ((Value)this.instance).clearValueType();
            return this;
        }

        @Override
        public boolean hasNullValue() {
            return ((Value)this.instance).hasNullValue();
        }

        @Override
        public int getNullValueValue() {
            return ((Value)this.instance).getNullValueValue();
        }

        public Builder setNullValueValue(int value) {
            this.copyOnWrite();
            ((Value)this.instance).setNullValueValue(value);
            return this;
        }

        @Override
        public NullValue getNullValue() {
            return ((Value)this.instance).getNullValue();
        }

        public Builder setNullValue(NullValue value) {
            this.copyOnWrite();
            ((Value)this.instance).setNullValue(value);
            return this;
        }

        public Builder clearNullValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearNullValue();
            return this;
        }

        @Override
        public boolean hasBooleanValue() {
            return ((Value)this.instance).hasBooleanValue();
        }

        @Override
        public boolean getBooleanValue() {
            return ((Value)this.instance).getBooleanValue();
        }

        public Builder setBooleanValue(boolean value) {
            this.copyOnWrite();
            ((Value)this.instance).setBooleanValue(value);
            return this;
        }

        public Builder clearBooleanValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearBooleanValue();
            return this;
        }

        @Override
        public boolean hasIntegerValue() {
            return ((Value)this.instance).hasIntegerValue();
        }

        @Override
        public long getIntegerValue() {
            return ((Value)this.instance).getIntegerValue();
        }

        public Builder setIntegerValue(long value) {
            this.copyOnWrite();
            ((Value)this.instance).setIntegerValue(value);
            return this;
        }

        public Builder clearIntegerValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearIntegerValue();
            return this;
        }

        @Override
        public boolean hasDoubleValue() {
            return ((Value)this.instance).hasDoubleValue();
        }

        @Override
        public double getDoubleValue() {
            return ((Value)this.instance).getDoubleValue();
        }

        public Builder setDoubleValue(double value) {
            this.copyOnWrite();
            ((Value)this.instance).setDoubleValue(value);
            return this;
        }

        public Builder clearDoubleValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearDoubleValue();
            return this;
        }

        @Override
        public boolean hasTimestampValue() {
            return ((Value)this.instance).hasTimestampValue();
        }

        @Override
        public Timestamp getTimestampValue() {
            return ((Value)this.instance).getTimestampValue();
        }

        public Builder setTimestampValue(Timestamp value) {
            this.copyOnWrite();
            ((Value)this.instance).setTimestampValue(value);
            return this;
        }

        public Builder setTimestampValue(Timestamp.Builder builderForValue) {
            this.copyOnWrite();
            ((Value)this.instance).setTimestampValue((Timestamp)builderForValue.build());
            return this;
        }

        public Builder mergeTimestampValue(Timestamp value) {
            this.copyOnWrite();
            ((Value)this.instance).mergeTimestampValue(value);
            return this;
        }

        public Builder clearTimestampValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearTimestampValue();
            return this;
        }

        @Override
        public boolean hasStringValue() {
            return ((Value)this.instance).hasStringValue();
        }

        @Override
        public String getStringValue() {
            return ((Value)this.instance).getStringValue();
        }

        @Override
        public ByteString getStringValueBytes() {
            return ((Value)this.instance).getStringValueBytes();
        }

        public Builder setStringValue(String value) {
            this.copyOnWrite();
            ((Value)this.instance).setStringValue(value);
            return this;
        }

        public Builder clearStringValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearStringValue();
            return this;
        }

        public Builder setStringValueBytes(ByteString value) {
            this.copyOnWrite();
            ((Value)this.instance).setStringValueBytes(value);
            return this;
        }

        @Override
        public boolean hasBytesValue() {
            return ((Value)this.instance).hasBytesValue();
        }

        @Override
        public ByteString getBytesValue() {
            return ((Value)this.instance).getBytesValue();
        }

        public Builder setBytesValue(ByteString value) {
            this.copyOnWrite();
            ((Value)this.instance).setBytesValue(value);
            return this;
        }

        public Builder clearBytesValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearBytesValue();
            return this;
        }

        @Override
        public boolean hasReferenceValue() {
            return ((Value)this.instance).hasReferenceValue();
        }

        @Override
        public String getReferenceValue() {
            return ((Value)this.instance).getReferenceValue();
        }

        @Override
        public ByteString getReferenceValueBytes() {
            return ((Value)this.instance).getReferenceValueBytes();
        }

        public Builder setReferenceValue(String value) {
            this.copyOnWrite();
            ((Value)this.instance).setReferenceValue(value);
            return this;
        }

        public Builder clearReferenceValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearReferenceValue();
            return this;
        }

        public Builder setReferenceValueBytes(ByteString value) {
            this.copyOnWrite();
            ((Value)this.instance).setReferenceValueBytes(value);
            return this;
        }

        @Override
        public boolean hasGeoPointValue() {
            return ((Value)this.instance).hasGeoPointValue();
        }

        @Override
        public LatLng getGeoPointValue() {
            return ((Value)this.instance).getGeoPointValue();
        }

        public Builder setGeoPointValue(LatLng value) {
            this.copyOnWrite();
            ((Value)this.instance).setGeoPointValue(value);
            return this;
        }

        public Builder setGeoPointValue(LatLng.Builder builderForValue) {
            this.copyOnWrite();
            ((Value)this.instance).setGeoPointValue((LatLng)builderForValue.build());
            return this;
        }

        public Builder mergeGeoPointValue(LatLng value) {
            this.copyOnWrite();
            ((Value)this.instance).mergeGeoPointValue(value);
            return this;
        }

        public Builder clearGeoPointValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearGeoPointValue();
            return this;
        }

        @Override
        public boolean hasArrayValue() {
            return ((Value)this.instance).hasArrayValue();
        }

        @Override
        public ArrayValue getArrayValue() {
            return ((Value)this.instance).getArrayValue();
        }

        public Builder setArrayValue(ArrayValue value) {
            this.copyOnWrite();
            ((Value)this.instance).setArrayValue(value);
            return this;
        }

        public Builder setArrayValue(ArrayValue.Builder builderForValue) {
            this.copyOnWrite();
            ((Value)this.instance).setArrayValue((ArrayValue)builderForValue.build());
            return this;
        }

        public Builder mergeArrayValue(ArrayValue value) {
            this.copyOnWrite();
            ((Value)this.instance).mergeArrayValue(value);
            return this;
        }

        public Builder clearArrayValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearArrayValue();
            return this;
        }

        @Override
        public boolean hasMapValue() {
            return ((Value)this.instance).hasMapValue();
        }

        @Override
        public MapValue getMapValue() {
            return ((Value)this.instance).getMapValue();
        }

        public Builder setMapValue(MapValue value) {
            this.copyOnWrite();
            ((Value)this.instance).setMapValue(value);
            return this;
        }

        public Builder setMapValue(MapValue.Builder builderForValue) {
            this.copyOnWrite();
            ((Value)this.instance).setMapValue((MapValue)builderForValue.build());
            return this;
        }

        public Builder mergeMapValue(MapValue value) {
            this.copyOnWrite();
            ((Value)this.instance).mergeMapValue(value);
            return this;
        }

        public Builder clearMapValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearMapValue();
            return this;
        }
    }

    public static enum ValueTypeCase {
        NULL_VALUE(11),
        BOOLEAN_VALUE(1),
        INTEGER_VALUE(2),
        DOUBLE_VALUE(3),
        TIMESTAMP_VALUE(10),
        STRING_VALUE(17),
        BYTES_VALUE(18),
        REFERENCE_VALUE(5),
        GEO_POINT_VALUE(8),
        ARRAY_VALUE(9),
        MAP_VALUE(6),
        VALUETYPE_NOT_SET(0);

        private final int value;

        private ValueTypeCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static ValueTypeCase valueOf(int value) {
            return ValueTypeCase.forNumber(value);
        }

        public static ValueTypeCase forNumber(int value) {
            switch (value) {
                case 11: {
                    return NULL_VALUE;
                }
                case 1: {
                    return BOOLEAN_VALUE;
                }
                case 2: {
                    return INTEGER_VALUE;
                }
                case 3: {
                    return DOUBLE_VALUE;
                }
                case 10: {
                    return TIMESTAMP_VALUE;
                }
                case 17: {
                    return STRING_VALUE;
                }
                case 18: {
                    return BYTES_VALUE;
                }
                case 5: {
                    return REFERENCE_VALUE;
                }
                case 8: {
                    return GEO_POINT_VALUE;
                }
                case 9: {
                    return ARRAY_VALUE;
                }
                case 6: {
                    return MAP_VALUE;
                }
                case 0: {
                    return VALUETYPE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

