/*
 * Decompiled with CFR 0.152.
 */
package common;

import androidx.compose.runtime.internal.StabilityInferred;
import coil3.PlatformContext;
import coil3.SingletonImageLoader;
import coil3.decode.BlackholeDecoder;
import coil3.decode.Decoder;
import coil3.request.CachePolicy;
import coil3.request.ImageRequest;
import coil3.size.Size;
import di.ContentSource;
import di.MultiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import models.DisplayPerformance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J(\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcommon/ImageCacher;", "", "contentSource", "Ldi/ContentSource;", "logger", "Ldi/MultiLogger;", "<init>", "(Ldi/ContentSource;Ldi/MultiLogger;)V", "getContentSource", "()Ldi/ContentSource;", "getLogger", "()Ldi/MultiLogger;", "preFetchArtistImages", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "accountId", "", "context", "Lcoil3/PlatformContext;", "loadedPerformances", "", "Lmodels/DisplayPerformance;", "preCacheMap", "screenSize", "Lcoil3/size/Size;", "mapUrl", "Companion", "shared"})
@StabilityInferred(parameters=0)
public final class ImageCacher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentSource contentSource;
    @NotNull
    private final MultiLogger logger;
    public static final int $stable = 8;
    @NotNull
    private static volatile Map<String, Boolean> artistImagePreCache = new LinkedHashMap();
    @NotNull
    private static volatile Map<String, Boolean> mapPreCache = new LinkedHashMap();
    @NotNull
    private static volatile Map<String, Boolean> didPreCacheAccount = new LinkedHashMap();

    public ImageCacher(@NotNull ContentSource contentSource, @NotNull MultiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)contentSource, (String)"contentSource");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.contentSource = contentSource;
        this.logger = logger;
    }

    @NotNull
    public final ContentSource getContentSource() {
        return this.contentSource;
    }

    @NotNull
    public final MultiLogger getLogger() {
        return this.logger;
    }

    public final void preFetchArtistImages(@NotNull CoroutineScope scope, @NotNull String accountId, @NotNull PlatformContext context, @NotNull List<DisplayPerformance> loadedPerformances) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(loadedPerformances, (String)"loadedPerformances");
        if (!(this.contentSource instanceof ContentSource.Live) || loadedPerformances.isEmpty() || Intrinsics.areEqual((Object)didPreCacheAccount.get(accountId), (Object)true)) {
            return;
        }
        didPreCacheAccount.put(accountId, true);
        this.logger.i("Pre Fetching Images For: " + accountId);
        BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loadedPerformances, context, null){
            int label;
            final /* synthetic */ List<DisplayPerformance> $loadedPerformances;
            final /* synthetic */ PlatformContext $context;
            {
                this.$loadedPerformances = $loadedPerformances;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        void $this$mapNotNullTo$iv$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable $this$mapNotNull$iv = this.$loadedPerformances;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String string2;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            DisplayPerformance it = (DisplayPerformance)element$iv$iv;
                            boolean bl2 = false;
                            if (StringsKt.endsWith$default((String)it.getArtistImageUrl(), (String)"svg", (boolean)false, (int)2, null)) {
                                string2 = null;
                            } else {
                                CharSequence charSequence;
                                CharSequence charSequence2 = it.getArtistImageUrl();
                                if (charSequence2.length() == 0) {
                                    boolean bl3 = false;
                                    charSequence = null;
                                } else {
                                    charSequence = charSequence2;
                                }
                                string2 = (String)charSequence;
                            }
                            if (string2 == null) continue;
                            String it$iv$iv = string2;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List images = (List)destination$iv$iv;
                        $this$mapNotNull$iv = images;
                        PlatformContext platformContext = this.$context;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual(ImageCacher.access$getArtistImagePreCache$cp().get(it), (Object)Boxing.boxBoolean((boolean)true))) continue;
                            ImageRequest.Builder requestBuilder = new ImageRequest.Builder(platformContext).memoryCachePolicy(CachePolicy.DISABLED).decoderFactory((Decoder.Factory)new BlackholeDecoder.Factory(null, 1, null)).data((Object)it);
                            SingletonImageLoader.get((PlatformContext)platformContext).enqueue(requestBuilder.build());
                            ImageCacher.access$getArtistImagePreCache$cp().put(it, Boxing.boxBoolean((boolean)true));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void preCacheMap(@NotNull CoroutineScope scope, @NotNull PlatformContext context, @NotNull Size screenSize, @Nullable String mapUrl) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)screenSize, (String)"screenSize");
        if (mapUrl != null && !Intrinsics.areEqual((Object)mapPreCache.get(mapUrl), (Object)true)) {
            BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, mapUrl, screenSize, null){
                int label;
                final /* synthetic */ PlatformContext $context;
                final /* synthetic */ String $mapUrl;
                final /* synthetic */ Size $screenSize;
                {
                    this.$context = $context;
                    this.$mapUrl = $mapUrl;
                    this.$screenSize = $screenSize;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ImageRequest.Builder requestBuilder = new ImageRequest.Builder(this.$context).data((Object)this.$mapUrl);
                            if (StringsKt.contains$default((CharSequence)this.$mapUrl, (CharSequence)".svg", (boolean)false, (int)2, null)) {
                                requestBuilder.size(this.$screenSize);
                            }
                            SingletonImageLoader.get((PlatformContext)this.$context).enqueue(requestBuilder.build());
                            ImageCacher.access$getMapPreCache$cp().put(this.$mapUrl, Boxing.boxBoolean((boolean)true));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public static final /* synthetic */ Map access$getArtistImagePreCache$cp() {
        return artistImagePreCache;
    }

    public static final /* synthetic */ Map access$getMapPreCache$cp() {
        return mapPreCache;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcommon/ImageCacher$Companion;", "", "<init>", "()V", "artistImagePreCache", "", "", "", "mapPreCache", "didPreCacheAccount", "shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

