/*
 * Decompiled with CFR 0.152.
 */
package common;

import androidx.compose.runtime.internal.StabilityInferred;
import data.subscriptiontopics.SubscriptionTopicType;
import di.MultiLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00072\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\b\t\n\u00a8\u0006\u000b"}, d2={"Lcommon/NotificationTypes;", "", "<init>", "()V", "Message", "ScheduleChanges", "Unknown", "Companion", "Lcommon/NotificationTypes$Message;", "Lcommon/NotificationTypes$ScheduleChanges;", "Lcommon/NotificationTypes$Unknown;", "shared"})
@StabilityInferred(parameters=1)
public abstract class NotificationTypes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    private NotificationTypes() {
    }

    public /* synthetic */ NotificationTypes(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcommon/NotificationTypes$Companion;", "", "<init>", "()V", "getType", "Lcommon/NotificationTypes;", "data", "", "", "logger", "Ldi/MultiLogger;", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotificationTypes getType(@NotNull Map<String, String> data, @NotNull MultiLogger logger) {
            NotificationTypes notificationTypes;
            String type;
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            String string2 = type = data.get("notificationType");
            if (Intrinsics.areEqual((Object)string2, (Object)SubscriptionTopicType.ScheduleChanges.INSTANCE.getTopic())) {
                NotificationTypes versionCode22;
                try {
                    String string3 = data.get("versionCode");
                    Intrinsics.checkNotNull((Object)string3);
                    int versionCode22 = Integer.parseInt(string3);
                    String string4 = data.get("scheduleName");
                    Intrinsics.checkNotNull((Object)string4);
                    String scheduleName = string4;
                    String string5 = data.get("eventId");
                    Intrinsics.checkNotNull((Object)string5);
                    String eventId = string5;
                    versionCode22 = new ScheduleChanges(versionCode22, scheduleName, eventId);
                }
                catch (Exception exception) {
                    logger.e("ScheduleChanges Notification Error", exception);
                    versionCode22 = Unknown.INSTANCE;
                }
                notificationTypes = versionCode22;
            } else if (Intrinsics.areEqual((Object)string2, (Object)SubscriptionTopicType.Marketing.INSTANCE.getTopic()) || Intrinsics.areEqual((Object)string2, (Object)SubscriptionTopicType.General.INSTANCE.getTopic()) || Intrinsics.areEqual((Object)string2, (Object)SubscriptionTopicType.Emergency.INSTANCE.getTopic())) {
                NotificationTypes notificationTypes2;
                try {
                    String string6 = data.get("id");
                    Intrinsics.checkNotNull((Object)string6);
                    String id = string6;
                    String string7 = data.get("name");
                    Intrinsics.checkNotNull((Object)string7);
                    String name = string7;
                    String string8 = data.get("subject");
                    Intrinsics.checkNotNull((Object)string8);
                    String subject = string8;
                    String string9 = data.get("body");
                    Intrinsics.checkNotNull((Object)string9);
                    String body = string9;
                    String string10 = data.get("accountId");
                    Intrinsics.checkNotNull((Object)string10);
                    String accountId = string10;
                    String string11 = data.get("eventId");
                    Intrinsics.checkNotNull((Object)string11);
                    String eventId = string11;
                    String string12 = data.get("zoneId");
                    Intrinsics.checkNotNull((Object)string12);
                    String zoneId = string12;
                    SubscriptionTopicType notificationType = SubscriptionTopicType.Companion.from(type);
                    notificationTypes2 = new Message(id, name, accountId, eventId, subject, body, notificationType.getChannelId(), zoneId);
                }
                catch (Exception exception) {
                    logger.e("ScheduleChanges Notification Error", exception);
                    notificationTypes2 = Unknown.INSTANCE;
                }
                notificationTypes = notificationTypes2;
            } else {
                notificationTypes = Unknown.INSTANCE;
            }
            NotificationTypes notificationType = notificationTypes;
            logger.i("Notification Recieved: " + notificationType);
            return notificationType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003JY\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006&"}, d2={"Lcommon/NotificationTypes$Message;", "Lcommon/NotificationTypes;", "id", "", "name", "accountId", "eventId", "subject", "body", "channelId", "zoneId", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "getAccountId", "getEventId", "getSubject", "getBody", "getChannelId", "getZoneId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Message
    extends NotificationTypes {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String accountId;
        @NotNull
        private final String eventId;
        @NotNull
        private final String subject;
        @NotNull
        private final String body;
        @NotNull
        private final String channelId;
        @NotNull
        private final String zoneId;
        public static final int $stable;

        public Message(@NotNull String id, @NotNull String name, @NotNull String accountId, @NotNull String eventId, @NotNull String subject, @NotNull String body, @NotNull String channelId, @NotNull String zoneId) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            super(null);
            this.id = id;
            this.name = name;
            this.accountId = accountId;
            this.eventId = eventId;
            this.subject = subject;
            this.body = body;
            this.channelId = channelId;
            this.zoneId = zoneId;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getAccountId() {
            return this.accountId;
        }

        @NotNull
        public final String getEventId() {
            return this.eventId;
        }

        @NotNull
        public final String getSubject() {
            return this.subject;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public final String getZoneId() {
            return this.zoneId;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.accountId;
        }

        @NotNull
        public final String component4() {
            return this.eventId;
        }

        @NotNull
        public final String component5() {
            return this.subject;
        }

        @NotNull
        public final String component6() {
            return this.body;
        }

        @NotNull
        public final String component7() {
            return this.channelId;
        }

        @NotNull
        public final String component8() {
            return this.zoneId;
        }

        @NotNull
        public final Message copy(@NotNull String id, @NotNull String name, @NotNull String accountId, @NotNull String eventId, @NotNull String subject, @NotNull String body, @NotNull String channelId, @NotNull String zoneId) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            return new Message(id, name, accountId, eventId, subject, body, channelId, zoneId);
        }

        public static /* synthetic */ Message copy$default(Message message, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = message.id;
            }
            if ((n & 2) != 0) {
                string3 = message.name;
            }
            if ((n & 4) != 0) {
                string4 = message.accountId;
            }
            if ((n & 8) != 0) {
                string5 = message.eventId;
            }
            if ((n & 0x10) != 0) {
                string6 = message.subject;
            }
            if ((n & 0x20) != 0) {
                string7 = message.body;
            }
            if ((n & 0x40) != 0) {
                string8 = message.channelId;
            }
            if ((n & 0x80) != 0) {
                string9 = message.zoneId;
            }
            return message.copy(string2, string3, string4, string5, string6, string7, string8, string9);
        }

        @NotNull
        public String toString() {
            return "Message(id=" + this.id + ", name=" + this.name + ", accountId=" + this.accountId + ", eventId=" + this.eventId + ", subject=" + this.subject + ", body=" + this.body + ", channelId=" + this.channelId + ", zoneId=" + this.zoneId + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.accountId.hashCode();
            result = result * 31 + this.eventId.hashCode();
            result = result * 31 + this.subject.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + this.channelId.hashCode();
            result = result * 31 + this.zoneId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message = (Message)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)message.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)message.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.accountId, (Object)message.accountId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.eventId, (Object)message.eventId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.subject, (Object)message.subject)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)message.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.channelId, (Object)message.channelId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.zoneId, (Object)message.zoneId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcommon/NotificationTypes$ScheduleChanges;", "Lcommon/NotificationTypes;", "versionCode", "", "scheduleName", "", "eventId", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getVersionCode", "()I", "getScheduleName", "()Ljava/lang/String;", "getEventId", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "shared"})
    @StabilityInferred(parameters=1)
    public static final class ScheduleChanges
    extends NotificationTypes {
        private final int versionCode;
        @NotNull
        private final String scheduleName;
        @NotNull
        private final String eventId;
        public static final int $stable;

        public ScheduleChanges(int versionCode, @NotNull String scheduleName, @NotNull String eventId) {
            Intrinsics.checkNotNullParameter((Object)scheduleName, (String)"scheduleName");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            super(null);
            this.versionCode = versionCode;
            this.scheduleName = scheduleName;
            this.eventId = eventId;
        }

        public final int getVersionCode() {
            return this.versionCode;
        }

        @NotNull
        public final String getScheduleName() {
            return this.scheduleName;
        }

        @NotNull
        public final String getEventId() {
            return this.eventId;
        }

        public final int component1() {
            return this.versionCode;
        }

        @NotNull
        public final String component2() {
            return this.scheduleName;
        }

        @NotNull
        public final String component3() {
            return this.eventId;
        }

        @NotNull
        public final ScheduleChanges copy(int versionCode, @NotNull String scheduleName, @NotNull String eventId) {
            Intrinsics.checkNotNullParameter((Object)scheduleName, (String)"scheduleName");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            return new ScheduleChanges(versionCode, scheduleName, eventId);
        }

        public static /* synthetic */ ScheduleChanges copy$default(ScheduleChanges scheduleChanges, int n, String string2, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = scheduleChanges.versionCode;
            }
            if ((n2 & 2) != 0) {
                string2 = scheduleChanges.scheduleName;
            }
            if ((n2 & 4) != 0) {
                string3 = scheduleChanges.eventId;
            }
            return scheduleChanges.copy(n, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ScheduleChanges(versionCode=" + this.versionCode + ", scheduleName=" + this.scheduleName + ", eventId=" + this.eventId + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.versionCode);
            result = result * 31 + this.scheduleName.hashCode();
            result = result * 31 + this.eventId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScheduleChanges)) {
                return false;
            }
            ScheduleChanges scheduleChanges = (ScheduleChanges)other;
            if (this.versionCode != scheduleChanges.versionCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scheduleName, (Object)scheduleChanges.scheduleName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eventId, (Object)scheduleChanges.eventId);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcommon/NotificationTypes$Unknown;", "Lcommon/NotificationTypes;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Unknown
    extends NotificationTypes {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();
        public static final int $stable;

        private Unknown() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Unknown";
        }

        public int hashCode() {
            return 1971681831;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown cfr_ignored_0 = (Unknown)other;
            return true;
        }
    }
}

