/*
 * Decompiled with CFR 0.152.
 */
package common;

import androidx.compose.runtime.internal.StabilityInferred;
import extensions.LocalDateTimeExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcommon/TimeProvider;", "", "<init>", "()V", "getNow", "Lkotlinx/datetime/Instant;", "getNowInstant", "timeZone", "Lkotlinx/datetime/TimeZone;", "getTime", "Lkotlinx/datetime/LocalDateTime;", "getUtcInstant", "getLocalTime", "Lkotlinx/datetime/LocalTime;", "getSystemMillis", "", "getLocalDate", "Lkotlinx/datetime/LocalDate;", "shared"})
@StabilityInferred(parameters=1)
public final class TimeProvider {
    @NotNull
    public static final TimeProvider INSTANCE = new TimeProvider();
    public static final int $stable;

    private TimeProvider() {
    }

    @NotNull
    public final Instant getNow() {
        return Clock.System.INSTANCE.now();
    }

    @NotNull
    public final Instant getNowInstant(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return TimeZoneKt.toInstant((LocalDateTime)TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)timeZone), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
    }

    @NotNull
    public final LocalDateTime getTime(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)timeZone);
    }

    public static /* synthetic */ LocalDateTime getTime$default(TimeProvider timeProvider, TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = (TimeZone)TimeZone.Companion.getUTC();
        }
        return timeProvider.getTime(timeZone);
    }

    @NotNull
    public final Instant getUtcInstant() {
        return LocalDateTimeExtensionsKt.toInstantUTC(this.getTime((TimeZone)TimeZone.Companion.getUTC()));
    }

    @NotNull
    public final LocalTime getLocalTime() {
        return TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getTime();
    }

    public final long getSystemMillis() {
        return Clock.System.INSTANCE.now().toEpochMilliseconds();
    }

    @NotNull
    public final LocalDate getLocalDate() {
        return TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate();
    }
}

