/*
 * Decompiled with CFR 0.152.
 */
package common.states;

import androidx.compose.runtime.internal.StabilityInferred;
import common.TimeProvider;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00112\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcommon/states/DarkModeState;", "", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "isDarkMode", "", "isSystemDarkMode", "timeProvider", "Lcommon/TimeProvider;", "Light", "Dark", "System", "Automatic", "Companion", "Lcommon/states/DarkModeState$Automatic;", "Lcommon/states/DarkModeState$Dark;", "Lcommon/states/DarkModeState$Light;", "Lcommon/states/DarkModeState$System;", "shared"})
@StabilityInferred(parameters=1)
public abstract class DarkModeState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String key;
    public static final int $stable;
    @NotNull
    public static final String darkModeSettingsKey = "darkModeKey";

    private DarkModeState(String key) {
        this.key = key;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final boolean isDarkMode(boolean isSystemDarkMode, @NotNull TimeProvider timeProvider) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        DarkModeState darkModeState = this;
        if (Intrinsics.areEqual((Object)darkModeState, (Object)Dark.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)darkModeState, (Object)Light.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)darkModeState, (Object)System.INSTANCE)) {
            bl = isSystemDarkMode;
        } else if (Intrinsics.areEqual((Object)darkModeState, (Object)Automatic.INSTANCE)) {
            int currentHour = TimeProvider.INSTANCE.getTime(TimeZone.Companion.currentSystemDefault()).getHour();
            bl = currentHour >= 20 || currentHour < 8;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public /* synthetic */ DarkModeState(String key, DefaultConstructorMarker $constructor_marker) {
        this(key);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcommon/states/DarkModeState$Automatic;", "Lcommon/states/DarkModeState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Automatic
    extends DarkModeState {
        @NotNull
        public static final Automatic INSTANCE = new Automatic();
        public static final int $stable;

        private Automatic() {
            super("automatic", null);
        }

        @NotNull
        public String toString() {
            return "Automatic";
        }

        public int hashCode() {
            return -737094196;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Automatic)) {
                return false;
            }
            Automatic cfr_ignored_0 = (Automatic)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcommon/states/DarkModeState$Companion;", "", "<init>", "()V", "darkModeSettingsKey", "", "getDarkMode", "Lcommon/states/DarkModeState;", "key", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DarkModeState getDarkMode(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string2 = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String string3 = string2;
            return Intrinsics.areEqual((Object)string3, (Object)Light.INSTANCE.getKey()) ? (DarkModeState)Light.INSTANCE : (Intrinsics.areEqual((Object)string3, (Object)Dark.INSTANCE.getKey()) ? (DarkModeState)Dark.INSTANCE : (Intrinsics.areEqual((Object)string3, (Object)System.INSTANCE.getKey()) ? (DarkModeState)System.INSTANCE : (Intrinsics.areEqual((Object)string3, (Object)Automatic.INSTANCE.getKey()) ? (DarkModeState)Automatic.INSTANCE : (DarkModeState)Dark.INSTANCE)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcommon/states/DarkModeState$Dark;", "Lcommon/states/DarkModeState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Dark
    extends DarkModeState {
        @NotNull
        public static final Dark INSTANCE = new Dark();
        public static final int $stable;

        private Dark() {
            super("dark", null);
        }

        @NotNull
        public String toString() {
            return "Dark";
        }

        public int hashCode() {
            return -461452491;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Dark)) {
                return false;
            }
            Dark cfr_ignored_0 = (Dark)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcommon/states/DarkModeState$Light;", "Lcommon/states/DarkModeState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Light
    extends DarkModeState {
        @NotNull
        public static final Light INSTANCE = new Light();
        public static final int $stable;

        private Light() {
            super("light", null);
        }

        @NotNull
        public String toString() {
            return "Light";
        }

        public int hashCode() {
            return -1412509385;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Light)) {
                return false;
            }
            Light cfr_ignored_0 = (Light)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcommon/states/DarkModeState$System;", "Lcommon/states/DarkModeState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class System
    extends DarkModeState {
        @NotNull
        public static final System INSTANCE = new System();
        public static final int $stable;

        private System() {
            super("system", null);
        }

        @NotNull
        public String toString() {
            return "System";
        }

        public int hashCode() {
            return -622568914;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof System)) {
                return false;
            }
            System cfr_ignored_0 = (System)other;
            return true;
        }
    }
}

