/*
 * Decompiled with CFR 0.152.
 */
package common.states;

import androidx.compose.runtime.internal.StabilityInferred;
import common.TimeProvider;
import common.states.FestivalNotActiveState;
import data.account.model.YearData;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00062\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcommon/states/FestivalActiveState;", "", "<init>", "()V", "Active", "NotActive", "Companion", "Lcommon/states/FestivalActiveState$Active;", "Lcommon/states/FestivalActiveState$NotActive;", "shared"})
@StabilityInferred(parameters=1)
public abstract class FestivalActiveState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    private FestivalActiveState() {
    }

    public /* synthetic */ FestivalActiveState(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcommon/states/FestivalActiveState$Active;", "Lcommon/states/FestivalActiveState;", "dayOfFestival", "", "<init>", "(I)V", "getDayOfFestival", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Active
    extends FestivalActiveState {
        private final int dayOfFestival;
        public static final int $stable;

        public Active(int dayOfFestival) {
            super(null);
            this.dayOfFestival = dayOfFestival;
        }

        public final int getDayOfFestival() {
            return this.dayOfFestival;
        }

        public final int component1() {
            return this.dayOfFestival;
        }

        @NotNull
        public final Active copy(int dayOfFestival) {
            return new Active(dayOfFestival);
        }

        public static /* synthetic */ Active copy$default(Active active, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = active.dayOfFestival;
            }
            return active.copy(n);
        }

        @NotNull
        public String toString() {
            return "Active(dayOfFestival=" + this.dayOfFestival + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.dayOfFestival);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Active)) {
                return false;
            }
            Active active = (Active)other;
            return this.dayOfFestival == active.dayOfFestival;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcommon/states/FestivalActiveState$Companion;", "", "<init>", "()V", "getFestivalActiveState", "Lcommon/states/FestivalActiveState;", "yearData", "Ldata/account/model/YearData;", "timeProvider", "Lcommon/TimeProvider;", "shared"})
    @SourceDebugExtension(value={"SMAP\nFestivalActiveState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FestivalActiveState.kt\ncommon/states/FestivalActiveState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1878#2,3:48\n*S KotlinDebug\n*F\n+ 1 FestivalActiveState.kt\ncommon/states/FestivalActiveState$Companion\n*L\n35#1:48,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FestivalActiveState getFestivalActiveState(@NotNull YearData yearData, @NotNull TimeProvider timeProvider) {
            Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
            Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
            Instant currentTime = TimeZoneKt.toInstant((LocalDateTime)TimeProvider.getTime$default(TimeProvider.INSTANCE, null, 1, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
            LocalDateTime localDateTime = (LocalDateTime)CollectionsKt.lastOrNull(yearData.getDateList());
            if (localDateTime != null) {
                LocalDateTime localDateTime2 = localDateTime;
                boolean bl = false;
                Instant startOfDay = TimeZoneKt.toInstant((LocalDateTime)localDateTime2, (TimeZone)yearData.getZoneId());
                Instant endOfDay = InstantKt.plus((Instant)startOfDay, (int)24, (DateTimeUnit.TimeBased)DateTimeUnit.Companion.getHOUR());
                if (currentTime.compareTo(endOfDay) > 0) {
                    return new NotActive(FestivalNotActiveState.AfterFestival.INSTANCE);
                }
            }
            Iterable $this$forEachIndexed$iv = yearData.getDateList();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void localDateTime3;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalDateTime localDateTime4 = (LocalDateTime)item$iv;
                int index = n;
                boolean bl = false;
                Instant startOfDay = TimeZoneKt.toInstant((LocalDateTime)localDateTime3, (TimeZone)yearData.getZoneId());
                Instant endOfDay = InstantKt.plus((Instant)startOfDay, (int)24, (DateTimeUnit.TimeBased)DateTimeUnit.Companion.getHOUR());
                if (!Intrinsics.areEqual((Object)currentTime, (Object)startOfDay) && currentTime.compareTo(startOfDay) <= 0 || currentTime.compareTo(endOfDay) >= 0) continue;
                return new Active(index);
            }
            return new NotActive(FestivalNotActiveState.BeforeFestival.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcommon/states/FestivalActiveState$NotActive;", "Lcommon/states/FestivalActiveState;", "notActiveState", "Lcommon/states/FestivalNotActiveState;", "<init>", "(Lcommon/states/FestivalNotActiveState;)V", "getNotActiveState", "()Lcommon/states/FestivalNotActiveState;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class NotActive
    extends FestivalActiveState {
        @NotNull
        private final FestivalNotActiveState notActiveState;
        public static final int $stable;

        public NotActive(@NotNull FestivalNotActiveState notActiveState) {
            Intrinsics.checkNotNullParameter((Object)notActiveState, (String)"notActiveState");
            super(null);
            this.notActiveState = notActiveState;
        }

        @NotNull
        public final FestivalNotActiveState getNotActiveState() {
            return this.notActiveState;
        }

        @NotNull
        public final FestivalNotActiveState component1() {
            return this.notActiveState;
        }

        @NotNull
        public final NotActive copy(@NotNull FestivalNotActiveState notActiveState) {
            Intrinsics.checkNotNullParameter((Object)notActiveState, (String)"notActiveState");
            return new NotActive(notActiveState);
        }

        public static /* synthetic */ NotActive copy$default(NotActive notActive, FestivalNotActiveState festivalNotActiveState, int n, Object object) {
            if ((n & 1) != 0) {
                festivalNotActiveState = notActive.notActiveState;
            }
            return notActive.copy(festivalNotActiveState);
        }

        @NotNull
        public String toString() {
            return "NotActive(notActiveState=" + this.notActiveState + ")";
        }

        public int hashCode() {
            return this.notActiveState.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotActive)) {
                return false;
            }
            NotActive notActive = (NotActive)other;
            return Intrinsics.areEqual((Object)this.notActiveState, (Object)notActive.notActiveState);
        }
    }
}

