/*
 * Decompiled with CFR 0.152.
 */
package data;

import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import com.russhwolf.settings.Settings;
import com.shambatimes.database.LiveDatabase;
import data.DestructiveMigrationSchema0To1;
import di.MultiLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Ldata/DatabaseMigrations;", "", "<init>", "()V", "databaseMigration", "", "key", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "settings", "Lcom/russhwolf/settings/Settings;", "logger", "Ldi/MultiLogger;", "setPragmaVersion", "version", "", "getPragmaVersion", "", "shared"})
@StabilityInferred(parameters=1)
public final class DatabaseMigrations {
    @NotNull
    public static final DatabaseMigrations INSTANCE = new DatabaseMigrations();
    public static final int $stable;

    private DatabaseMigrations() {
    }

    public final void databaseMigration(@NotNull String key, @NotNull SqlDriver driver, @NotNull Settings settings, @NotNull MultiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        int databaseVersion = settings.getInt(key, 0);
        int pragmaVersion = this.getPragmaVersion(driver);
        int migratedLegacyDatabaseKey = 2;
        long targetVersion = 6L;
        if (databaseVersion == 0) {
            logger.i("Legacy Database Version is 0, doing destructive migration");
            DestructiveMigrationSchema0To1.INSTANCE.migrate-zeHU3Mk(driver, 0L, 1L, new AfterVersion[0]);
            this.setPragmaVersion(targetVersion, driver, logger);
            pragmaVersion = this.getPragmaVersion(driver);
            settings.putInt(key, migratedLegacyDatabaseKey);
        }
        if (databaseVersion == 1 && pragmaVersion == 0) {
            logger.i("Initial Legacy Upgraded Users Migrating To New Pragma Versioning");
            this.setPragmaVersion(1L, driver, logger);
            pragmaVersion = this.getPragmaVersion(driver);
            settings.putInt(key, migratedLegacyDatabaseKey);
        }
        if (databaseVersion == migratedLegacyDatabaseKey && pragmaVersion == 0) {
            logger.e("Database was deleted or app downgraded and upgraded, marking as up to date and performing migration");
            DestructiveMigrationSchema0To1.INSTANCE.migrate-zeHU3Mk(driver, 0L, 1L, new AfterVersion[0]);
            this.setPragmaVersion(targetVersion, driver, logger);
            pragmaVersion = this.getPragmaVersion(driver);
        }
        if ((long)pragmaVersion > targetVersion) {
            logger.e("Downgrade Detected - Destructive Reset");
            DestructiveMigrationSchema0To1.INSTANCE.migrate-zeHU3Mk(driver, 0L, 1L, new AfterVersion[0]);
            this.setPragmaVersion(targetVersion, driver, logger);
            settings.putInt(key, migratedLegacyDatabaseKey);
        }
        logger.i("Pragma Version " + pragmaVersion + " to " + targetVersion);
        try {
            ((QueryResult.Value)LiveDatabase.Companion.getSchema().migrate(driver, (long)pragmaVersion, targetVersion, new AfterVersion[0])).unbox-impl();
        }
        catch (Exception exception) {
            logger.e("DATABASE MIGRATION FAILED, DESTRUCTIVE MIGRATION TO AVOID CRASH ON LAUNCH", exception);
            DestructiveMigrationSchema0To1.INSTANCE.migrate-zeHU3Mk(driver, 0L, 1L, new AfterVersion[0]);
        }
        if ((long)pragmaVersion < targetVersion) {
            this.setPragmaVersion(targetVersion, driver, logger);
        }
    }

    private final void setPragmaVersion(long version, SqlDriver driver, MultiLogger logger) {
        logger.i("Updating PRAGMA Version To " + version);
        SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)("PRAGMA user_version = " + version), (int)0, null, (int)8, null);
    }

    private final int getPragmaVersion(SqlDriver driver) {
        return ((Number)SqlDriver.DefaultImpls.executeQuery$default((SqlDriver)driver, null, (String)"PRAGMA user_version", DatabaseMigrations::getPragmaVersion$lambda$0, (int)0, null, (int)16, null).getValue()).intValue();
    }

    private static final QueryResult getPragmaVersion$lambda$0(SqlCursor cursor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        if (((Boolean)cursor.next().getValue()).booleanValue()) {
            Long l = cursor.getLong(0);
            n = l != null ? (int)l.longValue() : 0;
        } else {
            n = 0;
        }
        return (QueryResult)QueryResult.Value.box-impl((Object)QueryResult.Value.constructor-impl((Object)n));
    }
}

