/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.mp4.Mp4Context;
import java.io.IOException;
import java.io.InputStream;

public class Mp4Reader {
    private Mp4Reader() {
    }

    public static void extract(@NotNull InputStream inputStream, @NotNull Mp4Handler<?> handler) {
        StreamReader reader = new StreamReader(inputStream);
        reader.setMotorolaByteOrder(true);
        Mp4Context context = new Mp4Context();
        Mp4Reader.processBoxes(reader, -1L, handler, context);
    }

    private static void processBoxes(StreamReader reader, long atomEnd, Mp4Handler<?> handler, Mp4Context context) {
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                boolean isLargeSize;
                long boxSize = reader.getUInt32();
                String boxType = reader.getString(4);
                boolean bl = isLargeSize = boxSize == 1L;
                if (isLargeSize) {
                    boxSize = reader.getInt64();
                }
                if (boxSize > Integer.MAX_VALUE) {
                    handler.addError("Box size too large.");
                    break;
                }
                if (boxSize < 8L) {
                    handler.addError("Box size too small.");
                    break;
                }
                if (handler.shouldAcceptContainer(boxType)) {
                    Mp4Reader.processBoxes(reader, boxSize + reader.getPosition() - 8L, handler.processContainer(boxType, boxSize, context), context);
                    continue;
                }
                if (handler.shouldAcceptBox(boxType)) {
                    handler = handler.processBox(boxType, reader.getBytes((int)boxSize - 8), boxSize, context);
                    continue;
                }
                if (isLargeSize) {
                    if (boxSize >= 16L) {
                        reader.skip(boxSize - 16L);
                        continue;
                    }
                    break;
                }
                reader.skip(boxSize - 8L);
            }
        }
        catch (IOException e) {
            handler.addError(e.getMessage());
        }
    }
}

