/*
 * Decompiled with CFR 0.152.
 */
package extensions;

import androidx.compose.ui.text.StringKt;
import extensions.LocalDateTimeExtensionsKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import kotlinx.datetime.format.DayOfWeekNames;
import kotlinx.datetime.format.MonthNames;
import kotlinx.datetime.format.Padding;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"toMonthDayString", "", "Lkotlinx/datetime/LocalDate;", "Lkotlinx/datetime/LocalDateTime;", "toDropDownDate", "roundToNearestMinutes", "intervalMinutes", "", "shared"})
@SourceDebugExtension(value={"SMAP\nLocalDateExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateExtensions.kt\nextensions/LocalDateExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class LocalDateExtensionsKt {
    @NotNull
    public static final String toMonthDayString(@NotNull LocalDate $this$toMonthDayString) {
        Intrinsics.checkNotNullParameter((Object)$this$toMonthDayString, (String)"<this>");
        String string2 = $this$toMonthDayString.getMonth().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringKt.capitalize((String)string2, (androidx.compose.ui.text.intl.Locale)androidx.compose.ui.text.intl.Locale.Companion.getCurrent()) + " " + $this$toMonthDayString.getDayOfMonth();
    }

    @NotNull
    public static final String toMonthDayString(@NotNull LocalDateTime $this$toMonthDayString) {
        Intrinsics.checkNotNullParameter((Object)$this$toMonthDayString, (String)"<this>");
        String string2 = $this$toMonthDayString.getMonth().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringKt.capitalize((String)string2, (androidx.compose.ui.text.intl.Locale)androidx.compose.ui.text.intl.Locale.Companion.getCurrent()) + " " + $this$toMonthDayString.getDayOfMonth();
    }

    @NotNull
    public static final String toDropDownDate(@NotNull LocalDate $this$toDropDownDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDropDownDate, (String)"<this>");
        DateTimeFormat formatter = LocalDate.Companion.Format(LocalDateExtensionsKt::toDropDownDate$lambda$0);
        String formatted = formatter.format((Object)$this$toDropDownDate);
        return formatted;
    }

    @NotNull
    public static final LocalDateTime roundToNearestMinutes(@NotNull LocalDateTime $this$roundToNearestMinutes, int intervalMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$roundToNearestMinutes, (String)"<this>");
        if (!(intervalMinutes > 0)) {
            boolean $i$a$-require-LocalDateExtensionsKt$roundToNearestMinutes$22 = false;
            String $i$a$-require-LocalDateExtensionsKt$roundToNearestMinutes$22 = "intervalMinutes must be positive";
            throw new IllegalArgumentException($i$a$-require-LocalDateExtensionsKt$roundToNearestMinutes$22.toString());
        }
        int totalMinutes = $this$roundToNearestMinutes.getHour() * 60 + $this$roundToNearestMinutes.getMinute() + ($this$roundToNearestMinutes.getSecond() + 30) / 60;
        int roundedMinutes = totalMinutes / intervalMinutes * intervalMinutes;
        return LocalDateTimeExtensionsKt.plus$default(LocalDateKt.atTime$default((LocalDate)$this$roundToNearestMinutes.getDate(), (int)0, (int)0, (int)0, (int)0, (int)12, null), roundedMinutes, DateTimeUnit.Companion.getMINUTE(), null, 4, null);
    }

    private static final Unit toDropDownDate$lambda$0(DateTimeFormatBuilder.WithDate $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        $this$Format.dayOfWeek(DayOfWeekNames.Companion.getENGLISH_ABBREVIATED());
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)' ');
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'(');
        $this$Format.monthName(MonthNames.Companion.getENGLISH_ABBREVIATED());
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)' ');
        $this$Format.dayOfMonth(Padding.NONE);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)')');
        return Unit.INSTANCE;
    }
}

