/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.grid;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import cafe.adriel.voyager.core.model.ScreenModel;
import cafe.adriel.voyager.core.model.ScreenModelKt;
import com.russhwolf.settings.Settings;
import common.ConstantsKt;
import common.MinimumGridItemSizeType;
import common.analytics.AnalyticsLogger;
import data.account.model.Stage;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import models.GridDimensions;
import models.GridOrientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.screens.grid.FirstTimeGridHelpType;
import ui.screens.grid.GridState;
import ui.screens.grid.GridViewModelKt;
import ui.screens.home.SearchedPerformance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0004\b%\u0010&J\b\u0010'\u001a\u00020\u0007H\u0002J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0015J\u001e\u0010Z\u001a\u00020X2\u0006\u0010[\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010]\u001a\u00020XJ\u000e\u0010^\u001a\u00020X2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010_\u001a\u00020XJ\u0006\u0010`\u001a\u00020XJ\u0006\u0010a\u001a\u00020XJ\u0006\u0010b\u001a\u00020XJ\u000e\u0010c\u001a\u0002062\u0006\u0010d\u001a\u000206J\u000e\u0010e\u001a\u0002062\u0006\u0010d\u001a\u000206J\u0016\u0010f\u001a\u00020X2\u0006\u0010g\u001a\u00020\u00072\u0006\u0010h\u001a\u00020\u0007J\u0017\u0010i\u001a\u00020X2\u0006\u0010j\u001a\u00020kH\u0002\u00a2\u0006\u0004\bl\u0010mJ\u001d\u0010n\u001a\u00020X2\u0006\u0010o\u001a\u00020k2\u0006\u0010p\u001a\u00020\u0005\u00a2\u0006\u0004\bq\u0010rJ\u000e\u0010s\u001a\u00020X2\u0006\u0010t\u001a\u00020\u0005J\u0006\u0010u\u001a\u00020XJ.\u0010v\u001a\u00020\u00152\u0006\u0010w\u001a\u00020\u00052\u0006\u0010x\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u00072\u0006\u0010z\u001a\u00020\u00072\u0006\u0010{\u001a\u00020\u0007J\u0006\u0010|\u001a\u00020XJ\b\u0010}\u001a\u00020XH\u0016J)\u0010~\u001a\u00020X2\u0006\u0010\u007f\u001a\u00020>2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u000f\u0010\u0082\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0083\u0001J\u0011\u0010\u0085\u0001\u001a\u00020X2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J\u0010\u0010\u0088\u0001\u001a\u00020X2\u0007\u0010\u0089\u0001\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00150+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150-\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010/R\u0016\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150-\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010/R\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00107\u001a\b\u0012\u0004\u0012\u0002060-\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010/R\u000e\u00109\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010=\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001c\u0010C\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010@\"\u0004\bE\u0010BR\u0011\u0010F\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010LR\u0014\u0010O\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010LR\u0014\u0010Q\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010LR\u0014\u0010S\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010LR\u0014\u0010U\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010L\u00a8\u0006\u008a\u0001"}, d2={"Lui/screens/grid/GridViewModel;", "Lcafe/adriel/voyager/core/model/ScreenModel;", "analyticsLogger", "Lcommon/analytics/AnalyticsLogger;", "density", "", "minutesPerRow", "", "settings", "Lcom/russhwolf/settings/Settings;", "<init>", "(Lcommon/analytics/AnalyticsLogger;FILcom/russhwolf/settings/Settings;)V", "getAnalyticsLogger", "()Lcommon/analytics/AnalyticsLogger;", "getDensity", "()F", "getSettings", "()Lcom/russhwolf/settings/Settings;", "stageCount", "gridOpacity", "isFirstGridVisit", "", "isFirstGridAdminVisit", "minimumGridSize", "", "fontSize", "isGridOrientationFlipped", "hasClearedRowColumnFilters", "isGridZoomChangesToSave", "zoneId", "Lkotlinx/datetime/TimeZone;", "minimumPortraitOrientation", "Lmodels/GridOrientation$Portrait;", "minimumLandscapeOrientation", "Lmodels/GridOrientation$Landscape;", "getMinimumGridFontItemSize", "Landroidx/compose/ui/unit/TextUnit;", "getMinimumGridFontItemSize-XSAIIZE", "()J", "getMinimumGridItemSize", "portraitOrientation", "landscapeOrientation", "_gridFavoriteFilterLiveData", "Lkotlinx/coroutines/flow/MutableStateFlow;", "gridFavoriteFilterLiveData", "Lkotlinx/coroutines/flow/StateFlow;", "getGridFavoriteFilterLiveData", "()Lkotlinx/coroutines/flow/StateFlow;", "_gridShowCurrentlyPlayingLiveData", "gridShowCurrentlyPlayingLiveData", "getGridShowCurrentlyPlayingLiveData", "_isFirstLoadJump", "isFirstLoadJump", "_gridStateLiveData", "Lui/screens/grid/GridState;", "gridStateLiveData", "getGridStateLiveData", "maxYZoom", "maxXZoom", "viewHeight", "screenWidth", "startOfDay", "Lkotlinx/datetime/Instant;", "getStartOfDay", "()Lkotlinx/datetime/Instant;", "setStartOfDay", "(Lkotlinx/datetime/Instant;)V", "earliestPerformance", "getEarliestPerformance", "setEarliestPerformance", "numberOfHeaders", "getNumberOfHeaders", "()I", "maxGridHeightLandscape", "Lmodels/GridDimensions;", "getMaxGridHeightLandscape", "()Lmodels/GridDimensions;", "maxGridHeightPortrait", "getMaxGridHeightPortrait", "maxGridWidthLandscape", "getMaxGridWidthLandscape", "maxGridWidthPortrait", "getMaxGridWidthPortrait", "maxGridHeight", "getMaxGridHeight", "maxGridWidth", "getMaxGridWidth", "performFirstLoadJump", "", "isFirstLoad", "setGridScreenDimensionsAndStartingOffset", "height", "width", "setDynamicOrientations", "setGridZoneId", "gridFavoritesClicked", "gridShowCurrentlyPlayingClicked", "clearOtherSelectedActions", "gridStateToggled", "getPortraitToLandscapeGridState", "previousGridState", "getLandscapeToPortraitGridState", "jumpToSearchOffset", "offsetX", "offsetY", "gridDragged", "dragAmount", "Landroidx/compose/ui/geometry/Offset;", "gridDragged-k-4lQ0M", "(J)V", "gridTransformed", "pan", "zoom", "gridTransformed-3MmeM6k", "(JF)V", "gridZoomed", "zoomChange", "saveAnyZoomChanges", "isZoomBeyondLimits", "zoomDirection", "zoomX", "zoomXChange", "zoomY", "zoomYChange", "clearFiltersClickedOnce", "onDispose", "handleSearchResult", "startTimeInstant", "searchedPerformance", "Lui/screens/home/SearchedPerformance;", "stageList", "", "Ldata/account/model/Stage;", "gridHelpAcknowledged", "firstTimeType", "Lui/screens/grid/FirstTimeGridHelpType;", "setStageCount", "count", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGridViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridViewModel.kt\nui/screens/grid/GridViewModel\n+ 2 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,762:1\n155#2,2:763\n155#2,2:765\n30#3:767\n30#3:771\n53#4,3:768\n53#4,3:772\n60#4:776\n70#4:779\n70#4:782\n60#4:785\n60#4:788\n70#4:791\n65#5:775\n69#5:778\n69#5:781\n65#5:784\n65#5:787\n69#5:790\n22#6:777\n22#6:780\n22#6:783\n22#6:786\n22#6:789\n22#6:792\n360#7,7:793\n*S KotlinDebug\n*F\n+ 1 GridViewModel.kt\nui/screens/grid/GridViewModel\n*L\n336#1:763,2\n357#1:765,2\n414#1:767\n481#1:771\n414#1:768,3\n481#1:772,3\n487#1:776\n488#1:779\n496#1:782\n497#1:785\n515#1:788\n516#1:791\n487#1:775\n488#1:778\n496#1:781\n497#1:784\n515#1:787\n516#1:790\n487#1:777\n488#1:780\n496#1:783\n497#1:786\n515#1:789\n516#1:792\n717#1:793,7\n*E\n"})
public final class GridViewModel
implements ScreenModel {
    @NotNull
    private final AnalyticsLogger analyticsLogger;
    private final float density;
    @NotNull
    private final Settings settings;
    private int stageCount;
    private float gridOpacity;
    private boolean isFirstGridVisit;
    private boolean isFirstGridAdminVisit;
    @NotNull
    private String minimumGridSize;
    @NotNull
    private String fontSize;
    private boolean isGridOrientationFlipped;
    private boolean hasClearedRowColumnFilters;
    private boolean isGridZoomChangesToSave;
    @NotNull
    private TimeZone zoneId;
    @NotNull
    private GridOrientation.Portrait minimumPortraitOrientation;
    @NotNull
    private GridOrientation.Landscape minimumLandscapeOrientation;
    @NotNull
    private GridOrientation.Portrait portraitOrientation;
    @NotNull
    private GridOrientation.Landscape landscapeOrientation;
    @NotNull
    private final MutableStateFlow<Boolean> _gridFavoriteFilterLiveData;
    @NotNull
    private final StateFlow<Boolean> gridFavoriteFilterLiveData;
    @NotNull
    private final MutableStateFlow<Boolean> _gridShowCurrentlyPlayingLiveData;
    @NotNull
    private final StateFlow<Boolean> gridShowCurrentlyPlayingLiveData;
    @NotNull
    private final MutableStateFlow<Boolean> _isFirstLoadJump;
    @NotNull
    private final StateFlow<Boolean> isFirstLoadJump;
    @NotNull
    private final MutableStateFlow<GridState> _gridStateLiveData;
    @NotNull
    private final StateFlow<GridState> gridStateLiveData;
    private final int maxYZoom;
    private final int maxXZoom;
    private int viewHeight;
    private int screenWidth;
    @Nullable
    private Instant startOfDay;
    @Nullable
    private Instant earliestPerformance;
    private final int numberOfHeaders;
    public static final int $stable = 8;

    public GridViewModel(@NotNull AnalyticsLogger analyticsLogger, float density, int minutesPerRow, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)analyticsLogger, (String)"analyticsLogger");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.analyticsLogger = analyticsLogger;
        this.density = density;
        this.settings = settings;
        this.gridOpacity = (float)this.settings.getInt("gridOpacityKey", 70) / 100.0f;
        this.isFirstGridVisit = this.settings.getBoolean("isFirstGridVisit", true);
        this.isFirstGridAdminVisit = this.settings.getBoolean("isFirstGridAdminVisit", true);
        this.minimumGridSize = this.settings.getString("minimumGridStageSizeKey", "small");
        this.fontSize = this.settings.getString("gridFontSizeKey", "small");
        this.isGridOrientationFlipped = this.settings.getBoolean("isGridFlipped" + this.settings.getString("activeEventSelectedKey", ""), false);
        this.zoneId = (TimeZone)TimeZone.Companion.getUTC();
        this.hasClearedRowColumnFilters = this.settings.getBoolean("hasClearedRowColumnFiltersKey", false);
        this.minimumPortraitOrientation = new GridOrientation.Portrait(MathKt.roundToInt((float)((float)70 * this.density)), this.getMinimumGridItemSize(), MathKt.roundToInt((float)((float)120 * this.density)), this.getMinimumGridFontItemSize-XSAIIZE(), null);
        this.minimumLandscapeOrientation = new GridOrientation.Landscape(MathKt.roundToInt((float)((float)80 * this.density)), MathKt.roundToInt((float)((float)80 * this.density)), this.getMinimumGridItemSize(), this.getMinimumGridFontItemSize-XSAIIZE(), null);
        this.portraitOrientation = this.minimumPortraitOrientation;
        this.landscapeOrientation = this.minimumLandscapeOrientation;
        this._gridFavoriteFilterLiveData = StateFlowKt.MutableStateFlow((Object)false);
        this.gridFavoriteFilterLiveData = (StateFlow)this._gridFavoriteFilterLiveData;
        this._gridShowCurrentlyPlayingLiveData = StateFlowKt.MutableStateFlow((Object)false);
        this.gridShowCurrentlyPlayingLiveData = (StateFlow)this._gridShowCurrentlyPlayingLiveData;
        this._isFirstLoadJump = StateFlowKt.MutableStateFlow(null);
        this.isFirstLoadJump = (StateFlow)this._isFirstLoadJump;
        this._gridStateLiveData = StateFlowKt.MutableStateFlow((Object)new GridState(this.isGridOrientationFlipped ? (GridOrientation)this.landscapeOrientation : (GridOrientation)this.portraitOrientation, 0.0f, 0.0f, this.settings.getInt("zoomX", 0), this.settings.getInt("zoomY", 0), this.gridOpacity, this.hasClearedRowColumnFilters, this.isFirstGridVisit, this.isFirstGridAdminVisit, 6, null));
        this.gridStateLiveData = (StateFlow)this._gridStateLiveData;
        this.maxYZoom = MathKt.roundToInt((float)((float)80 * this.density));
        this.maxXZoom = MathKt.roundToInt((float)((float)39 * this.density));
        this.numberOfHeaders = ConstantsKt.getMinutesPerDay() / minutesPerRow;
    }

    @NotNull
    public final AnalyticsLogger getAnalyticsLogger() {
        return this.analyticsLogger;
    }

    public final float getDensity() {
        return this.density;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    private final long getMinimumGridFontItemSize-XSAIIZE() {
        String string2 = this.fontSize;
        return Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.Small.INSTANCE.getKey()) ? TextUnitKt.getSp((double)12.5) : (Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.Medium.INSTANCE.getKey()) ? TextUnitKt.getSp((int)14) : (Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.Large.INSTANCE.getKey()) ? TextUnitKt.getSp((int)15) : (Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.XLarge.INSTANCE.getKey()) ? TextUnitKt.getSp((int)16) : TextUnitKt.getSp((int)13))));
    }

    private final int getMinimumGridItemSize() {
        String string2 = this.minimumGridSize;
        return Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.Small.INSTANCE.getKey()) ? MathKt.roundToInt((float)((float)70 * this.density)) : (Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.Medium.INSTANCE.getKey()) ? MathKt.roundToInt((float)((float)85 * this.density)) : (Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.Large.INSTANCE.getKey()) ? MathKt.roundToInt((float)((float)100 * this.density)) : (Intrinsics.areEqual((Object)string2, (Object)MinimumGridItemSizeType.XLarge.INSTANCE.getKey()) ? MathKt.roundToInt((float)((float)120 * this.density)) : MathKt.roundToInt((float)((float)70 * this.density)))));
    }

    @NotNull
    public final StateFlow<Boolean> getGridFavoriteFilterLiveData() {
        return this.gridFavoriteFilterLiveData;
    }

    @NotNull
    public final StateFlow<Boolean> getGridShowCurrentlyPlayingLiveData() {
        return this.gridShowCurrentlyPlayingLiveData;
    }

    @NotNull
    public final StateFlow<Boolean> isFirstLoadJump() {
        return this.isFirstLoadJump;
    }

    @NotNull
    public final StateFlow<GridState> getGridStateLiveData() {
        return this.gridStateLiveData;
    }

    @Nullable
    public final Instant getStartOfDay() {
        return this.startOfDay;
    }

    public final void setStartOfDay(@Nullable Instant instant) {
        this.startOfDay = instant;
    }

    @Nullable
    public final Instant getEarliestPerformance() {
        return this.earliestPerformance;
    }

    public final void setEarliestPerformance(@Nullable Instant instant) {
        this.earliestPerformance = instant;
    }

    public final int getNumberOfHeaders() {
        return this.numberOfHeaders;
    }

    private final GridDimensions getMaxGridHeightLandscape() {
        return new GridDimensions(((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getHourHeight() * this.stageCount + MathKt.roundToInt((float)((float)56 * this.density)), ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getColumnWidth());
    }

    private final GridDimensions getMaxGridHeightPortrait() {
        return new GridDimensions(((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getRowHeight(((GridState)this.gridStateLiveData.getValue()).getZoomY()) * this.numberOfHeaders + this.minimumPortraitOrientation.getAxisHeightOrWidth(), ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getHourHeight());
    }

    private final GridDimensions getMaxGridWidthLandscape() {
        return new GridDimensions((((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getColumnWidth() + ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getWidthZoomOffset(((GridState)this.gridStateLiveData.getValue()).getZoomX())) * this.numberOfHeaders + ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getAxisHeightOrWidth(), ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getHourHeight());
    }

    private final GridDimensions getMaxGridWidthPortrait() {
        return new GridDimensions(((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getAxisHeightOrWidth() + this.stageCount * ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getColumnWidth(), ((GridState)this.gridStateLiveData.getValue()).getGridOrientation().getColumnWidth());
    }

    private final GridDimensions getMaxGridHeight() {
        GridDimensions gridDimensions;
        GridOrientation gridOrientation = ((GridState)this.gridStateLiveData.getValue()).getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            gridDimensions = this.getMaxGridHeightLandscape();
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            gridDimensions = this.getMaxGridHeightPortrait();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gridDimensions;
    }

    private final GridDimensions getMaxGridWidth() {
        GridDimensions gridDimensions;
        GridOrientation gridOrientation = ((GridState)this.gridStateLiveData.getValue()).getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            gridDimensions = this.getMaxGridWidthLandscape();
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            gridDimensions = this.getMaxGridWidthPortrait();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gridDimensions;
    }

    public final void performFirstLoadJump(boolean isFirstLoad) {
        if (isFirstLoad && this._isFirstLoadJump.getValue() == null) {
            this._isFirstLoadJump.setValue((Object)true);
        } else if (Intrinsics.areEqual((Object)this._isFirstLoadJump.getValue(), (Object)true)) {
            this._isFirstLoadJump.setValue((Object)false);
        }
    }

    public final void setGridScreenDimensionsAndStartingOffset(int height, int width, int stageCount) {
        GridOrientation gridOrientation;
        this.viewHeight = height;
        this.screenWidth = width;
        this.stageCount = stageCount;
        this.minimumGridSize = this.settings.getString("minimumGridStageSizeKey", "small");
        this.fontSize = this.settings.getString("gridFontSizeKey", "small");
        this.minimumLandscapeOrientation = GridOrientation.Landscape.copy-lGoEivg$default(this.minimumLandscapeOrientation, 0, 0, this.getMinimumGridItemSize(), this.getMinimumGridFontItemSize-XSAIIZE(), 3, null);
        this.minimumPortraitOrientation = GridOrientation.Portrait.copy-lGoEivg$default(this.minimumPortraitOrientation, 0, this.getMinimumGridItemSize(), 0, this.getMinimumGridFontItemSize-XSAIIZE(), 5, null);
        this.setDynamicOrientations();
        GridState gridState = (GridState)this._gridStateLiveData.getValue();
        Instant startOfDay = this.startOfDay;
        Instant earliestPerformance = this.earliestPerformance;
        Integer offsetMinY = startOfDay != null && earliestPerformance != null && gridState.getGridOrientation() instanceof GridOrientation.Portrait ? Integer.valueOf(MathKt.roundToInt((float)((float)Duration.getInWholeSeconds-impl((long)startOfDay.minus-5sfh64U(earliestPerformance)) / ConstantsKt.getSecondsPerHour() * (float)(((GridOrientation.Portrait)gridState.getGridOrientation()).getHourHeight() + gridState.getZoomY())))) : null;
        Integer offsetXMin = startOfDay != null && earliestPerformance != null && gridState.getGridOrientation() instanceof GridOrientation.Landscape ? Integer.valueOf(MathKt.roundToInt((float)((float)Duration.getInWholeSeconds-impl((long)startOfDay.minus-5sfh64U(earliestPerformance)) / ConstantsKt.getSecondsPerHour() * (float)(((GridOrientation.Landscape)gridState.getGridOrientation()).getColumnWidth() + gridState.getZoomX()))) * 2) : null;
        GridState gridState2 = (GridState)this.gridStateLiveData.getValue();
        GridOrientation gridOrientation2 = ((GridState)this.gridStateLiveData.getValue()).getGridOrientation();
        if (gridOrientation2 instanceof GridOrientation.Landscape) {
            gridOrientation = this.landscapeOrientation;
        } else if (gridOrientation2 instanceof GridOrientation.Portrait) {
            gridOrientation = this.portraitOrientation;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        GridOrientation gridOrientation3 = gridOrientation;
        float f = offsetMinY != null ? RangesKt.coerceAtMost((float)((GridState)this.gridStateLiveData.getValue()).getOffsetY(), (float)offsetMinY.intValue()) : ((GridState)this.gridStateLiveData.getValue()).getOffsetY();
        float f2 = offsetXMin != null ? RangesKt.coerceAtMost((float)((GridState)this.gridStateLiveData.getValue()).getOffsetX(), (float)offsetXMin.intValue()) : ((GridState)this.gridStateLiveData.getValue()).getOffsetX();
        this._gridStateLiveData.setValue((Object)GridState.copy$default(gridState2, gridOrientation3, f2, f, 0, 0, 0.0f, false, false, false, 504, null));
    }

    public final void setDynamicOrientations() {
        GridOrientation.Portrait portrait;
        long fontSize;
        long arg0$iv;
        boolean bl;
        double other$iv;
        float sizeIncrease;
        if (this.minimumLandscapeOrientation.getHourHeight() * this.stageCount + this.minimumLandscapeOrientation.getHourHeight() > this.viewHeight) {
            v0 = this.minimumLandscapeOrientation;
        } else {
            int availableHeight = this.viewHeight - this.minimumLandscapeOrientation.getHourHeight();
            int heightPerItem = availableHeight / this.stageCount;
            sizeIncrease = (float)heightPerItem / (float)this.minimumLandscapeOrientation.getHourHeight() - 1.0f;
            long l = TextUnitKt.getSp((int)12);
            other$iv = RangesKt.coerceAtMost((double)(1.0 + RangesKt.coerceAtLeast((double)((double)sizeIncrease * 0.7), (double)0.0)), (double)1.4);
            bl = false;
            TextUnitKt.checkArithmetic--R2X_6o((long)arg0$iv);
            fontSize = TextUnitKt.pack((long)TextUnit.getRawType-impl((long)arg0$iv), (float)((float)((double)TextUnit.getValue-impl((long)arg0$iv) * other$iv)));
            v0 = this.landscapeOrientation = new GridOrientation.Landscape(this.minimumLandscapeOrientation.getAxisHeightOrWidth(), this.minimumLandscapeOrientation.getColumnWidth(), RangesKt.coerceAtMost((int)heightPerItem, (int)MathKt.roundToInt((double)(105.0 * (double)this.density))), GridViewModelKt.coerceAtLeast-NB67dxo(fontSize, this.getMinimumGridFontItemSize-XSAIIZE()), null);
        }
        if (this.minimumPortraitOrientation.getColumnWidth() * this.stageCount + this.minimumPortraitOrientation.getAxisHeightOrWidth() > this.screenWidth) {
            portrait = this.minimumPortraitOrientation;
        } else {
            int availableWidth = this.screenWidth - this.minimumPortraitOrientation.getAxisHeightOrWidth();
            int widthPerItem = availableWidth / this.stageCount;
            sizeIncrease = (float)widthPerItem / (float)this.minimumLandscapeOrientation.getColumnWidth() - 1.0f;
            arg0$iv = TextUnitKt.getSp((int)12);
            other$iv = RangesKt.coerceAtMost((double)(1.0 + RangesKt.coerceAtLeast((double)((double)sizeIncrease * 0.7), (double)0.0)), (double)1.4);
            bl = false;
            TextUnitKt.checkArithmetic--R2X_6o((long)arg0$iv);
            fontSize = TextUnitKt.pack((long)TextUnit.getRawType-impl((long)arg0$iv), (float)((float)((double)TextUnit.getValue-impl((long)arg0$iv) * other$iv)));
            portrait = new GridOrientation.Portrait(this.minimumPortraitOrientation.getAxisHeightOrWidth(), RangesKt.coerceAtMost((int)widthPerItem, (int)MathKt.roundToInt((float)((float)350 * this.density))), this.minimumPortraitOrientation.getHourHeight(), GridViewModelKt.coerceAtLeast-NB67dxo(fontSize, this.getMinimumGridFontItemSize-XSAIIZE()), null);
        }
        this.portraitOrientation = portrait;
    }

    public final void setGridZoneId(@NotNull TimeZone zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = zoneId;
    }

    public final void gridFavoritesClicked() {
        if (!((Boolean)this.gridFavoriteFilterLiveData.getValue()).booleanValue()) {
            this.analyticsLogger.logGridFavoriteToggled();
        }
        this._gridFavoriteFilterLiveData.setValue((Object)((Boolean)this.gridFavoriteFilterLiveData.getValue() == false ? 1 : 0));
        this._gridShowCurrentlyPlayingLiveData.setValue((Object)false);
    }

    public final void gridShowCurrentlyPlayingClicked() {
        this._gridShowCurrentlyPlayingLiveData.setValue((Object)((Boolean)this.gridShowCurrentlyPlayingLiveData.getValue() == false ? 1 : 0));
        this._gridFavoriteFilterLiveData.setValue((Object)false);
    }

    public final void clearOtherSelectedActions() {
        this._gridShowCurrentlyPlayingLiveData.setValue((Object)false);
        this._gridFavoriteFilterLiveData.setValue((Object)false);
    }

    /*
     * WARNING - void declaration
     */
    public final void gridStateToggled() {
        void x$iv;
        GridState gridState;
        GridState gridState2 = (GridState)this.gridStateLiveData.getValue();
        String eventId = this.settings.getString("activeEventSelectedKey", "");
        GridOrientation gridOrientation = gridState2.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Portrait) {
            this.settings.putBoolean("isGridFlipped" + eventId, true);
            gridState = this.getPortraitToLandscapeGridState(gridState2);
        } else if (gridOrientation instanceof GridOrientation.Landscape) {
            this.settings.putBoolean("isGridFlipped" + eventId, false);
            gridState = this.getLandscapeToPortraitGridState(gridState2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this._gridStateLiveData.setValue((Object)gridState);
        this.analyticsLogger.logGridOrientationToggled(((GridState)this._gridStateLiveData.getValue()).getGridOrientation());
        float f = 0.0f;
        float y$iv = 0.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        this.gridDragged-k-4lQ0M(Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
    }

    @NotNull
    public final GridState getPortraitToLandscapeGridState(@NotNull GridState previousGridState) {
        Intrinsics.checkNotNullParameter((Object)previousGridState, (String)"previousGridState");
        GridOrientation.Landscape newOrientation = this.landscapeOrientation;
        int oldHeight = previousGridState.getGridOrientation().getHourHeight() / 2;
        int newWidth = newOrientation.getColumnWidth();
        int zoomX = RangesKt.coerceIn((int)previousGridState.getZoomY(), (int)(this.maxXZoom * -1), (int)this.maxXZoom);
        float previousYRowCountOffset = previousGridState.getOffsetY() / (float)(oldHeight + previousGridState.getZoomY() / 2);
        int adjustedWidth = newWidth + zoomX;
        return new GridState(newOrientation, previousYRowCountOffset * (float)adjustedWidth, 0.0f, zoomX, 0, this.gridOpacity, this.hasClearedRowColumnFilters, this.isFirstGridVisit, this.isFirstGridAdminVisit);
    }

    @NotNull
    public final GridState getLandscapeToPortraitGridState(@NotNull GridState previousGridState) {
        Intrinsics.checkNotNullParameter((Object)previousGridState, (String)"previousGridState");
        GridOrientation.Portrait newOrientation = this.portraitOrientation;
        int oldWidth = previousGridState.getGridOrientation().getColumnWidth();
        int newHeight = newOrientation.getHourHeight() / 2;
        int zoomY = RangesKt.coerceIn((int)previousGridState.getZoomX(), (int)(this.maxYZoom * -1), (int)this.maxYZoom);
        float previousYRowCountOffset = previousGridState.getOffsetX() / (float)(oldWidth + previousGridState.getZoomX());
        int adjustedHeight = newHeight + zoomY / 2;
        return new GridState(newOrientation, 0.0f, previousYRowCountOffset * (float)adjustedHeight, 0, zoomY, this.gridOpacity, this.hasClearedRowColumnFilters, this.isFirstGridVisit, this.isFirstGridAdminVisit);
    }

    /*
     * WARNING - void declaration
     */
    public final void jumpToSearchOffset(int offsetX, int offsetY) {
        void x$iv;
        GridState gridState = (GridState)this.gridStateLiveData.getValue();
        float f = gridState.getOffsetX();
        float y$iv = gridState.getOffsetY();
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        long gridOffset = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        GridOrientation gridOrientation = gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            long arg0$iv = gridOffset;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float f2 = (float)(-offsetX) - Float.intBitsToFloat(bits$iv$iv$iv);
            arg0$iv = gridOffset;
            boolean bl2 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            this.gridDragged-k-4lQ0M(Offset.copy-dBAh8RU((long)gridOffset, (float)f2, (float)((float)(-offsetY) - Float.intBitsToFloat(bits$iv$iv$iv))));
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            long arg0$iv = gridOffset;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits = false;
            float f3 = (float)(-offsetY) - Float.intBitsToFloat(bits$iv$iv$iv);
            long arg0$iv2 = gridOffset;
            boolean bl3 = false;
            long value$iv$iv2 = arg0$iv2;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
            boolean $i$f$floatFromBits2 = false;
            float f4 = (float)(-offsetX) - Float.intBitsToFloat(bits$iv$iv$iv2);
            this.gridDragged-k-4lQ0M(Offset.copy-dBAh8RU((long)gridOffset, (float)f4, (float)f3));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void gridDragged-k-4lQ0M(long dragAmount) {
        GridState gridState = (GridState)this.gridStateLiveData.getValue();
        float offsetX = gridState.getOffsetX();
        float offsetY = gridState.getOffsetY();
        float maxOffsetX = (float)(this.getMaxGridWidth().getTotalSize() - this.screenWidth) * -1.0f;
        float maxOffsetY = (float)(this.getMaxGridHeight().getTotalSize() - this.viewHeight) * -1.0f;
        long arg0$iv = dragAmount;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        offsetX = RangesKt.coerceIn((float)(offsetX + Float.intBitsToFloat(bits$iv$iv$iv)), (float)RangesKt.coerceAtMost((float)maxOffsetX, (float)0.0f), (float)0.0f);
        arg0$iv = dragAmount;
        boolean bl2 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        offsetY = RangesKt.coerceIn((float)(offsetY + Float.intBitsToFloat(bits$iv$iv$iv)), (float)RangesKt.coerceAtMost((float)maxOffsetY, (float)0.0f), (float)0.0f);
        Instant startOfDay = this.startOfDay;
        Instant earliestPerformance = this.earliestPerformance;
        Integer offsetYMin = startOfDay != null && earliestPerformance != null && ((GridState)this.gridStateLiveData.getValue()).getGridOrientation() instanceof GridOrientation.Portrait ? Integer.valueOf(MathKt.roundToInt((float)((float)Duration.getInWholeSeconds-impl((long)startOfDay.minus-5sfh64U(earliestPerformance)) / ConstantsKt.getSecondsPerHour() * (float)(gridState.getGridOrientation().getHourHeight() + gridState.getZoomY())))) : null;
        Integer offsetXMin = startOfDay != null && earliestPerformance != null && ((GridState)this.gridStateLiveData.getValue()).getGridOrientation() instanceof GridOrientation.Landscape ? Integer.valueOf(MathKt.roundToInt((float)((float)Duration.getInWholeSeconds-impl((long)startOfDay.minus-5sfh64U(earliestPerformance)) / ConstantsKt.getSecondsPerHour() * (float)(gridState.getGridOrientation().getColumnWidth() + gridState.getZoomX()))) * 2) : null;
        this._gridStateLiveData.setValue((Object)GridState.copy$default(gridState, null, offsetXMin != null ? RangesKt.coerceAtMost((float)offsetX, (float)offsetXMin.intValue()) : offsetX, offsetYMin != null ? RangesKt.coerceAtMost((float)offsetY, (float)offsetYMin.intValue()) : offsetY, 0, 0, 0.0f, false, false, false, 505, null));
    }

    public final void gridTransformed-3MmeM6k(long pan, float zoom) {
        if (zoom == 1.0f) {
            this.gridDragged-k-4lQ0M(pan);
        } else {
            this.gridZoomed(zoom);
        }
    }

    public final void gridZoomed(float zoomChange) {
        float f;
        float f2;
        int n;
        int n2;
        float f3;
        int n3;
        int n4;
        int n5;
        int zoomYChange;
        if (zoomChange == 1.0f) {
            return;
        }
        GridState gridState = (GridState)this.gridStateLiveData.getValue();
        int zoomX = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)gridState.getZoomX(), (int)(-this.maxXZoom)), (int)this.maxXZoom);
        int zoomY = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)gridState.getZoomY(), (int)(-this.maxYZoom)), (int)this.maxYZoom);
        int zoomXChange = gridState.getGridOrientation().getZoomWidthChange(zoomChange);
        if (this.isZoomBeyondLimits(zoomChange, zoomX, zoomXChange, zoomY, zoomYChange = gridState.getGridOrientation().getZoomHeightChange(zoomChange))) {
            return;
        }
        zoomX = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(zoomX + zoomXChange), (int)(-this.maxXZoom)), (int)this.maxXZoom);
        zoomY = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(zoomY + zoomYChange), (int)(-this.maxYZoom)), (int)this.maxYZoom);
        int offset = zoomChange > 1.0f ? -96 : 96;
        GridOrientation gridOrientation = gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Portrait) {
            n5 = ((GridOrientation.Portrait)gridState.getGridOrientation()).getHourHeight();
        } else if (gridOrientation instanceof GridOrientation.Landscape) {
            n5 = ((GridOrientation.Landscape)gridState.getGridOrientation()).getColumnWidth();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int unadjustedHeightOrWidth = n5;
        GridOrientation gridOrientation2 = gridState.getGridOrientation();
        if (gridOrientation2 instanceof GridOrientation.Portrait) {
            n4 = gridState.getZoomY();
        } else if (gridOrientation2 instanceof GridOrientation.Landscape) {
            n4 = gridState.getZoomX();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int previousZoom = n4;
        GridOrientation gridOrientation3 = gridState.getGridOrientation();
        if (gridOrientation3 instanceof GridOrientation.Portrait) {
            n3 = (unadjustedHeightOrWidth + previousZoom) / 2;
        } else if (gridOrientation3 instanceof GridOrientation.Landscape) {
            n3 = unadjustedHeightOrWidth + previousZoom;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int previousItemHeightOrWidth = n3;
        GridOrientation gridOrientation4 = gridState.getGridOrientation();
        if (gridOrientation4 instanceof GridOrientation.Landscape) {
            f3 = gridState.getOffsetX() / (float)previousItemHeightOrWidth;
        } else if (gridOrientation4 instanceof GridOrientation.Portrait) {
            f3 = gridState.getOffsetY() / (float)previousItemHeightOrWidth;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float previousRowColumnItemOffset = f3;
        GridOrientation gridOrientation5 = gridState.getGridOrientation();
        if (gridOrientation5 instanceof GridOrientation.Portrait) {
            n2 = zoomY;
        } else if (gridOrientation5 instanceof GridOrientation.Landscape) {
            n2 = zoomX;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int currentZoom = n2;
        GridOrientation gridOrientation6 = gridState.getGridOrientation();
        if (gridOrientation6 instanceof GridOrientation.Portrait) {
            n = (unadjustedHeightOrWidth + currentZoom) / 2;
        } else if (gridOrientation6 instanceof GridOrientation.Landscape) {
            n = unadjustedHeightOrWidth + currentZoom;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int currentHeightOrWidth = n;
        int calculatedCurrentHeightOrWidth = currentHeightOrWidth * 48 + offset;
        float currentXorYOffset = (float)currentHeightOrWidth * previousRowColumnItemOffset;
        GridOrientation gridOrientation7 = gridState.getGridOrientation();
        if (gridOrientation7 instanceof GridOrientation.Portrait) {
            f2 = RangesKt.coerceIn((float)currentXorYOffset, (float)RangesKt.coerceAtMost((float)(((float)calculatedCurrentHeightOrWidth - (float)this.viewHeight) * (float)-1), (float)0.0f), (float)0.0f);
        } else if (gridOrientation7 instanceof GridOrientation.Landscape) {
            f2 = gridState.getOffsetY();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float newOffsetY = f2;
        GridOrientation gridOrientation8 = gridState.getGridOrientation();
        if (gridOrientation8 instanceof GridOrientation.Portrait) {
            f = gridState.getOffsetX();
        } else if (gridOrientation8 instanceof GridOrientation.Landscape) {
            f = RangesKt.coerceIn((float)currentXorYOffset, (float)RangesKt.coerceAtMost((float)(((float)calculatedCurrentHeightOrWidth - (float)this.screenWidth) * (float)-1), (float)0.0f), (float)0.0f);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float newOffsetX = f;
        this.isGridZoomChangesToSave = true;
        this._gridStateLiveData.setValue((Object)GridState.copy$default(gridState, null, newOffsetX, newOffsetY, zoomX, zoomY, 0.0f, false, false, false, 481, null));
    }

    public final void saveAnyZoomChanges() {
        if (this.isGridZoomChangesToSave) {
            this.isGridZoomChangesToSave = false;
            BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ GridViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.this$0.getSettings().putInt("zoomX", ((GridState)this.this$0.getGridStateLiveData().getValue()).getZoomX());
                            this.this$0.getSettings().putInt("zoomY", ((GridState)this.this$0.getGridStateLiveData().getValue()).getZoomY());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public final boolean isZoomBeyondLimits(float zoomDirection, int zoomX, int zoomXChange, int zoomY, int zoomYChange) {
        return zoomX + zoomXChange < -this.maxXZoom && zoomDirection < 1.0f || zoomX + zoomXChange > this.maxXZoom && zoomDirection > 1.0f || zoomY + zoomYChange < -this.maxYZoom && zoomDirection < 1.0f || zoomY + zoomYChange > this.maxYZoom && zoomDirection > 1.0f;
    }

    public final void clearFiltersClickedOnce() {
        if (this.hasClearedRowColumnFilters) {
            return;
        }
        this.settings.putBoolean("hasClearedRowColumnFiltersKey", true);
        this.hasClearedRowColumnFilters = true;
        this._gridStateLiveData.setValue((Object)GridState.copy$default((GridState)this._gridStateLiveData.getValue(), null, 0.0f, 0.0f, 0, 0, 0.0f, true, false, false, 447, null));
    }

    public void onDispose() {
    }

    public final void handleSearchResult(@NotNull Instant startTimeInstant, @NotNull SearchedPerformance searchedPerformance2, @NotNull List<Stage> stageList) {
        int n;
        long performanceOffsetSeconds;
        int zoomWidthOffset;
        int zoomHeightOffset;
        int hourHeight;
        int stageWidth;
        GridState gridStateNonDerived;
        block6: {
            Intrinsics.checkNotNullParameter((Object)startTimeInstant, (String)"startTimeInstant");
            Intrinsics.checkNotNullParameter((Object)searchedPerformance2, (String)"searchedPerformance");
            Intrinsics.checkNotNullParameter(stageList, (String)"stageList");
            gridStateNonDerived = (GridState)this.gridStateLiveData.getValue();
            stageWidth = gridStateNonDerived.getGridOrientation().getColumnWidth();
            hourHeight = gridStateNonDerived.getGridOrientation().getHourHeight();
            zoomHeightOffset = gridStateNonDerived.getZoomY();
            zoomWidthOffset = gridStateNonDerived.getZoomX();
            performanceOffsetSeconds = Duration.getInWholeSeconds-impl((long)searchedPerformance2.getDisplayPerformance().getStartInstant().minus-5sfh64U(startTimeInstant));
            List<Stage> $this$indexOfFirst$iv = stageList;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Stage> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Stage item$iv;
                Stage it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getKey(), (Object)searchedPerformance2.getDisplayPerformance().getStageKey())) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = -1;
        }
        int stageOffset = n;
        GridOrientation gridOrientation = gridStateNonDerived.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Portrait) {
            int performanceY = MathKt.roundToInt((float)((float)performanceOffsetSeconds / ConstantsKt.getSecondsPerHour() * (float)(hourHeight + zoomHeightOffset)));
            int performanceX = stageOffset * stageWidth;
            this.jumpToSearchOffset(performanceX - 1, performanceY - 1);
        } else if (gridOrientation instanceof GridOrientation.Landscape) {
            int performanceX = MathKt.roundToInt((float)((float)performanceOffsetSeconds / ConstantsKt.getSecondsPerHour() * (float)(stageWidth + zoomWidthOffset) * (float)2));
            int performanceY = stageOffset * hourHeight;
            this.jumpToSearchOffset(performanceX - 1, performanceY - 1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void gridHelpAcknowledged(@NotNull FirstTimeGridHelpType firstTimeType) {
        Intrinsics.checkNotNullParameter((Object)firstTimeType, (String)"firstTimeType");
        FirstTimeGridHelpType firstTimeGridHelpType = firstTimeType;
        if (Intrinsics.areEqual((Object)firstTimeGridHelpType, (Object)FirstTimeGridHelpType.Admin.INSTANCE)) {
            if (this.isFirstGridAdminVisit) {
                this.isFirstGridAdminVisit = false;
                this.settings.putBoolean("isFirstGridAdminVisit", false);
                this._gridStateLiveData.setValue((Object)GridState.copy$default((GridState)this._gridStateLiveData.getValue(), null, 0.0f, 0.0f, 0, 0, 0.0f, false, false, false, 255, null));
            }
        } else if (Intrinsics.areEqual((Object)firstTimeGridHelpType, (Object)FirstTimeGridHelpType.Guest.INSTANCE)) {
            if (this.isFirstGridVisit) {
                this.isFirstGridVisit = false;
                this.settings.putBoolean("isFirstGridVisit", false);
                this._gridStateLiveData.setValue((Object)GridState.copy$default((GridState)this._gridStateLiveData.getValue(), null, 0.0f, 0.0f, 0, 0, 0.0f, false, false, false, 383, null));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void setStageCount(int count) {
        this.stageCount = count;
    }
}

