/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.internal.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class AvailabilityException
extends Exception {
    private final ArrayMap zaa;

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull GoogleApi<? extends Api.ApiOptions> api) {
        ApiKey<? extends Api.ApiOptions> apiKey = api.getApiKey();
        boolean bl = this.zaa.get(apiKey) != null;
        String string2 = apiKey.zaa();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The given API (");
        stringBuilder.append(string2);
        stringBuilder.append(") was not part of the availability request.");
        Preconditions.checkArgument(bl, stringBuilder.toString());
        return Preconditions.checkNotNull((ConnectionResult)this.zaa.get(apiKey));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull HasApiKey<? extends Api.ApiOptions> api) {
        ApiKey<? extends Api.ApiOptions> apiKey = api.getApiKey();
        boolean bl = this.zaa.get(apiKey) != null;
        String string2 = apiKey.zaa();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The given API (");
        stringBuilder.append(string2);
        stringBuilder.append(") was not part of the availability request.");
        Preconditions.checkArgument(bl, stringBuilder.toString());
        return Preconditions.checkNotNull((ConnectionResult)this.zaa.get(apiKey));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NonNull
    public String getMessage() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = ((AvailabilityException)serializable).zaa.keySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object object = (ApiKey)iterator.next();
            Object object2 = Preconditions.checkNotNull((ConnectionResult)((AvailabilityException)serializable).zaa.get(object));
            bl = (((ConnectionResult)object2).isSuccess() ^ true) & bl;
            object = ((ApiKey)object).zaa();
            object2 = String.valueOf(object2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
            stringBuilder.append(": ");
            stringBuilder.append((String)object2);
            arrayList.add(stringBuilder.toString());
        }
        Serializable serializable = new StringBuilder();
        if (bl) {
            ((StringBuilder)serializable).append("None of the queried APIs are available. ");
        } else {
            ((StringBuilder)serializable).append("Some of the queried APIs are unavailable. ");
        }
        ((StringBuilder)serializable).append(TextUtils.join((CharSequence)"; ", arrayList));
        return ((StringBuilder)serializable).toString();
    }

    public AvailabilityException(@NonNull ArrayMap arrayMap) {
        this.zaa = arrayMap;
    }
}

