/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@KeepForSdk
public class ConnectionTracker {
    private static final Object zzb;
    @Nullable
    private static volatile ConnectionTracker zzc;
    @VisibleForTesting
    @NonNull
    public ConcurrentHashMap zza;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static ConnectionTracker getInstance() {
        Object object;
        if (zzc == null) {
            object = zzb;
            synchronized (object) {
                ConnectionTracker connectionTracker = zzc;
                if (connectionTracker == null) {
                    zzc = connectionTracker = new ConnectionTracker();
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        object = zzc;
        Preconditions.checkNotNull(object);
        return object;
    }

    static {
        Object object;
        zzb = object = new Object();
    }

    private ConnectionTracker() {
        ConcurrentHashMap concurrentHashMap;
        this.zza = concurrentHashMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void unbindService(@NonNull Context context, @NonNull ServiceConnection conn) {
        void var1_1;
        void var2_3;
        if (ConnectionTracker.zzd(conn) && this.zza.containsKey(var2_3)) {
            try {
                ConnectionTracker.zzb((Context)var1_1, (ServiceConnection)this.zza.get(var2_3));
                return;
            }
            finally {
                this.zza.remove(var2_3);
            }
        }
        ConnectionTracker.zzb((Context)var1_1, (ServiceConnection)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void unbindServiceSafe(@NonNull Context context, @NonNull ServiceConnection conn) {
        try {
            void var2_2;
            void var1_1;
            this.unbindService((Context)var1_1, (ServiceConnection)var2_2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean bindService(@NonNull Context context, @NonNull Intent intent, @NonNull ServiceConnection conn, int flags) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.zzc((Context)var1_1, var1_1.getClass().getName(), (Intent)var2_2, (ServiceConnection)var3_3, (int)var4_4, true, null);
    }

    private static void zzb(Context context, ServiceConnection serviceConnection) {
        try {
            context.unbindService(serviceConnection);
            return;
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException runtimeException) {
            return;
        }
    }

    public final boolean zza(@NonNull Context context, @NonNull String string2, @NonNull Intent intent, @NonNull ServiceConnection serviceConnection, int n, @Nullable Executor executor) {
        return this.zzc(context, string2, intent, serviceConnection, n, true, executor);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean zzc(Context var1_2, String var2_5, Intent var3_6, ServiceConnection var4_7, int var5_8, boolean var6_9, @Nullable Executor var7_13) {
        var6_10 = var3_6.getComponent();
        if (var6_10 == null) lbl-1000:
        // 3 sources

        {
            while (true) {
                if (ConnectionTracker.zzd(var4_7)) {
                    block9: {
                        var6_11 = this.zza.putIfAbsent(var4_7, var4_7);
                        if (var6_11 != null && var4_7 != var6_11) {
                            var6_11 = new Object[]{var4_7, var2_5, var3_6.getAction()};
                            Log.w("ConnectionTracker", String.format("Duplicate binding with the same ServiceConnection: %s, %s, %s.", var6_11));
                        }
                        var1_3 = ConnectionTracker.zze(var1_2, var3_6, var4_7, var5_8, var7_13);
                        if (!var1_3) break block9;
                        var0_1 = var1_3;
lbl14:
                        // 2 sources

                        return var0_1;
                    }
                    this.zza.remove(var4_7, var4_7);
                    return false;
                }
                var0_1 = ConnectionTracker.zze(var1_2, var3_6, var4_7, var5_8, var7_13);
                ** continue;
                break;
            }
        }
        var6_10 = var6_10.getPackageName();
        "com.google.android.gms".equals(var6_10);
        try {
            var6_12 = Wrappers.packageManager((Context)var1_2).getApplicationInfo((String)var6_10, (int)0).flags;
            if ((var6_12 & 0x200000) == 0) ** GOTO lbl-1000
        }
        catch (PackageManager.NameNotFoundException v0) {
            ** continue;
        }
        Log.w("ConnectionTracker", "Attempted to bind to a service in a STOPPED package.");
        return false;
        catch (Throwable var1_4) {
            this.zza.remove(var4_7, var4_7);
            throw var1_4;
        }
    }

    private static boolean zzd(ServiceConnection serviceConnection) {
        return !(serviceConnection instanceof zzs);
    }

    private static final boolean zze(Context context, Intent intent, ServiceConnection serviceConnection, int n, @Nullable Executor executor) {
        if (PlatformVersion.isAtLeastQ() && executor != null) {
            return context.bindService(intent, n, executor, serviceConnection);
        }
        return context.bindService(intent, serviceConnection, n);
    }
}

