/*
 * Decompiled with CFR 0.152.
 */
package com.github.skydoves.colorpicker.compose;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Color;
import com.github.skydoves.colorpicker.compose.GeometryExtensionsKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001a%\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0002H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0000\"\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"hexCode", "", "Landroidx/compose/ui/graphics/Color;", "getHexCode-8_81llA", "(J)Ljava/lang/String;", "hex", "", "getHex", "(I)Ljava/lang/String;", "toHSV", "Lkotlin/Triple;", "", "toHSV-8_81llA", "(J)Lkotlin/Triple;", "hsvToCoord", "Landroidx/compose/ui/geometry/Offset;", "h", "s", "center", "hsvToCoord-0AR0LA0", "(FFJ)J", "angleToHue", "angle", "hueToAngle", "hue", "colorpicker-compose"})
public final class ColorExtensionsKt {
    @NotNull
    public static final String getHexCode-8_81llA(long $this$hexCode) {
        boolean bl = false;
        int a = (int)(Color.getAlpha-impl((long)$this$hexCode) * (float)255);
        int r = (int)(Color.getRed-impl((long)$this$hexCode) * (float)255);
        int g = (int)(Color.getGreen-impl((long)$this$hexCode) * (float)255);
        int b = (int)(Color.getBlue-impl((long)$this$hexCode) * (float)255);
        return ColorExtensionsKt.getHex(a) + ColorExtensionsKt.getHex(r) + ColorExtensionsKt.getHex(g) + ColorExtensionsKt.getHex(b);
    }

    private static final String getHex(int $this$hex) {
        String string = Integer.toString($this$hex, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.padStart((String)string, (int)2, (char)'0');
    }

    @NotNull
    public static final Triple<Float, Float, Float> toHSV-8_81llA(long $this$toHSV_u2d8_81llA) {
        float cmin;
        float cmax = Math.max(Color.getRed-impl((long)$this$toHSV_u2d8_81llA), Math.max(Color.getGreen-impl((long)$this$toHSV_u2d8_81llA), Color.getBlue-impl((long)$this$toHSV_u2d8_81llA)));
        float diff = cmax - (cmin = Math.min(Color.getRed-impl((long)$this$toHSV_u2d8_81llA), Math.min(Color.getGreen-impl((long)$this$toHSV_u2d8_81llA), Color.getBlue-impl((long)$this$toHSV_u2d8_81llA))));
        float h = diff == 0.0f ? 0.0f : (cmax == Color.getRed-impl((long)$this$toHSV_u2d8_81llA) ? ((float)60 * ((Color.getGreen-impl((long)$this$toHSV_u2d8_81llA) - Color.getBlue-impl((long)$this$toHSV_u2d8_81llA)) / diff) + 360.0f) % 360.0f : (cmax == Color.getGreen-impl((long)$this$toHSV_u2d8_81llA) ? ((float)60 * ((Color.getBlue-impl((long)$this$toHSV_u2d8_81llA) - Color.getRed-impl((long)$this$toHSV_u2d8_81llA)) / diff) + 120.0f) % 360.0f : ((float)60 * ((Color.getRed-impl((long)$this$toHSV_u2d8_81llA) - Color.getGreen-impl((long)$this$toHSV_u2d8_81llA)) / diff) + 240.0f) % 360.0f));
        float s = cmax == 0.0f ? 0.0f : diff / cmax;
        float v = cmax;
        return new Triple((Object)Float.valueOf(h), (Object)Float.valueOf(s), (Object)Float.valueOf(v));
    }

    public static final long hsvToCoord-0AR0LA0(float h, float s, long center) {
        return Offset.plus-MK-Hz9U((long)GeometryExtensionsKt.fromAngle(Offset.Companion, ColorExtensionsKt.hueToAngle(h), s * GeometryExtensionsKt.getMinCoordinate-k-4lQ0M(center)), (long)center);
    }

    public static final float angleToHue(float angle) {
        return (-GeometryExtensionsKt.toDegrees(angle) + 360.0f) % 360.0f;
    }

    public static final float hueToAngle(float hue) {
        return -GeometryExtensionsKt.toRadians(hue);
    }
}

