/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.draftSchedule.editing;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Serializable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import models.DisplayPerformance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \r2\u00020\u0001:\u0004\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lui/screens/draftSchedule/editing/ImageType;", "", "<init>", "()V", "getImageDimensions", "Lkotlin/Pair;", "", "displayPerformance", "Lmodels/DisplayPerformance;", "getImageSource", "URL", "None", "File", "Companion", "Lui/screens/draftSchedule/editing/ImageType$File;", "Lui/screens/draftSchedule/editing/ImageType$None;", "Lui/screens/draftSchedule/editing/ImageType$URL;", "shared"})
@StabilityInferred(parameters=1)
public abstract class ImageType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    private ImageType() {
    }

    @NotNull
    public final Pair<Integer, Integer> getImageDimensions(@Nullable DisplayPerformance displayPerformance) {
        Pair pair;
        ImageType imageType = this;
        if (imageType instanceof File) {
            pair = new Pair((Object)((File)this).getWidth(), (Object)((File)this).getHeight());
        } else if (imageType instanceof None) {
            pair = new Pair((Object)0, (Object)0);
        } else if (imageType instanceof URL) {
            DisplayPerformance displayPerformance2 = displayPerformance;
            DisplayPerformance displayPerformance3 = displayPerformance;
            pair = new Pair((Object)(displayPerformance2 != null ? displayPerformance2.getImageWidth() : 0), (Object)(displayPerformance3 != null ? displayPerformance3.getImageHeight() : 0));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    @Nullable
    public final Object getImageSource() {
        Serializable serializable;
        ImageType imageType = this;
        if (imageType instanceof File) {
            serializable = (Serializable)((File)this).getByteArray();
        } else if (imageType instanceof URL) {
            serializable = (Serializable)((Object)((URL)this).getUrl());
        } else if (imageType instanceof None) {
            serializable = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return serializable;
    }

    public /* synthetic */ ImageType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\n"}, d2={"Lui/screens/draftSchedule/editing/ImageType$Companion;", "", "<init>", "()V", "from", "Lui/screens/draftSchedule/editing/ImageType;", "displayPerformance", "Lmodels/DisplayPerformance;", "imageUrl", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImageType from(@Nullable DisplayPerformance displayPerformance) {
            String string2;
            DisplayPerformance displayPerformance2 = displayPerformance;
            String string3 = string2 = displayPerformance2 != null ? displayPerformance2.getArtistImageUrl() : null;
            return string2 == null ? (ImageType)None.INSTANCE : (Intrinsics.areEqual((Object)string2, (Object)"") ? (ImageType)None.INSTANCE : (ImageType)new URL(displayPerformance.getArtistImageUrl(), displayPerformance.getImageWidth(), displayPerformance.getImageHeight()));
        }

        @NotNull
        public final ImageType from(@Nullable String imageUrl, @Nullable DisplayPerformance displayPerformance) {
            ImageType imageType;
            String string2 = imageUrl;
            if (string2 == null) {
                imageType = None.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"")) {
                imageType = None.INSTANCE;
            } else {
                DisplayPerformance displayPerformance2 = displayPerformance;
                DisplayPerformance displayPerformance3 = displayPerformance;
                imageType = new URL(imageUrl, displayPerformance2 != null ? displayPerformance2.getImageWidth() : 0, displayPerformance3 != null ? displayPerformance3.getImageHeight() : 0);
            }
            return imageType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lui/screens/draftSchedule/editing/ImageType$File;", "Lui/screens/draftSchedule/editing/ImageType;", "byteArray", "", "extension", "", "width", "", "height", "<init>", "([BLjava/lang/String;II)V", "getByteArray", "()[B", "getExtension", "()Ljava/lang/String;", "getWidth", "()I", "getHeight", "equals", "", "other", "", "hashCode", "component1", "component2", "component3", "component4", "copy", "toString", "shared"})
    @StabilityInferred(parameters=0)
    public static final class File
    extends ImageType {
        @NotNull
        private final byte[] byteArray;
        @NotNull
        private final String extension;
        private final int width;
        private final int height;
        public static final int $stable = 8;

        public File(@NotNull byte[] byteArray, @NotNull String extension, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            super(null);
            this.byteArray = byteArray;
            this.extension = extension;
            this.width = width;
            this.height = height;
        }

        @NotNull
        public final byte[] getByteArray() {
            return this.byteArray;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            File cfr_ignored_0 = (File)other;
            if (!Arrays.equals(this.byteArray, ((File)other).byteArray)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extension, (Object)((File)other).extension);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.byteArray);
            result = 31 * result + this.extension.hashCode();
            return result;
        }

        @NotNull
        public final byte[] component1() {
            return this.byteArray;
        }

        @NotNull
        public final String component2() {
            return this.extension;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        @NotNull
        public final File copy(@NotNull byte[] byteArray, @NotNull String extension, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            return new File(byteArray, extension, width, height);
        }

        public static /* synthetic */ File copy$default(File file, byte[] byArray, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                byArray = file.byteArray;
            }
            if ((n3 & 2) != 0) {
                string2 = file.extension;
            }
            if ((n3 & 4) != 0) {
                n = file.width;
            }
            if ((n3 & 8) != 0) {
                n2 = file.height;
            }
            return file.copy(byArray, string2, n, n2);
        }

        @NotNull
        public String toString() {
            return "File(byteArray=" + Arrays.toString(this.byteArray) + ", extension=" + this.extension + ", width=" + this.width + ", height=" + this.height + ")";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lui/screens/draftSchedule/editing/ImageType$None;", "Lui/screens/draftSchedule/editing/ImageType;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class None
    extends ImageType {
        @NotNull
        public static final None INSTANCE = new None();
        public static final int $stable;

        private None() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "None";
        }

        public int hashCode() {
            return 1965462046;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof None)) {
                return false;
            }
            None cfr_ignored_0 = (None)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lui/screens/draftSchedule/editing/ImageType$URL;", "Lui/screens/draftSchedule/editing/ImageType;", "url", "", "width", "", "height", "<init>", "(Ljava/lang/String;II)V", "getUrl", "()Ljava/lang/String;", "getWidth", "()I", "getHeight", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "shared"})
    @StabilityInferred(parameters=1)
    public static final class URL
    extends ImageType {
        @NotNull
        private final String url;
        private final int width;
        private final int height;
        public static final int $stable;

        public URL(@NotNull String url, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(null);
            this.url = url;
            this.width = width;
            this.height = height;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        public final int component2() {
            return this.width;
        }

        public final int component3() {
            return this.height;
        }

        @NotNull
        public final URL copy(@NotNull String url, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new URL(url, width, height);
        }

        public static /* synthetic */ URL copy$default(URL uRL, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string2 = uRL.url;
            }
            if ((n3 & 2) != 0) {
                n = uRL.width;
            }
            if ((n3 & 4) != 0) {
                n2 = uRL.height;
            }
            return uRL.copy(string2, n, n2);
        }

        @NotNull
        public String toString() {
            return "URL(url=" + this.url + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof URL)) {
                return false;
            }
            URL uRL = (URL)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)uRL.url)) {
                return false;
            }
            if (this.width != uRL.width) {
                return false;
            }
            return this.height == uRL.height;
        }
    }
}

