/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.grid;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.extensions.android.composecolor.ComposeColorExtensionsKt;
import com.github.ajalt.colormath.model.RGB;
import common.ConstantsKt;
import data.account.model.Stage;
import extensions.LocalDateTimeExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import models.DisplayPerformance;
import models.GridOrientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.screens.draftSchedule.grid.DraggedChanges;
import ui.screens.grid.AdjustedTimes;
import ui.screens.grid.GridState;
import ui.screens.grid.ImmutableLocalDateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0091\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u001c\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\b\u00108\u001a\u00020(H\u0002J\b\u00109\u001a\u00020\u001aH\u0002J\b\u0010:\u001a\u00020\u001aH\u0002J\b\u0010;\u001a\u00020\u001aH\u0002J\b\u0010<\u001a\u00020\u001aH\u0002J\b\u0010=\u001a\u00020\u001aH\u0002J\u000f\u0010>\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b?\u00103J\r\u0010@\u001a\u00020\r\u00a2\u0006\u0004\bA\u00103J\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0010J\u0006\u0010C\u001a\u00020DJ\t\u0010E\u001a\u00020\u0003H\u00c2\u0003J\t\u0010F\u001a\u00020\u0005H\u00c2\u0003J\t\u0010G\u001a\u00020\u0007H\u00c2\u0003J\t\u0010H\u001a\u00020\tH\u00c2\u0003J\t\u0010I\u001a\u00020\u000bH\u00c2\u0003J\u0010\u0010J\u001a\u00020\rH\u00c2\u0003\u00a2\u0006\u0004\bK\u00103J\u0010\u0010L\u001a\u00020\rH\u00c2\u0003\u00a2\u0006\u0004\bM\u00103J\u0015\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0010H\u00c2\u0003J\u000f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u00c2\u0003J\t\u0010P\u001a\u00020\u0015H\u00c2\u0003J\t\u0010Q\u001a\u00020\u0017H\u00c2\u0003J\t\u0010R\u001a\u00020\u0017H\u00c2\u0003J\t\u0010S\u001a\u00020\u001aH\u00c2\u0003J\t\u0010T\u001a\u00020\u001aH\u00c2\u0003J\t\u0010U\u001a\u00020\u001aH\u00c2\u0003J\u00b8\u0001\u0010V\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001aH\u00c6\u0001\u00a2\u0006\u0004\bW\u0010XJ\u0013\u0010Y\u001a\u00020\u00152\b\u0010Z\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010[\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\\\u001a\u00020]H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00101\u001a\u00020\r\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b2\u00103R\u0010\u00104\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u00105\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lui/screens/grid/DraggedDisplayDetails;", "", "displayPerformance", "Lmodels/DisplayPerformance;", "gridState", "Lui/screens/grid/GridState;", "startTime", "Lui/screens/grid/ImmutableLocalDateTime;", "startTimeInstant", "Lkotlinx/datetime/Instant;", "adjustedTimes", "Lui/screens/grid/AdjustedTimes;", "dragOffset", "Landroidx/compose/ui/geometry/Offset;", "dragDelta", "draggedItemActual", "Lkotlin/Pair;", "stageList", "", "Ldata/account/model/Stage;", "isStageFiltering", "", "thresholdPixelsFromDp", "", "dragScreenInPixels", "screenWidth", "", "screenHeight", "bottomBarHeight", "<init>", "(Lmodels/DisplayPerformance;Lui/screens/grid/GridState;Lui/screens/grid/ImmutableLocalDateTime;Lkotlinx/datetime/Instant;Lui/screens/grid/AdjustedTimes;JJLkotlin/Pair;Ljava/util/List;ZFFIIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "adjustedStartInstant", "adjustedEndInstant", "stageWidth", "hourHeight", "zoomHeightOffset", "zoomWidthOffset", "itemLength", "visibleSeconds", "", "pixelsForVisibleSeconds", "originalPerformanceX", "originalPerformanceY", "animatedX", "animatedY", "tempItemAnimatedX", "tempItemAnimatedY", "adjustedStartPosition", "coercedOffset", "getCoercedOffset-F1C5BW0", "()J", "offsetDifference", "firstVisibleStage", "nearestStageIndex", "nearestTempStageIndex", "getPerformanceOffsetSeconds", "calculatePerformanceOffsetX", "calculatePerformanceOffsetXAfterDrag", "calculatePerformanceOffsetYAfterDrag", "calculateOriginalPerformanceY", "calculateAdjustedStartPosition", "calculateCoercedOffset", "calculateCoercedOffset-F1C5BW0", "getScreenEdgeDragAdjustment", "getScreenEdgeDragAdjustment-F1C5BW0", "getTempDragItem", "getDroppedItemChanges", "Lui/screens/draftSchedule/grid/DraggedChanges;", "component1", "component2", "component3", "component4", "component5", "component6", "component6-F1C5BW0", "component7", "component7-F1C5BW0", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "copy-Q8-0s6A", "(Lmodels/DisplayPerformance;Lui/screens/grid/GridState;Lui/screens/grid/ImmutableLocalDateTime;Lkotlinx/datetime/Instant;Lui/screens/grid/AdjustedTimes;JJLkotlin/Pair;Ljava/util/List;ZFFIII)Lui/screens/grid/DraggedDisplayDetails;", "equals", "other", "hashCode", "toString", "", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDraggedDisplayDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DraggedDisplayDetails.kt\nui/screens/grid/DraggedDisplayDetails\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,365:1\n65#2:366\n65#2:369\n69#2:372\n65#2:375\n65#2:378\n65#2:381\n69#2:384\n65#2:387\n69#2:390\n65#2:393\n69#2:396\n65#2:399\n65#2:406\n69#2:413\n69#2:420\n65#2:427\n65#2:434\n69#2:441\n69#2:448\n60#3:367\n60#3:370\n70#3:373\n60#3:376\n60#3:379\n60#3:382\n70#3:385\n60#3:388\n70#3:391\n60#3:394\n70#3:397\n60#3:400\n53#3,3:403\n60#3:407\n53#3,3:410\n70#3:414\n53#3,3:417\n70#3:421\n53#3,3:424\n60#3:428\n53#3,3:431\n60#3:435\n53#3,3:438\n70#3:442\n53#3,3:445\n70#3:449\n53#3,3:452\n22#4:368\n22#4:371\n22#4:374\n22#4:377\n22#4:380\n22#4:383\n22#4:386\n22#4:389\n22#4:392\n22#4:395\n22#4:398\n22#4:401\n22#4:408\n22#4:415\n22#4:422\n22#4:429\n22#4:436\n22#4:443\n22#4:450\n30#5:402\n30#5:409\n30#5:416\n30#5:423\n30#5:430\n30#5:437\n30#5:444\n30#5:451\n*S KotlinDebug\n*F\n+ 1 DraggedDisplayDetails.kt\nui/screens/grid/DraggedDisplayDetails\n*L\n62#1:366\n63#1:369\n66#1:372\n77#1:375\n80#1:378\n127#1:381\n131#1:384\n169#1:387\n172#1:390\n180#1:393\n183#1:396\n231#1:399\n233#1:406\n238#1:413\n240#1:420\n248#1:427\n250#1:434\n255#1:441\n257#1:448\n62#1:367\n63#1:370\n66#1:373\n77#1:376\n80#1:379\n127#1:382\n131#1:385\n169#1:388\n172#1:391\n180#1:394\n183#1:397\n231#1:400\n232#1:403,3\n233#1:407\n234#1:410,3\n238#1:414\n239#1:417,3\n240#1:421\n241#1:424,3\n248#1:428\n249#1:431,3\n250#1:435\n251#1:438,3\n255#1:442\n256#1:445,3\n257#1:449\n258#1:452,3\n62#1:368\n63#1:371\n66#1:374\n77#1:377\n80#1:380\n127#1:383\n131#1:386\n169#1:389\n172#1:392\n180#1:395\n183#1:398\n231#1:401\n233#1:408\n238#1:415\n240#1:422\n248#1:429\n250#1:436\n255#1:443\n257#1:450\n232#1:402\n234#1:409\n239#1:416\n241#1:423\n249#1:430\n251#1:437\n256#1:444\n258#1:451\n*E\n"})
public final class DraggedDisplayDetails {
    @NotNull
    private final DisplayPerformance displayPerformance;
    @NotNull
    private final GridState gridState;
    @NotNull
    private final ImmutableLocalDateTime startTime;
    @NotNull
    private final Instant startTimeInstant;
    @NotNull
    private final AdjustedTimes adjustedTimes;
    private final long dragOffset;
    private final long dragDelta;
    @NotNull
    private final Pair<DisplayPerformance, Offset> draggedItemActual;
    @NotNull
    private final List<Stage> stageList;
    private final boolean isStageFiltering;
    private final float thresholdPixelsFromDp;
    private final float dragScreenInPixels;
    private final int screenWidth;
    private final int screenHeight;
    private final int bottomBarHeight;
    @NotNull
    private final Instant adjustedStartInstant;
    @NotNull
    private final Instant adjustedEndInstant;
    private final int stageWidth;
    private final int hourHeight;
    private final int zoomHeightOffset;
    private final int zoomWidthOffset;
    private final float itemLength;
    private final long visibleSeconds;
    private final int pixelsForVisibleSeconds;
    private final int originalPerformanceX;
    private final int originalPerformanceY;
    private final int animatedX;
    private final int animatedY;
    private final float tempItemAnimatedX;
    private final float tempItemAnimatedY;
    private final int adjustedStartPosition;
    private final long coercedOffset;
    private final long offsetDifference;
    private final float firstVisibleStage;
    private final int nearestStageIndex;
    private final int nearestTempStageIndex;
    public static final int $stable = 8;

    private DraggedDisplayDetails(DisplayPerformance displayPerformance, GridState gridState, ImmutableLocalDateTime startTime, Instant startTimeInstant, AdjustedTimes adjustedTimes, long dragOffset, long dragDelta, Pair<DisplayPerformance, Offset> draggedItemActual, List<Stage> stageList, boolean isStageFiltering, float thresholdPixelsFromDp, float dragScreenInPixels, int screenWidth, int screenHeight, int bottomBarHeight) {
        int n;
        int n2;
        float f;
        float f2;
        boolean $i$f$floatFromBits;
        int bits$iv$iv$iv;
        boolean $i$f$unpackFloat1;
        long value$iv$iv;
        long arg0$iv;
        int n3;
        float f3;
        Intrinsics.checkNotNullParameter((Object)displayPerformance, (String)"displayPerformance");
        Intrinsics.checkNotNullParameter((Object)gridState, (String)"gridState");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)startTimeInstant, (String)"startTimeInstant");
        Intrinsics.checkNotNullParameter((Object)adjustedTimes, (String)"adjustedTimes");
        Intrinsics.checkNotNullParameter(draggedItemActual, (String)"draggedItemActual");
        Intrinsics.checkNotNullParameter(stageList, (String)"stageList");
        this.displayPerformance = displayPerformance;
        this.gridState = gridState;
        this.startTime = startTime;
        this.startTimeInstant = startTimeInstant;
        this.adjustedTimes = adjustedTimes;
        this.dragOffset = dragOffset;
        this.dragDelta = dragDelta;
        this.draggedItemActual = draggedItemActual;
        this.stageList = stageList;
        this.isStageFiltering = isStageFiltering;
        this.thresholdPixelsFromDp = thresholdPixelsFromDp;
        this.dragScreenInPixels = dragScreenInPixels;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.bottomBarHeight = bottomBarHeight;
        this.adjustedStartInstant = this.adjustedTimes.getStart();
        this.adjustedEndInstant = this.adjustedTimes.getEnd();
        this.stageWidth = this.gridState.getGridOrientation().getColumnWidth();
        this.hourHeight = this.gridState.getGridOrientation().getHourHeight();
        this.zoomHeightOffset = this.gridState.getZoomY();
        this.zoomWidthOffset = this.gridState.getZoomX();
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            f3 = (float)Duration.getInWholeSeconds-impl((long)this.displayPerformance.getEndInstant().minus-5sfh64U(this.displayPerformance.getStartInstant())) / ConstantsKt.getSecondsPerHour() * (float)(this.stageWidth + this.zoomWidthOffset) * (float)2;
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            f3 = (float)Duration.getInWholeSeconds-impl((long)this.displayPerformance.getEndInstant().minus-5sfh64U(this.displayPerformance.getStartInstant())) / ConstantsKt.getSecondsPerHour() * (float)(this.hourHeight + this.zoomHeightOffset);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.itemLength = f3;
        this.visibleSeconds = Duration.getInWholeSeconds-impl((long)this.adjustedTimes.getEnd().minus-5sfh64U(this.adjustedStartInstant)) - (long)3600;
        gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            n3 = MathKt.roundToInt((float)((float)this.visibleSeconds / ConstantsKt.getSecondsPerHour() * (float)(this.stageWidth + this.zoomWidthOffset)));
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            n3 = MathKt.roundToInt((float)((float)this.visibleSeconds / ConstantsKt.getSecondsPerHour() * (float)(this.hourHeight + this.zoomHeightOffset) + (float)this.bottomBarHeight));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.pixelsForVisibleSeconds = n3;
        this.originalPerformanceX = this.calculatePerformanceOffsetX();
        this.originalPerformanceY = this.calculateOriginalPerformanceY();
        this.animatedX = this.calculatePerformanceOffsetXAfterDrag();
        this.animatedY = this.calculatePerformanceOffsetYAfterDrag();
        gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            arg0$iv = ((Offset)this.draggedItemActual.getSecond()).unbox-impl();
            $i$f$getX-impl = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            f2 = (float)this.originalPerformanceX + Float.intBitsToFloat(bits$iv$iv$iv) / (float)2;
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            arg0$iv = ((Offset)this.draggedItemActual.getSecond()).unbox-impl();
            $i$f$getX-impl = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            f2 = (float)this.originalPerformanceX + Float.intBitsToFloat(bits$iv$iv$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.tempItemAnimatedX = f2;
        long arg0$iv2 = ((Offset)this.draggedItemActual.getSecond()).unbox-impl();
        boolean bl = false;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        this.tempItemAnimatedY = (float)this.originalPerformanceY + Float.intBitsToFloat(bits$iv$iv$iv2);
        this.adjustedStartPosition = this.calculateAdjustedStartPosition();
        this.coercedOffset = this.calculateCoercedOffset-F1C5BW0();
        this.offsetDifference = Offset.minus-MK-Hz9U((long)((Offset)this.draggedItemActual.getSecond()).unbox-impl(), (long)this.coercedOffset);
        GridOrientation gridOrientation2 = this.gridState.getGridOrientation();
        if (gridOrientation2 instanceof GridOrientation.Landscape) {
            arg0$iv = this.coercedOffset;
            boolean bl2 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            f = (float)(this.displayPerformance.getStageIndex() * this.stageWidth * -1) - Float.intBitsToFloat(bits$iv$iv$iv);
        } else if (gridOrientation2 instanceof GridOrientation.Portrait) {
            arg0$iv = this.coercedOffset;
            boolean bl3 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            f = (float)(this.displayPerformance.getStageIndex() * this.stageWidth * -1) - Float.intBitsToFloat(bits$iv$iv$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.firstVisibleStage = f;
        gridOrientation2 = this.gridState.getGridOrientation();
        if (gridOrientation2 instanceof GridOrientation.Landscape) {
            n2 = MathKt.roundToInt((double)((double)this.animatedY / (double)this.hourHeight));
        } else if (gridOrientation2 instanceof GridOrientation.Portrait) {
            n2 = MathKt.roundToInt((double)((double)this.animatedX / (double)this.stageWidth));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.nearestStageIndex = n2;
        gridOrientation2 = this.gridState.getGridOrientation();
        if (gridOrientation2 instanceof GridOrientation.Landscape) {
            n = MathKt.roundToInt((double)((double)this.tempItemAnimatedY / (double)this.hourHeight));
        } else if (gridOrientation2 instanceof GridOrientation.Portrait) {
            n = MathKt.roundToInt((double)((double)this.tempItemAnimatedX / (double)this.stageWidth));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.nearestTempStageIndex = n;
    }

    public final long getCoercedOffset-F1C5BW0() {
        return this.coercedOffset;
    }

    private final long getPerformanceOffsetSeconds() {
        return this.adjustedStartInstant.compareTo(this.displayPerformance.getStartInstant()) > 0 ? Duration.getInWholeSeconds-impl((long)this.adjustedStartInstant.minus-5sfh64U(this.startTimeInstant)) : Duration.getInWholeSeconds-impl((long)this.displayPerformance.getStartInstant().minus-5sfh64U(this.startTimeInstant));
    }

    private final int calculatePerformanceOffsetX() {
        int n;
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            n = MathKt.roundToInt((float)((float)this.getPerformanceOffsetSeconds() / ConstantsKt.getSecondsPerHour() * (float)(this.stageWidth + this.zoomWidthOffset)));
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            n = this.displayPerformance.getStageIndex() * this.stageWidth;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final int calculatePerformanceOffsetXAfterDrag() {
        long arg0$iv = this.dragOffset;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        return this.originalPerformanceX + (int)Float.intBitsToFloat(bits$iv$iv$iv);
    }

    private final int calculatePerformanceOffsetYAfterDrag() {
        long arg0$iv = this.dragOffset;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits = false;
        return this.originalPerformanceY + (int)Float.intBitsToFloat(bits$iv$iv$iv);
    }

    private final int calculateOriginalPerformanceY() {
        int n;
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            n = this.displayPerformance.getStageIndex() * this.hourHeight;
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            n = MathKt.roundToInt((float)((float)this.getPerformanceOffsetSeconds() / ConstantsKt.getSecondsPerHour() * (float)(this.hourHeight + this.zoomHeightOffset)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final int calculateAdjustedStartPosition() {
        int n;
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            n = MathKt.roundToInt((float)((float)Duration.getInWholeSeconds-impl((long)this.adjustedStartInstant.minus-5sfh64U(this.startTimeInstant)) / ConstantsKt.getSecondsPerHour() * (float)(this.stageWidth + this.zoomWidthOffset) * (float)2));
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            n = MathKt.roundToInt((float)((float)Duration.getInWholeSeconds-impl((long)this.adjustedStartInstant.minus-5sfh64U(this.startTimeInstant)) / ConstantsKt.getSecondsPerHour() * (float)(this.hourHeight + this.zoomHeightOffset)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final long calculateCoercedOffset-F1C5BW0() {
        long l;
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            long arg0$iv = this.dragOffset;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float f = RangesKt.coerceAtMost((float)RangesKt.coerceAtLeast((float)Float.intBitsToFloat(bits$iv$iv$iv), (float)((float)(this.originalPerformanceX * 2) * -1.0f)), (float)((float)((this.stageWidth + this.zoomWidthOffset) * 48 - this.originalPerformanceX * 2) - this.itemLength));
            arg0$iv = this.dragOffset;
            boolean bl2 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            l = Offset.copy-dBAh8RU((long)this.dragOffset, (float)f, (float)RangesKt.coerceAtMost((float)RangesKt.coerceAtLeast((float)Float.intBitsToFloat(bits$iv$iv$iv), (float)((float)this.originalPerformanceY * -1.0f)), (float)((float)(this.hourHeight * ((Collection)this.stageList).size()) - (float)this.originalPerformanceY - (float)this.hourHeight)));
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            long arg0$iv = this.dragOffset;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float f = RangesKt.coerceAtMost((float)RangesKt.coerceAtLeast((float)Float.intBitsToFloat(bits$iv$iv$iv), (float)((float)this.originalPerformanceX * -1.0f)), (float)(this.stageWidth * this.stageList.size() - this.originalPerformanceX));
            arg0$iv = this.dragOffset;
            boolean bl3 = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            l = Offset.copy-dBAh8RU((long)this.dragOffset, (float)f, (float)RangesKt.coerceAtMost((float)RangesKt.coerceAtLeast((float)Float.intBitsToFloat(bits$iv$iv$iv), (float)((float)this.originalPerformanceY * -1.0f)), (float)((float)((this.hourHeight + this.zoomHeightOffset) * 24) - this.itemLength - (float)this.originalPerformanceY)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final long getScreenEdgeDragAdjustment-F1C5BW0() {
        void x$iv;
        long v1$iv$iv;
        boolean $i$f$Offset;
        float y$iv;
        boolean $i$f$floatFromBits;
        long adjustmentOffset = Offset.Companion.getZero-F1C5BW0();
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            void x$iv2;
            long v1$iv$iv2;
            boolean $i$f$Offset2;
            float y$iv2;
            int screenHeightAdjusted = this.screenHeight - this.hourHeight;
            int screenWidth = this.screenWidth - ((GridOrientation.Landscape)this.gridState.getGridOrientation()).getAxisHeightOrWidth();
            int originalOffsetFromStartPosition = this.originalPerformanceX * 2 - this.adjustedStartPosition;
            long arg0$iv2 = this.dragDelta;
            boolean bl = false;
            long value$iv$iv = arg0$iv2;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits2 = false;
            if (Float.intBitsToFloat(bits$iv$iv$iv) < 0.0f && this.originalPerformanceX + this.animatedX < this.adjustedStartPosition) {
                void x$iv3;
                float arg0$iv2 = 10.0f;
                y$iv2 = 0.0f;
                $i$f$Offset2 = false;
                boolean $i$f$packFloats = false;
                v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv3);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv2);
                adjustmentOffset = Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            } else {
                arg0$iv2 = this.dragDelta;
                bl = false;
                value$iv$iv = arg0$iv2;
                $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits2 = false;
                if (Float.intBitsToFloat(bits$iv$iv$iv) > 0.0f) {
                    arg0$iv2 = this.coercedOffset;
                    bl = false;
                    value$iv$iv = arg0$iv2;
                    $i$f$unpackFloat1 = false;
                    bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                    $i$f$floatFromBits2 = false;
                    if ((float)originalOffsetFromStartPosition + Float.intBitsToFloat(bits$iv$iv$iv) + this.itemLength > (float)screenWidth) {
                        void x$iv4;
                        float arg0$iv3 = -10.0f;
                        y$iv2 = 0.0f;
                        $i$f$Offset2 = false;
                        boolean $i$f$packFloats = false;
                        v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv4);
                        long v2$iv$iv = Float.floatToRawIntBits(y$iv2);
                        adjustmentOffset = Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv & 0xFFFFFFFFL)));
                    }
                }
            }
            if (this.isStageFiltering) return adjustmentOffset;
            long arg0$iv42 = this.offsetDifference;
            boolean bl2 = false;
            value$iv$iv = arg0$iv42;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits2 = false;
            if (Float.intBitsToFloat(bits$iv$iv$iv) < 0.0f && (float)(this.animatedY + this.hourHeight) + this.gridState.getOffsetY() > (float)screenHeightAdjusted) {
                void x$iv5;
                float arg0$iv42 = 0.0f;
                y$iv2 = -10.0f;
                $i$f$Offset2 = false;
                boolean $i$f$packFloats = false;
                v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv5);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv2);
                return Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            }
            arg0$iv42 = this.offsetDifference;
            bl2 = false;
            value$iv$iv = arg0$iv42;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits2 = false;
            if (!(Float.intBitsToFloat(bits$iv$iv$iv) > 0.0f)) return adjustmentOffset;
            if (!((float)(-this.animatedY) > this.gridState.getOffsetY())) return adjustmentOffset;
            float arg0$iv2 = 0.0f;
            y$iv2 = 10.0f;
            $i$f$Offset2 = false;
            boolean $i$f$packFloats = false;
            v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv2);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv2);
            return Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv & 0xFFFFFFFFL)));
        }
        if (!(gridOrientation instanceof GridOrientation.Portrait)) throw new NoWhenBranchMatchedException();
        if (!this.isStageFiltering) {
            long arg0$iv5 = this.dragDelta;
            boolean bl = false;
            long value$iv$iv = arg0$iv5;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            if (Float.intBitsToFloat(bits$iv$iv$iv) < 0.0f && this.firstVisibleStage > this.gridState.getOffsetX()) {
                void x$iv6;
                float arg0$iv5 = this.dragScreenInPixels;
                y$iv = 0.0f;
                $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                v1$iv$iv = Float.floatToRawIntBits((float)x$iv6);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv);
                adjustmentOffset = Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            } else {
                arg0$iv5 = this.dragDelta;
                bl = false;
                value$iv$iv = arg0$iv5;
                $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits = false;
                if (Float.intBitsToFloat(bits$iv$iv$iv) > 0.0f && (float)this.animatedX > (float)(this.screenWidth - this.stageWidth) - this.gridState.getOffsetX() - (float)this.stageWidth) {
                    void x$iv7;
                    float arg0$iv6 = -this.dragScreenInPixels;
                    y$iv = 0.0f;
                    $i$f$Offset = false;
                    boolean $i$f$packFloats = false;
                    v1$iv$iv = Float.floatToRawIntBits((float)x$iv7);
                    long v2$iv$iv = Float.floatToRawIntBits(y$iv);
                    adjustmentOffset = Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
                }
            }
        }
        long arg0$iv = this.offsetDifference;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        if (Float.intBitsToFloat(bits$iv$iv$iv) < 0.0f) {
            arg0$iv = this.coercedOffset;
            bl = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            if ((float)(this.originalPerformanceY - this.adjustedStartPosition) + Float.intBitsToFloat(bits$iv$iv$iv) + this.itemLength > (float)this.pixelsForVisibleSeconds - this.thresholdPixelsFromDp) {
                void x$iv8;
                float arg0$iv7 = 0.0f;
                y$iv = -10.0f;
                $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                v1$iv$iv = Float.floatToRawIntBits((float)x$iv8);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv);
                return Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
            }
        }
        arg0$iv = this.offsetDifference;
        bl = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        if (!(Float.intBitsToFloat(bits$iv$iv$iv) > 0.0f)) return adjustmentOffset;
        arg0$iv = this.coercedOffset;
        bl = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        if (!((float)(this.originalPerformanceY - this.adjustedStartPosition) + Float.intBitsToFloat(bits$iv$iv$iv) <= this.thresholdPixelsFromDp)) return adjustmentOffset;
        float arg0$iv3 = 0.0f;
        y$iv = 10.0f;
        $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        return Offset.plus-MK-Hz9U((long)adjustmentOffset, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)));
    }

    @NotNull
    public final Pair<DisplayPerformance, Offset> getTempDragItem() {
        return new Pair((Object)(this.isStageFiltering ? (DisplayPerformance)this.draggedItemActual.getFirst() : DisplayPerformance.copy-rS6ku68$default((DisplayPerformance)this.draggedItemActual.getFirst(), null, null, null, null, null, null, 0, 0, null, 0, null, null, this.nearestStageIndex > CollectionsKt.getLastIndex(this.stageList) ? ComposeColorExtensionsKt.toComposeColor((Color)((Color)RGB.Companion.invoke(((Stage)CollectionsKt.last(this.stageList)).getColor()))) : (this.nearestStageIndex < 0 ? ComposeColorExtensionsKt.toComposeColor((Color)((Color)RGB.Companion.invoke(((Stage)CollectionsKt.first(this.stageList)).getColor()))) : ComposeColorExtensionsKt.toComposeColor((Color)((Color)RGB.Companion.invoke(this.stageList.get(this.nearestStageIndex).getColor())))), null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, 0, false, false, -4097, 1, null)), (Object)Offset.box-impl((long)this.coercedOffset));
    }

    @NotNull
    public final DraggedChanges getDroppedItemChanges() {
        double d;
        GridOrientation gridOrientation = this.gridState.getGridOrientation();
        if (gridOrientation instanceof GridOrientation.Landscape) {
            d = (double)this.tempItemAnimatedX / (double)(this.stageWidth + this.zoomWidthOffset) * (double)ConstantsKt.getSecondsPerHour();
        } else if (gridOrientation instanceof GridOrientation.Portrait) {
            d = (double)this.tempItemAnimatedY / (double)(this.hourHeight + this.zoomHeightOffset) * (double)ConstantsKt.getSecondsPerHour();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double performanceOffsetSeconds = d;
        int fifteenMinutesInSeconds = 900;
        int roundedPerformanceOffsetSeconds = MathKt.roundToInt((double)(performanceOffsetSeconds / (double)fifteenMinutesInSeconds)) * fifteenMinutesInSeconds;
        LocalDateTime newStartTime = LocalDateTimeExtensionsKt.plus$default(this.startTime.getLocalDateTime(), roundedPerformanceOffsetSeconds, DateTimeUnit.Companion.getSECOND(), null, 4, null);
        long duration = Duration.getInWholeSeconds-impl((long)this.displayPerformance.getEndInstant().minus-5sfh64U(this.displayPerformance.getStartInstant()));
        LocalDateTime newEndTime = LocalDateTimeExtensionsKt.plus$default(newStartTime, (int)duration, DateTimeUnit.Companion.getSECOND(), null, 4, null);
        Stage stageDrop = this.nearestTempStageIndex > CollectionsKt.getLastIndex(this.stageList) ? (Stage)CollectionsKt.last(this.stageList) : (this.nearestTempStageIndex < 0 ? (Stage)CollectionsKt.first(this.stageList) : this.stageList.get(this.nearestTempStageIndex));
        return new DraggedChanges(this.displayPerformance.getPerformanceId(), newStartTime, newEndTime, !this.isStageFiltering ? stageDrop : this.stageList.get(this.displayPerformance.getStageIndex()));
    }

    private final DisplayPerformance component1() {
        return this.displayPerformance;
    }

    private final GridState component2() {
        return this.gridState;
    }

    private final ImmutableLocalDateTime component3() {
        return this.startTime;
    }

    private final Instant component4() {
        return this.startTimeInstant;
    }

    private final AdjustedTimes component5() {
        return this.adjustedTimes;
    }

    private final long component6-F1C5BW0() {
        return this.dragOffset;
    }

    private final long component7-F1C5BW0() {
        return this.dragDelta;
    }

    private final Pair<DisplayPerformance, Offset> component8() {
        return this.draggedItemActual;
    }

    private final List<Stage> component9() {
        return this.stageList;
    }

    private final boolean component10() {
        return this.isStageFiltering;
    }

    private final float component11() {
        return this.thresholdPixelsFromDp;
    }

    private final float component12() {
        return this.dragScreenInPixels;
    }

    private final int component13() {
        return this.screenWidth;
    }

    private final int component14() {
        return this.screenHeight;
    }

    private final int component15() {
        return this.bottomBarHeight;
    }

    @NotNull
    public final DraggedDisplayDetails copy-Q8-0s6A(@NotNull DisplayPerformance displayPerformance, @NotNull GridState gridState, @NotNull ImmutableLocalDateTime startTime, @NotNull Instant startTimeInstant, @NotNull AdjustedTimes adjustedTimes, long dragOffset, long dragDelta, @NotNull Pair<DisplayPerformance, Offset> draggedItemActual, @NotNull List<Stage> stageList, boolean isStageFiltering, float thresholdPixelsFromDp, float dragScreenInPixels, int screenWidth, int screenHeight, int bottomBarHeight) {
        Intrinsics.checkNotNullParameter((Object)displayPerformance, (String)"displayPerformance");
        Intrinsics.checkNotNullParameter((Object)gridState, (String)"gridState");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)startTimeInstant, (String)"startTimeInstant");
        Intrinsics.checkNotNullParameter((Object)adjustedTimes, (String)"adjustedTimes");
        Intrinsics.checkNotNullParameter(draggedItemActual, (String)"draggedItemActual");
        Intrinsics.checkNotNullParameter(stageList, (String)"stageList");
        return new DraggedDisplayDetails(displayPerformance, gridState, startTime, startTimeInstant, adjustedTimes, dragOffset, dragDelta, draggedItemActual, stageList, isStageFiltering, thresholdPixelsFromDp, dragScreenInPixels, screenWidth, screenHeight, bottomBarHeight, null);
    }

    public static /* synthetic */ DraggedDisplayDetails copy-Q8-0s6A$default(DraggedDisplayDetails draggedDisplayDetails, DisplayPerformance displayPerformance, GridState gridState, ImmutableLocalDateTime immutableLocalDateTime, Instant instant, AdjustedTimes adjustedTimes, long l, long l2, Pair pair, List list, boolean bl, float f, float f2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            displayPerformance = draggedDisplayDetails.displayPerformance;
        }
        if ((n4 & 2) != 0) {
            gridState = draggedDisplayDetails.gridState;
        }
        if ((n4 & 4) != 0) {
            immutableLocalDateTime = draggedDisplayDetails.startTime;
        }
        if ((n4 & 8) != 0) {
            instant = draggedDisplayDetails.startTimeInstant;
        }
        if ((n4 & 0x10) != 0) {
            adjustedTimes = draggedDisplayDetails.adjustedTimes;
        }
        if ((n4 & 0x20) != 0) {
            l = draggedDisplayDetails.dragOffset;
        }
        if ((n4 & 0x40) != 0) {
            l2 = draggedDisplayDetails.dragDelta;
        }
        if ((n4 & 0x80) != 0) {
            pair = draggedDisplayDetails.draggedItemActual;
        }
        if ((n4 & 0x100) != 0) {
            list = draggedDisplayDetails.stageList;
        }
        if ((n4 & 0x200) != 0) {
            bl = draggedDisplayDetails.isStageFiltering;
        }
        if ((n4 & 0x400) != 0) {
            f = draggedDisplayDetails.thresholdPixelsFromDp;
        }
        if ((n4 & 0x800) != 0) {
            f2 = draggedDisplayDetails.dragScreenInPixels;
        }
        if ((n4 & 0x1000) != 0) {
            n = draggedDisplayDetails.screenWidth;
        }
        if ((n4 & 0x2000) != 0) {
            n2 = draggedDisplayDetails.screenHeight;
        }
        if ((n4 & 0x4000) != 0) {
            n3 = draggedDisplayDetails.bottomBarHeight;
        }
        return draggedDisplayDetails.copy-Q8-0s6A(displayPerformance, gridState, immutableLocalDateTime, instant, adjustedTimes, l, l2, pair, list, bl, f, f2, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "DraggedDisplayDetails(displayPerformance=" + this.displayPerformance + ", gridState=" + this.gridState + ", startTime=" + this.startTime + ", startTimeInstant=" + this.startTimeInstant + ", adjustedTimes=" + this.adjustedTimes + ", dragOffset=" + Offset.toString-impl((long)this.dragOffset) + ", dragDelta=" + Offset.toString-impl((long)this.dragDelta) + ", draggedItemActual=" + this.draggedItemActual + ", stageList=" + this.stageList + ", isStageFiltering=" + this.isStageFiltering + ", thresholdPixelsFromDp=" + this.thresholdPixelsFromDp + ", dragScreenInPixels=" + this.dragScreenInPixels + ", screenWidth=" + this.screenWidth + ", screenHeight=" + this.screenHeight + ", bottomBarHeight=" + this.bottomBarHeight + ")";
    }

    public int hashCode() {
        int result = this.displayPerformance.hashCode();
        result = result * 31 + this.gridState.hashCode();
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + this.startTimeInstant.hashCode();
        result = result * 31 + this.adjustedTimes.hashCode();
        result = result * 31 + Offset.hashCode-impl((long)this.dragOffset);
        result = result * 31 + Offset.hashCode-impl((long)this.dragDelta);
        result = result * 31 + this.draggedItemActual.hashCode();
        result = result * 31 + ((Object)this.stageList).hashCode();
        result = result * 31 + Boolean.hashCode(this.isStageFiltering);
        result = result * 31 + Float.hashCode(this.thresholdPixelsFromDp);
        result = result * 31 + Float.hashCode(this.dragScreenInPixels);
        result = result * 31 + Integer.hashCode(this.screenWidth);
        result = result * 31 + Integer.hashCode(this.screenHeight);
        result = result * 31 + Integer.hashCode(this.bottomBarHeight);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DraggedDisplayDetails)) {
            return false;
        }
        DraggedDisplayDetails draggedDisplayDetails = (DraggedDisplayDetails)other;
        if (!Intrinsics.areEqual((Object)this.displayPerformance, (Object)draggedDisplayDetails.displayPerformance)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gridState, (Object)draggedDisplayDetails.gridState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)draggedDisplayDetails.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTimeInstant, (Object)draggedDisplayDetails.startTimeInstant)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.adjustedTimes, (Object)draggedDisplayDetails.adjustedTimes)) {
            return false;
        }
        if (!Offset.equals-impl0((long)this.dragOffset, (long)draggedDisplayDetails.dragOffset)) {
            return false;
        }
        if (!Offset.equals-impl0((long)this.dragDelta, (long)draggedDisplayDetails.dragDelta)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.draggedItemActual, draggedDisplayDetails.draggedItemActual)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stageList, draggedDisplayDetails.stageList)) {
            return false;
        }
        if (this.isStageFiltering != draggedDisplayDetails.isStageFiltering) {
            return false;
        }
        if (Float.compare(this.thresholdPixelsFromDp, draggedDisplayDetails.thresholdPixelsFromDp) != 0) {
            return false;
        }
        if (Float.compare(this.dragScreenInPixels, draggedDisplayDetails.dragScreenInPixels) != 0) {
            return false;
        }
        if (this.screenWidth != draggedDisplayDetails.screenWidth) {
            return false;
        }
        if (this.screenHeight != draggedDisplayDetails.screenHeight) {
            return false;
        }
        return this.bottomBarHeight == draggedDisplayDetails.bottomBarHeight;
    }

    public /* synthetic */ DraggedDisplayDetails(DisplayPerformance displayPerformance, GridState gridState, ImmutableLocalDateTime startTime, Instant startTimeInstant, AdjustedTimes adjustedTimes, long dragOffset, long dragDelta, Pair draggedItemActual, List stageList, boolean isStageFiltering, float thresholdPixelsFromDp, float dragScreenInPixels, int screenWidth, int screenHeight, int bottomBarHeight, DefaultConstructorMarker $constructor_marker) {
        this(displayPerformance, gridState, startTime, startTimeInstant, adjustedTimes, dragOffset, dragDelta, (Pair<DisplayPerformance, Offset>)draggedItemActual, stageList, isStageFiltering, thresholdPixelsFromDp, dragScreenInPixels, screenWidth, screenHeight, bottomBarHeight);
    }
}

