/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.ICtCpKt;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.RGBInt;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 V2\u00020\u0001:\u0001VB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u0015J\u001a\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0000H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0000H\u0016Jv\u0010<\u001a\u0002H=\"\u0004\b\u0000\u0010=2`\u0010>\u001a\\\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(C\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(E\u0012\u0013\u0012\u00110@\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(F\u0012\u0004\u0012\u0002H=0?H\u0082\b\u00a2\u0006\u0002\u0010GJ1\u00108\u001a\u0002H=\"\b\b\u0000\u0010=*\u00020\u00012\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H=0H\u00a2\u0006\u0002\bIH\u0082\b\u00a2\u0006\u0002\u0010JJ\t\u0010K\u001a\u00020\u0003H\u00c6\u0003J\t\u0010L\u001a\u00020\u0003H\u00c6\u0003J\t\u0010M\u001a\u00020\u0003H\u00c6\u0003J\t\u0010N\u001a\u00020\u0003H\u00c6\u0003J\t\u0010O\u001a\u00020\bH\u00c6\u0003J;\u0010P\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010Q\u001a\u00020\"2\b\u0010R\u001a\u0004\u0018\u00010SH\u00d6\u0003J\t\u0010T\u001a\u00020\u0013H\u00d6\u0001J\t\u0010U\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006W"}, d2={"Lcom/github/ajalt/colormath/model/RGB;", "Lcom/github/ajalt/colormath/Color;", "r", "", "g", "b", "alpha", "space", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "<init>", "(FFFFLcom/github/ajalt/colormath/model/RGBColorSpace;)V", "getR", "()F", "getG", "getB", "getAlpha", "getSpace", "()Lcom/github/ajalt/colormath/model/RGBColorSpace;", "redInt", "", "getRedInt", "()I", "greenInt", "getGreenInt", "blueInt", "getBlueInt", "alphaInt", "getAlphaInt", "toRGBInt", "Lcom/github/ajalt/colormath/model/RGBInt;", "toRGBInt-RGiG7fk", "toHex", "", "withNumberSign", "", "renderAlpha", "Lcom/github/ajalt/colormath/RenderCondition;", "convertTo", "toHSL", "Lcom/github/ajalt/colormath/model/HSL;", "toHSV", "Lcom/github/ajalt/colormath/model/HSV;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "toCMYK", "Lcom/github/ajalt/colormath/model/CMYK;", "toHWB", "Lcom/github/ajalt/colormath/model/HWB;", "toOklab", "Lcom/github/ajalt/colormath/model/Oklab;", "toICtCp", "Lcom/github/ajalt/colormath/model/ICtCp;", "toAnsi16", "Lcom/github/ajalt/colormath/model/Ansi16;", "toAnsi256", "Lcom/github/ajalt/colormath/model/Ansi256;", "toSRGB", "toArray", "", "clamp", "srgbHueMinMaxChroma", "T", "block", "Lkotlin/Function4;", "", "Lkotlin/ParameterName;", "name", "hue", "min", "max", "chroma", "(Lkotlin/jvm/functions/Function4;)Ljava/lang/Object;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Lcom/github/ajalt/colormath/Color;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nRGB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RGB.kt\ncom/github/ajalt/colormath/model/RGB\n+ 2 Matrix.kt\ncom/github/ajalt/colormath/internal/MatrixKt\n+ 3 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,381:1\n360#1:382\n341#1:383\n360#1:384\n342#1,16:385\n341#1:401\n360#1:402\n342#1,16:403\n360#1:423\n341#1:424\n360#1:425\n342#1,16:426\n360#1:442\n360#1:443\n360#1:456\n77#2,4:419\n89#3,12:444\n*S KotlinDebug\n*F\n+ 1 RGB.kt\ncom/github/ajalt/colormath/model/RGB\n*L\n181#1:382\n225#1:383\n225#1:384\n225#1:385,16\n237#1:401\n237#1:402\n237#1:403,16\n253#1:423\n264#1:424\n264#1:425\n264#1:426,16\n301#1:442\n310#1:443\n341#1:456\n248#1:419,4\n331#1:444,12\n*E\n"})
public final class RGB
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float r;
    private final float g;
    private final float b;
    private final float alpha;
    @NotNull
    private final RGBColorSpace space;

    public RGB(float r, float g, float b, float alpha, @NotNull RGBColorSpace space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getR() {
        return this.r;
    }

    public final float getG() {
        return this.g;
    }

    public final float getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public RGBColorSpace getSpace() {
        return this.space;
    }

    public final int getRedInt() {
        return MathKt.roundToInt((float)(this.r * (float)255));
    }

    public final int getGreenInt() {
        return MathKt.roundToInt((float)(this.g * (float)255));
    }

    public final int getBlueInt() {
        return MathKt.roundToInt((float)(this.b * (float)255));
    }

    public final int getAlphaInt() {
        return MathKt.roundToInt((float)(InternalMathKt.nanToOne(this.getAlpha()) * (float)255));
    }

    public final int toRGBInt-RGiG7fk() {
        RGB this_$iv = this;
        boolean $i$f$toSRGB = false;
        RGB $this$toRGBInt_RGiG7fk_u24lambda_u240 = this_$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        return ((RGBInt)((Color)RGBInt.box-impl(RGBInt.constructor-impl($this$toRGBInt_RGiG7fk_u24lambda_u240.r, $this$toRGBInt_RGiG7fk_u24lambda_u240.g, $this$toRGBInt_RGiG7fk_u24lambda_u240.b, InternalMathKt.nanToOne($this$toRGBInt_RGiG7fk_u24lambda_u240.getAlpha()))))).unbox-impl();
    }

    @NotNull
    public final String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        return RGBInt.toHex-impl(this.toRGBInt-RGiG7fk(), withNumberSign, renderAlpha);
    }

    public static /* synthetic */ String toHex$default(RGB rGB, boolean bl, RenderCondition renderCondition, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            renderCondition = RenderCondition.AUTO;
        }
        return rGB.toHex(bl, renderCondition);
    }

    @NotNull
    public final RGB convertTo(@NotNull RGBColorSpace space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        RGBColorSpace.TransferFunctions f = SRGB.INSTANCE.getTransferFunctions();
        return Intrinsics.areEqual((Object)this.getSpace(), (Object)space) ? this : (Intrinsics.areEqual((Object)this.getSpace(), (Object)SRGB.INSTANCE) && Intrinsics.areEqual((Object)space, (Object)RGBColorSpaces.INSTANCE.getLinearSRGB()) ? space.invoke(f.eotf(this.r), f.eotf(this.g), f.eotf(this.b), this.getAlpha()) : (Intrinsics.areEqual((Object)this.getSpace(), (Object)RGBColorSpaces.INSTANCE.getLinearSRGB()) && Intrinsics.areEqual((Object)space, (Object)SRGB.INSTANCE) ? space.invoke(f.oetf(this.r), f.oetf(this.g), f.oetf(this.b), this.getAlpha()) : this.toXYZ().toRGB(space)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HSL toHSL() {
        void chroma;
        void max;
        void min;
        RGB this_$iv = this;
        boolean $i$f$srgbHueMinMaxChroma = false;
        RGB this_$iv$iv = this_$iv;
        boolean $i$f$toSRGB = false;
        RGB $this$srgbHueMinMaxChroma_u24lambda_u248$iv = this_$iv$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        double r$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.r;
        double g$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.g;
        double b$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.b;
        double min$iv = Math.min(r$iv, Math.min(g$iv, b$iv));
        double max$iv = Math.max(r$iv, Math.max(g$iv, b$iv));
        double chroma$iv = max$iv - min$iv;
        double h$iv = (chroma$iv < 1.0E-7 ? Double.NaN : (r$iv == max$iv ? (g$iv - b$iv) / chroma$iv : (g$iv == max$iv ? (double)2 + (b$iv - r$iv) / chroma$iv : (b$iv == max$iv ? (double)4 + (r$iv - g$iv) / chroma$iv : 0.0)))) * (double)60;
        double d = chroma$iv;
        double d2 = max$iv;
        double d3 = min$iv;
        double h = InternalMathKt.normalizeDeg(h$iv);
        boolean bl2 = false;
        void l = (min + max) / 2.0;
        double s = max == min ? 0.0 : (l <= 0.5 ? chroma / (max + min) : chroma / ((double)2 - max - min));
        return new HSL((float)h, (float)s, (float)l, this.getAlpha());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HSV toHSV() {
        void chroma;
        void max;
        RGB this_$iv = this;
        boolean $i$f$srgbHueMinMaxChroma = false;
        RGB this_$iv$iv = this_$iv;
        boolean $i$f$toSRGB = false;
        RGB $this$srgbHueMinMaxChroma_u24lambda_u248$iv = this_$iv$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        double r$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.r;
        double g$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.g;
        double b$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.b;
        double min$iv = Math.min(r$iv, Math.min(g$iv, b$iv));
        double max$iv = Math.max(r$iv, Math.max(g$iv, b$iv));
        double chroma$iv = max$iv - min$iv;
        double h$iv = (chroma$iv < 1.0E-7 ? Double.NaN : (r$iv == max$iv ? (g$iv - b$iv) / chroma$iv : (g$iv == max$iv ? (double)2 + (b$iv - r$iv) / chroma$iv : (b$iv == max$iv ? (double)4 + (r$iv - g$iv) / chroma$iv : 0.0)))) * (double)60;
        double d = chroma$iv;
        double d2 = max$iv;
        double h = InternalMathKt.normalizeDeg(h$iv);
        boolean bl2 = false;
        double s = max == 0.0 ? 0.0 : chroma / max;
        return new HSV((float)h, (float)s, (float)max, this.getAlpha());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public XYZ toXYZ() {
        void z;
        void y;
        void v1$iv;
        void v0$iv;
        void $this$dot_u2dlwRpc58$iv;
        RGBColorSpace.TransferFunctions f = this.getSpace().getTransferFunctions();
        float[] fArray = Matrix.constructor-impl(this.getSpace().getMatrixToXyz());
        float f2 = f.eotf(this.r);
        float f3 = f.eotf(this.g);
        float v2$iv = f.eotf(this.b);
        boolean bl = false;
        float f4 = Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 0, 2) * v0$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 1, 2) * v1$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 2, 2) * v2$iv;
        float f5 = Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 0, 1) * v0$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 1, 1) * v1$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 2, 1) * v2$iv;
        float x = Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 0, 0) * v0$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 1, 0) * v1$iv + Matrix.get-impl((float[])$this$dot_u2dlwRpc58$iv, 2, 0) * v2$iv;
        boolean bl2 = false;
        return XYZKt.XYZColorSpace(this.getSpace().getWhitePoint()).invoke(x, (float)y, (float)z, this.getAlpha());
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        RGB this_$iv = this;
        boolean $i$f$toSRGB = false;
        RGB $this$toCMYK_u24lambda_u244 = this_$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        float k = 1.0f - Math.max($this$toCMYK_u24lambda_u244.r, Math.max($this$toCMYK_u24lambda_u244.b, $this$toCMYK_u24lambda_u244.g));
        if (k == 1.0f) {
            return new CMYK(0.0f, 0.0f, 0.0f, k, $this$toCMYK_u24lambda_u244.getAlpha());
        }
        float c = (1.0f - $this$toCMYK_u24lambda_u244.r - k) / (1.0f - k);
        float m = (1.0f - $this$toCMYK_u24lambda_u244.g - k) / (1.0f - k);
        float y = (1.0f - $this$toCMYK_u24lambda_u244.b - k) / (1.0f - k);
        return new CMYK(c, m, y, k, $this$toCMYK_u24lambda_u244.getAlpha());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HWB toHWB() {
        void max;
        void min;
        RGB this_$iv = this;
        boolean $i$f$srgbHueMinMaxChroma = false;
        RGB this_$iv$iv = this_$iv;
        boolean $i$f$toSRGB = false;
        RGB $this$srgbHueMinMaxChroma_u24lambda_u248$iv = this_$iv$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        double r$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.r;
        double g$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.g;
        double b$iv = $this$srgbHueMinMaxChroma_u24lambda_u248$iv.b;
        double min$iv = Math.min(r$iv, Math.min(g$iv, b$iv));
        double max$iv = Math.max(r$iv, Math.max(g$iv, b$iv));
        double chroma$iv = max$iv - min$iv;
        double h$iv = (chroma$iv < 1.0E-7 ? Double.NaN : (r$iv == max$iv ? (g$iv - b$iv) / chroma$iv : (g$iv == max$iv ? (double)2 + (b$iv - r$iv) / chroma$iv : (b$iv == max$iv ? (double)4 + (r$iv - g$iv) / chroma$iv : 0.0)))) * (double)60;
        double d = max$iv;
        double d2 = min$iv;
        double hue = InternalMathKt.normalizeDeg(h$iv);
        boolean bl2 = false;
        return new HWB((float)hue, (float)min, (float)(1.0 - max), this.getAlpha());
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        if (!Intrinsics.areEqual((Object)this.getSpace(), (Object)RGBColorSpaces.INSTANCE.getSRGB())) {
            return this.toXYZ().toOklab();
        }
        float r = this.getSpace().getTransferFunctions().eotf(this.r);
        float g = this.getSpace().getTransferFunctions().eotf(this.g);
        float b = this.getSpace().getTransferFunctions().eotf(this.b);
        double l = 0.4122214708 * (double)r + 0.5363325363 * (double)g + 0.0514459929 * (double)b;
        double m = 0.2119034982 * (double)r + 0.6806995451 * (double)g + 0.1073969566 * (double)b;
        double s = 0.0883024619 * (double)r + 0.2817188376 * (double)g + 0.6299787005 * (double)b;
        double ll = Math.cbrt(l);
        double mm = Math.cbrt(m);
        double ss = Math.cbrt(s);
        return new Oklab((double)0.21045426f * ll + (double)0.7936178f * mm - (double)0.004072047f * ss, (double)1.9779985f * ll - (double)2.4285922f * mm + (double)0.4505937f * ss, (double)0.025904037f * ll + (double)0.78277177f * mm - (double)0.80867577f * ss, Float.valueOf(this.getAlpha()));
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        if (Intrinsics.areEqual((Object)this.getSpace(), (Object)RGBColorSpaces.INSTANCE.getBT2020())) {
            return ICtCpKt.convertBT2020ToICtCp(this);
        }
        return this.toXYZ().toICtCp();
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        RGB this_$iv = this;
        boolean $i$f$toSRGB = false;
        RGB $this$toAnsi16_u24lambda_u246 = this_$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        int value = MathKt.roundToInt((float)($this$toAnsi16_u24lambda_u246.toHSV().getV() * (float)100));
        if (value == 30) {
            return new Ansi16(30);
        }
        int v = value / 50;
        int ansi = 30 + (MathKt.roundToInt((float)$this$toAnsi16_u24lambda_u246.b) * 4 | MathKt.roundToInt((float)$this$toAnsi16_u24lambda_u246.g) * 2 | MathKt.roundToInt((float)$this$toAnsi16_u24lambda_u246.r));
        return new Ansi16(v == 2 ? ansi + 60 : ansi);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        RGB this_$iv = this;
        boolean $i$f$toSRGB = false;
        RGB $this$toAnsi256_u24lambda_u247 = this_$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        int ri = $this$toAnsi256_u24lambda_u247.getRedInt();
        int gi = $this$toAnsi256_u24lambda_u247.getGreenInt();
        int bi = $this$toAnsi256_u24lambda_u247.getBlueInt();
        int code = ri == gi && gi == bi ? (ri < 8 ? 16 : (ri > 248 ? 231 : MathKt.roundToInt((double)((double)(ri - 8) / 247.0 * 24.0)) + 232)) : 16 + 36 * MathKt.roundToInt((float)($this$toAnsi256_u24lambda_u247.r * (float)5)) + 6 * MathKt.roundToInt((float)($this$toAnsi256_u24lambda_u247.g * (float)5)) + MathKt.roundToInt((float)($this$toAnsi256_u24lambda_u247.b * (float)5));
        return new Ansi256(code);
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.convertTo(RGBColorSpaces.INSTANCE.getSRGB());
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.r, this.g, this.b, this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public RGB clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clamp3$iv;
        Color color2 = this;
        float f = this.r;
        float f2 = this.g;
        float f3 = this.b;
        float alpha$iv = this.getAlpha();
        boolean $i$f$clamp3 = false;
        List<ColorComponentInfo> list = $this$clamp3$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clamp3$iv;
                        return (RGB)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn((float)alpha$iv, (float)0.0f, (float)1.0f);
        float f6 = RangesKt.coerceIn((float)v3$iv, (float)c3$iv.getMin(), (float)c3$iv.getMax());
        float f7 = RangesKt.coerceIn((float)v2$iv, (float)c2$iv.getMin(), (float)c2$iv.getMax());
        float p0 = RangesKt.coerceIn((float)v1$iv, (float)c1$iv.getMin(), (float)c1$iv.getMax());
        boolean bl5 = false;
        color = RGB.copy$default(this, p0, (float)p1, (float)p2, (float)p3, null, 16, null);
        return (RGB)color;
    }

    private final <T> T srgbHueMinMaxChroma(Function4<? super Double, ? super Double, ? super Double, ? super Double, ? extends T> block) {
        boolean $i$f$srgbHueMinMaxChroma = false;
        RGB this_$iv = this;
        boolean $i$f$toSRGB = false;
        RGB $this$srgbHueMinMaxChroma_u24lambda_u248 = this_$iv.convertTo(SRGB.INSTANCE);
        boolean bl = false;
        double r = $this$srgbHueMinMaxChroma_u24lambda_u248.r;
        double g = $this$srgbHueMinMaxChroma_u24lambda_u248.g;
        double b = $this$srgbHueMinMaxChroma_u24lambda_u248.b;
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        double chroma = max - min;
        double h = (chroma < 1.0E-7 ? Double.NaN : (r == max ? (g - b) / chroma : (g == max ? (double)2 + (b - r) / chroma : (b == max ? (double)4 + (r - g) / chroma : 0.0)))) * (double)60;
        return (T)block.invoke((Object)InternalMathKt.normalizeDeg(h), (Object)min, (Object)max, (Object)chroma);
    }

    private final <T extends Color> T toSRGB(Function1<? super RGB, ? extends T> block) {
        boolean $i$f$toSRGB = false;
        return (T)((Color)block.invoke((Object)this.convertTo(SRGB.INSTANCE)));
    }

    public final float component1() {
        return this.r;
    }

    public final float component2() {
        return this.g;
    }

    public final float component3() {
        return this.b;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final RGBColorSpace component5() {
        return this.space;
    }

    @NotNull
    public final RGB copy(float r, float g, float b, float alpha, @NotNull RGBColorSpace space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        return new RGB(r, g, b, alpha, space);
    }

    public static /* synthetic */ RGB copy$default(RGB rGB, float f, float f2, float f3, float f4, RGBColorSpace rGBColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = rGB.r;
        }
        if ((n & 2) != 0) {
            f2 = rGB.g;
        }
        if ((n & 4) != 0) {
            f3 = rGB.b;
        }
        if ((n & 8) != 0) {
            f4 = rGB.alpha;
        }
        if ((n & 0x10) != 0) {
            rGBColorSpace = rGB.space;
        }
        return rGB.copy(f, f2, f3, f4, rGBColorSpace);
    }

    @NotNull
    public String toString() {
        return "RGB(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.r);
        result = result * 31 + Float.hashCode(this.g);
        result = result * 31 + Float.hashCode(this.b);
        result = result * 31 + Float.hashCode(this.alpha);
        result = result * 31 + this.space.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RGB)) {
            return false;
        }
        RGB rGB = (RGB)other;
        if (Float.compare(this.r, rGB.r) != 0) {
            return false;
        }
        if (Float.compare(this.g, rGB.g) != 0) {
            return false;
        }
        if (Float.compare(this.b, rGB.b) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, rGB.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.space, (Object)rGB.space);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0096\u0001J\u0019\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0018H\u0096\u0001J\u0011\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0003J)\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u001cH\u0096\u0003J)\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0018H\u0096\u0003R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0012\u0010&\u001a\u00020\u001bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020.X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/github/ajalt/colormath/model/RGB$Companion;", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "convert", "Lcom/github/ajalt/colormath/model/RGB;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "components", "", "from255", "r", "g", "b", "alpha", "grey", "amount", "", "invoke", "hex", "", "", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "matrixFromXyz", "getMatrixFromXyz", "()[F", "matrixToXyz", "getMatrixToXyz", "name", "getName", "()Ljava/lang/String;", "transferFunctions", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "getTransferFunctions", "()Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "colormath"})
    public static final class Companion
    implements RGBColorSpace {
        private final /* synthetic */ RGBColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = RGBColorSpaces.INSTANCE.getSRGB();
        }

        public boolean equals(@Nullable Object other) {
            return Intrinsics.areEqual((Object)RGBColorSpaces.INSTANCE.getSRGB(), (Object)other);
        }

        public int hashCode() {
            return RGBColorSpaces.INSTANCE.getSRGB().hashCode();
        }

        @Override
        @NotNull
        public RGB invoke(float r, float g, float b, float alpha) {
            return this.$$delegate_0.invoke(r, g, b, alpha);
        }

        @Override
        @NotNull
        public RGB invoke(@NotNull Number r, @NotNull Number g, @NotNull Number b, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)alpha, (String)"alpha");
            return this.$$delegate_0.invoke(r, g, b, alpha);
        }

        @Override
        @NotNull
        public RGB invoke(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            return this.$$delegate_0.invoke(hex);
        }

        @Override
        @NotNull
        public RGB from255(int r, int g, int b, int alpha) {
            return this.$$delegate_0.from255(r, g, b, alpha);
        }

        @Override
        @NotNull
        public RGB grey(@NotNull Number amount, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)alpha, (String)"alpha");
            return this.$$delegate_0.grey(amount, alpha);
        }

        @Override
        @NotNull
        public RGBColorSpace.TransferFunctions getTransferFunctions() {
            return this.$$delegate_0.getTransferFunctions();
        }

        @Override
        @NotNull
        public float[] getMatrixToXyz() {
            return this.$$delegate_0.getMatrixToXyz();
        }

        @Override
        @NotNull
        public float[] getMatrixFromXyz() {
            return this.$$delegate_0.getMatrixFromXyz();
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        @Override
        @NotNull
        public RGB convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return (RGB)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public RGB create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            return (RGB)this.$$delegate_0.create(components);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

