/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseException;
import com.google.firebase.functions.Serializer;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseFunctionsException
extends FirebaseException {
    @NonNull
    private final Code code;
    @Nullable
    private final Object details;

    @Nullable
    static FirebaseFunctionsException fromResponse(Code code, @Nullable String body, Serializer serializer2) {
        String description = code.name();
        Object details = null;
        try {
            JSONObject json = new JSONObject(body);
            JSONObject error = json.getJSONObject("error");
            if (error.opt("status") instanceof String) {
                code = Code.valueOf(error.getString("status"));
                description = code.name();
            }
            if (error.opt("message") instanceof String && !error.getString("message").isEmpty()) {
                description = error.getString("message");
            }
            if ((details = error.opt("details")) != null) {
                details = serializer2.decode(details);
            }
        }
        catch (IllegalArgumentException iae) {
            code = Code.INTERNAL;
            description = code.name();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (code == Code.OK) {
            return null;
        }
        return new FirebaseFunctionsException(description, code, details);
    }

    FirebaseFunctionsException(@NonNull String message, @NonNull Code code, @Nullable Object details) {
        super(message);
        this.code = code;
        this.details = details;
    }

    FirebaseFunctionsException(@NonNull String message, @NonNull Code code, @Nullable Object details, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.details = details;
    }

    @NonNull
    public Code getCode() {
        return this.code;
    }

    @Nullable
    public Object getDetails() {
        return this.details;
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private static final SparseArray<Code> STATUS_LIST;

        private Code(int value) {
            this.value = value;
        }

        private static SparseArray<Code> buildStatusList() {
            SparseArray<Code> codes = new SparseArray<Code>();
            for (Code c : Code.values()) {
                Code existingValue = codes.get(c.ordinal());
                if (existingValue != null) {
                    throw new IllegalStateException("Code value duplication between " + (Object)((Object)existingValue) + "&" + c.name());
                }
                codes.put(c.ordinal(), c);
            }
            return codes;
        }

        static Code fromValue(int value) {
            return STATUS_LIST.get(value, UNKNOWN);
        }

        static Code fromHttpStatus(int status) {
            switch (status) {
                case 200: {
                    return OK;
                }
                case 400: {
                    return INVALID_ARGUMENT;
                }
                case 401: {
                    return UNAUTHENTICATED;
                }
                case 403: {
                    return PERMISSION_DENIED;
                }
                case 404: {
                    return NOT_FOUND;
                }
                case 409: {
                    return ABORTED;
                }
                case 429: {
                    return RESOURCE_EXHAUSTED;
                }
                case 499: {
                    return CANCELLED;
                }
                case 500: {
                    return INTERNAL;
                }
                case 501: {
                    return UNIMPLEMENTED;
                }
                case 503: {
                    return UNAVAILABLE;
                }
                case 504: {
                    return DEADLINE_EXCEEDED;
                }
            }
            return UNKNOWN;
        }

        static {
            STATUS_LIST = Code.buildStatusList();
        }
    }
}

