/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.content.Context;
import androidx.annotation.Keep;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.functions.DaggerFunctionsComponent;
import com.google.firebase.functions.FunctionsMultiResourceComponent;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

@Keep
public class FunctionsRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-fn";

    @Override
    public List<Component<?>> getComponents() {
        Qualified<Executor> liteExecutor = Qualified.qualified(Lightweight.class, Executor.class);
        Qualified<Executor> uiExecutor = Qualified.qualified(UiThread.class, Executor.class);
        return Arrays.asList(Component.builder(FunctionsMultiResourceComponent.class).name(LIBRARY_NAME).add(Dependency.required(Context.class)).add(Dependency.required(FirebaseOptions.class)).add(Dependency.optionalProvider(InternalAuthProvider.class)).add(Dependency.requiredProvider(FirebaseInstanceIdInternal.class)).add(Dependency.deferred(InteropAppCheckTokenProvider.class)).add(Dependency.required(liteExecutor)).add(Dependency.required(uiExecutor)).factory(c -> DaggerFunctionsComponent.builder().setApplicationContext(c.get(Context.class)).setFirebaseOptions(c.get(FirebaseOptions.class)).setLiteExecutor((Executor)c.get(liteExecutor)).setUiExecutor((Executor)c.get(uiExecutor)).setAuth(c.getProvider(InternalAuthProvider.class)).setIid(c.getProvider(FirebaseInstanceIdInternal.class)).setAppCheck(c.getDeferred(InteropAppCheckTokenProvider.class)).build().getMultiResourceComponent()).build(), LibraryVersionComponent.create(LIBRARY_NAME, "20.4.0"));
    }
}

