/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.GmsRpc;
import com.google.firebase.iid.ServiceStarter;
import com.google.firebase.iid.Store;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

class SyncTask
implements Runnable {
    private final long nextDelaySeconds;
    private final PowerManager.WakeLock syncWakeLock;
    private final FirebaseInstanceId iid;
    @VisibleForTesting
    ExecutorService processorExecutor = FirebaseIidExecutors.newCachedSingleThreadExecutor();

    @VisibleForTesting
    SyncTask(FirebaseInstanceId firebaseInstanceId, long l) {
        this.iid = firebaseInstanceId;
        this.nextDelaySeconds = l;
        this.syncWakeLock = ((PowerManager)this.getContext().getSystemService("power")).newWakeLock(1, "fiid-sync");
        this.syncWakeLock.setReferenceCounted(false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public void run() {
        block22: {
            block21: {
                block20: {
                    if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                        this.syncWakeLock.acquire();
                    }
                    this.iid.setSyncScheduledOrRunning(true);
                    var1_1 = this.iid.isGmsCorePresent();
                    if (var1_1) break block20;
                    this.iid.setSyncScheduledOrRunning(false);
                    if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                        this.syncWakeLock.release();
                        return;
                    }
                    return;
                }
                var1_1 = ServiceStarter.getInstance().hasAccessNetworkStatePermission(this.getContext());
                if (!var1_1) break block21;
                var1_1 = this.isDeviceConnected();
                if (var1_1) break block21;
                var1_2 = new ConnectivityChangeReceiver(this);
                var1_2.registerReceiver();
                if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                    this.syncWakeLock.release();
                    return;
                }
                return;
            }
            var1_1 = this.maybeRefreshToken();
            if (!var1_1) break block22;
            this.iid.setSyncScheduledOrRunning(false);
lbl33:
            // 2 sources

            while (true) {
                if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
                    this.syncWakeLock.release();
                    return;
                }
                return;
            }
        }
        try {
            this.iid.syncWithDelaySecondsInternal(this.nextDelaySeconds);
            ** continue;
        }
        catch (IOException var1_3) {
            try {
                var2_6 = "FirebaseInstanceId";
                var1_4 = var1_3.getMessage();
                var3_7 = String.valueOf(var1_4).length();
                var3_7 += 93;
            }
            catch (Throwable var1_5) {
                if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) lbl-1000:
                // 2 sources

                {
                    throw var1_5;
                }
                this.syncWakeLock.release();
                ** continue;
            }
            var4_8 = new StringBuilder(var3_7);
            var4_8.append("Topic sync or token retrieval failed on hard failure exceptions: ");
            var4_8.append(var1_4);
            var4_8.append(". Won't retry the operation.");
            Log.e(var2_6, var4_8.toString());
            this.iid.setSyncScheduledOrRunning(false);
            if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) ** continue;
            this.syncWakeLock.release();
            return;
        }
    }

    @VisibleForTesting
    boolean maybeRefreshToken() throws IOException {
        IOException iOException2;
        block11: {
            block10: {
                Object object;
                block9: {
                    object = ((SyncTask)((Object)string2)).iid;
                    if (!((SyncTask)((Object)string2)).iid.tokenNeedsRefresh((Store.Token)(object = ((FirebaseInstanceId)object).getTokenWithoutTriggeringSync()))) {
                        return true;
                    }
                    String string2 = ((SyncTask)((Object)string2)).iid.blockingGetMasterToken();
                    if (string2 != null) break block9;
                    Log.e("FirebaseInstanceId", "Token retrieval failed: null");
                    return false;
                }
                boolean bl = Log.isLoggable("FirebaseInstanceId", 3);
                if (!bl) break block10;
                try {
                    Log.d("FirebaseInstanceId", "Token successfully retrieved");
                }
                catch (IOException iOException2) {
                    if (GmsRpc.isErrorMessageForRetryableError(iOException2.getMessage())) {
                        String string3 = iOException2.getMessage();
                        object = String.valueOf(string3);
                        int n = ((String)object).length();
                        StringBuilder stringBuilder = new StringBuilder(n + 52);
                        stringBuilder.append("Token retrieval failed: ");
                        stringBuilder.append(string3);
                        stringBuilder.append(". Will retry token retrieval");
                        Log.w("FirebaseInstanceId", stringBuilder.toString());
                        return false;
                    }
                    break block11;
                }
                catch (SecurityException securityException) {
                    Log.w("FirebaseInstanceId", "Token retrieval failed with SecurityException. Will retry token retrieval");
                    return false;
                }
            }
            return true;
        }
        if (iOException2.getMessage() != null) {
            throw iOException2;
        }
        Log.w("FirebaseInstanceId", "Token retrieval failed without exception message. Will retry token retrieval");
        return false;
    }

    Context getContext() {
        return this.iid.getApp().getApplicationContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isDeviceConnected() {
        if ((object = (ConnectivityManager)((SyncTask)object).getContext().getSystemService("connectivity")) == null) return false;
        Object object = object.getActiveNetworkInfo();
        if (object == null) return false;
        if (!object.isConnected()) return false;
        return true;
    }

    @VisibleForTesting
    static class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @Nullable
        private SyncTask task;

        public ConnectivityChangeReceiver(SyncTask syncTask) {
            this.task = syncTask;
        }

        public void registerReceiver() {
            if (FirebaseInstanceId.isDebugLogEnabled()) {
                Log.d("FirebaseInstanceId", "Connectivity change received registered");
            }
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.task.getContext().registerReceiver(this, intentFilter);
        }

        public void onReceive(Context object, Intent intent) {
            object = this.task;
            if (object == null) {
                return;
            }
            if (!((SyncTask)object).isDeviceConnected()) {
                return;
            }
            if (FirebaseInstanceId.isDebugLogEnabled()) {
                Log.d("FirebaseInstanceId", "Connectivity changed. Starting background sync.");
            }
            this.task.iid.enqueueTaskWithDelaySeconds(this.task, 0L);
            this.task.getContext().unregisterReceiver(this);
            this.task = null;
        }
    }
}

