/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    @KeepForSdk
    @NonNull
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    @KeepForSdk
    @NonNull
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    @KeepForSdk
    @NonNull
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES;
    private static final Feature[] zze;
    private int zzf;
    private long zzg;
    private long zzh;
    private int zzi;
    private long zzj;
    @Nullable
    private volatile String zzk;
    @VisibleForTesting
    zzu zza;
    private final Context zzl;
    private final Looper zzm;
    private final GmsClientSupervisor zzn;
    private final GoogleApiAvailabilityLight zzo;
    final Handler zzb;
    private final Object zzp;
    private final Object zzq;
    @GuardedBy(value="mServiceBrokerLock")
    @Nullable
    private IGmsServiceBroker zzr;
    @VisibleForTesting
    @NonNull
    protected ConnectionProgressReportCallbacks zzc;
    @GuardedBy(value="mLock")
    @Nullable
    private IInterface zzs;
    private final ArrayList zzt;
    @GuardedBy(value="mLock")
    @Nullable
    private zze zzu;
    @GuardedBy(value="mLock")
    private int zzv;
    @Nullable
    private final BaseConnectionCallbacks zzw;
    @Nullable
    private final BaseOnConnectionFailedListener zzx;
    private final int zzy;
    @Nullable
    private final String zzz;
    @Nullable
    private volatile String zzA;
    @Nullable
    private ConnectionResult zzB;
    private boolean zzC;
    @Nullable
    private volatile zzj zzD;
    @VisibleForTesting
    @NonNull
    protected AtomicInteger zzd;

    @KeepForSdk
    public int getGCoreServiceId() {
        return this.zzy;
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    @Nullable
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    @NonNull
    public final Context getContext() {
        return this.zzl;
    }

    @KeepForSdk
    @NonNull
    public Intent getSignInIntent() {
        Object object = new UnsupportedOperationException("Not a sign in API");
        throw object;
    }

    @KeepForSdk
    @Nullable
    public Bundle getConnectionHint() {
        return null;
    }

    @KeepForSdk
    @NonNull
    protected Bundle getGetServiceRequestExtraArgs() {
        Object object = new Bundle();
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = ((BaseGmsClient)((Object)this_)).zzq;
        synchronized (object) {
            IGmsServiceBroker this_ = ((BaseGmsClient)((Object)this_)).zzr;
            if (this_ != null) return this_.asBinder();
            return null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(@NonNull IBinder var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public final T getService() throws DeadObjectException {
        Object object = ((BaseGmsClient)this_).zzp;
        synchronized (object) {
            Object this_;
            int n = ((BaseGmsClient)this_).zzv;
            if (n == 5) {
                this_ = new DeadObjectException();
                throw this_;
            }
            ((BaseGmsClient)this_).checkConnected();
            this_ = ((BaseGmsClient)this_).zzs;
            Preconditions.checkNotNull(this_, "Client is connected but service is null");
            return (T)this_;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @NonNull
    public final Looper getLooper() {
        return this.zzm;
    }

    @Nullable
    @KeepForSdk
    public ConnectionTelemetryConfiguration getTelemetryConfiguration() {
        zzj this_ = ((BaseGmsClient)((Object)this_)).zzD;
        if (this_ == null) {
            return null;
        }
        return this_.zzd;
    }

    @KeepForSdk
    @NonNull
    public String getEndpointPackageName() {
        if (!((BaseGmsClient)this_).isConnected() || (this_ = ((BaseGmsClient)this_).zza) == null) {
            Object this_ = new RuntimeException("Failed to connect when checking package");
            throw this_;
        }
        return ((zzu)this_).zzb();
    }

    @KeepForSdk
    @Nullable
    public String getLastDisconnectMessage() {
        return this.zzk;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    @NonNull
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @KeepForSdk
    @NonNull
    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    @KeepForSdk
    @Nullable
    protected Executor getBindServiceExecutor() {
        return null;
    }

    static {
        zze = new Feature[0];
        String[] stringArray = new String[]{"service_esmobile", "service_googleme"};
        GOOGLE_PLUS_REQUIRED_FEATURES = stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Looper looper, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener, @Nullable String realClientName) {
        void var6_6;
        void var3_3;
        void var2_2;
        void var1_1;
        void var5_5;
        void var4_4;
        GmsClientSupervisor gmsClientSupervisor = GmsClientSupervisor.getInstance(context);
        GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
        Preconditions.checkNotNull(var4_4);
        Preconditions.checkNotNull(var5_5);
        this((Context)var1_1, (Looper)var2_2, gmsClientSupervisor, googleApiAvailabilityLight, (int)var3_3, (BaseConnectionCallbacks)var4_4, (BaseOnConnectionFailedListener)var5_5, (String)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Handler handler, @NonNull GmsClientSupervisor supervisor, @NonNull GoogleApiAvailabilityLight apiAvailability, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzk = null;
        Serializable serializable = new Serializable();
        this.zzp = serializable;
        serializable = new Serializable();
        this.zzq = serializable;
        this.zzt = serializable = new Serializable();
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        super(0);
        this.zzd = serializable;
        Preconditions.checkNotNull(var1_1, "Context must not be null");
        this.zzl = var1_1;
        Preconditions.checkNotNull(var2_2, "Handler must not be null");
        this.zzb = var2_2;
        this.zzm = var2_2.getLooper();
        Preconditions.checkNotNull(var3_3, "Supervisor must not be null");
        this.zzn = var3_3;
        Preconditions.checkNotNull(var4_4, "API availability must not be null");
        this.zzo = var4_4;
        this.zzy = var5_5;
        this.zzw = var6_6;
        this.zzx = var7_7;
        this.zzz = null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Looper looper, @NonNull GmsClientSupervisor supervisor, @NonNull GoogleApiAvailabilityLight apiAvailability, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener, @Nullable String realClientName) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        zzb zzb2;
        this.zzk = null;
        Serializable serializable = new Serializable();
        this.zzp = serializable;
        serializable = new Serializable();
        this.zzq = serializable;
        this.zzt = serializable = new Serializable();
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        super(0);
        this.zzd = serializable;
        Preconditions.checkNotNull(zzb2, "Context must not be null");
        this.zzl = zzb2;
        Preconditions.checkNotNull(var2_2, "Looper must not be null");
        this.zzm = var2_2;
        Preconditions.checkNotNull(var3_3, "Supervisor must not be null");
        this.zzn = var3_3;
        Preconditions.checkNotNull(var4_4, "API availability must not be null");
        this.zzo = var4_4;
        zzb2 = new zzb(this, (Looper)var2_2);
        this.zzb = zzb2;
        this.zzy = var5_5;
        this.zzw = var6_6;
        this.zzx = var7_7;
        this.zzz = var8_8;
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzo.isGooglePlayServicesAvailable(this.zzl, this.getMinApkVersion());
        if (n != 0) {
            this.zzp(1, null);
            LegacyClientCallbackAdapter legacyClientCallbackAdapter = new LegacyClientCallbackAdapter(this);
            this.triggerNotAvailable(legacyClientCallbackAdapter, n, null);
            return;
        }
        LegacyClientCallbackAdapter legacyClientCallbackAdapter = new LegacyClientCallbackAdapter(this);
        this.connect(legacyClientCallbackAdapter);
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!((BaseGmsClient)this_).isConnected()) {
            Object this_ = new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
            throw this_;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks callbacks) {
        void var1_1;
        Preconditions.checkNotNull(callbacks, "Connection progress callbacks cannot be null.");
        this.zzc = var1_1;
        this.zzp(2, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void disconnect() {
        this.zzd.incrementAndGet();
        ArrayList arrayList = this.zzt;
        synchronized (arrayList) {
            int n = this.zzt.size();
            for (int i = 0; i < n; ++i) {
                ((zzc)this.zzt.get(i)).zzf();
            }
            this.zzt.clear();
        }
        Object object = this.zzq;
        synchronized (object) {
            this.zzr = null;
            // MONITOREXIT @DISABLED, blocks:[2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var1_5
            this.zzp(1, null);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void disconnect(@NonNull String message) {
        void var1_1;
        this.zzk = var1_1;
        this.disconnect();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public void dump(@NonNull String prefix, @NonNull FileDescriptor object, @NonNull PrintWriter writer, @NonNull String[] stringArray) {
        long l;
        PrintWriter printWriter;
        void var3_4;
        object = ((BaseGmsClient)this_).zzp;
        // MONITORENTER : object
        int n = ((BaseGmsClient)this_).zzv;
        Object object2 = ((BaseGmsClient)this_).zzs;
        // MONITOREXIT : object
        object = ((BaseGmsClient)this_).zzq;
        // MONITORENTER : object
        Object object3 = ((BaseGmsClient)this_).zzr;
        // MONITOREXIT : object
        var3_4.append((CharSequence)((Object)printWriter)).append("mConnectState=");
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        switch (n) {
            default: {
                var3_4.print("UNKNOWN");
                break;
            }
            case 5: {
                var3_4.print("DISCONNECTING");
                break;
            }
            case 4: {
                var3_4.print("CONNECTED");
                break;
            }
            case 3: {
                var3_4.print("LOCAL_CONNECTING");
                break;
            }
            case 2: {
                var3_4.print("REMOTE_CONNECTING");
                break;
            }
            case 1: {
                var3_4.print("DISCONNECTED");
            }
        }
        var3_4.append(" mService=");
        if (object2 == null) {
            var3_4.append("null");
        } else {
            var3_4.append(((BaseGmsClient)this_).getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(object2.asBinder())));
        }
        var3_4.append(" mServiceBroker=");
        if (object3 == null) {
            var3_4.println("null");
        } else {
            var3_4.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(object3.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (((BaseGmsClient)this_).zzh > 0L) {
            PrintWriter printWriter2 = var3_4.append((CharSequence)((Object)printWriter));
            printWriter2 = printWriter2.append("lastConnectedTime=");
            l = ((BaseGmsClient)this_).zzh;
            object2 = new Date(l);
            object2 = ((DateFormat)object).format((Date)object2);
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(l);
            ((StringBuilder)object3).append(" ");
            ((StringBuilder)object3).append((String)object2);
            printWriter2.println(((StringBuilder)object3).toString());
        }
        if (((BaseGmsClient)this_).zzg > 0L) {
            var3_4.append((CharSequence)((Object)printWriter)).append("lastSuspendedCause=");
            int n2 = ((BaseGmsClient)this_).zzf;
            switch (n2) {
                default: {
                    var3_4.append(String.valueOf(n2));
                    break;
                }
                case 3: {
                    var3_4.append("CAUSE_DEAD_OBJECT_EXCEPTION");
                    break;
                }
                case 2: {
                    var3_4.append("CAUSE_NETWORK_LOST");
                    break;
                }
                case 1: {
                    var3_4.append("CAUSE_SERVICE_DISCONNECTED");
                }
            }
            PrintWriter printWriter3 = var3_4.append(" lastSuspendedTime=");
            l = ((BaseGmsClient)this_).zzg;
            object2 = new Date(l);
            object2 = ((DateFormat)object).format((Date)object2);
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(l);
            ((StringBuilder)object3).append(" ");
            ((StringBuilder)object3).append((String)object2);
            printWriter3.println(((StringBuilder)object3).toString());
        }
        if (((BaseGmsClient)this_).zzj <= 0L) return;
        var3_4.append((CharSequence)((Object)printWriter)).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(((BaseGmsClient)this_).zzi));
        printWriter = var3_4.append(" lastFailedTime=");
        l = ((BaseGmsClient)this_).zzj;
        Object this_ = new Date(l);
        this_ = ((DateFormat)object).format((Date)this_);
        object = new StringBuilder();
        ((StringBuilder)object).append(l);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append((String)this_);
        printWriter.println(((StringBuilder)object).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(@Nullable IAccountAccessor authedAccountAccessor, @NonNull Set<Scope> scopes) {
        block15: {
            Object object;
            Object object2;
            Object object3 = this.getGetServiceRequestExtraArgs();
            int n = this.zzy;
            String string2 = this.zzA;
            int n2 = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
            Scope[] scopeArray = GetServiceRequest.zza;
            Bundle bundle = new Bundle();
            Feature[] featureArray = GetServiceRequest.zzb;
            GetServiceRequest getServiceRequest = new GetServiceRequest(6, n, n2, null, null, scopeArray, bundle, null, featureArray, featureArray, true, 0, false, string2);
            getServiceRequest.zzf = this.zzl.getPackageName();
            getServiceRequest.zzi = object3;
            if (object2 != null) {
                getServiceRequest.zzh = object2.toArray(new Scope[0]);
            }
            if (this.requiresSignIn()) {
                object2 = this.getAccount();
                if (object2 == null) {
                    object2 = new Account(DEFAULT_ACCOUNT, "com.google");
                }
                getServiceRequest.zzj = object2;
                if (object != null) {
                    getServiceRequest.zzg = object.asBinder();
                }
            } else if (this.requiresAccount()) {
                getServiceRequest.zzj = this.getAccount();
            }
            getServiceRequest.zzk = zze;
            getServiceRequest.zzl = this.getApiFeatures();
            if (this.usesClientTelemetry()) {
                getServiceRequest.zzo = true;
            }
            try {
                object = this.zzq;
                // MONITORENTER : object
                object2 = this.zzr;
                if (object2 == null) break block15;
            }
            catch (DeadObjectException deadObjectException) {
                Log.w("GmsClient", "IGmsServiceBroker.getService failed", deadObjectException);
                this.triggerConnectionSuspended(3);
                return;
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (RemoteException | RuntimeException exception) {
                Log.w("GmsClient", "IGmsServiceBroker.getService failed", exception);
                this.onPostInitHandler(8, null, null, this.zzd.get());
                return;
            }
            object3 = new zzd(this, this.zzd.get());
            object2.getService((IGmsCallbacks)object3, getServiceRequest);
            // MONITOREXIT : object
            return;
        }
        Log.w("GmsClient", "mServiceBroker is null, client disconnected");
        return;
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzh = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(@NonNull ConnectionResult result) {
        void var1_1;
        this.zzi = var1_1.getErrorCode();
        this.zzj = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int cause) {
        void var1_1;
        this.zzf = var1_1;
        this.zzg = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected void onPostInitHandler(int statusCode, @Nullable IBinder service, @Nullable Bundle resolution, int disconnectCount) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Handler handler = this.zzb;
        zzf zzf2 = new zzf(this, (int)var1_1, (IBinder)var2_2, (Bundle)var3_3);
        handler.sendMessage(handler.obtainMessage(1, (int)var4_4, -1, zzf2));
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setAttributionTag(@NonNull String attributionTag) {
        void var1_1;
        this.zzA = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void triggerConnectionSuspended(int cause) {
        void var1_1;
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(6, this.zzd.get(), (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks callbacks, int errorCode, @Nullable PendingIntent resolution) {
        void var3_3;
        void var2_2;
        Handler handler;
        Preconditions.checkNotNull(callbacks, "Connection progress callbacks cannot be null.");
        this.zzc = handler;
        handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(3, this.zzd.get(), (int)var2_2, var3_3));
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    protected boolean getUseDynamicLookup() {
        return this.getMinApkVersion() >= 211700000;
    }

    @KeepForSdk
    public boolean hasConnectionInfo() {
        return this.zzD != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (bl) return true;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public boolean usesClientTelemetry() {
        return false;
    }

    @KeepForSdk
    @NonNull
    public Feature[] getApiFeatures() {
        return zze;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        zzj this_ = ((BaseGmsClient)((Object)this_)).zzD;
        if (this_ == null) {
            return null;
        }
        return this_.zzb;
    }

    static /* bridge */ /* synthetic */ ConnectionResult zza(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzB;
    }

    static /* bridge */ /* synthetic */ BaseConnectionCallbacks zzb(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzw;
    }

    static /* bridge */ /* synthetic */ Object zzd(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzq;
    }

    @NonNull
    protected final String zze() {
        String string2 = this.zzz;
        if (string2 == null) {
            return this.zzl.getClass().getName();
        }
        return string2;
    }

    static /* bridge */ /* synthetic */ ArrayList zzf(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzt;
    }

    static /* bridge */ /* synthetic */ void zzg(BaseGmsClient baseGmsClient, ConnectionResult connectionResult) {
        baseGmsClient.zzB = connectionResult;
    }

    static /* bridge */ /* synthetic */ void zzh(BaseGmsClient baseGmsClient, IGmsServiceBroker iGmsServiceBroker) {
        baseGmsClient.zzr = iGmsServiceBroker;
    }

    static /* bridge */ /* synthetic */ void zzi(BaseGmsClient baseGmsClient, int n, IInterface iInterface) {
        baseGmsClient.zzp(n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzj(BaseGmsClient object, zzj object2) {
        ((BaseGmsClient)object).zzD = object2;
        if (!((BaseGmsClient)object).usesClientTelemetry()) {
            return;
        }
        object = ((zzj)object2).zzd;
        object2 = RootTelemetryConfigManager.getInstance();
        object = object == null ? null : ((ConnectionTelemetryConfiguration)object).zza();
        ((RootTelemetryConfigManager)object2).zza((RootTelemetryConfiguration)object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzk(BaseGmsClient baseGmsClient, int n) {
        int n2;
        block6: {
            Object object = baseGmsClient.zzp;
            synchronized (object) {
                int n3 = baseGmsClient.zzv;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl5 : MonitorExitStatement: MONITOREXIT : var1_3
                if (n3 == 3) {
                    baseGmsClient.zzC = true;
                    n2 = 5;
                    break block6;
                } else {
                    n2 = 4;
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        Handler handler = baseGmsClient.zzb;
        handler.sendMessage(handler.obtainMessage(n2, baseGmsClient.zzd.get(), 16));
    }

    protected final void zzl(int n, @Nullable Bundle object, int n2) {
        object = this.zzb;
        zzg zzg2 = new zzg(this, n, null);
        ((Handler)object).sendMessage(object.obtainMessage(7, n2, -1, (Object)zzg2));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void zzp(int var1_2, @Nullable IInterface var2_12) {
        var3_13 = var1_2 == 4;
        {
            block12: {
                var4_15 = var2_12 != null;
                var3_13 = var3_13 == var4_15;
                Preconditions.checkArgument(var3_13);
                var3_14 = this.zzp;
                // MONITORENTER : var3_14
                ** try [egrp 0[TRYBLOCK] [0 : 33->668)] { 
lbl8:
                // 1 sources

                this.zzv = var1_2;
                this.zzs = var2_12;
                switch (var1_2) {
                    case 2: 
                    case 3: {
                        var1_3 = this.zzu;
                        if (var1_3 != null && (var2_12 = this.zza) != null) {
                            var4_16 = "GmsClient";
                            var5_19 = var2_12.zzc();
                            var2_12 = var2_12.zzb();
                            var6_20 = new StringBuilder();
                            var6_20.append("Calling connect() while still connected, missing disconnect() for ");
                            var6_20.append((String)var5_19);
                            var6_20.append(" on ");
                            var6_20.append((String)var2_12);
                            Log.e(var4_16, var6_20.toString());
                            var2_12 = this.zzn;
                            var4_16 = this.zza.zzc();
                            Preconditions.checkNotNull(var4_16);
                            var2_12.zzb(var4_16, this.zza.zzb(), this.zza.zza(), var1_3, this.zze(), this.zza.zzd());
                            this.zzd.incrementAndGet();
                        }
                        this.zzu = var2_12 = new zze(this, this.zzd.get());
                        var1_4 = this.zzv;
                        var1_5 = var1_4 == 3 && (var1_5 = this.getLocalStartServiceAction()) != null ? new zzu(this.getContext().getPackageName(), this.getLocalStartServiceAction(), true, GmsClientSupervisor.getDefaultBindFlags(), false) : new zzu(this.getStartServicePackage(), this.getStartServiceAction(), false, GmsClientSupervisor.getDefaultBindFlags(), this.getUseDynamicLookup());
                        this.zza = var1_5;
                        var1_6 = this.zza.zzd();
                        if (var1_6 != 0 && (var1_6 = this.getMinApkVersion()) < 17895000) break block12;
                        var1_7 = this.zzn;
                        var4_17 = this.zza.zzc();
                        Preconditions.checkNotNull(var4_17);
                        var5_19 = this.zza;
                        var5_19 = var5_19.zzb();
                        var6_20 = this.zza;
                        var6_21 = var6_20.zza();
                        var7_22 = this.zze();
                        var8_23 = this.zza;
                        var8_24 = var8_23.zzd();
                        var9_25 = this.getBindServiceExecutor();
                        var10_26 = new zzn((String)var4_17, (String)var5_19, var6_21, var8_24);
                        var1_8 = var1_7.zzc(var10_26, (ServiceConnection)var2_12, var7_22, var9_25);
                        if (!var1_8) {
                            var1_9 = this.zza;
                            var1_9 = var1_9.zzc();
                            var2_12 = this.zza;
                            var2_12 = var2_12.zzb();
                            var4_17 = new StringBuilder();
                            var4_17.append("unable to connect to service: ");
                            var4_17.append((String)var1_9);
                            var4_17.append(" on ");
                            var4_17.append((String)var2_12);
                            Log.w("GmsClient", var4_17.toString());
                            this.zzl(16, null, this.zzd.get());
                            ** break;
                        }
                        ** GOTO lbl83
                    }
                    case 1: {
                        var1_10 = this.zzu;
                        if (var1_10 != null) {
                            var2_12 = this.zzn;
                            var4_18 = this.zza.zzc();
                            Preconditions.checkNotNull(var4_18);
                            var2_12.zzb(var4_18, this.zza.zzb(), this.zza.zza(), var1_10, this.zze(), this.zza.zzd());
                            this.zzu = null;
                        }
                    }
lbl83:
                    // 6 sources

                    default: {
                        // MONITOREXIT : var3_14
                        return;
                    }
                    case 4: 
                }
                Preconditions.checkNotNull(var2_12);
                this.onConnectedLocked(var2_12);
                return;
            }
            var1_11 = new IllegalStateException("Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ".concat(String.valueOf(this.zza.zzc())));
            throw var1_11;
        }
lbl94:
        // 1 sources

        catch (Throwable var0_1) {}
        // MONITOREXIT : var3_14
        throw var0_1;
    }

    static /* bridge */ /* synthetic */ boolean zzm(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzC;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ boolean zzn(BaseGmsClient baseGmsClient, int n, int n2, IInterface iInterface) {
        Object object = baseGmsClient.zzp;
        synchronized (object) {
            int n3 = baseGmsClient.zzv;
            if (n3 != n) {
                return false;
            }
            baseGmsClient.zzp(n2, iInterface);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ boolean zzo(BaseGmsClient baseGmsClient) {
        if (baseGmsClient.zzC) {
            return false;
        }
        if (TextUtils.isEmpty(baseGmsClient.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty(baseGmsClient.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(baseGmsClient.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        @KeepForSdk
        public static final int CAUSE_DEAD_OBJECT_EXCEPTION = 3;

        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        @KeepForSdk
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        final /* synthetic */ BaseGmsClient zza;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public LegacyClientCallbackAdapter(BaseGmsClient this$0) {
            void var1_1;
            this.zza = var1_1;
        }

        @Override
        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient baseGmsClient = ((LegacyClientCallbackAdapter)((Object)baseGmsClient)).zza;
                baseGmsClient.getRemoteService(null, baseGmsClient.getScopes());
                return;
            }
            if (((LegacyClientCallbackAdapter)((Object)baseGmsClient)).zza.zzx != null) {
                ((LegacyClientCallbackAdapter)((Object)baseGmsClient)).zza.zzx.onConnectionFailed(connectionResult);
                return;
            }
        }
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }
}

