/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Iterator;

@ShowFirstParty
@KeepForSdk
public abstract class FastSafeParcelableJsonResponse
extends FastJsonResponse
implements SafeParcelable {
    @Override
    public final int describeContents() {
        return 0;
    }

    @KeepForSdk
    public int hashCode() {
        Iterator<FastJsonResponse.Field<?, ?>> iterator = this.getFieldMappings().values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            FastJsonResponse.Field<?, ?> field = iterator.next();
            if (!this.isFieldSet(field)) continue;
            n = n * 31 + Preconditions.checkNotNull(this.getFieldValue(field)).hashCode();
        }
        return n;
    }

    @Override
    @VisibleForTesting
    @Nullable
    public Object getValueObject(@NonNull String string2) {
        return null;
    }

    @KeepForSdk
    public FastSafeParcelableJsonResponse() {
    }

    @KeepForSdk
    public boolean equals(@Nullable Object obj) {
        FastJsonResponse fastJsonResponse;
        if (obj == null) {
            return false;
        }
        if (this == fastJsonResponse) {
            return true;
        }
        if (!this.getClass().isInstance(fastJsonResponse)) {
            return false;
        }
        fastJsonResponse = fastJsonResponse;
        for (FastJsonResponse.Field<?, ?> field : this.getFieldMappings().values()) {
            if (this.isFieldSet(field)) {
                if (fastJsonResponse.isFieldSet(field)) {
                    if (Objects.equal(this.getFieldValue(field), fastJsonResponse.getFieldValue(field))) continue;
                    return false;
                }
                return false;
            }
            if (!fastJsonResponse.isFieldSet(field)) continue;
            return false;
        }
        return true;
    }

    @Override
    @VisibleForTesting
    public boolean isPrimitiveFieldSet(@NonNull String string2) {
        return false;
    }

    @KeepForSdk
    @NonNull
    public byte[] toByteArray() {
        Parcel parcel = Parcel.obtain();
        object.writeToParcel(parcel, 0);
        Object object = parcel.marshall();
        parcel.recycle();
        return object;
    }
}

