/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.android;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.database.core.TokenProvider;
import com.google.firebase.inject.Deferred;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class AndroidAppCheckTokenProvider
implements TokenProvider {
    private final Deferred<InteropAppCheckTokenProvider> deferredAppCheckProvider;
    private final AtomicReference<InteropAppCheckTokenProvider> internalAppCheck;

    public AndroidAppCheckTokenProvider(Deferred<InteropAppCheckTokenProvider> deferredAppCheckProvider) {
        this.deferredAppCheckProvider = deferredAppCheckProvider;
        this.internalAppCheck = new AtomicReference();
        deferredAppCheckProvider.whenAvailable(authProvider -> this.internalAppCheck.set((InteropAppCheckTokenProvider)authProvider.get()));
    }

    @Override
    @SuppressLint(value={"TaskMainThread"})
    public void getToken(boolean forceRefresh, @NonNull TokenProvider.GetTokenCompletionListener listener2) {
        InteropAppCheckTokenProvider appCheckProvider = this.internalAppCheck.get();
        if (appCheckProvider != null) {
            Task<AppCheckTokenResult> getTokenResult = appCheckProvider.getToken(forceRefresh);
            getTokenResult.addOnSuccessListener(result -> listener2.onSuccess(result.getToken())).addOnFailureListener(e -> listener2.onError(e.getMessage()));
        } else {
            listener2.onSuccess(null);
        }
    }

    @Override
    public void addTokenChangeListener(ExecutorService executorService, TokenProvider.TokenChangeListener tokenListener) {
        this.deferredAppCheckProvider.whenAvailable(provider -> ((InteropAppCheckTokenProvider)provider.get()).addAppCheckTokenListener(tokenResult -> executorService.execute(() -> tokenListener.onTokenChange(tokenResult.getToken()))));
    }

    @Override
    public void removeTokenChangeListener(TokenProvider.TokenChangeListener tokenListener) {
    }
}

