/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.annotations.NotNull;
import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.EventRegistrationZombieListener;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.QuerySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ZombieEventManager
implements EventRegistrationZombieListener {
    final HashMap<EventRegistration, List<EventRegistration>> globalEventRegistrations = new HashMap();
    private static ZombieEventManager defaultInstance = new ZombieEventManager();

    private ZombieEventManager() {
    }

    @NotNull
    public static ZombieEventManager getInstance() {
        return defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEventRegistration(EventRegistration registration2) {
        HashMap<EventRegistration, List<EventRegistration>> hashMap = this.globalEventRegistrations;
        synchronized (hashMap) {
            List<EventRegistration> registrationList = this.globalEventRegistrations.get(registration2);
            if (registrationList == null) {
                registrationList = new ArrayList<EventRegistration>();
                this.globalEventRegistrations.put(registration2, registrationList);
            }
            registrationList.add(registration2);
            if (!registration2.getQuerySpec().isDefault()) {
                EventRegistration defaultRegistration = registration2.clone(QuerySpec.defaultQueryAtPath(registration2.getQuerySpec().getPath()));
                registrationList = this.globalEventRegistrations.get(defaultRegistration);
                if (registrationList == null) {
                    registrationList = new ArrayList<EventRegistration>();
                    this.globalEventRegistrations.put(defaultRegistration, registrationList);
                }
                registrationList.add(registration2);
            }
            registration2.setIsUserInitiated(true);
            registration2.setOnZombied(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRecordEventRegistration(EventRegistration zombiedRegistration) {
        HashMap<EventRegistration, List<EventRegistration>> hashMap = this.globalEventRegistrations;
        synchronized (hashMap) {
            EventRegistration defaultRegistration;
            boolean found = false;
            List<EventRegistration> registrationList = this.globalEventRegistrations.get(zombiedRegistration);
            if (registrationList != null) {
                for (int i = 0; i < registrationList.size(); ++i) {
                    if (registrationList.get(i) != zombiedRegistration) continue;
                    found = true;
                    registrationList.remove(i);
                    break;
                }
                if (registrationList.isEmpty()) {
                    this.globalEventRegistrations.remove(zombiedRegistration);
                }
            }
            Utilities.hardAssert(found || !zombiedRegistration.isUserInitiated());
            if (!zombiedRegistration.getQuerySpec().isDefault() && (registrationList = this.globalEventRegistrations.get(defaultRegistration = zombiedRegistration.clone(QuerySpec.defaultQueryAtPath(zombiedRegistration.getQuerySpec().getPath())))) != null) {
                for (int i = 0; i < registrationList.size(); ++i) {
                    if (registrationList.get(i) != zombiedRegistration) continue;
                    registrationList.remove(i);
                    break;
                }
                if (registrationList.isEmpty()) {
                    this.globalEventRegistrations.remove(defaultRegistration);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zombifyForRemove(EventRegistration registration2) {
        HashMap<EventRegistration, List<EventRegistration>> hashMap = this.globalEventRegistrations;
        synchronized (hashMap) {
            List<EventRegistration> registrationList = this.globalEventRegistrations.get(registration2);
            if (registrationList != null && !registrationList.isEmpty()) {
                if (registration2.getQuerySpec().isDefault()) {
                    HashSet<QuerySpec> zombiedQueries = new HashSet<QuerySpec>();
                    for (int i = registrationList.size() - 1; i >= 0; --i) {
                        EventRegistration currentRegistration = registrationList.get(i);
                        if (zombiedQueries.contains(currentRegistration.getQuerySpec())) continue;
                        zombiedQueries.add(currentRegistration.getQuerySpec());
                        currentRegistration.zombify();
                    }
                } else {
                    registrationList.get(0).zombify();
                }
            }
        }
    }

    @Override
    public void onZombied(EventRegistration zombiedInstance) {
        this.unRecordEventRegistration(zombiedInstance);
    }
}

