/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.persistence;

import android.util.Log;
import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.UserWriteRecord;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.view.CacheNode;
import com.google.firebase.database.core.view.QuerySpec;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.Node;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class NoopPersistenceManager
implements PersistenceManager {
    private static final String TAG = "NoopPersistenceManager";
    private boolean insideTransaction = false;

    @Override
    public void saveUserOverwrite(Path path, Node node, long writeId) {
        this.verifyInsideTransaction();
    }

    @Override
    public void saveUserMerge(Path path, CompoundWrite children, long writeId) {
        this.verifyInsideTransaction();
    }

    @Override
    public void removeUserWrite(long writeId) {
        this.verifyInsideTransaction();
    }

    @Override
    public void removeAllUserWrites() {
        this.verifyInsideTransaction();
    }

    @Override
    public void applyUserWriteToServerCache(Path path, Node node) {
        this.verifyInsideTransaction();
    }

    @Override
    public void applyUserWriteToServerCache(Path path, CompoundWrite merge) {
        this.verifyInsideTransaction();
    }

    @Override
    public List<UserWriteRecord> loadUserWrites() {
        return Collections.emptyList();
    }

    @Override
    public CacheNode serverCache(QuerySpec query) {
        return new CacheNode(IndexedNode.from(EmptyNode.Empty(), query.getIndex()), false, false);
    }

    @Override
    public void updateServerCache(QuerySpec query, Node node) {
        this.verifyInsideTransaction();
    }

    @Override
    public void updateServerCache(Path path, CompoundWrite children) {
        this.verifyInsideTransaction();
    }

    @Override
    public void setQueryActive(QuerySpec query) {
        this.verifyInsideTransaction();
    }

    @Override
    public void setQueryInactive(QuerySpec query) {
        this.verifyInsideTransaction();
    }

    @Override
    public void setQueryComplete(QuerySpec query) {
        this.verifyInsideTransaction();
    }

    @Override
    public void setTrackedQueryKeys(QuerySpec query, Set<ChildKey> keys) {
        this.verifyInsideTransaction();
    }

    @Override
    public void updateTrackedQueryKeys(QuerySpec query, Set<ChildKey> added, Set<ChildKey> removed) {
        this.verifyInsideTransaction();
    }

    @Override
    public <T> T runInTransaction(Callable<T> callable) {
        Utilities.hardAssert(!this.insideTransaction, "runInTransaction called when an existing transaction is already in progress.");
        this.insideTransaction = true;
        try {
            T t = callable.call();
            return t;
        }
        catch (Throwable e) {
            Log.e(TAG, "Caught Throwable.", e);
            throw new RuntimeException(e);
        }
        finally {
            this.insideTransaction = false;
        }
    }

    private void verifyInsideTransaction() {
        Utilities.hardAssert(this.insideTransaction, "Transaction expected to already be in progress.");
    }
}

