/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.Value;
import java.util.Collections;
import java.util.List;

public abstract class ArrayTransformOperation
implements TransformOperation {
    private final List<Value> elements;

    ArrayTransformOperation(List<Value> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public List<Value> getElements() {
        return this.elements;
    }

    @Override
    public Value applyToLocalView(@Nullable Value previousValue, Timestamp localWriteTime) {
        return this.apply(previousValue);
    }

    @Override
    public Value applyToRemoteDocument(@Nullable Value previousValue, Value transformResult) {
        return this.apply(previousValue);
    }

    @Override
    @Nullable
    public Value computeBaseValue(@Nullable Value currentValue) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTransformOperation that = (ArrayTransformOperation)o;
        return this.elements.equals(that.elements);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    protected abstract Value apply(@Nullable Value var1);

    static ArrayValue.Builder coercedFieldValuesArray(@Nullable Value value) {
        if (Values.isArray(value)) {
            return (ArrayValue.Builder)value.getArrayValue().toBuilder();
        }
        return ArrayValue.newBuilder();
    }

    public static class Remove
    extends ArrayTransformOperation {
        public Remove(List<Value> elements) {
            super(elements);
        }

        @Override
        protected Value apply(@Nullable Value previousValue) {
            ArrayValue.Builder result = Remove.coercedFieldValuesArray(previousValue);
            for (Value removeElement : this.getElements()) {
                int i = 0;
                while (i < result.getValuesCount()) {
                    if (Values.equals(result.getValues(i), removeElement)) {
                        result.removeValues(i);
                        continue;
                    }
                    ++i;
                }
            }
            return (Value)Value.newBuilder().setArrayValue(result).build();
        }
    }

    public static class Union
    extends ArrayTransformOperation {
        public Union(List<Value> elements) {
            super(elements);
        }

        @Override
        protected Value apply(@Nullable Value previousValue) {
            ArrayValue.Builder result = Union.coercedFieldValuesArray(previousValue);
            for (Value unionElement : this.getElements()) {
                if (Values.contains(result, unionElement)) continue;
                result.addValues(unionElement);
            }
            return (Value)Value.newBuilder().setArrayValue(result).build();
        }
    }
}

