/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cloudmessaging.Rpc;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.GmsRpc$$Lambda$0;
import com.google.firebase.iid.Metadata;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@KeepForSdk
public class GmsRpc {
    @KeepForSdk
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    @KeepForSdk
    public static final String ERROR_INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";
    private final FirebaseApp app;
    private final Metadata metadata;
    private final Rpc rpc;
    private final Provider<UserAgentPublisher> userAgentPublisher;
    private final Provider<HeartBeatInfo> heartbeatInfo;
    private final FirebaseInstallationsApi firebaseInstallations;

    /*
     * WARNING - void declaration
     */
    public GmsRpc(FirebaseApp app, Metadata metadata, Provider<UserAgentPublisher> userAgentPublisher, Provider<HeartBeatInfo> heartbeatInfo, FirebaseInstallationsApi firebaseInstallations) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Rpc rpc = new Rpc(var1_1.getApplicationContext());
        this((FirebaseApp)var1_1, (Metadata)var2_2, rpc, (Provider<UserAgentPublisher>)var3_3, (Provider<HeartBeatInfo>)var4_4, (FirebaseInstallationsApi)var5_5);
    }

    @VisibleForTesting
    GmsRpc(FirebaseApp firebaseApp, Metadata metadata, Rpc rpc, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        this.app = firebaseApp;
        this.metadata = metadata;
        this.rpc = rpc;
        this.userAgentPublisher = provider;
        this.heartbeatInfo = provider2;
        this.firebaseInstallations = firebaseInstallationsApi;
    }

    /*
     * WARNING - void declaration
     */
    public Task<String> getToken(String instanceId, String authorizedEntity, String scope) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bundle bundle = new Bundle();
        return this.extractResponseWhenComplete(this.startRpc((String)var1_1, (String)var2_2, (String)var3_3, bundle));
    }

    /*
     * WARNING - void declaration
     */
    public Task<?> deleteToken(String instanceId, String authorizedEntity, String scope) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        return this.extractResponseWhenComplete(this.startRpc((String)var1_1, (String)var2_2, (String)var3_3, bundle));
    }

    /*
     * WARNING - void declaration
     */
    public Task<?> deleteInstanceId(String instanceId) {
        void var1_1;
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        return this.extractResponseWhenComplete(this.startRpc((String)var1_1, "*", "*", bundle));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public Task<?> subscribeToTopic(String instanceId, String cachedToken, String topic) {
        void var2_2;
        void var1_1;
        String string2;
        Bundle bundle = new Bundle();
        String string3 = String.valueOf(string2);
        String string4 = "/topics/";
        string3 = string3.length() != 0 ? string4.concat(string3) : new String(string4);
        bundle.putString("gcm.topic", string3);
        string2 = String.valueOf(string2);
        string3 = "/topics/";
        if (string2.length() != 0) {
            string2 = string3.concat(string2);
            return this.extractResponseWhenComplete(this.startRpc((String)var1_1, (String)var2_2, string2, bundle));
        }
        string2 = new String(string3);
        return this.extractResponseWhenComplete(this.startRpc((String)var1_1, (String)var2_2, string2, bundle));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public Task<?> unsubscribeFromTopic(String instanceId, String cachedToken, String topic) {
        void var2_2;
        void var1_1;
        String string2;
        Bundle bundle = new Bundle();
        String string3 = String.valueOf(string2);
        String string4 = "/topics/";
        string3 = string3.length() != 0 ? string4.concat(string3) : new String(string4);
        bundle.putString("gcm.topic", string3);
        bundle.putString("delete", "1");
        string2 = String.valueOf(string2);
        string3 = "/topics/";
        if (string2.length() != 0) {
            string2 = string3.concat(string2);
            return this.extractResponseWhenComplete(this.startRpc((String)var1_1, (String)var2_2, string2, bundle));
        }
        string2 = new String(string3);
        return this.extractResponseWhenComplete(this.startRpc((String)var1_1, (String)var2_2, string2, bundle));
    }

    private Task<Bundle> startRpc(String string2, String string3, String string4, Bundle bundle) {
        this.setDefaultAttributesToBundle(string2, string3, string4, bundle);
        return this.rpc.send(bundle);
    }

    private static String base64UrlSafe(byte[] byArray) {
        return Base64.encodeToString(byArray, 11);
    }

    private String getHashedFirebaseAppName() {
        Object object = ((GmsRpc)object).app.getName();
        String string2 = "SHA-1";
        try {
            object = GmsRpc.base64UrlSafe(MessageDigest.getInstance(string2).digest(((String)object).getBytes()));
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "[HASH-ERROR]";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bundle setDefaultAttributesToBundle(String object, String string2, String string3, Bundle bundle) {
        block4: {
            bundle.putString("scope", string3);
            bundle.putString("sender", string2);
            bundle.putString("subtype", string2);
            bundle.putString("appid", (String)object);
            bundle.putString("gmp_app_id", ((GmsRpc)((Object)userAgentPublisher)).app.getOptions().getApplicationId());
            bundle.putString("gmsv", Integer.toString(((GmsRpc)((Object)userAgentPublisher)).metadata.getGmsVersionCode()));
            bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
            bundle.putString("app_ver", ((GmsRpc)((Object)userAgentPublisher)).metadata.getAppVersionCode());
            bundle.putString("app_ver_name", ((GmsRpc)((Object)userAgentPublisher)).metadata.getAppVersionName());
            bundle.putString("firebase-app-name-hash", ((GmsRpc)((Object)userAgentPublisher)).getHashedFirebaseAppName());
            object = ((GmsRpc)((Object)userAgentPublisher)).firebaseInstallations.getToken(false);
            object = ((InstallationTokenResult)Tasks.await(object)).getToken();
            boolean bl = TextUtils.isEmpty((CharSequence)object);
            if (bl) break block4;
            bundle.putString("Goog-Firebase-Installations-Auth", (String)object);
        }
        try {
            Log.w("FirebaseInstanceId", "FIS auth token is empty");
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e("FirebaseInstanceId", "Failed to get FIS auth token", exception);
        }
        bundle.putString("cliv", "fiid-21.1.0");
        object = ((GmsRpc)((Object)userAgentPublisher)).heartbeatInfo.get();
        UserAgentPublisher userAgentPublisher = ((GmsRpc)((Object)userAgentPublisher)).userAgentPublisher.get();
        if (object != null && userAgentPublisher != null && (object = object.getHeartBeatCode("fire-iid")) != HeartBeatInfo.HeartBeat.NONE) {
            bundle.putString("Firebase-Client-Log-Type", Integer.toString(((HeartBeatInfo.HeartBeat)((Object)object)).getCode()));
            bundle.putString("Firebase-Client", userAgentPublisher.getUserAgent());
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @AnyThread
    private String handleResponse(Bundle object) throws IOException {
        Object object2;
        if (object == null) {
            object2 = new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            throw object2;
        }
        object2 = ((Bundle)object).getString("registration_id");
        if (object2 != null) {
            return object2;
        }
        object2 = ((Bundle)object).getString("unregistered");
        if (object2 != null) {
            return object2;
        }
        object2 = ((Bundle)object).getString("error");
        if ("RST".equals(object2)) {
            object2 = new IOException("INSTANCE_ID_RESET");
            throw object2;
        }
        if (object2 == null) {
            object2 = String.valueOf(object);
            object = String.valueOf(object2);
            int n = ((String)object).length();
            StringBuilder stringBuilder = new StringBuilder(n + 21);
            stringBuilder.append("Unexpected response: ");
            stringBuilder.append((String)object2);
            object2 = stringBuilder.toString();
            Throwable throwable = new Throwable();
            Log.w("FirebaseInstanceId", (String)object2, throwable);
            object2 = new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            throw object2;
        }
        object = new IOException((String)object2);
        throw object;
    }

    private Task<String> extractResponseWhenComplete(Task<Bundle> task) {
        Executor executor = FirebaseIidExecutors.directExecutor();
        GmsRpc$$Lambda$0 gmsRpc$$Lambda$0 = new GmsRpc$$Lambda$0(this);
        return task.continueWith(executor, gmsRpc$$Lambda$0);
    }

    static boolean isErrorMessageForRetryableError(String string2) {
        return ERROR_SERVICE_NOT_AVAILABLE.equals(string2) || ERROR_INTERNAL_SERVER_ERROR.equals(string2) || "InternalServerError".equals(string2);
    }

    final /* synthetic */ String lambda$extractResponseWhenComplete$0$GmsRpc(Task task) throws Exception {
        return this.handleResponse((Bundle)task.getResult(IOException.class));
    }
}

