/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import androidx.annotation.Keep;
import com.google.firebase.FirebaseApp;
import com.google.firebase.abt.component.AbtComponent;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import com.google.firebase.remoteconfig.interop.FirebaseRemoteConfigInterop;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@Keep
public class RemoteConfigRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-rc";

    @Override
    public List<Component<?>> getComponents() {
        Qualified<ScheduledExecutorService> blockingExecutor = Qualified.qualified(Blocking.class, ScheduledExecutorService.class);
        return Arrays.asList(Component.builder(RemoteConfigComponent.class, FirebaseRemoteConfigInterop.class).name(LIBRARY_NAME).add(Dependency.required(Context.class)).add(Dependency.required(blockingExecutor)).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(FirebaseInstallationsApi.class)).add(Dependency.required(AbtComponent.class)).add(Dependency.optionalProvider(AnalyticsConnector.class)).factory(container -> new RemoteConfigComponent(container.get(Context.class), (ScheduledExecutorService)container.get(blockingExecutor), container.get(FirebaseApp.class), container.get(FirebaseInstallationsApi.class), container.get(AbtComponent.class).get("frc"), container.getProvider(AnalyticsConnector.class))).eagerInDefaultApp().build(), LibraryVersionComponent.create(LIBRARY_NAME, "21.6.0"));
    }
}

