/*
 * Decompiled with CFR 0.152.
 */
package common.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import common.TimeProvider;
import data.account.model.Account;
import data.account.model.Stage;
import data.account.model.YearData;
import data.myevents.model.MyEvent;
import data.publishedevents.models.PublishedEvent;
import dev.gitlive.firebase.analytics.FirebaseAnalytics;
import di.MultiLogger;
import di.OSPlatform;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.datetime.Instant;
import models.DisplayPerformance;
import models.GridOrientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011J\u001e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010'\u001a\u00020\rJ\u001e\u0010(\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010.\u001a\u00020\r2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010/\u001a\u00020\r2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u00102\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u00104\u001a\u00020\rJ\u0006\u00105\u001a\u00020\rJ\u0006\u00106\u001a\u00020\rJ\u0006\u00107\u001a\u00020\rJ\u0006\u00108\u001a\u00020\rJ\u000e\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020!J\u0006\u0010;\u001a\u00020\rJ\u0006\u0010<\u001a\u00020\rJ\u0016\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020!J\u0016\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020CJ\u0016\u0010D\u001a\u00020\r2\u0006\u0010A\u001a\u00020!2\u0006\u0010?\u001a\u00020CJ\u0014\u0010E\u001a\u00020\r2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcommon/analytics/AnalyticsLogger;", "", "osPlatform", "Ldi/OSPlatform;", "logger", "Ldi/MultiLogger;", "analytics", "Ldev/gitlive/firebase/analytics/FirebaseAnalytics;", "<init>", "(Ldi/OSPlatform;Ldi/MultiLogger;Ldev/gitlive/firebase/analytics/FirebaseAnalytics;)V", "lastOpened", "Lkotlinx/datetime/Instant;", "setEventDetails", "", "yearData", "Ldata/account/model/YearData;", "loadedAccount", "Ldata/account/model/Account;", "logFavorite", "displayPerformance", "Lmodels/DisplayPerformance;", "account", "logUnfavorite", "logLastOpened", "logEventJoined", "publishedEvent", "Ldata/publishedevents/models/PublishedEvent;", "logDemoOpened", "logEventRemoved", "event", "Ldata/myevents/model/MyEvent;", "logRankUsage", "accountId", "", "logScreenChanged", "screen", "LAppScreens;", "logStageFiltered", "logTimeFiltered", "logGridFavoriteToggled", "logNowPlayingClicked", "logGridOrientationToggled", "gridOrientation", "Lmodels/GridOrientation;", "logJumpToTime", "currentScreen", "logJumpToGrid", "logJumpToStage", "logShowProfile", "artistName", "logFilterArtistList", "logSearchOpened", "logAccountInfoScreenOpened", "logFaqScreenOpened", "logStoreButtonClicked", "logMapScreenOpened", "logMoreListOpened", "logMorePageOpened", "screenTitle", "logNotificationScreenOpened", "logSettingsScreenOpened", "logStringSettingChanged", "stringKey", "newValue", "logBooleanChanged", "key", "actionIndex", "", "logIntSettingChanged", "logStagesReordered", "orderedStages", "", "Ldata/account/model/Stage;", "shared"})
@StabilityInferred(parameters=0)
public final class AnalyticsLogger {
    @NotNull
    private final OSPlatform osPlatform;
    @NotNull
    private final MultiLogger logger;
    @Nullable
    private final FirebaseAnalytics analytics;
    @Nullable
    private Instant lastOpened;
    public static final int $stable = 8;

    public AnalyticsLogger(@NotNull OSPlatform osPlatform, @NotNull MultiLogger logger, @Nullable FirebaseAnalytics analytics) {
        Intrinsics.checkNotNullParameter((Object)osPlatform, (String)"osPlatform");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.osPlatform = osPlatform;
        this.logger = logger;
        this.analytics = analytics;
    }

    public final void setEventDetails(@NotNull YearData yearData, @NotNull Account loadedAccount, @NotNull OSPlatform osPlatform) {
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        Intrinsics.checkNotNullParameter((Object)osPlatform, (String)"osPlatform");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$setEventDetails_u24lambda_u240 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$setEventDetails_u24lambda_u240.analytics;
            if (firebaseAnalytics != null) {
                firebaseAnalytics.setUserProperty("eventId", yearData.getEventId());
            }
            FirebaseAnalytics firebaseAnalytics2 = $this$setEventDetails_u24lambda_u240.analytics;
            if (firebaseAnalytics2 != null) {
                firebaseAnalytics2.setUserProperty("accountId", loadedAccount.getAccountId());
            }
            FirebaseAnalytics firebaseAnalytics3 = $this$setEventDetails_u24lambda_u240.analytics;
            if (firebaseAnalytics3 != null) {
                firebaseAnalytics3.setUserProperty("platform", osPlatform.getPlatformName());
            }
            FirebaseAnalytics firebaseAnalytics4 = $this$setEventDetails_u24lambda_u240.analytics;
            if (firebaseAnalytics4 != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics4.setDefaultEventParameters(MapsKt.mapOf((Pair[])pairArray));
            }
            FirebaseAnalytics firebaseAnalytics5 = $this$setEventDetails_u24lambda_u240.analytics;
            if (firebaseAnalytics5 != null) {
                firebaseAnalytics5.setUserId(yearData.getEventId());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logFavorite(@NotNull DisplayPerformance displayPerformance, @NotNull YearData yearData, @NotNull Account account) {
        Intrinsics.checkNotNullParameter((Object)displayPerformance, (String)"displayPerformance");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logFavorite_u24lambda_u241 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logFavorite_u24lambda_u241.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logFavorite_u24lambda_u241.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)account.getAccountId()), new Pair((Object)"artistName", (Object)displayPerformance.getArtistName())};
                firebaseAnalytics.logEvent(StringsKt.replace$default((String)StringsKt.replace$default((String)displayPerformance.getPerformanceId(), (String)"-", (String)"_", (boolean)false, (int)4, null), (String)"PID", (String)"fav", (boolean)false, (int)4, null), MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logUnfavorite(@NotNull DisplayPerformance displayPerformance, @NotNull YearData yearData, @NotNull Account account) {
        Intrinsics.checkNotNullParameter((Object)displayPerformance, (String)"displayPerformance");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logUnfavorite_u24lambda_u242 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logUnfavorite_u24lambda_u242.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logUnfavorite_u24lambda_u242.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)account.getAccountId()), new Pair((Object)"artistName", (Object)displayPerformance.getArtistName())};
                firebaseAnalytics.logEvent(StringsKt.replace$default((String)StringsKt.replace$default((String)displayPerformance.getPerformanceId(), (String)"-", (String)"_", (boolean)false, (int)4, null), (String)"PID", (String)"ufv", (boolean)false, (int)4, null), MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logLastOpened(@NotNull YearData yearData, @NotNull Account account) {
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        try {
            if (((CharSequence)account.getAccountId()).length() > 0 && ((CharSequence)yearData.getEventId()).length() > 0) {
                Instant lastOpened = this.lastOpened;
                long checkAfterMinutes = 3L;
                long timeSinceLastUpdate = lastOpened == null ? checkAfterMinutes : Duration.getInWholeMinutes-impl((long)TimeProvider.INSTANCE.getUtcInstant().minus-5sfh64U(lastOpened));
                this.lastOpened = TimeProvider.INSTANCE.getUtcInstant();
                if (timeSinceLastUpdate >= checkAfterMinutes) {
                    FirebaseAnalytics firebaseAnalytics = this.analytics;
                    if (firebaseAnalytics != null) {
                        Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)this.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)account.getAccountId())};
                        firebaseAnalytics.logEvent("app_opened", MapsKt.mapOf((Pair[])pairArray));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.e("Error Logging app_opened", exception);
        }
    }

    public final void logEventJoined(@NotNull PublishedEvent publishedEvent) {
        Intrinsics.checkNotNullParameter((Object)publishedEvent, (String)"publishedEvent");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logEventJoined_u24lambda_u243 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logEventJoined_u24lambda_u243.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)publishedEvent.getEventId()), new Pair((Object)"platform", (Object)$this$logEventJoined_u24lambda_u243.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)publishedEvent.getAccountId())};
                firebaseAnalytics.logEvent("event_joined", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logDemoOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logDemoOpened_u24lambda_u244 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logDemoOpened_u24lambda_u244.analytics;
            if (firebaseAnalytics != null) {
                firebaseAnalytics.logEvent("demo_opened", MapsKt.mapOf((Pair)new Pair((Object)"platform", (Object)$this$logDemoOpened_u24lambda_u244.osPlatform.getPlatformName())));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logEventRemoved(@NotNull MyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logEventRemoved_u24lambda_u245 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logEventRemoved_u24lambda_u245.analytics;
            if (firebaseAnalytics != null) {
                firebaseAnalytics.setUserProperty("eventId", event.getEventId());
            }
            FirebaseAnalytics firebaseAnalytics2 = $this$logEventRemoved_u24lambda_u245.analytics;
            if (firebaseAnalytics2 != null) {
                firebaseAnalytics2.setUserProperty("accountId", event.getAccountId());
            }
            FirebaseAnalytics firebaseAnalytics3 = $this$logEventRemoved_u24lambda_u245.analytics;
            if (firebaseAnalytics3 != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)event.getEventId()), new Pair((Object)"platform", (Object)$this$logEventRemoved_u24lambda_u245.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)event.getAccountId())};
                firebaseAnalytics3.logEvent("event_removed", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logRankUsage(@NotNull String accountId, @NotNull YearData yearData) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logRankUsage_u24lambda_u246 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logRankUsage_u24lambda_u246.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logRankUsage_u24lambda_u246.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)accountId)};
                firebaseAnalytics.logEvent("favorite_ranked_usage", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logScreenChanged(@NotNull AppScreens screen, @NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logScreenChanged_u24lambda_u247 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logScreenChanged_u24lambda_u247.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logScreenChanged_u24lambda_u247.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("screen_changed_" + screen, MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logStageFiltered(@NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logStageFiltered_u24lambda_u248 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logStageFiltered_u24lambda_u248.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logStageFiltered_u24lambda_u248.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("stage_filtered", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logTimeFiltered(@NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logTimeFiltered_u24lambda_u249 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logTimeFiltered_u24lambda_u249.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logTimeFiltered_u24lambda_u249.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("time_filtered", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logGridFavoriteToggled() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logGridFavoriteToggled_u24lambda_u2410 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logGridFavoriteToggled_u24lambda_u2410.analytics;
            if (firebaseAnalytics != null) {
                firebaseAnalytics.logEvent("grid_favorites_toggled", MapsKt.mapOf((Pair)new Pair((Object)"platform", (Object)$this$logGridFavoriteToggled_u24lambda_u2410.osPlatform.getPlatformName())));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logNowPlayingClicked(@NotNull AppScreens screen, @NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logNowPlayingClicked_u24lambda_u2411 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logNowPlayingClicked_u24lambda_u2411.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logNowPlayingClicked_u24lambda_u2411.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("now_playing_clicked_" + screen, MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logGridOrientationToggled(@NotNull GridOrientation gridOrientation) {
        Intrinsics.checkNotNullParameter((Object)gridOrientation, (String)"gridOrientation");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            String string2;
            AnalyticsLogger $this$logGridOrientationToggled_u24lambda_u2412 = analyticsLogger;
            boolean bl = false;
            GridOrientation gridOrientation2 = gridOrientation;
            if (gridOrientation2 instanceof GridOrientation.Landscape) {
                string2 = "landscape";
            } else if (gridOrientation2 instanceof GridOrientation.Portrait) {
                string2 = "portrait";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String orientationName = string2;
            FirebaseAnalytics firebaseAnalytics = $this$logGridOrientationToggled_u24lambda_u2412.analytics;
            if (firebaseAnalytics != null) {
                firebaseAnalytics.logEvent("grid_orientation_selected_" + orientationName, MapsKt.mapOf((Pair)new Pair((Object)"platform", (Object)$this$logGridOrientationToggled_u24lambda_u2412.osPlatform.getPlatformName())));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logJumpToTime(@NotNull AppScreens currentScreen, @NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)currentScreen, (String)"currentScreen");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logJumpToTime_u24lambda_u2413 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logJumpToTime_u24lambda_u2413.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"fromScreen", (Object)currentScreen), new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logJumpToTime_u24lambda_u2413.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("jump_to_time", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logJumpToGrid(@NotNull AppScreens currentScreen, @NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)currentScreen, (String)"currentScreen");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logJumpToGrid_u24lambda_u2414 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logJumpToGrid_u24lambda_u2414.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"fromScreen", (Object)currentScreen), new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logJumpToGrid_u24lambda_u2414.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("jump_to_grid", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logJumpToStage(@NotNull AppScreens currentScreen, @NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)currentScreen, (String)"currentScreen");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logJumpToStage_u24lambda_u2415 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logJumpToStage_u24lambda_u2415.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"fromScreen", (Object)currentScreen), new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logJumpToStage_u24lambda_u2415.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("jump_to_stage", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logShowProfile(@NotNull String artistName, @NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logShowProfile_u24lambda_u2416 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logShowProfile_u24lambda_u2416.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"artistName", (Object)artistName), new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logShowProfile_u24lambda_u2416.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("show_profile", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logFilterArtistList(@NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logFilterArtistList_u24lambda_u2417 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logFilterArtistList_u24lambda_u2417.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logFilterArtistList_u24lambda_u2417.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("filter_artist_list", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logSearchOpened(@NotNull YearData yearData, @NotNull Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)loadedAccount, (String)"loadedAccount");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logSearchOpened_u24lambda_u2418 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logSearchOpened_u24lambda_u2418.analytics;
            if (firebaseAnalytics != null) {
                Pair[] pairArray = new Pair[]{new Pair((Object)"eventId", (Object)yearData.getEventId()), new Pair((Object)"platform", (Object)$this$logSearchOpened_u24lambda_u2418.osPlatform.getPlatformName()), new Pair((Object)"accountId", (Object)loadedAccount.getAccountId())};
                firebaseAnalytics.logEvent("search_opened", MapsKt.mapOf((Pair[])pairArray));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logAccountInfoScreenOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logAccountInfoScreenOpened_u24lambda_u2419 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logAccountInfoScreenOpened_u24lambda_u2419.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"account_info_screen_opened", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logFaqScreenOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logFaqScreenOpened_u24lambda_u2420 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logFaqScreenOpened_u24lambda_u2420.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"faq_screen_opened", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logStoreButtonClicked() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logStoreButtonClicked_u24lambda_u2421 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logStoreButtonClicked_u24lambda_u2421.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"store_button_clicked", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logMapScreenOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logMapScreenOpened_u24lambda_u2422 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logMapScreenOpened_u24lambda_u2422.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"map_screen_opened", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logMoreListOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logMoreListOpened_u24lambda_u2423 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logMoreListOpened_u24lambda_u2423.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"more_list_opened", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logMorePageOpened(@NotNull String screenTitle) {
        Intrinsics.checkNotNullParameter((Object)screenTitle, (String)"screenTitle");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logMorePageOpened_u24lambda_u2424 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logMorePageOpened_u24lambda_u2424.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)("more_page_opened_" + StringsKt.replace$default((String)screenTitle, (String)" ", (String)"_", (boolean)false, (int)4, null)), null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logNotificationScreenOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logNotificationScreenOpened_u24lambda_u2425 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logNotificationScreenOpened_u24lambda_u2425.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"notification_screen_opened", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logSettingsScreenOpened() {
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logSettingsScreenOpened_u24lambda_u2426 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logSettingsScreenOpened_u24lambda_u2426.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)"settings_screen_opened", null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logStringSettingChanged(@NotNull String stringKey, @NotNull String newValue) {
        Intrinsics.checkNotNullParameter((Object)stringKey, (String)"stringKey");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logStringSettingChanged_u24lambda_u2427 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logStringSettingChanged_u24lambda_u2427.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)("settings_changed_" + stringKey + "_" + newValue), null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logBooleanChanged(@NotNull String key, int actionIndex) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String enabledState = actionIndex == 0 ? "disabled" : "enabled";
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logBooleanChanged_u24lambda_u2428 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logBooleanChanged_u24lambda_u2428.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)("settings_changed_" + key + "_" + enabledState), null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logIntSettingChanged(@NotNull String key, int newValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logIntSettingChanged_u24lambda_u2429 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logIntSettingChanged_u24lambda_u2429.analytics;
            if (firebaseAnalytics != null) {
                FirebaseAnalytics.logEvent$default((FirebaseAnalytics)firebaseAnalytics, (String)("settings_changed_" + key + "_" + newValue), null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void logStagesReordered(@NotNull List<Stage> orderedStages) {
        Intrinsics.checkNotNullParameter(orderedStages, (String)"orderedStages");
        AnalyticsLogger analyticsLogger = this;
        try {
            Unit unit;
            AnalyticsLogger $this$logStagesReordered_u24lambda_u2431 = analyticsLogger;
            boolean bl = false;
            FirebaseAnalytics firebaseAnalytics = $this$logStagesReordered_u24lambda_u2431.analytics;
            if (firebaseAnalytics != null) {
                firebaseAnalytics.logEvent("settings_changed_stage_reordered", MapsKt.mapOf((Pair)new Pair((Object)"stageOrders", (Object)CollectionsKt.joinToString$default((Iterable)orderedStages, (CharSequence)",", null, null, (int)0, null, AnalyticsLogger::logStagesReordered$lambda$31$lambda$30, (int)30, null))));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final CharSequence logStagesReordered$lambda$31$lambda$30(Stage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }
}

