/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.accountoverview;

import androidx.compose.runtime.Immutable;
import cafe.adriel.voyager.core.model.ScreenModel;
import cafe.adriel.voyager.core.model.ScreenModelKt;
import com.russhwolf.settings.Settings;
import common.ImageUploader;
import common.R2NetworkError;
import data.account.AccountRepositoryApi;
import data.account.ResultOf;
import data.account.model.Account;
import data.account.model.AdditionalContentType;
import data.account.model.ArtistNetwork;
import data.account.model.Directions;
import data.account.model.EventReference;
import data.account.model.Faq;
import data.account.model.FirestoreMapper;
import data.account.model.Stage;
import data.account.model.TagColor;
import data.account.model.YearData;
import data.artist.ArtistRepositoryApi;
import data.artist.CurrentVersionState;
import data.artist.model.Artist;
import data.artist.model.Performance;
import data.publishedevents.PublishedEventRepositoryApi;
import data.publishedevents.models.PublishedEvent;
import data.user.NetworkException;
import data.user.User;
import data.user.UserRepositoryApi;
import di.AppMode;
import di.ContentSource;
import di.MultiLogger;
import extensions.ListExtensionsKt;
import extensions.LocalDateTimeExtensionsKt;
import extensions.StringExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import myapplication.shared.generated.resources.Res;
import myapplication.shared.generated.resources.String0_commonMainKt;
import myapplication.shared.generated.resources.String2_commonMainKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.StringResource;
import ui.screens.accountoverview.AccountManagement;
import ui.screens.accountoverview.AccountUiState;
import ui.screens.accountoverview.AccountViewModel;
import ui.screens.accountoverview.AddEditEventType;
import ui.screens.accountoverview.EventLoadedData;
import ui.screens.accountoverview.FestivalAccountEditableData;
import ui.screens.accountoverview.FestivalCreationData;
import ui.screens.accountoverview.ProcessingState;
import ui.screens.accountoverview.SnackbarMessage;
import ui.screens.draftSchedule.editing.ImageType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020)H\u0086@\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020)J$\u0010-\u001a\u00020)2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020)2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209J$\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u0002002\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0082@\u00a2\u0006\u0002\u0010<J\u0016\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020=2\u0006\u00108\u001a\u000209Je\u00105\u001a\u00020)2\u0006\u0010>\u001a\u0002002\u0006\u00108\u001a\u0002092\"\u0010?\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020A\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0B\u0012\u0006\u0012\u0004\u0018\u00010C0@2\"\u0010D\u001a\u001e\b\u0001\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0B\u0012\u0006\u0012\u0004\u0018\u00010C0@H\u0002\u00a2\u0006\u0002\u0010EJ\u0016\u0010F\u001a\u00020)2\u0006\u00106\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u0016\u0010J\u001a\u00020)2\u0006\u00106\u001a\u00020K2\u0006\u0010H\u001a\u00020IJ\u0018\u0010L\u001a\u00020)2\u0006\u00106\u001a\u00020M2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010N\u001a\u00020)2\u0006\u00106\u001a\u00020O2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010P\u001a\u00020)2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u000100J\u001c\u0010T\u001a\u00020)2\u0006\u0010>\u001a\u0002002\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J$\u0010U\u001a\u00020)2\u0006\u0010>\u001a\u0002002\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010V\u001a\u00020WJ\u000e\u0010X\u001a\u00020)2\u0006\u00106\u001a\u00020OJ\u000e\u0010Y\u001a\u00020)2\u0006\u00106\u001a\u00020ZJ\u0016\u0010[\u001a\u00020)2\u0006\u00106\u001a\u00020ZH\u0082@\u00a2\u0006\u0002\u0010\\J\u001e\u0010]\u001a\u00020)2\u0006\u00106\u001a\u00020Z2\u0006\u0010^\u001a\u00020_H\u0082@\u00a2\u0006\u0002\u0010`J\u008e\u0001\u0010a\u001a\u00020)2\u0006\u0010>\u001a\u0002002\u0006\u00103\u001a\u0002042\"\u0010b\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020A\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0B\u0012\u0006\u0012\u0004\u0018\u00010C0@2&\u0010c\u001a\"\b\u0001\u0012\b\u0012\u00060dj\u0002`e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0B\u0012\u0006\u0012\u0004\u0018\u00010C0@2\"\u0010D\u001a\u001e\b\u0001\u0012\u0004\u0012\u000204\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0B\u0012\u0006\u0012\u0004\u0018\u00010C0@H\u0082@\u00a2\u0006\u0002\u0010fJ\u001c\u0010g\u001a\u00020)2\u0006\u00106\u001a\u00020h2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020j0/J\u0018\u0010k\u001a\u00020)2\u0006\u00106\u001a\u00020l2\b\u0010m\u001a\u0004\u0018\u00010nJ\u0016\u0010o\u001a\u00020)2\u0006\u00106\u001a\u00020p2\u0006\u0010q\u001a\u000202J\u001c\u0010r\u001a\u00020)2\u0006\u00106\u001a\u00020s2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020u0/J\u0016\u0010v\u001a\u00020&2\u0006\u0010>\u001a\u0002002\u0006\u0010w\u001a\u000202J\u0012\u0010x\u001a\u0002022\n\u0010y\u001a\u00060dj\u0002`eJ,\u0010z\u001a\u00020)2\u0006\u0010>\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u0010V\u001a\u00020W2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\u000e\u0010{\u001a\u00020)2\u0006\u00106\u001a\u00020|J\u000e\u0010{\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000e\u0010~\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000e\u0010\u007f\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u0080\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020MJ\u000f\u0010\u0081\u0001\u001a\u00020)2\u0006\u00106\u001a\u000207J\u0015\u0010\u0082\u0001\u001a\u00020)2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\u000f\u0010\u0083\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u0084\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u0085\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u0086\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u0087\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u0088\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u0017\u0010\u0089\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020R2\u0006\u0010>\u001a\u000200J\u000f\u0010\u008a\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u008a\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020|J\u000f\u0010\u008b\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u000f\u0010\u008c\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020GJ\u000f\u0010\u008d\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020}J\u0007\u0010\u008e\u0001\u001a\u00020)J\u0011\u0010\u008f\u0001\u001a\u00020)2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001J\u001a\u0010\u008f\u0001\u001a\u00020)2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0092\u0001\u001a\u000202J\u000f\u0010\u0093\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020sJ\u0018\u0010\u0094\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020p2\u0007\u0010\u0095\u0001\u001a\u000202J\u0017\u0010\u0096\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020l2\u0006\u0010m\u001a\u00020nJ\u001e\u0010\u0097\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020h2\r\u0010\u0097\u0001\u001a\b\u0012\u0004\u0012\u00020j0/J\u0019\u0010\u0098\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020Z2\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001J\u001e\u0010\u009b\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020s2\r\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020u0/J\u0011\u0010\u009d\u0001\u001a\u00020)2\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001J\u0018\u0010\u00a0\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020K2\u0007\u0010\u00a1\u0001\u001a\u00020IJ\u0018\u0010\u00a2\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020G2\u0007\u0010\u00a1\u0001\u001a\u00020IJ\u0018\u0010\u00a3\u0001\u001a\u00020)2\u0006\u00106\u001a\u0002072\u0007\u0010\u00a4\u0001\u001a\u000209J\u0018\u0010\u00a3\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020=2\u0007\u0010\u00a4\u0001\u001a\u000209J\u0010\u0010\u00a5\u0001\u001a\u00020)2\u0007\u00106\u001a\u00030\u00a6\u0001J\u000f\u0010\u00a7\u0001\u001a\u00020)2\u0006\u00106\u001a\u00020|J\u0010\u0010\u00a8\u0001\u001a\u00020)2\u0007\u00106\u001a\u00030\u00a9\u0001J\u0010\u0010\u00a8\u0001\u001a\u00020)2\u0007\u00106\u001a\u00030\u00aa\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\t\u0010!\u001a\u00020\"X\u0082\u0004R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ab\u0001"}, d2={"Lui/screens/accountoverview/AccountViewModel;", "Lcafe/adriel/voyager/core/model/ScreenModel;", "appMode", "Ldi/AppMode;", "userRepo", "Ldata/user/UserRepositoryApi;", "accountRepo", "Ldata/account/AccountRepositoryApi;", "draftArtistRepositoryApi", "Ldata/artist/ArtistRepositoryApi;", "publishedEventRepository", "Ldata/publishedevents/PublishedEventRepositoryApi;", "settings", "Lcom/russhwolf/settings/Settings;", "logger", "Ldi/MultiLogger;", "imageUploader", "Lcommon/ImageUploader;", "<init>", "(Ldi/AppMode;Ldata/user/UserRepositoryApi;Ldata/account/AccountRepositoryApi;Ldata/artist/ArtistRepositoryApi;Ldata/publishedevents/PublishedEventRepositoryApi;Lcom/russhwolf/settings/Settings;Ldi/MultiLogger;Lcommon/ImageUploader;)V", "user", "Ldata/user/User;", "_accountUiStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lui/screens/accountoverview/AccountUiState;", "accountUiStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getAccountUiStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "_errorMessageStateFlow", "Lui/screens/accountoverview/SnackbarMessage;", "errorMessageStateFlow", "getErrorMessageStateFlow", "isProcessingYearData", "Lkotlinx/atomicfu/AtomicBoolean;", "eventListenerJob", "Lkotlinx/coroutines/Job;", "isShowDemoDialog", "", "isMenuOpenedOnce", "loadInitialUserAccounts", "", "loadUserAccounts", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "signOut", "listenForYearDataUpdates", "accountList", "", "Ldata/account/model/Account;", "accountId", "", "yearData", "Ldata/account/model/YearData;", "saveAccountDetails", "uiState", "Lui/screens/accountoverview/AccountUiState$EditAccount;", "accountData", "Lui/screens/accountoverview/FestivalAccountEditableData;", "updateOpenedAccountOrReloadList", "newAccount", "(Ldata/account/model/Account;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lui/screens/accountoverview/AccountUiState$EditAccountFromEvent;", "account", "onProcessing", "Lkotlin/Function2;", "Lui/screens/accountoverview/ProcessingState;", "Lkotlin/coroutines/Continuation;", "", "onComplete", "(Ldata/account/model/Account;Lui/screens/accountoverview/FestivalAccountEditableData;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "addFestival", "Lui/screens/accountoverview/AccountUiState$AddNewAccount;", "festival", "Lui/screens/accountoverview/FestivalCreationData;", "addEditEvent", "Lui/screens/accountoverview/AddEditEventType;", "addEvent", "Lui/screens/accountoverview/AccountUiState$AddNewEvent;", "updateEvent", "Lui/screens/accountoverview/AccountUiState$EditEvent;", "addNewAccount", "accountManagement", "Lui/screens/accountoverview/AccountManagement;", "loadedAccount", "addNewEvent", "eventSelected", "eventReference", "Ldata/account/model/EventReference;", "invalidDateDialogDismissed", "saveMap", "Lui/screens/accountoverview/AccountUiState$EditMap;", "clearMap", "(Lui/screens/accountoverview/AccountUiState$EditMap;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadMap", "newMap", "Lui/screens/draftSchedule/editing/ImageType$File;", "(Lui/screens/accountoverview/AccountUiState$EditMap;Lui/screens/draftSchedule/editing/ImageType$File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateYearData", "onProcessingChanged", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ldata/account/model/Account;Ldata/account/model/YearData;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveFaq", "Lui/screens/accountoverview/AccountUiState$EditFaq;", "newFaq", "Ldata/account/model/Faq;", "saveDirections", "Lui/screens/accountoverview/AccountUiState$EditDirections;", "newDirections", "Ldata/account/model/Directions;", "saveAbout", "Lui/screens/accountoverview/AccountUiState$EditAbout;", "about", "saveAdditionalContent", "Lui/screens/accountoverview/AccountUiState$EditAdditionalContent;", "additionalContentList", "Ldata/account/model/AdditionalContentType;", "isEventPublished", "eventId", "getImageUploadErrorCode", "error", "editEvent", "editAccount", "Lui/screens/accountoverview/AccountUiState$AccountOpened;", "Lui/screens/accountoverview/EventLoadedData;", "editMap", "editAdditionalContent", "exitAddNewEvent", "exitEditAccount", "showAccountList", "openLiveApp", "openDraftLineupPublishing", "messageGuests", "previewDraftApp", "returnToOverview", "editFaq", "openAccount", "returnToAccountList", "editDirections", "returnToLoadedAccount", "editAbout", "clearSnackbarMessage", "showError", "errorMessage", "Lorg/jetbrains/compose/resources/StringResource;", "insertedText", "firstTimeAdditionalContentDialogSeen", "aboutTextChanged", "text", "updateDirections", "updateFaqList", "updateMap", "imageType", "Lui/screens/draftSchedule/editing/ImageType;", "updateAdditionalContent", "updatedAdditionalContentList", "updateAdditionalPage", "page", "", "updateEventData", "festivalCreationData", "updateNewAccountData", "updateAccountDetails", "data", "demoDialogSeen", "Lui/screens/accountoverview/AccountUiState$NoAccountFound;", "menuOpenedOnce", "hasSeenSingleStageWarning", "Lui/screens/accountoverview/AccountUiState$PreviewDraftApp;", "Lui/screens/accountoverview/AccountUiState$OpenLiveApp;", "shared"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAccountViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountViewModel.kt\nui/screens/accountoverview/AccountViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1260:1\n1056#2:1261\n360#2,7:1262\n230#2,2:1269\n360#2,7:1271\n774#2:1278\n865#2,2:1279\n1563#2:1281\n1634#2,2:1282\n1617#2,9:1284\n1869#2:1293\n1870#2:1295\n1626#2:1296\n1636#2:1297\n1563#2:1298\n1634#2,3:1299\n295#2,2:1302\n295#2,2:1304\n295#2,2:1306\n1#3:1294\n*S KotlinDebug\n*F\n+ 1 AccountViewModel.kt\nui/screens/accountoverview/AccountViewModel\n*L\n130#1:1261\n234#1:1262,7\n464#1:1269,2\n469#1:1271,7\n810#1:1278\n810#1:1279,2\n892#1:1281\n892#1:1282,2\n896#1:1284,9\n896#1:1293\n896#1:1295\n896#1:1296\n892#1:1297\n914#1:1298\n914#1:1299,3\n929#1:1302,2\n959#1:1304,2\n1063#1:1306,2\n896#1:1294\n*E\n"})
public final class AccountViewModel
implements ScreenModel {
    @NotNull
    private final AppMode appMode;
    @NotNull
    private final UserRepositoryApi userRepo;
    @NotNull
    private final AccountRepositoryApi accountRepo;
    @NotNull
    private final ArtistRepositoryApi draftArtistRepositoryApi;
    @NotNull
    private final PublishedEventRepositoryApi publishedEventRepository;
    @NotNull
    private final Settings settings;
    @NotNull
    private final MultiLogger logger;
    @NotNull
    private final ImageUploader imageUploader;
    @Nullable
    private final User user;
    @NotNull
    private final MutableStateFlow<AccountUiState> _accountUiStateFlow;
    @NotNull
    private final StateFlow<AccountUiState> accountUiStateFlow;
    @NotNull
    private final MutableStateFlow<SnackbarMessage> _errorMessageStateFlow;
    @NotNull
    private final StateFlow<SnackbarMessage> errorMessageStateFlow;
    private volatile /* synthetic */ int isProcessingYearData$volatile;
    @Nullable
    private Job eventListenerJob;
    private boolean isShowDemoDialog;
    private boolean isMenuOpenedOnce;
    public static final int $stable;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isProcessingYearData$volatile$FU;

    public AccountViewModel(@NotNull AppMode appMode, @NotNull UserRepositoryApi userRepo, @NotNull AccountRepositoryApi accountRepo, @NotNull ArtistRepositoryApi draftArtistRepositoryApi, @NotNull PublishedEventRepositoryApi publishedEventRepository, @NotNull Settings settings, @NotNull MultiLogger logger, @NotNull ImageUploader imageUploader) {
        Intrinsics.checkNotNullParameter((Object)appMode, (String)"appMode");
        Intrinsics.checkNotNullParameter((Object)userRepo, (String)"userRepo");
        Intrinsics.checkNotNullParameter((Object)accountRepo, (String)"accountRepo");
        Intrinsics.checkNotNullParameter((Object)draftArtistRepositoryApi, (String)"draftArtistRepositoryApi");
        Intrinsics.checkNotNullParameter((Object)publishedEventRepository, (String)"publishedEventRepository");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)imageUploader, (String)"imageUploader");
        this.appMode = appMode;
        this.userRepo = userRepo;
        this.accountRepo = accountRepo;
        this.draftArtistRepositoryApi = draftArtistRepositoryApi;
        this.publishedEventRepository = publishedEventRepository;
        this.settings = settings;
        this.logger = logger;
        this.imageUploader = imageUploader;
        this.user = this.userRepo.getSignedInUser();
        this._accountUiStateFlow = StateFlowKt.MutableStateFlow((Object)AccountUiState.SignedIn.INSTANCE);
        this.accountUiStateFlow = (StateFlow)this._accountUiStateFlow;
        this._errorMessageStateFlow = StateFlowKt.MutableStateFlow(null);
        this.errorMessageStateFlow = (StateFlow)this._errorMessageStateFlow;
        if (this.user == null) {
            this._accountUiStateFlow.setValue((Object)AccountUiState.SignedOut.INSTANCE);
        }
        this.isMenuOpenedOnce = this.appMode instanceof AppMode.Demo ? this.settings.getBoolean("isAccountMenuOpenedOnce", false) : true;
        this.isShowDemoDialog = this.appMode instanceof AppMode.Demo ? this.settings.getBoolean("isShownDemoDialog", true) : false;
    }

    @NotNull
    public final StateFlow<AccountUiState> getAccountUiStateFlow() {
        return this.accountUiStateFlow;
    }

    @NotNull
    public final StateFlow<SnackbarMessage> getErrorMessageStateFlow() {
        return this.errorMessageStateFlow;
    }

    private final /* synthetic */ int isProcessingYearData$volatile() {
        return this.isProcessingYearData$volatile;
    }

    private final /* synthetic */ void setProcessingYearData$volatile(int value) {
        this.isProcessingYearData$volatile = value;
    }

    public final void loadInitialUserAccounts() {
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.this$0.getAccountUiStateFlow().getValue() instanceof AccountUiState.SignedIn)) ** GOTO lbl22
                        this.label = 1;
                        v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.label = 2;
                        v1 = this.this$0.loadUserAccounts((Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object loadUserAccounts(@NotNull Continuation<? super Unit> $completion) {
        block13: {
            if (!($completion instanceof loadUserAccounts.1)) ** GOTO lbl-1000
            var6_2 = $completion;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccountViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.loadUserAccounts((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.accountRepo.getUserAccountList((Continuation<? super ResultOf<? extends List<Account>>>)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    if (!((result = (ResultOf)v0) instanceof ResultOf.Failure)) break;
                    System.out.println((Object)"Account Fetch Error");
                    this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                    this._accountUiStateFlow.setValue((Object)new AccountUiState.ErrorScreen(((ResultOf.Failure)result).getException()));
                    $continuation.L$0 = result;
                    $continuation.label = 2;
                    v1 = DelayKt.delay((long)5000L, (Continuation)$continuation);
                    if (v1 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl34
                }
                case 2: {
                    result = (ResultOf)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl34:
                    // 2 sources

                    this.signOut();
                    break block13;
                }
            }
            if (result instanceof ResultOf.Success) {
                if (((List)((ResultOf.Success)result).getResult()).isEmpty()) {
                    this._accountUiStateFlow.setValue((Object)new AccountUiState.NoAccountFound(this.isShowDemoDialog, this.appMode));
                } else {
                    $this$sortedBy$iv = (Iterable)((ResultOf.Success)result).getResult();
                    $i$f$sortedBy = false;
                    this.showAccountList(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Account it = (Account)a;
                            boolean bl = false;
                            String string2 = it.getAccountName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                            it = (Account)b;
                            Comparable comparable = (Comparable)((Object)string2);
                            bl = false;
                            String string3 = it.getAccountName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string3)));
                        }
                    }));
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void signOut() {
        this.settings.putBoolean("isDemoOpened", false);
        this.settings.remove("activeAccount");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AccountViewModel.access$getUserRepo$p(this.this$0).signOut((Continuation<? super ResultOf<Unit>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((result = (ResultOf)v0) instanceof ResultOf.Failure) {
                            AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                            AccountViewModel.access$getLogger$p(this.this$0).e("Sign Out Error", ((ResultOf.Failure)result).getException());
                        } else if (result instanceof ResultOf.Success) {
                            AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.SignedOut.INSTANCE);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void listenForYearDataUpdates(@NotNull List<Account> accountList, @NotNull String accountId, @NotNull YearData yearData) {
        Intrinsics.checkNotNullParameter(accountList, (String)"accountList");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Job job2 = this.eventListenerJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.eventListenerJob = BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, accountId, yearData, accountList, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ String $accountId;
            final /* synthetic */ YearData $yearData;
            final /* synthetic */ List<Account> $accountList;
            {
                this.this$0 = $receiver;
                this.$accountId = $accountId;
                this.$yearData = $yearData;
                this.$accountList = $accountList;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AccountViewModel.access$getDraftArtistRepositoryApi$p(this.this$0).listenForRemoteEventUpdates(this.$accountId, this.$yearData, ContentSource.Draft.INSTANCE, (Continuation<? super Flow<? extends ResultOf<CurrentVersionState>>>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = FlowKt.collectLatest((Flow)FlowKt.cancellable((Flow)((Flow)v0)), (Function2)((Function2)new Function2<ResultOf<? extends CurrentVersionState>, Continuation<? super Unit>, Object>(this.this$0, this.$accountId, this.$yearData, this.$accountList, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            final /* synthetic */ String $accountId;
                            final /* synthetic */ YearData $yearData;
                            final /* synthetic */ List<Account> $accountList;
                            {
                                this.this$0 = $receiver;
                                this.$accountId = $accountId;
                                this.$yearData = $yearData;
                                this.$accountList = $accountList;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                block8: {
                                    var2_2 = (ResultOf)this.L$0;
                                    var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var3_4 = result;
                                            if (!(var3_4 instanceof ResultOf.Failure)) ** GOTO lbl10
                                            AccountViewModel.access$getLogger$p(this.this$0).e("Error listening For Updates", ((ResultOf.Failure)result).getException());
                                            break block8;
lbl10:
                                            // 1 sources

                                            if (!(var3_4 instanceof ResultOf.Success)) break;
                                            if (AccountViewModel.access$isProcessingYearData$volatile$FU().get(this.this$0) == 1) {
                                                AccountViewModel.access$getLogger$p(this.this$0).i("Year Data change from self, ignoring update.");
                                                return Unit.INSTANCE;
                                            }
                                            this.L$0 = result;
                                            this.label = 1;
                                            v0 = AccountViewModel.access$getAccountRepo$p(this.this$0).getYearData(ContentSource.Draft.INSTANCE, this.$accountId, this.$yearData.getEventId(), (CurrentVersionState)((ResultOf.Success)result).getResult(), (Continuation<? super ResultOf<YearData>>)((Continuation)this));
                                            if (v0 == var6_3) {
                                                return var6_3;
                                            }
                                            ** GOTO lbl23
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl23:
                                            // 2 sources

                                            if (!((var5_6 = (updatedYearData = (ResultOf)v0)) instanceof ResultOf.Failure)) ** GOTO lbl26
                                            AccountViewModel.access$getLogger$p(this.this$0).e("Year Data Listener Error", ((ResultOf.Failure)updatedYearData).getException());
                                            break block8;
lbl26:
                                            // 1 sources

                                            if (!(var5_6 instanceof ResultOf.Success)) ** GOTO lbl34
                                            if (((YearData)((ResultOf.Success)updatedYearData).getResult()).getVersion() != ((CurrentVersionState)((ResultOf.Success)result).getResult()).getYearDataVersion()) {
                                                System.out.println((Object)"QQQ Different Version");
                                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getEvent_data_changed_elsewhere_message(Res.string.INSTANCE), null, 2, null));
                                                this.this$0.showAccountList(this.$accountList);
                                            } else {
                                                AccountViewModel.access$getLogger$p(this.this$0).i("Year Data same version, nothing to update.");
                                            }
                                            break block8;
lbl34:
                                            // 1 sources

                                            throw new NoWhenBranchMatchedException();
                                        }
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ResultOf<CurrentVersionState> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void saveAccountDetails(@NotNull AccountUiState.EditAccount uiState, @NotNull FestivalAccountEditableData accountData) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)accountData, (String)"accountData");
        this.saveAccountDetails(uiState.getLoadedAccount(), accountData, (Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this, uiState, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditAccount $uiState;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ProcessingState processingState = (ProcessingState)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditAccount.copy$default(this.$uiState, (ProcessingState)it, null, null, null, null, null, 62, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Function2<? super Account, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<Account, Continuation<? super Unit>, Object>(this, uiState, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditAccount $uiState;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Account account = (Account)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void updatedAccount2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = updatedAccount2;
                        this.label = 1;
                        Object object2 = AccountViewModel.access$updateOpenedAccountOrReloadList(this.this$0, (Account)updatedAccount2, this.$uiState.getAccountList(), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Account p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Object updateOpenedAccountOrReloadList(Account newAccount, List<Account> accountList, Continuation<? super Unit> $completion) {
        int index;
        block4: {
            int n;
            List<Account> $this$indexOfFirst$iv = accountList;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Account> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Account item$iv;
                Account it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getAccountId(), (Object)newAccount.getAccountId())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            this.logger.e("updateAccountListOrReload error", new IllegalStateException("Updated Account Not Found In List"));
            Object object = this.loadUserAccounts($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        List<Account> newAccountList = ListExtensionsKt.replaceAt(CollectionsKt.toMutableList((Collection)accountList), index, newAccount);
        this._accountUiStateFlow.setValue((Object)new AccountUiState.AccountOpened(newAccount, newAccountList, this.appMode, this.isMenuOpenedOnce));
        return Unit.INSTANCE;
    }

    public final void saveAccountDetails(@NotNull AccountUiState.EditAccountFromEvent uiState, @NotNull FestivalAccountEditableData accountData) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)accountData, (String)"accountData");
        this.saveAccountDetails(uiState.getLoadedAccount(), accountData, (Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this, uiState, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditAccountFromEvent $uiState;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ProcessingState processingState = (ProcessingState)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditAccountFromEvent.copy$default(this.$uiState, (ProcessingState)it, null, null, null, null, null, null, null, 254, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Function2<? super Account, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<Account, Continuation<? super Unit>, Object>(uiState, this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountUiState.EditAccountFromEvent $uiState;
            final /* synthetic */ AccountViewModel this$0;
            {
                this.$uiState = $uiState;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Account)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$indexOfFirst$iv = this.$uiState.getAccountList();
                        $i$f$indexOfFirst = false;
                        index$iv = 0;
                        var7_6 = $this$indexOfFirst$iv.iterator();
                        while (var7_6.hasNext()) {
                            it = item$iv = var7_6.next();
                            $i$a$-indexOfFirst-AccountViewModel$saveAccountDetails$4$index$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getAccountId(), (Object)result.getAccountId())) ** GOTO lbl17
                            v0 = index$iv;
                            ** GOTO lbl20
lbl17:
                            // 1 sources

                            ++index$iv;
                        }
                        v0 = -1;
lbl20:
                        // 2 sources

                        index = v0;
                        accountList = index != -1 ? ListExtensionsKt.replaceAt(CollectionsKt.toMutableList((Collection)this.$uiState.getAccountList()), index, result) : this.$uiState.getAccountList();
                        this.this$0.returnToOverview(AccountUiState.EditAccountFromEvent.copy$default(this.$uiState, null, (Account)result, accountList, null, null, null, null, null, 249, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Account p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void saveAccountDetails(Account account, FestivalAccountEditableData accountData, Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object> onProcessing, Function2<? super Account, ? super Continuation<? super Unit>, ? extends Object> onComplete) {
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onProcessing, this, account, accountData, onComplete, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int label;
            final /* synthetic */ Function2<ProcessingState, Continuation<? super Unit>, Object> $onProcessing;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ Account $account;
            final /* synthetic */ FestivalAccountEditableData $accountData;
            final /* synthetic */ Function2<Account, Continuation<? super Unit>, Object> $onComplete;
            {
                this.$onProcessing = $onProcessing;
                this.this$0 = $receiver;
                this.$account = $account;
                this.$accountData = $accountData;
                this.$onComplete = $onComplete;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block41: {
                    block42: {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = this.$onProcessing.invoke((Object)ProcessingState.Processing.INSTANCE, (Object)this);
                                if (v0 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = AccountViewModel.access$getPublishedEventRepository$p(this.this$0).getPublishedEvent(this.$account.getAccountId(), (Continuation<? super ResultOf<PublishedEvent>>)((Continuation)this));
                                if (v1 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                if ((result = (ResultOf)v1) instanceof ResultOf.Failure) {
                                    v2 = null;
                                } else if (result instanceof ResultOf.Success) {
                                    v2 = (PublishedEvent)((ResultOf.Success)result).getResult();
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                publishedEvent = v2;
                                var4_12 = this.$accountData.getBannerImageType();
                                if (!(var4_12 instanceof ImageType.File)) ** GOTO lbl61
                                this.L$0 = publishedEvent;
                                this.label = 3;
                                v3 = AccountViewModel.access$getImageUploader$p(this.this$0).uploadImage((ImageType.File)this.$accountData.getBannerImageType(), this.$account.getAccountId(), "", (Continuation<? super ResultOf<String>>)((Continuation)this));
                                if (v3 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl41
                            }
                            case 3: {
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl41:
                                // 2 sources

                                if (!((result = (ResultOf)v3) instanceof ResultOf.Failure)) break;
                                AccountViewModel.access$getLogger$p(this.this$0).e("updateAccountDetails Banner Upload Error", ((ResultOf.Failure)result).getException());
                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_uploading_image_message(Res.string.INSTANCE), this.this$0.getImageUploadErrorCode(((ResultOf.Failure)result).getException())));
                                this.L$0 = publishedEvent;
                                this.L$1 = result;
                                this.label = 4;
                                v4 = this.$onProcessing.invoke((Object)ProcessingState.NotProcessing.INSTANCE, (Object)this);
                                if (v4 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl56
                            }
                            case 4: {
                                result = (ResultOf)this.L$1;
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl56:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        if (result instanceof ResultOf.Success) {
                            v5 = (String)((ResultOf.Success)result).getResult();
                        } else {
                            throw new NoWhenBranchMatchedException();
lbl61:
                            // 1 sources

                            if (var4_12 instanceof ImageType.None) {
                                v5 = "";
                            } else if (var4_12 instanceof ImageType.URL) {
                                v5 = this.$account.getBannerImageUrl();
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        bannerResult = v5;
                        result = this.$accountData.getIconImageType();
                        if (!(result instanceof ImageType.File)) ** GOTO lbl107
                        this.L$0 = publishedEvent;
                        this.L$1 = bannerResult;
                        this.label = 5;
                        v6 = AccountViewModel.access$getImageUploader$p(this.this$0).uploadImage((ImageType.File)this.$accountData.getIconImageType(), this.$account.getAccountId(), "", (Continuation<? super ResultOf<String>>)((Continuation)this));
                        if (v6 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl83
                        {
                            case 5: {
                                bannerResult = (String)this.L$1;
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v6 = $result;
lbl83:
                                // 2 sources

                                result = (ResultOf)v6;
                                if (!(result instanceof ResultOf.Failure)) break;
                                AccountViewModel.access$getLogger$p(this.this$0).e("updateAccountDetails Icon Upload Error", ((ResultOf.Failure)result).getException());
                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_uploading_image_message(Res.string.INSTANCE), this.this$0.getImageUploadErrorCode(((ResultOf.Failure)result).getException())));
                                this.L$0 = publishedEvent;
                                this.L$1 = bannerResult;
                                this.L$2 = result;
                                this.label = 6;
                                v7 = this.$onProcessing.invoke((Object)ProcessingState.NotProcessing.INSTANCE, (Object)this);
                                if (v7 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl102
                            }
                            case 6: {
                                result = (ResultOf)this.L$2;
                                bannerResult = (String)this.L$1;
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
lbl102:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        if (result instanceof ResultOf.Success) {
                            v8 = (String)((ResultOf.Success)result).getResult();
                        } else {
                            throw new NoWhenBranchMatchedException();
lbl107:
                            // 1 sources

                            if (result instanceof ImageType.None) {
                                v8 = "";
                            } else if (result instanceof ImageType.URL) {
                                v8 = this.$account.getIconImageUrl();
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        iconResult = v8;
                        if (StringsKt.isBlank((CharSequence)this.$accountData.getNewSocial())) {
                            v9 = this.$accountData.getSocialList();
                        } else {
                            result = CollectionsKt.toMutableList((Collection)this.$accountData.getSocialList());
                            var7_23 = this.$accountData;
                            $this$invokeSuspend_u24lambda_u240 = result;
                            $i$a$-apply-AccountViewModel$saveAccountDetails$5$socialList$1 = false;
                            $this$invokeSuspend_u24lambda_u240.add(var7_23.getNewSocial());
                            v9 = result;
                        }
                        socialList = v9;
                        var7_23 = this.$accountData.getFestivalName();
                        $this$invokeSuspend_u24lambda_u240 = this.$accountData.getWebsiteUrl();
                        var9_30 = this.$accountData.getStoreUrl();
                        var10_31 = this.$accountData.getSupportEmail();
                        newAccount = Account.copy$default(this.$account, null, null, (String)var7_23, null, var9_30, (String)$this$invokeSuspend_u24lambda_u240, bannerResult, iconResult, var10_31, socialList, false, 1035, null);
                        if (publishedEvent != null) {
                            $this$invokeSuspend_u24lambda_u240 = this.$accountData.getFestivalName();
                            var9_30 = this.$accountData.getWebsiteUrl();
                            v10 = this.$accountData.getFestivalName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"toLowerCase(...)");
                            var10_31 = v10;
                            var11_32 = StringExtensionsKt.toFirebaseSearchList(this.$accountData.getFestivalName());
                            v11 = PublishedEvent.copy$default(publishedEvent, null, (String)$this$invokeSuspend_u24lambda_u240, var10_31, var11_32, null, null, iconResult, null, null, null, 0L, null, null, var9_30, socialList, false, 40881, null);
                        } else {
                            v11 = null;
                        }
                        newPublishedEvent = v11;
                        this.L$0 = publishedEvent;
                        this.L$1 = bannerResult;
                        this.L$2 = iconResult;
                        this.L$3 = socialList;
                        this.L$4 = newAccount;
                        this.L$5 = newPublishedEvent;
                        this.label = 7;
                        v12 = AccountViewModel.access$getAccountRepo$p(this.this$0).editAccount(newAccount, newPublishedEvent, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                        if (v12 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl163
                        {
                            case 7: {
                                newPublishedEvent = (PublishedEvent)this.L$5;
                                newAccount = (Account)this.L$4;
                                socialList = (List<String>)this.L$3;
                                iconResult = (String)this.L$2;
                                bannerResult = (String)this.L$1;
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v12 = $result;
lbl163:
                                // 2 sources

                                if (!((result = (ResultOf)v12) instanceof ResultOf.Failure)) break;
                                AccountViewModel.access$getLogger$p(this.this$0).e("updateAccountDetails Error", ((ResultOf.Failure)result).getException());
                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                                this.L$0 = publishedEvent;
                                this.L$1 = bannerResult;
                                this.L$2 = iconResult;
                                this.L$3 = socialList;
                                this.L$4 = newAccount;
                                this.L$5 = newPublishedEvent;
                                this.L$6 = result;
                                this.label = 8;
                                v13 = this.$onProcessing.invoke((Object)ProcessingState.NotProcessing.INSTANCE, (Object)this);
                                if (v13 == var12_2) {
                                    return var12_2;
                                }
                                break block41;
                            }
                            case 8: {
                                result = (ResultOf)this.L$6;
                                newPublishedEvent = (PublishedEvent)this.L$5;
                                newAccount = (Account)this.L$4;
                                socialList = (List)this.L$3;
                                iconResult = (String)this.L$2;
                                bannerResult = (String)this.L$1;
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v13 = $result;
                                break block41;
                            }
                        }
                        if (!(result instanceof ResultOf.Success)) break block42;
                        this.L$0 = publishedEvent;
                        this.L$1 = bannerResult;
                        this.L$2 = iconResult;
                        this.L$3 = socialList;
                        this.L$4 = newAccount;
                        this.L$5 = newPublishedEvent;
                        this.L$6 = result;
                        this.label = 9;
                        v14 = this.$onComplete.invoke((Object)newAccount, (Object)this);
                        if (v14 == var12_2) {
                            return var12_2;
                        }
                        break block41;
                        {
                            case 9: {
                                result = (ResultOf)this.L$6;
                                newPublishedEvent = (PublishedEvent)this.L$5;
                                newAccount = (Account)this.L$4;
                                socialList = (List)this.L$3;
                                iconResult = (String)this.L$2;
                                bannerResult = (String)this.L$1;
                                publishedEvent = (PublishedEvent)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v14 = $result;
                                break block41;
                            }
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void addFestival(@NotNull AccountUiState.AddNewAccount uiState, @NotNull FestivalCreationData festival) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)festival, (String)"festival");
        this._accountUiStateFlow.setValue((Object)AccountUiState.AddNewAccount.copy$default(uiState, null, ProcessingState.Processing.INSTANCE, null, null, null, 29, null));
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(festival, this, uiState, null){
            Object L$0;
            int label;
            final /* synthetic */ FestivalCreationData $festival;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.AddNewAccount $uiState;
            {
                this.$festival = $festival;
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = AccountViewModel.access$getUser$p(this.this$0);
                        Intrinsics.checkNotNull((Object)v0);
                        account = this.$festival.toAccount(v0.getUserId());
                        this.L$0 = account;
                        this.label = 1;
                        v1 = AccountViewModel.access$getAccountRepo$p(this.this$0).addNewAccount(account, this.$festival.toYearData(((EventReference)CollectionsKt.first(account.getEventList())).getEventId()), (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        account = (Account)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        result = (ResultOf)v1;
                        if (result instanceof ResultOf.Failure) {
                            AccountViewModel.access$getLogger$p(this.this$0).e("addFestival Error", ((ResultOf.Failure)result).getException());
                            AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                            AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.AddNewAccount.copy$default(this.$uiState, null, ProcessingState.NotProcessing.INSTANCE, null, null, null, 29, null));
                        } else if (result instanceof ResultOf.Success) {
                            $this$invokeSuspend_u24lambda_u240 = var5_5 /* !! */  = CollectionsKt.toMutableList((Collection)this.$uiState.getAccountList());
                            $i$a$-apply-AccountViewModel$addFestival$1$newAccountList$1 = false;
                            $this$invokeSuspend_u24lambda_u240.add(account);
                            var5_5 /* !! */  = var5_5 /* !! */ ;
                            $i$f$sortedBy = false;
                            newAccountList = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    Account it = (Account)a;
                                    boolean bl = false;
                                    String string2 = it.getAccountName().toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                                    it = (Account)b;
                                    Comparable comparable = (Comparable)((Object)string2);
                                    bl = false;
                                    String string3 = it.getAccountName().toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string3)));
                                }
                            });
                            AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)new AccountUiState.AccountOpened(account, newAccountList, AccountViewModel.access$getAppMode$p(this.this$0), AccountViewModel.access$isMenuOpenedOnce$p(this.this$0)));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void addEditEvent(@NotNull AddEditEventType uiState, @NotNull FestivalCreationData festival) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)festival, (String)"festival");
        AddEditEventType addEditEventType = uiState;
        if (addEditEventType instanceof AccountUiState.AddNewEvent) {
            this.addEvent((AccountUiState.AddNewEvent)uiState, festival);
        } else if (addEditEventType instanceof AccountUiState.EditEvent) {
            this.updateEvent((AccountUiState.EditEvent)uiState, festival);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addEvent(AccountUiState.AddNewEvent uiState, FestivalCreationData festival) {
        void $this$addEvent_u24lambda_u242;
        List list;
        this._accountUiStateFlow.setValue((Object)AccountUiState.AddNewEvent.copy$default(uiState, null, null, null, null, ProcessingState.Processing.INSTANCE, null, null, 111, null));
        YearData newYearData = festival.toYearData(null);
        List list2 = list = CollectionsKt.toMutableList((Collection)uiState.getLoadedAccount().getEventList());
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Account account = uiState.getLoadedAccount();
        boolean bl = false;
        $this$addEvent_u24lambda_u242.add(new EventReference(newYearData.getEventId(), (LocalDateTime)CollectionsKt.first(newYearData.getDateList()), (LocalDateTime)CollectionsKt.last(newYearData.getDateList()), newYearData.getZoneId(), false));
        Unit unit = Unit.INSTANCE;
        Account updatedAccount2 = Account.copy$default(account, string4, string3, string2, list, null, null, null, null, null, null, false, 2039, null);
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, updatedAccount2, newYearData, uiState, null){
            Object L$0;
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ Account $updatedAccount;
            final /* synthetic */ YearData $newYearData;
            final /* synthetic */ AccountUiState.AddNewEvent $uiState;
            {
                this.this$0 = $receiver;
                this.$updatedAccount = $updatedAccount;
                this.$newYearData = $newYearData;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block9: {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = AccountViewModel.access$getAccountRepo$p(this.this$0).addEventToAccount(this.$updatedAccount, this.$newYearData, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((result = (ResultOf)v0) instanceof ResultOf.Failure) {
                                AccountViewModel.access$getLogger$p(this.this$0).e("addEvent Error", ((ResultOf.Failure)result).getException());
                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                                AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.AddNewEvent.copy$default(this.$uiState, null, null, null, null, ProcessingState.NotProcessing.INSTANCE, null, null, 111, null));
                                System.out.println((Object)"Error Adding Event!");
                            } else {
                                if (!(result instanceof ResultOf.Success)) break;
                                this.L$0 = result;
                                this.label = 2;
                                v1 = AccountViewModel.access$updateOpenedAccountOrReloadList(this.this$0, this.$updatedAccount, this.$uiState.getAccountList(), (Continuation)this);
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                            }
                            break block9;
                        }
                        case 2: {
                            result = (ResultOf)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            break block9;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void updateEvent(AccountUiState.EditEvent uiState, FestivalCreationData festival) {
        int eventIndex;
        EventReference eventReference;
        YearData yearData;
        block7: {
            int n;
            Object element$iv2;
            block6: {
                yearData = festival.updateYearData(uiState.getYearData());
                Iterable $this$first$iv = uiState.getLoadedAccount().getEventList();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    EventReference it = (EventReference)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEventId(), (Object)yearData.getEventId())) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            EventReference oldEventReference = (EventReference)element$iv2;
            eventReference = festival.updateEventReference(oldEventReference, uiState.getYearData());
            List<EventReference> $this$indexOfFirst$iv = uiState.getLoadedAccount().getEventList();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<EventReference> bl = $this$indexOfFirst$iv.iterator();
            while (bl.hasNext()) {
                EventReference item$iv;
                EventReference it = item$iv = bl.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getEventId(), (Object)yearData.getEventId())) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = eventIndex = -1;
        }
        if (uiState.getLastEvent() != null && uiState.getEarliestEvent() != null) {
            LocalDateTime start = (LocalDateTime)CollectionsKt.first(yearData.getDateList());
            LocalDateTime end = LocalDateTimeExtensionsKt.plus$default((LocalDateTime)CollectionsKt.last(yearData.getDateList()), 24, DateTimeUnit.Companion.getHOUR(), null, 4, null);
            ClosedRange festivalDateRange = RangesKt.rangeTo((Comparable)((Comparable)start), (Comparable)((Comparable)end));
            boolean isLastEventInRange = festivalDateRange.contains((Comparable)uiState.getLastEvent());
            boolean isFirstEventInRange = festivalDateRange.contains((Comparable)uiState.getEarliestEvent());
            System.out.println((Object)("isFirstEventInRange: " + isFirstEventInRange + "   isLastEventInRange: " + isLastEventInRange));
            if (!isLastEventInRange || !isFirstEventInRange) {
                this._accountUiStateFlow.setValue((Object)AccountUiState.EditEvent.copy$default(uiState, null, null, null, null, null, null, null, null, null, null, null, null, null, true, 8191, null));
                return;
            }
        }
        if (eventIndex == -1) {
            this.logger.e("UpdateEvent Error", new IllegalStateException("Event Not Found In Account List"));
            this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_unrecoverable_message(Res.string.INSTANCE), null, 2, null));
            BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AccountViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.loadUserAccounts((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        Account updatedAccount2 = Account.copy$default(uiState.getLoadedAccount(), null, null, null, ListExtensionsKt.replaceAt(CollectionsKt.toMutableList((Collection)uiState.getLoadedAccount().getEventList()), eventIndex, eventReference), null, null, null, null, null, null, false, 2039, null);
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditEvent.copy$default(uiState, null, null, null, null, ProcessingState.Processing.INSTANCE, null, null, null, null, null, null, null, null, false, 16367, null));
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uiState, yearData, updatedAccount2, eventReference, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int I$0;
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditEvent $uiState;
            final /* synthetic */ YearData $yearData;
            final /* synthetic */ Account $updatedAccount;
            final /* synthetic */ EventReference $eventReference;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                this.$yearData = $yearData;
                this.$updatedAccount = $updatedAccount;
                this.$eventReference = $eventReference;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block14: {
                    block13: {
                        block15: {
                            var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = AccountViewModel.access$getDraftArtistRepositoryApi$p(this.this$0).getRemoteCurrentVersionState((ContentSource)ContentSource.Draft.INSTANCE, this.$uiState.getLoadedAccount().getAccountId(), this.$yearData.getEventId(), (Continuation<? super ResultOf<CurrentVersionState>>)((Continuation)this));
                                    if (v0 == var19_2) {
                                        return var19_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    if ((var3_5 = (currentVersionState = (ResultOf)v0)) instanceof ResultOf.Failure) {
                                        AccountViewModel.access$getLogger$p(this.this$0).e("updateEvent Error", ((ResultOf.Failure)currentVersionState).getException());
                                        AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                                        return Unit.INSTANCE;
                                    }
                                    if (!(var3_5 instanceof ResultOf.Success)) break block13;
                                    remoteCurrentVersionState = (CurrentVersionState)((ResultOf.Success)currentVersionState).getResult();
                                    nextVersion = remoteCurrentVersionState.getYearDataVersion() + 1L;
                                    nextCurrentVersionState = CurrentVersionState.copy$default(remoteCurrentVersionState, null, null, null, 0L, null, nextVersion, 31, null);
                                    nextYearData = YearData.copy$default(this.$yearData, null, 0, null, null, null, null, null, null, null, null, nextVersion, null, false, 7167, null);
                                    AccountViewModel.access$isProcessingYearData$volatile$FU().getAndSet(this.this$0, 1);
                                    this.L$0 = currentVersionState;
                                    this.L$1 = remoteCurrentVersionState;
                                    this.L$2 = nextCurrentVersionState;
                                    this.L$3 = nextYearData;
                                    this.J$0 = nextVersion;
                                    this.label = 2;
                                    v1 = AccountViewModel.access$getAccountRepo$p(this.this$0).updateEvent(nextCurrentVersionState, this.$updatedAccount, nextYearData, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                                    if (v1 == var19_2) {
                                        return var19_2;
                                    }
                                    ** GOTO lbl42
                                }
                                case 2: {
                                    nextVersion = this.J$0;
                                    nextYearData = (YearData)this.L$3;
                                    nextCurrentVersionState = (CurrentVersionState)this.L$2;
                                    remoteCurrentVersionState = (CurrentVersionState)this.L$1;
                                    currentVersionState = (ResultOf)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl42:
                                    // 2 sources

                                    if (!((result = (ResultOf)v1) instanceof ResultOf.Failure)) ** GOTO lbl49
                                    AccountViewModel.access$isProcessingYearData$volatile$FU().getAndSet(this.this$0, 0);
                                    AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                                    AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditEvent.copy$default(this.$uiState, null, null, null, null, ProcessingState.NotProcessing.INSTANCE, null, null, null, null, null, null, null, null, false, 16367, null));
                                    AccountViewModel.access$getLogger$p(this.this$0).e("updateEvent Error", ((ResultOf.Failure)result).getException());
                                    break block14;
lbl49:
                                    // 1 sources

                                    if (!(result instanceof ResultOf.Success)) break block15;
                                    this.L$0 = currentVersionState;
                                    this.L$1 = remoteCurrentVersionState;
                                    this.L$2 = nextCurrentVersionState;
                                    this.L$3 = nextYearData;
                                    this.L$4 = result;
                                    this.J$0 = nextVersion;
                                    this.label = 3;
                                    v2 = AccountViewModel.access$getDraftArtistRepositoryApi$p(this.this$0).updateCurrentVersionState(nextCurrentVersionState, (Continuation<? super Unit>)((Continuation)this));
                                    if (v2 == var19_2) {
                                        return var19_2;
                                    }
                                    ** GOTO lbl70
                                }
                                case 3: {
                                    nextVersion = this.J$0;
                                    result = (ResultOf)this.L$4;
                                    nextYearData = (YearData)this.L$3;
                                    nextCurrentVersionState = (CurrentVersionState)this.L$2;
                                    remoteCurrentVersionState = (CurrentVersionState)this.L$1;
                                    currentVersionState = (ResultOf)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl70:
                                    // 2 sources

                                    AccountViewModel.access$isProcessingYearData$volatile$FU().getAndSet(this.this$0, 0);
                                    var11_16 = this.$uiState.getAccountList();
                                    var12_17 = this.$updatedAccount;
                                    $i$f$indexOfFirst = false;
                                    index$iv = 0;
                                    for (E item$iv : $this$indexOfFirst$iv) {
                                        it = (Account)item$iv;
                                        $i$a$-indexOfFirst-AccountViewModel$updateEvent$1$indexOfAccount$1 = false;
                                        if (!Intrinsics.areEqual((Object)it.getAccountId(), (Object)var12_17.getAccountId())) ** GOTO lbl82
                                        v3 = index$iv;
                                        ** GOTO lbl85
lbl82:
                                        // 1 sources

                                        ++index$iv;
                                    }
                                    v3 = indexOfAccount = -1;
lbl85:
                                    // 2 sources

                                    if (indexOfAccount != -1) break;
                                    this.L$0 = currentVersionState;
                                    this.L$1 = remoteCurrentVersionState;
                                    this.L$2 = nextCurrentVersionState;
                                    this.L$3 = nextYearData;
                                    this.L$4 = result;
                                    this.J$0 = nextVersion;
                                    this.I$0 = indexOfAccount;
                                    this.label = 4;
                                    v4 = this.this$0.loadUserAccounts((Continuation<? super Unit>)((Continuation)this));
                                    if (v4 == var19_2) {
                                        return var19_2;
                                    }
                                    break block14;
                                }
                                case 4: {
                                    indexOfAccount = this.I$0;
                                    nextVersion = this.J$0;
                                    result = (ResultOf)this.L$4;
                                    nextYearData = (YearData)this.L$3;
                                    nextCurrentVersionState = (CurrentVersionState)this.L$2;
                                    remoteCurrentVersionState = (CurrentVersionState)this.L$1;
                                    currentVersionState = (ResultOf)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v4 = $result;
                                    break block14;
                                }
                            }
                            var11_16 = ListExtensionsKt.replaceAt(CollectionsKt.toMutableList((Collection)this.$uiState.getAccountList()), indexOfAccount, this.$updatedAccount);
                            this.this$0.returnToOverview(AccountUiState.EditEvent.copy$default(this.$uiState, this.$updatedAccount, var11_16, null, null, null, this.$eventReference, nextYearData, null, null, null, null, null, null, false, 16284, null));
                            break block14;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void addNewAccount(@NotNull AccountManagement accountManagement, @Nullable Account loadedAccount) {
        Intrinsics.checkNotNullParameter((Object)accountManagement, (String)"accountManagement");
        this._accountUiStateFlow.setValue((Object)new AccountUiState.AddNewAccount(accountManagement.getAccountList(), ProcessingState.NotProcessing.INSTANCE, loadedAccount, this.appMode, null, 16, null));
    }

    public final void addNewEvent(@NotNull Account account, @NotNull List<Account> accountList) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter(accountList, (String)"accountList");
        EventReference lastEvent = (EventReference)CollectionsKt.lastOrNull(account.getEventList());
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(lastEvent, this, account, accountList, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ EventReference $lastEvent;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ Account $account;
            final /* synthetic */ List<Account> $accountList;
            {
                this.$lastEvent = $lastEvent;
                this.this$0 = $receiver;
                this.$account = $account;
                this.$accountList = $accountList;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block8: {
                    var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.$lastEvent == null) break;
                            var14_3 = this.$lastEvent.getEventId();
                            var13_4 = this.$account.getAccountId();
                            var12_5 = ContentSource.Draft.INSTANCE;
                            var11_6 = AccountViewModel.access$getAccountRepo$p(this.this$0);
                            this.L$0 = var11_6;
                            this.L$1 = var12_5;
                            this.L$2 = var13_4;
                            this.L$3 = var14_3;
                            this.label = 1;
                            v0 = AccountViewModel.access$getDraftArtistRepositoryApi$p(this.this$0).getCurrentVersionState((ContentSource)ContentSource.Draft.INSTANCE, this.$lastEvent.getEventId(), (Continuation<? super CurrentVersionState>)((Continuation)this));
                            if (v0 == var16_2) {
                                return var16_2;
                            }
                            ** GOTO lbl26
                        }
                        case 1: {
                            var14_3 = (String)this.L$3;
                            var13_4 = (String)this.L$2;
                            var12_5 = (ContentSource)this.L$1;
                            var11_6 = (AccountRepositoryApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl26:
                            // 2 sources

                            var15_7 = v0;
                            this.L$0 = null;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.L$3 = null;
                            this.label = 2;
                            v1 = var11_6.getRemoteYearData(var12_5, var13_4, var14_3, (CurrentVersionState)var15_7, (Continuation<? super ResultOf<YearData>>)((Continuation)this));
                            if (v1 == var16_2) {
                                return var16_2;
                            }
                            ** GOTO lbl39
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl39:
                            // 2 sources

                            if (!((var4_9 = (lastEventYearData = (ResultOf)v1)) instanceof ResultOf.Failure)) ** GOTO lbl42
                            v2 = new FestivalCreationData(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
                            break block8;
lbl42:
                            // 1 sources

                            if (!(var4_9 instanceof ResultOf.Success)) ** GOTO lbl54
                            var5_10 = this.$account.getAccountName();
                            var6_11 = this.$account.getWebsiteUrl();
                            v3 = (LocalDateTime)CollectionsKt.firstOrNull(((YearData)((ResultOf.Success)lastEventYearData).getResult()).getDateList());
                            if (v3 == null || (v3 = v3.getTime()) == null) {
                                v3 = new LocalTime(0, 0, 0, 0);
                            }
                            var7_12 = v3;
                            var8_13 = ((YearData)((ResultOf.Success)lastEventYearData).getResult()).getStageList();
                            var9_14 = this.$lastEvent.getTimeZoneId().toString();
                            var10_15 = ((YearData)((ResultOf.Success)lastEventYearData).getResult()).getTagColorList();
                            v2 = new FestivalCreationData(var5_10, var6_11, null, null, null, null, null, (LocalTime)var7_12, var9_14, var8_13, var10_15, 124, null);
                            break block8;
lbl54:
                            // 1 sources

                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    v2 = new FestivalCreationData(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
                }
                festivalData = v2;
                AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)new AccountUiState.AddNewEvent(this.$account, this.$accountList, festivalData, String2_commonMainKt.getEvent_add_title(Res.string.INSTANCE), ProcessingState.NotProcessing.INSTANCE, null, AccountViewModel.access$getAppMode$p(this.this$0), 32, null));
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void eventSelected(@NotNull Account account, @NotNull List<Account> accountList, @NotNull EventReference eventReference) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter(accountList, (String)"accountList");
        Intrinsics.checkNotNullParameter((Object)eventReference, (String)"eventReference");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, account, eventReference, accountList, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ Account $account;
            final /* synthetic */ EventReference $eventReference;
            final /* synthetic */ List<Account> $accountList;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                this.$eventReference = $eventReference;
                this.$accountList = $accountList;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var7_3 = this.$eventReference.getEventId();
                        var6_4 = this.$account.getAccountId();
                        var5_5 = ContentSource.Draft.INSTANCE;
                        var4_6 = AccountViewModel.access$getAccountRepo$p(this.this$0);
                        this.L$0 = var4_6;
                        this.L$1 = var5_5;
                        this.L$2 = var6_4;
                        this.L$3 = var7_3;
                        this.label = 1;
                        v0 = AccountViewModel.access$getDraftArtistRepositoryApi$p(this.this$0).getCurrentVersionState((ContentSource)ContentSource.Draft.INSTANCE, this.$eventReference.getEventId(), (Continuation<? super CurrentVersionState>)((Continuation)this));
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        var7_3 = (String)this.L$3;
                        var6_4 = (String)this.L$2;
                        var5_5 = (ContentSource)this.L$1;
                        var4_6 = (AccountRepositoryApi)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        var8_7 = v0;
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 2;
                        v1 = var4_6.getRemoteYearData(var5_5, var6_4, var7_3, (CurrentVersionState)var8_7, (Continuation<? super ResultOf<YearData>>)((Continuation)this));
                        if (v1 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl38
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl38:
                        // 2 sources

                        if ((var3_9 = (yearDataResult = (ResultOf)v1)) instanceof ResultOf.Failure) {
                            if (((ResultOf.Failure)yearDataResult).getException() instanceof NetworkException) {
                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_network_generic_message(Res.string.INSTANCE), null, 2, null));
                            } else {
                                AccountViewModel.access$getLogger$p(this.this$0).e("eventSelected error", ((ResultOf.Failure)yearDataResult).getException());
                                AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                            }
                            return Unit.INSTANCE;
                        }
                        if (!(var3_9 instanceof ResultOf.Success)) {
                            throw new NoWhenBranchMatchedException();
                        }
                        this.this$0.listenForYearDataUpdates(this.$accountList, this.$account.getAccountId(), (YearData)((ResultOf.Success)yearDataResult).getResult());
                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)new AccountUiState.EventLoaded((YearData)((ResultOf.Success)yearDataResult).getResult(), this.$eventReference, this.$account, this.$accountList, this.this$0.isEventPublished(this.$account, ((YearData)((ResultOf.Success)yearDataResult).getResult()).getEventId()), AccountViewModel.access$getAppMode$p(this.this$0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void invalidDateDialogDismissed(@NotNull AccountUiState.EditEvent uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditEvent.copy$default(uiState, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 8191, null));
    }

    public final void saveMap(@NotNull AccountUiState.EditMap uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        if (!(uiState.getUpdatedMap() instanceof ImageType.URL)) {
            this._accountUiStateFlow.setValue((Object)AccountUiState.EditMap.copy$default(uiState, null, null, null, ProcessingState.Processing.INSTANCE, null, null, null, 119, null));
        }
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uiState, this, null){
            int label;
            final /* synthetic */ AccountUiState.EditMap $uiState;
            final /* synthetic */ AccountViewModel this$0;
            {
                this.$uiState = $uiState;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                block8: {
                    ImageType imageType;
                    block9: {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                imageType = this.$uiState.getUpdatedMap();
                                if (!(imageType instanceof ImageType.None)) break;
                                this.label = 1;
                                Object object2 = AccountViewModel.access$clearMap(this.this$0, this.$uiState, (Continuation)this);
                                if (object2 == object) {
                                    return object;
                                }
                                break block8;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                break block8;
                            }
                        }
                        if (!(imageType instanceof ImageType.File)) break block9;
                        this.label = 2;
                        Object object3 = AccountViewModel.access$uploadMap(this.this$0, this.$uiState, (ImageType.File)this.$uiState.getUpdatedMap(), (Continuation)this);
                        if (object3 == object) {
                            return object;
                        }
                        break block8;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                break block8;
                            }
                        }
                    }
                    if (imageType instanceof ImageType.URL) {
                        AccountViewModel.access$get_errorMessageStateFlow$p(this.this$0).setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_save_map_image_already_uploaded_message(Res.string.INSTANCE), null, 2, null));
                        AccountViewModel.access$getLogger$p(this.this$0).e("Error: Entered Save Map With ImageType URL");
                        return Unit.INSTANCE;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Object clearMap(AccountUiState.EditMap uiState, Continuation<? super Unit> $completion) {
        Object object = this.updateYearData(uiState.getLoadedAccount(), YearData.copy$default(uiState.getYearData(), null, 0, null, null, null, null, null, null, null, null, 0L, null, false, 8159, null), (Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this, uiState, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditMap $uiState;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ProcessingState processingState = (ProcessingState)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditMap.copy$default(this.$uiState, null, null, null, (ProcessingState)it, null, null, null, 119, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Function2<? super Exception, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Exception exception = (Exception)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void error;
                        ResultKt.throwOnFailure((Object)$result);
                        AccountViewModel.access$getLogger$p(this.this$0).e("saveMap errror", (Exception)error);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Function2<? super YearData, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<YearData, Continuation<? super Unit>, Object>(this, uiState, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditMap $uiState;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                YearData yearData = (YearData)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.returnToOverview(AccountUiState.EditMap.copy$default(this.$uiState, (YearData)it, null, null, null, null, null, null, 126, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(YearData p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object uploadMap(AccountUiState.EditMap uiState, ImageType.File newMap, Continuation<? super Unit> $completion) {
        block9: {
            if (!($completion instanceof uploadMap.1)) ** GOTO lbl-1000
            var6_4 = $completion;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccountViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AccountViewModel.access$uploadMap(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = uiState;
                    $continuation.L$1 = newMap;
                    $continuation.label = 1;
                    v0 = this.imageUploader.uploadImage(newMap, uiState.getLoadedAccount().getAccountId(), uiState.getYearData().getEventId(), (Continuation<? super ResultOf<String>>)$continuation);
                    if (v0 == var7_6) {
                        return var7_6;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    newMap = (ImageType.File)$continuation.L$1;
                    uiState = (AccountUiState.EditMap)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    if (!((urlResult = (ResultOf)v0) instanceof ResultOf.Failure)) ** GOTO lbl29
                    this.logger.e("saveMap upload image error", ((ResultOf.Failure)urlResult).getException());
                    this._accountUiStateFlow.setValue((Object)AccountUiState.EditMap.copy$default(uiState, null, null, null, ProcessingState.NotProcessing.INSTANCE, null, null, null, 119, null));
                    this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_uploading_image_message(Res.string.INSTANCE), this.getImageUploadErrorCode(((ResultOf.Failure)urlResult).getException())));
                    break block9;
lbl29:
                    // 1 sources

                    if (!(urlResult instanceof ResultOf.Success)) break;
                    $continuation.L$0 = uiState;
                    $continuation.L$1 = newMap;
                    $continuation.L$2 = urlResult;
                    $continuation.label = 2;
                    v1 = this.updateYearData(uiState.getLoadedAccount(), YearData.copy$default(uiState.getYearData(), null, 0, null, null, null, (String)((ResultOf.Success)urlResult).getResult(), null, null, null, null, 0L, null, false, 8159, null), (Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this, uiState, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ AccountViewModel this$0;
                        final /* synthetic */ AccountUiState.EditMap $uiState;
                        {
                            this.this$0 = $receiver;
                            this.$uiState = $uiState;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            ProcessingState processingState = (ProcessingState)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void it;
                                    ResultKt.throwOnFailure((Object)$result);
                                    AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditMap.copy$default(this.$uiState, null, null, null, (ProcessingState)it, null, null, null, 119, null));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Function2<? super Exception, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ AccountViewModel this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            Exception exception = (Exception)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void error;
                                    ResultKt.throwOnFailure((Object)$result);
                                    AccountViewModel.access$getLogger$p(this.this$0).e("saveMap errror", (Exception)error);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Function2<? super YearData, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<YearData, Continuation<? super Unit>, Object>(this, uiState, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ AccountViewModel this$0;
                        final /* synthetic */ AccountUiState.EditMap $uiState;
                        {
                            this.this$0 = $receiver;
                            this.$uiState = $uiState;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            YearData yearData = (YearData)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void it;
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.this$0.returnToOverview(AccountUiState.EditMap.copy$default(this.$uiState, (YearData)it, null, null, null, null, null, null, 126, null));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(YearData p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation<? super Unit>)$continuation);
                    if (v1 == var7_6) {
                        return var7_6;
                    }
                    ** GOTO lbl44
                }
                case 2: {
                    urlResult = (ResultOf)$continuation.L$2;
                    newMap = (ImageType.File)$continuation.L$1;
                    uiState = (AccountUiState.EditMap)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateYearData(Account account, YearData yearData, Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object> onProcessingChanged, Function2<? super Exception, ? super Continuation<? super Unit>, ? extends Object> onError, Function2<? super YearData, ? super Continuation<? super Unit>, ? extends Object> onComplete, Continuation<? super Unit> $completion) {
        block17: {
            if (!($completion instanceof updateYearData.1)) ** GOTO lbl-1000
            var13_7 = $completion;
            if ((var13_7.label & -2147483648) != 0) {
                var13_7.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AccountViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AccountViewModel.access$updateYearData(this.this$0, null, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = account;
                    $continuation.L$1 = yearData;
                    $continuation.L$2 = onProcessingChanged;
                    $continuation.L$3 = onError;
                    $continuation.L$4 = onComplete;
                    $continuation.label = 1;
                    v0 = this.draftArtistRepositoryApi.getRemoteCurrentVersionState((ContentSource)ContentSource.Draft.INSTANCE, account.getAccountId(), yearData.getEventId(), (Continuation<? super ResultOf<CurrentVersionState>>)$continuation);
                    if (v0 == var14_9) {
                        return var14_9;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    onComplete = (Function2)$continuation.L$4;
                    onError = (Function2)$continuation.L$3;
                    onProcessingChanged = (Function2)$continuation.L$2;
                    yearData = (YearData)$continuation.L$1;
                    account = (Account)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    if (!((currentVersionState = (ResultOf)v0) instanceof ResultOf.Failure)) break;
                    this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                    $continuation.L$0 = account;
                    $continuation.L$1 = yearData;
                    $continuation.L$2 = onProcessingChanged;
                    $continuation.L$3 = onError;
                    $continuation.L$4 = onComplete;
                    $continuation.L$5 = currentVersionState;
                    $continuation.label = 2;
                    v1 = onProcessingChanged.invoke((Object)ProcessingState.NotProcessing.INSTANCE, (Object)$continuation);
                    if (v1 == var14_9) {
                        return var14_9;
                    }
                    ** GOTO lbl52
                }
                case 2: {
                    currentVersionState = (ResultOf)$continuation.L$5;
                    onComplete = (Function2)$continuation.L$4;
                    onError = (Function2)$continuation.L$3;
                    onProcessingChanged = (Function2)$continuation.L$2;
                    yearData = (YearData)$continuation.L$1;
                    account = (Account)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl52:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            Intrinsics.checkNotNull((Object)currentVersionState, (String)"null cannot be cast to non-null type data.account.ResultOf.Success<data.artist.CurrentVersionState>");
            nextVersion = ((CurrentVersionState)((ResultOf.Success)currentVersionState).getResult()).getYearDataVersion() + 1L;
            AccountViewModel.isProcessingYearData$volatile$FU().getAndSet(this, 1);
            $continuation.L$0 = account;
            $continuation.L$1 = yearData;
            $continuation.L$2 = onProcessingChanged;
            $continuation.L$3 = onError;
            $continuation.L$4 = onComplete;
            $continuation.L$5 = currentVersionState;
            $continuation.J$0 = nextVersion;
            $continuation.label = 3;
            v2 = this.accountRepo.updateYearData(ContentSource.Draft.INSTANCE, account, YearData.copy$default(yearData, null, 0, null, null, null, null, null, null, null, null, nextVersion, null, false, 7167, null), CurrentVersionState.copy$default((CurrentVersionState)((ResultOf.Success)currentVersionState).getResult(), null, null, null, 0L, null, nextVersion, 31, null), (Continuation<? super ResultOf<Unit>>)$continuation);
            if (v2 == var14_9) {
                return var14_9;
            }
            ** GOTO lbl79
            {
                case 3: {
                    nextVersion = $continuation.J$0;
                    currentVersionState = (ResultOf)$continuation.L$5;
                    onComplete = (Function2)$continuation.L$4;
                    onError = (Function2)$continuation.L$3;
                    onProcessingChanged = (Function2)$continuation.L$2;
                    yearData = (YearData)$continuation.L$1;
                    account = (Account)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl79:
                    // 2 sources

                    updateResult = (ResultOf)v2;
                    AccountViewModel.isProcessingYearData$volatile$FU().getAndSet(this, 0);
                    var11_20 = updateResult;
                    if (!(var11_20 instanceof ResultOf.Failure)) break;
                    $continuation.L$0 = account;
                    $continuation.L$1 = yearData;
                    $continuation.L$2 = onProcessingChanged;
                    $continuation.L$3 = onError;
                    $continuation.L$4 = onComplete;
                    $continuation.L$5 = currentVersionState;
                    $continuation.L$6 = updateResult;
                    $continuation.J$0 = nextVersion;
                    $continuation.label = 4;
                    v3 = onError.invoke((Object)((ResultOf.Failure)updateResult).getException(), (Object)$continuation);
                    if (v3 == var14_9) {
                        return var14_9;
                    }
                    ** GOTO lbl108
                }
                case 4: {
                    nextVersion = $continuation.J$0;
                    updateResult = (ResultOf)$continuation.L$6;
                    currentVersionState = (ResultOf)$continuation.L$5;
                    onComplete = (Function2)$continuation.L$4;
                    onError = (Function2)$continuation.L$3;
                    onProcessingChanged = (Function2)$continuation.L$2;
                    yearData = (YearData)$continuation.L$1;
                    account = (Account)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl108:
                    // 2 sources

                    this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_generic_message(Res.string.INSTANCE), null, 2, null));
                    $continuation.L$0 = account;
                    $continuation.L$1 = yearData;
                    $continuation.L$2 = onProcessingChanged;
                    $continuation.L$3 = onError;
                    $continuation.L$4 = onComplete;
                    $continuation.L$5 = currentVersionState;
                    $continuation.L$6 = updateResult;
                    $continuation.J$0 = nextVersion;
                    $continuation.label = 5;
                    v4 = onProcessingChanged.invoke((Object)ProcessingState.NotProcessing.INSTANCE, (Object)$continuation);
                    if (v4 == var14_9) {
                        return var14_9;
                    }
                    ** GOTO lbl133
                }
                case 5: {
                    nextVersion = $continuation.J$0;
                    updateResult = (ResultOf)$continuation.L$6;
                    currentVersionState = (ResultOf)$continuation.L$5;
                    onComplete = (Function2)$continuation.L$4;
                    onError = (Function2)$continuation.L$3;
                    onProcessingChanged = (Function2)$continuation.L$2;
                    yearData = (YearData)$continuation.L$1;
                    account = (Account)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl133:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            if (!(var11_20 instanceof ResultOf.Success)) break block17;
            $continuation.L$0 = account;
            $continuation.L$1 = yearData;
            $continuation.L$2 = onProcessingChanged;
            $continuation.L$3 = onError;
            $continuation.L$4 = onComplete;
            $continuation.L$5 = currentVersionState;
            $continuation.L$6 = updateResult;
            $continuation.J$0 = nextVersion;
            $continuation.label = 6;
            v5 = onComplete.invoke((Object)yearData, (Object)$continuation);
            if (v5 == var14_9) {
                return var14_9;
            }
            ** GOTO lbl159
            {
                case 6: {
                    nextVersion = $continuation.J$0;
                    updateResult = (ResultOf)$continuation.L$6;
                    currentVersionState = (ResultOf)$continuation.L$5;
                    onComplete = (Function2)$continuation.L$4;
                    onError = (Function2)$continuation.L$3;
                    onProcessingChanged = (Function2)$continuation.L$2;
                    yearData = (YearData)$continuation.L$1;
                    account = (Account)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl159:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
        }
        throw new NoWhenBranchMatchedException();
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    public final void saveFaq(@NotNull AccountUiState.EditFaq uiState, @NotNull List<Faq> newFaq) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter(newFaq, (String)"newFaq");
        if (Intrinsics.areEqual(newFaq, uiState.getYearData().getFaqList())) {
            this.logger.i("saveFaq - Nothing Changed, Aborting Save");
            this.returnToOverview(uiState);
            return;
        }
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditFaq.copy$default(uiState, null, null, null, null, ProcessingState.Processing.INSTANCE, null, null, 111, null));
        Iterable $this$filter$iv = newFaq;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Faq it = (Faq)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)it.getAnswer()) && !StringsKt.isBlank((CharSequence)it.getQuestion()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List faqListWithNoBlanks = (List)destination$iv$iv;
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uiState, (List<Faq>)faqListWithNoBlanks, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditFaq $uiState;
            final /* synthetic */ List<Faq> $faqListWithNoBlanks;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                this.$faqListWithNoBlanks = $faqListWithNoBlanks;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AccountViewModel.access$updateYearData(this.this$0, this.$uiState.getLoadedAccount(), YearData.copy$default(this.$uiState.getYearData(), null, 0, null, null, null, null, null, null, this.$faqListWithNoBlanks, null, 0L, null, false, 7935, null), (Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this.this$0, this.$uiState, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            final /* synthetic */ AccountUiState.EditFaq $uiState;
                            {
                                this.this$0 = $receiver;
                                this.$uiState = $uiState;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ProcessingState processingState = (ProcessingState)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditFaq.copy$default(this.$uiState, null, null, null, null, (ProcessingState)it, null, null, 111, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Exception exception = (Exception)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void error;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$getLogger$p(this.this$0).e("saveFaq error", (Exception)error);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<YearData, Continuation<? super Unit>, Object>(this.$uiState, this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountUiState.EditFaq $uiState;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.$uiState = $uiState;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                YearData yearData = (YearData)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountUiState.EditFaq updatedUiState = AccountUiState.EditFaq.copy$default(this.$uiState, (YearData)it, null, null, null, null, null, null, 126, null);
                                        this.this$0.returnToOverview(updatedUiState);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(YearData p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void saveDirections(@NotNull AccountUiState.EditDirections uiState, @Nullable Directions newDirections) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        if (Intrinsics.areEqual((Object)newDirections, (Object)uiState.getYearData().getDirections())) {
            this.logger.i("saveFaq - Nothing Changed, Aborting Save");
            this.returnToOverview(uiState);
            return;
        }
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditDirections.copy$default(uiState, null, null, null, null, ProcessingState.Processing.INSTANCE, null, null, 111, null));
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uiState, newDirections, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditDirections $uiState;
            final /* synthetic */ Directions $newDirections;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                this.$newDirections = $newDirections;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AccountViewModel.access$updateYearData(this.this$0, this.$uiState.getLoadedAccount(), YearData.copy$default(this.$uiState.getYearData(), null, 0, null, null, null, null, this.$newDirections, null, null, null, 0L, null, false, 8127, null), (Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this.this$0, this.$uiState, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            final /* synthetic */ AccountUiState.EditDirections $uiState;
                            {
                                this.this$0 = $receiver;
                                this.$uiState = $uiState;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ProcessingState processingState = (ProcessingState)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditDirections.copy$default(this.$uiState, null, null, null, null, (ProcessingState)it, null, null, 111, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Exception exception = (Exception)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void error;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$getLogger$p(this.this$0).e("saveDirections error", (Exception)error);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<YearData, Continuation<? super Unit>, Object>(this.$uiState, this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountUiState.EditDirections $uiState;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.$uiState = $uiState;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                YearData yearData = (YearData)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountUiState.EditDirections updatedUiState = AccountUiState.EditDirections.copy$default(this.$uiState, (YearData)it, null, null, null, null, null, null, 126, null);
                                        this.this$0.returnToOverview(updatedUiState);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(YearData p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void saveAbout(@NotNull AccountUiState.EditAbout uiState, @NotNull String about) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)about, (String)"about");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)about)).toString(), (Object)uiState.getYearData().getAbout())) {
            this.logger.i("saveAbout - Nothing Changed, Aborting Save");
            this.returnToOverview(uiState);
            return;
        }
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAbout.copy$default(uiState, null, null, null, null, ProcessingState.Processing.INSTANCE, null, null, 111, null));
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uiState, about, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditAbout $uiState;
            final /* synthetic */ String $about;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                this.$about = $about;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AccountViewModel.access$updateYearData(this.this$0, this.$uiState.getLoadedAccount(), YearData.copy$default(this.$uiState.getYearData(), null, 0, null, null, null, null, null, null, null, null, 0L, ((Object)StringsKt.trim((CharSequence)this.$about)).toString(), false, 6143, null), (Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this.this$0, this.$uiState, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            final /* synthetic */ AccountUiState.EditAbout $uiState;
                            {
                                this.this$0 = $receiver;
                                this.$uiState = $uiState;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ProcessingState processingState = (ProcessingState)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditAbout.copy$default(this.$uiState, null, null, null, null, (ProcessingState)it, null, null, 111, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Exception exception = (Exception)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void error;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$getLogger$p(this.this$0).e("saveAbout error", (Exception)error);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<YearData, Continuation<? super Unit>, Object>(this.$uiState, this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountUiState.EditAbout $uiState;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.$uiState = $uiState;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                YearData yearData = (YearData)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountUiState.EditAbout updatedUiState = AccountUiState.EditAbout.copy$default(this.$uiState, (YearData)it, null, null, null, null, null, null, 126, null);
                                        this.this$0.returnToOverview(updatedUiState);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(YearData p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveAdditionalContent(@NotNull AccountUiState.EditAdditionalContent uiState, @NotNull List<? extends AdditionalContentType> additionalContentList) {
        Object v2;
        List additionalContentCleaned;
        block14: {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
            Intrinsics.checkNotNullParameter(additionalContentList, (String)"additionalContentList");
            Iterable $this$map$iv = additionalContentList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                AdditionalContentType.AdditionalContent additionalContent;
                void additionalContent2;
                AdditionalContentType additionalContentType = (AdditionalContentType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                void var13_19 = additionalContent2;
                if (var13_19 instanceof AdditionalContentType.AdditionalContent) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = ((AdditionalContentType.AdditionalContent)additionalContent2).getAdditionalContent();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        AdditionalContentType.HeaderAndContent it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        AdditionalContentType.HeaderAndContent headerContent = (AdditionalContentType.HeaderAndContent)element$iv$iv;
                        boolean bl3 = false;
                        if ((StringsKt.isBlank((CharSequence)headerContent.getContent()) && StringsKt.isBlank((CharSequence)headerContent.getHeader()) ? null : headerContent) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List headerContentList = (List)destination$iv$iv2;
                    additionalContent = AdditionalContentType.AdditionalContent.copy$default((AdditionalContentType.AdditionalContent)additionalContent2, null, headerContentList, 1, null);
                } else if (var13_19 instanceof AdditionalContentType.AdditionalContentWeb) {
                    additionalContent = additionalContent2;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add((AdditionalContentType)additionalContent);
            }
            additionalContentCleaned = (List)destination$iv$iv;
            Iterable $this$map$iv2 = additionalContentCleaned;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                boolean bl;
                void additionalContent;
                AdditionalContentType bl5 = (AdditionalContentType)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl6 = false;
                void var14_21 = additionalContent;
                if (var14_21 instanceof AdditionalContentType.AdditionalContent) {
                    bl = ((AdditionalContentType.AdditionalContent)additionalContent).isContentEmpty();
                } else if (var14_21 instanceof AdditionalContentType.AdditionalContentWeb) {
                    bl = StringsKt.isBlank((CharSequence)((AdditionalContentType.AdditionalContentWeb)additionalContent).getUrl());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(bl);
            }
            List isValidContentInvalid = (List)destination$iv$iv3;
            if (isValidContentInvalid.contains(true)) {
                this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String0_commonMainKt.getAdditional_content_invalid_date_error(Res.string.INSTANCE), null, 2, null));
                return;
            }
            Iterable $this$firstOrNull$iv = additionalContentCleaned;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AdditionalContentType it = (AdditionalContentType)element$iv;
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)it.getScreenTitle())) continue;
                v2 = element$iv;
                break block14;
            }
            v2 = null;
        }
        if (v2 != null) {
            this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String0_commonMainKt.getAdditional_content_invalid_title_error(Res.string.INSTANCE), null, 2, null));
            return;
        }
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAdditionalContent.copy$default(uiState, null, null, null, null, ProcessingState.Processing.INSTANCE, null, false, 0, null, 495, null));
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uiState, (List<? extends AdditionalContentType>)additionalContentCleaned, null){
            int label;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ AccountUiState.EditAdditionalContent $uiState;
            final /* synthetic */ List<AdditionalContentType> $additionalContentCleaned;
            {
                this.this$0 = $receiver;
                this.$uiState = $uiState;
                this.$additionalContentCleaned = $additionalContentCleaned;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AccountViewModel.access$updateYearData(this.this$0, this.$uiState.getLoadedAccount(), YearData.copy$default(this.$uiState.getYearData(), null, 0, null, null, null, null, null, this.$additionalContentCleaned, null, null, 0L, null, false, 8063, null), (Function2)new Function2<ProcessingState, Continuation<? super Unit>, Object>(this.this$0, this.$uiState, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            final /* synthetic */ AccountUiState.EditAdditionalContent $uiState;
                            {
                                this.this$0 = $receiver;
                                this.$uiState = $uiState;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ProcessingState processingState = (ProcessingState)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$get_accountUiStateFlow$p(this.this$0).setValue((Object)AccountUiState.EditAdditionalContent.copy$default(this.$uiState, null, null, null, null, (ProcessingState)it, null, false, 0, null, 495, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ProcessingState p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Exception exception = (Exception)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void error;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountViewModel.access$getLogger$p(this.this$0).e("saveAdditionalContent error", (Exception)error);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Function2)new Function2<YearData, Continuation<? super Unit>, Object>(this.$uiState, this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ AccountUiState.EditAdditionalContent $uiState;
                            final /* synthetic */ AccountViewModel this$0;
                            {
                                this.$uiState = $uiState;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                YearData yearData = (YearData)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountUiState.EditAdditionalContent updatedUiState = AccountUiState.EditAdditionalContent.copy$default(this.$uiState, (YearData)it, null, null, null, null, null, false, 0, null, 510, null);
                                        this.this$0.returnToOverview(updatedUiState);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(YearData p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final boolean isEventPublished(@NotNull Account account, @NotNull String eventId) {
        boolean isPublished;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Iterable $this$firstOrNull$iv = account.getEventList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EventReference it = (EventReference)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEventId(), (Object)eventId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        EventReference eventReference = v0;
        boolean bl = isPublished = eventReference != null ? eventReference.isPublished() : false;
        if (!isPublished) {
            isPublished = this.settings.getBoolean("isPublished" + eventId, false);
        }
        return isPublished;
    }

    @NotNull
    public final String getImageUploadErrorCode(@NotNull Exception error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return error instanceof R2NetworkError ? "{" + ((R2NetworkError)error).getCode() : "";
    }

    public final void editEvent(@NotNull Account account, @NotNull YearData yearData, @NotNull EventReference eventReference, @NotNull List<Account> accountList) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        Intrinsics.checkNotNullParameter((Object)eventReference, (String)"eventReference");
        Intrinsics.checkNotNullParameter(accountList, (String)"accountList");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(account, eventReference, yearData, this, accountList, null){
            int label;
            final /* synthetic */ Account $account;
            final /* synthetic */ EventReference $eventReference;
            final /* synthetic */ YearData $yearData;
            final /* synthetic */ AccountViewModel this$0;
            final /* synthetic */ List<Account> $accountList;
            {
                this.$account = $account;
                this.$eventReference = $eventReference;
                this.$yearData = $yearData;
                this.this$0 = $receiver;
                this.$accountList = $accountList;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        FirestoreMapper<ArtistNetwork> it;
                        void $this$flatMapTo$iv$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        String string2 = this.$account.getAccountName();
                        String string3 = this.$account.getWebsiteUrl();
                        LocalTime localTime = this.$eventReference.getStartDate().getTime();
                        List<Stage> list = this.$yearData.getStageList();
                        Iterable<TagColor> iterable = this.$yearData.getTagColorList();
                        LocalDate localDate = this.$eventReference.getStartDate().getDate();
                        LocalDate localDate2 = this.$eventReference.getEndDate().getDate();
                        Object object = this.$eventReference.getTimeZoneId().toString();
                        FestivalCreationData festivalData = new FestivalCreationData(string2, string3, null, null, null, localDate, localDate2, localTime, (String)object, list, (List)iterable, 28, null);
                        List<Artist> artistList = AccountViewModel.access$getDraftArtistRepositoryApi$p(this.this$0).getArtistList(this.$account.getAccountId(), this.$yearData);
                        Iterable $this$flatMap$iv = artistList;
                        boolean $i$f$flatMap = false;
                        iterable = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            it = (Artist)element$iv$iv;
                            boolean bl = false;
                            Iterable list$iv$iv = ((Artist)it).getPerformanceList();
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        $this$flatMap$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        $this$flatMapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Performance)element$iv$iv;
                            boolean bl = false;
                            if (!(!((Performance)it).isDeleted())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List performancesWithoutDeletions = (List)destination$iv$iv;
                        Iterable $this$sortedBy$iv = performancesWithoutDeletions;
                        boolean $i$f$sortedBy = false;
                        List sortedPerformances = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Performance it = (Performance)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)it.getStartTime();
                                it = (Performance)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getStartTime()));
                            }
                        });
                        LocalDateTime earliestEvent = !((Collection)sortedPerformances).isEmpty() ? ((Performance)CollectionsKt.first((List)sortedPerformances)).getStartTime() : null;
                        LocalDateTime latestEvent = !((Collection)sortedPerformances).isEmpty() ? ((Performance)CollectionsKt.last((List)sortedPerformances)).getEndTime() : null;
                        localDate = String2_commonMainKt.getEvent_edit_title(Res.string.INSTANCE);
                        object = performancesWithoutDeletions;
                        MutableStateFlow mutableStateFlow = AccountViewModel.access$get_accountUiStateFlow$p(this.this$0);
                        boolean $i$f$map = false;
                        it = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            Performance performance = (Performance)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl = false;
                            collection.add(it2.getStageKey());
                        }
                        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                        object = ProcessingState.NotProcessing.INSTANCE;
                        AppMode appMode = AccountViewModel.access$getAppMode$p(this.this$0);
                        mutableStateFlow.setValue((Object)new AccountUiState.EditEvent(this.$account, this.$accountList, festivalData, (StringResource)localDate, (ProcessingState)object, this.$eventReference, this.$yearData, null, appMode, artistList, set, earliestEvent, latestEvent, false, 128, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void editAccount(@NotNull AccountUiState.AccountOpened uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAccount.Companion.fromUiState(uiState));
    }

    public final void editAccount(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAccountFromEvent.Companion.fromEventData(uiState));
    }

    public final void editMap(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditMap.Companion.fromEventData(uiState));
    }

    public final void editAdditionalContent(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAdditionalContent.Companion.fromEventData(uiState, this.settings.getBoolean("isShowFirstTimeAdditionalContentDialog", true)));
    }

    public final void exitAddNewEvent(@NotNull AccountUiState.AddNewEvent uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this.showAccountList(uiState.getAccountList());
    }

    public final void exitEditAccount(@NotNull AccountUiState.EditAccount uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)new AccountUiState.AccountOpened(uiState.getLoadedAccount(), uiState.getAccountList(), this.appMode, this.isMenuOpenedOnce));
    }

    public final void showAccountList(@NotNull List<Account> accountList) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter(accountList, (String)"accountList");
            Job job2 = this.eventListenerJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            String activeAccount = this.settings.getStringOrNull("activeManagementAccount");
            Iterable $this$firstOrNull$iv = accountList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Account it = (Account)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAccountId(), (Object)activeAccount)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Account foundAccount = v1;
        this._accountUiStateFlow.setValue((Object)(foundAccount == null ? (AccountUiState)new AccountUiState.AccountOpened((Account)CollectionsKt.first(accountList), accountList, this.appMode, this.isMenuOpenedOnce) : (AccountUiState)new AccountUiState.AccountOpened(foundAccount, accountList, this.appMode, this.isMenuOpenedOnce)));
    }

    public final void openLiveApp(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        boolean isPublished = this.isEventPublished(uiState.getLoadedAccount(), uiState.getYearData().getEventId());
        boolean isSeenSingleStageWarning = this.settings.getBoolean("isSeenSingleStageWarning", false);
        if (isPublished) {
            this._accountUiStateFlow.setValue((Object)AccountUiState.OpenLiveApp.Companion.fromEventData(uiState, isSeenSingleStageWarning));
        } else {
            this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_preview_live_app_not_published_error(Res.string.INSTANCE), uiState.getLoadedAccount().getAccountName()));
        }
    }

    public final void openDraftLineupPublishing(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.DraftLineupPublishing.Companion.fromEventData(uiState));
    }

    public final void messageGuests(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        if (this.isEventPublished(uiState.getLoadedAccount(), uiState.getYearData().getEventId())) {
            this._accountUiStateFlow.setValue((Object)AccountUiState.MessageGuests.Companion.fromEventData(uiState));
        } else {
            this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(String2_commonMainKt.getError_message_guests_app_not_published_error(Res.string.INSTANCE), uiState.getLoadedAccount().getAccountName()));
        }
    }

    public final void previewDraftApp(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        boolean isSeenSingleStageWarning = this.settings.getBoolean("isSeenSingleStageWarning", false);
        this._accountUiStateFlow.setValue((Object)AccountUiState.PreviewDraftApp.Companion.fromEventData(uiState, isSeenSingleStageWarning));
    }

    public final void returnToOverview(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EventLoaded.Companion.fromEventData(uiState, this.isEventPublished(uiState.getLoadedAccount(), uiState.getYearData().getEventId()), this.appMode));
    }

    public final void editFaq(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditFaq.Companion.fromEventData(uiState));
    }

    public final void openAccount(@NotNull AccountManagement uiState, @NotNull Account account) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.settings.putString("activeManagementAccount", account.getAccountId());
        this._accountUiStateFlow.setValue((Object)new AccountUiState.AccountOpened(account, uiState.getAccountList(), this.appMode, this.isMenuOpenedOnce));
    }

    public final void returnToAccountList(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)new AccountUiState.AccountOpened(uiState.getLoadedAccount(), uiState.getAccountList(), this.appMode, this.isMenuOpenedOnce));
    }

    public final void returnToAccountList(@NotNull AccountUiState.AccountOpened uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)new AccountUiState.AccountListLoaded(uiState.getAccountList(), uiState.getLoadedAccount(), this.appMode));
    }

    public final void editDirections(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditDirections.Companion.fromEventData(uiState));
    }

    public final void returnToLoadedAccount(@NotNull AccountUiState.AddNewAccount uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        if (uiState.getAccountList().isEmpty()) {
            this._accountUiStateFlow.setValue((Object)new AccountUiState.NoAccountFound(this.isShowDemoDialog, this.appMode));
        } else {
            Account account = uiState.getLoadedAccount();
            if (account == null) {
                account = (Account)CollectionsKt.first(uiState.getAccountList());
            }
            this._accountUiStateFlow.setValue((Object)new AccountUiState.AccountOpened(account, uiState.getAccountList(), this.appMode, this.isMenuOpenedOnce));
        }
    }

    public final void editAbout(@NotNull EventLoadedData uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAbout.Companion.fromEventData(uiState));
    }

    public final void clearSnackbarMessage() {
        this._errorMessageStateFlow.setValue(null);
    }

    public final void showError(@NotNull StringResource errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(errorMessage, null, 2, null));
    }

    public final void showError(@NotNull StringResource errorMessage, @NotNull String insertedText) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)insertedText, (String)"insertedText");
        this._errorMessageStateFlow.setValue((Object)new SnackbarMessage(errorMessage, insertedText));
    }

    public final void firstTimeAdditionalContentDialogSeen(@NotNull AccountUiState.EditAdditionalContent uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this.settings.putBoolean("isShowFirstTimeAdditionalContentDialog", false);
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAdditionalContent.copy$default(uiState, null, null, null, null, null, null, false, 0, null, 447, null));
    }

    public final void aboutTextChanged(@NotNull AccountUiState.EditAbout uiState, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAbout.copy$default(uiState, null, null, null, null, null, null, text, 63, null));
    }

    public final void updateDirections(@NotNull AccountUiState.EditDirections uiState, @NotNull Directions newDirections) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)newDirections, (String)"newDirections");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditDirections.copy$default(uiState, null, null, null, null, null, null, newDirections, 63, null));
    }

    public final void updateFaqList(@NotNull AccountUiState.EditFaq uiState, @NotNull List<Faq> updateFaqList) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter(updateFaqList, (String)"updateFaqList");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditFaq.copy$default(uiState, null, null, null, null, null, null, updateFaqList, 63, null));
    }

    public final void updateMap(@NotNull AccountUiState.EditMap uiState, @NotNull ImageType imageType) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditMap.copy$default(uiState, null, null, null, null, null, null, imageType, 63, null));
    }

    public final void updateAdditionalContent(@NotNull AccountUiState.EditAdditionalContent uiState, @NotNull List<? extends AdditionalContentType> updatedAdditionalContentList) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter(updatedAdditionalContentList, (String)"updatedAdditionalContentList");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAdditionalContent.copy$default(uiState, null, null, null, null, null, null, false, 0, updatedAdditionalContentList, 255, null));
    }

    public final void updateAdditionalPage(int page) {
        block0: {
            Object object = this._accountUiStateFlow.getValue();
            AccountUiState.EditAdditionalContent editAdditionalContent = object instanceof AccountUiState.EditAdditionalContent ? (AccountUiState.EditAdditionalContent)object : null;
            if (editAdditionalContent == null) break block0;
            AccountUiState.EditAdditionalContent it = editAdditionalContent;
            boolean bl = false;
            this._accountUiStateFlow.setValue((Object)AccountUiState.EditAdditionalContent.copy$default(it, null, null, null, null, null, null, false, page, null, 383, null));
        }
    }

    public final void updateEventData(@NotNull AddEditEventType uiState, @NotNull FestivalCreationData festivalCreationData) {
        AccountUiState accountUiState;
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)festivalCreationData, (String)"festivalCreationData");
        AddEditEventType addEditEventType = uiState;
        if (addEditEventType instanceof AccountUiState.AddNewEvent) {
            accountUiState = AccountUiState.AddNewEvent.copy$default((AccountUiState.AddNewEvent)uiState, null, null, null, null, null, festivalCreationData, null, 95, null);
        } else if (addEditEventType instanceof AccountUiState.EditEvent) {
            accountUiState = AccountUiState.EditEvent.copy$default((AccountUiState.EditEvent)uiState, null, null, null, null, null, null, null, festivalCreationData, null, null, null, null, null, false, 16255, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this._accountUiStateFlow.setValue((Object)accountUiState);
    }

    public final void updateNewAccountData(@NotNull AccountUiState.AddNewAccount uiState, @NotNull FestivalCreationData festivalCreationData) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)festivalCreationData, (String)"festivalCreationData");
        this._accountUiStateFlow.setValue((Object)AccountUiState.AddNewAccount.copy$default(uiState, null, null, null, null, festivalCreationData, 15, null));
    }

    public final void updateAccountDetails(@NotNull AccountUiState.EditAccount uiState, @NotNull FestivalAccountEditableData data) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAccount.copy$default(uiState, null, null, null, null, null, data, 31, null));
    }

    public final void updateAccountDetails(@NotNull AccountUiState.EditAccountFromEvent uiState, @NotNull FestivalAccountEditableData data) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this._accountUiStateFlow.setValue((Object)AccountUiState.EditAccountFromEvent.copy$default(uiState, null, null, null, null, null, null, null, data, 127, null));
    }

    public final void demoDialogSeen(@NotNull AccountUiState.NoAccountFound uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this.isShowDemoDialog = false;
        this.settings.putBoolean("isShownDemoDialog", false);
        this._accountUiStateFlow.setValue((Object)AccountUiState.NoAccountFound.copy$default(uiState, false, null, 2, null));
    }

    public final void menuOpenedOnce(@NotNull AccountUiState.AccountOpened uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this.settings.putBoolean("isAccountMenuOpenedOnce", true);
        this._accountUiStateFlow.setValue((Object)AccountUiState.AccountOpened.copy$default(uiState, null, null, null, true, 7, null));
    }

    public final void hasSeenSingleStageWarning(@NotNull AccountUiState.PreviewDraftApp uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this.settings.putBoolean("isSeenSingleStageWarning", true);
        this._accountUiStateFlow.setValue((Object)AccountUiState.PreviewDraftApp.copy$default(uiState, null, null, null, null, null, true, 31, null));
    }

    public final void hasSeenSingleStageWarning(@NotNull AccountUiState.OpenLiveApp uiState) {
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        this.settings.putBoolean("isSeenSingleStageWarning", true);
        this._accountUiStateFlow.setValue((Object)AccountUiState.OpenLiveApp.copy$default(uiState, null, null, null, null, null, true, 31, null));
    }

    public void onDispose() {
        ScreenModel.DefaultImpls.onDispose((ScreenModel)this);
    }

    public static final /* synthetic */ UserRepositoryApi access$getUserRepo$p(AccountViewModel $this) {
        return $this.userRepo;
    }

    public static final /* synthetic */ MutableStateFlow access$get_errorMessageStateFlow$p(AccountViewModel $this) {
        return $this._errorMessageStateFlow;
    }

    public static final /* synthetic */ MultiLogger access$getLogger$p(AccountViewModel $this) {
        return $this.logger;
    }

    public static final /* synthetic */ MutableStateFlow access$get_accountUiStateFlow$p(AccountViewModel $this) {
        return $this._accountUiStateFlow;
    }

    public static final /* synthetic */ ArtistRepositoryApi access$getDraftArtistRepositoryApi$p(AccountViewModel $this) {
        return $this.draftArtistRepositoryApi;
    }

    public static final /* synthetic */ AtomicIntegerFieldUpdater access$isProcessingYearData$volatile$FU() {
        return AccountViewModel.isProcessingYearData$volatile$FU;
    }

    public static final /* synthetic */ AccountRepositoryApi access$getAccountRepo$p(AccountViewModel $this) {
        return $this.accountRepo;
    }

    public static final /* synthetic */ Object access$updateOpenedAccountOrReloadList(AccountViewModel $this, Account newAccount, List accountList, Continuation $completion) {
        return $this.updateOpenedAccountOrReloadList(newAccount, accountList, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ PublishedEventRepositoryApi access$getPublishedEventRepository$p(AccountViewModel $this) {
        return $this.publishedEventRepository;
    }

    public static final /* synthetic */ ImageUploader access$getImageUploader$p(AccountViewModel $this) {
        return $this.imageUploader;
    }

    public static final /* synthetic */ User access$getUser$p(AccountViewModel $this) {
        return $this.user;
    }

    public static final /* synthetic */ AppMode access$getAppMode$p(AccountViewModel $this) {
        return $this.appMode;
    }

    public static final /* synthetic */ boolean access$isMenuOpenedOnce$p(AccountViewModel $this) {
        return $this.isMenuOpenedOnce;
    }

    public static final /* synthetic */ Object access$clearMap(AccountViewModel $this, AccountUiState.EditMap uiState, Continuation $completion) {
        return $this.clearMap(uiState, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$uploadMap(AccountViewModel $this, AccountUiState.EditMap uiState, ImageType.File newMap, Continuation $completion) {
        return $this.uploadMap(uiState, newMap, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateYearData(AccountViewModel $this, Account account, YearData yearData, Function2 onProcessingChanged, Function2 onError, Function2 onComplete, Continuation $completion) {
        return $this.updateYearData(account, yearData, (Function2<? super ProcessingState, ? super Continuation<? super Unit>, ? extends Object>)onProcessingChanged, (Function2<? super Exception, ? super Continuation<? super Unit>, ? extends Object>)onError, (Function2<? super YearData, ? super Continuation<? super Unit>, ? extends Object>)onComplete, (Continuation<? super Unit>)$completion);
    }

    static {
        isProcessingYearData$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(AccountViewModel.class, "isProcessingYearData$volatile");
    }
}

