/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.draftSchedule;

import androidx.compose.runtime.internal.StabilityInferred;
import data.account.model.Stage;
import extensions.LocalDateTimeExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import models.DisplayPerformance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.screens.FestivalDay;
import ui.screens.draftSchedule.editing.ImageType;
import ui.screens.draftSchedule.grid.DraggedChanges;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u001f2\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0005J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017J\u0006\u0010\u0018\u001a\u00020\u0019\u0082\u0001\u0005 !\"#$\u00a8\u0006%"}, d2={"Lui/screens/draftSchedule/AddPerformanceType;", "", "<init>", "()V", "stageKey", "", "performanceId", "artistName", "description", "imageUrl", "Lui/screens/draftSchedule/editing/ImageType;", "startDayOfMonth", "Lkotlinx/datetime/LocalDate;", "festivalDay", "Lui/screens/FestivalDay;", "startDayHour", "", "startDayMinute", "endDayOfMonth", "endDayHour", "endDayMinute", "genreList", "socialList", "", "isDeleted", "", "New", "Edit", "EditWithDragChanges", "AddNext", "NewFromClick", "Companion", "Lui/screens/draftSchedule/AddPerformanceType$AddNext;", "Lui/screens/draftSchedule/AddPerformanceType$Edit;", "Lui/screens/draftSchedule/AddPerformanceType$EditWithDragChanges;", "Lui/screens/draftSchedule/AddPerformanceType$New;", "Lui/screens/draftSchedule/AddPerformanceType$NewFromClick;", "shared"})
@StabilityInferred(parameters=1)
public abstract class AddPerformanceType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    private AddPerformanceType() {
    }

    @NotNull
    public final String stageKey() {
        Object object;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            object = ((AddNext)this).getStageKey();
        } else if (addPerformanceType instanceof Edit) {
            object = ((Edit)this).getDisplayPerformance().getStageKey();
        } else if (addPerformanceType instanceof New) {
            object = ((New)this).getStage();
            if (object == null || (object = ((Stage)object).getKey()) == null) {
                object = "";
            }
        } else if (addPerformanceType instanceof NewFromClick) {
            object = ((NewFromClick)this).getStageKey();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            object = ((EditWithDragChanges)this).getDraggedChanges().getStage().getKey();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String performanceId() {
        Object object;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            object = "";
        } else if (addPerformanceType instanceof Edit) {
            object = ((Edit)this).getDisplayPerformance().getPerformanceId();
        } else if (addPerformanceType instanceof New) {
            object = "";
        } else if (addPerformanceType instanceof NewFromClick) {
            object = "";
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            object = ((EditWithDragChanges)this).getMatchingPerformance();
            if (object == null || (object = ((DisplayPerformance)object).getPerformanceId()) == null) {
                object = "";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String artistName() {
        Object object;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            object = "";
        } else if (addPerformanceType instanceof Edit) {
            object = ((Edit)this).getDisplayPerformance().getArtistName();
        } else if (addPerformanceType instanceof New) {
            object = "";
        } else if (addPerformanceType instanceof NewFromClick) {
            object = "";
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            object = ((EditWithDragChanges)this).getMatchingPerformance();
            if (object == null || (object = ((DisplayPerformance)object).getArtistName()) == null) {
                object = "";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String description() {
        Object object;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            object = "";
        } else if (addPerformanceType instanceof Edit) {
            object = ((Edit)this).getDisplayPerformance().getArtistDescription();
        } else if (addPerformanceType instanceof New) {
            object = "";
        } else if (addPerformanceType instanceof NewFromClick) {
            object = "";
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            object = ((EditWithDragChanges)this).getMatchingPerformance();
            if (object == null || (object = ((DisplayPerformance)object).getArtistDescription()) == null) {
                object = "";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final ImageType imageUrl() {
        ImageType imageType;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            imageType = ImageType.None.INSTANCE;
        } else if (addPerformanceType instanceof Edit) {
            imageType = ((CharSequence)((Edit)this).getDisplayPerformance().getArtistImageUrl()).length() > 0 ? (ImageType)new ImageType.URL(((Edit)this).getDisplayPerformance().getArtistImageUrl(), ((Edit)this).getDisplayPerformance().getImageWidth(), ((Edit)this).getDisplayPerformance().getImageHeight()) : (ImageType)ImageType.None.INSTANCE;
        } else if (addPerformanceType instanceof New) {
            imageType = ImageType.None.INSTANCE;
        } else if (addPerformanceType instanceof NewFromClick) {
            imageType = ImageType.None.INSTANCE;
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            DisplayPerformance displayPerformance = ((EditWithDragChanges)this).getMatchingPerformance();
            CharSequence charSequence = displayPerformance != null ? displayPerformance.getArtistImageUrl() : null;
            imageType = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? (ImageType)ImageType.None.INSTANCE : (ImageType)new ImageType.URL(((EditWithDragChanges)this).getMatchingPerformance().getArtistImageUrl(), ((EditWithDragChanges)this).getMatchingPerformance().getImageWidth(), ((EditWithDragChanges)this).getMatchingPerformance().getImageHeight());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return imageType;
    }

    @NotNull
    public final LocalDate startDayOfMonth(@NotNull FestivalDay festivalDay2) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            localDate = ((AddNext)this).getStartDay();
        } else if (addPerformanceType instanceof Edit) {
            localDate = ((Edit)this).getDisplayPerformance().getStartTime().getDate();
        } else if (addPerformanceType instanceof New) {
            localDate = festivalDay2.getStartTime().getDate();
        } else if (addPerformanceType instanceof NewFromClick) {
            localDate = ((NewFromClick)this).getStartDay();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            localDate = ((EditWithDragChanges)this).getDraggedChanges().getStartTime().getDate();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return localDate;
    }

    public final int startDayHour(@NotNull FestivalDay festivalDay2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            n = ((AddNext)this).getStartHour();
        } else if (addPerformanceType instanceof Edit) {
            n = ((Edit)this).getDisplayPerformance().getStartTime().getHour();
        } else if (addPerformanceType instanceof New) {
            n = festivalDay2.getStartTime().getHour();
        } else if (addPerformanceType instanceof NewFromClick) {
            n = ((NewFromClick)this).getStartHour();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            n = ((EditWithDragChanges)this).getDraggedChanges().getStartTime().getHour();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public final int startDayMinute() {
        int n;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            n = ((AddNext)this).getStartMinute();
        } else if (addPerformanceType instanceof Edit) {
            n = ((Edit)this).getDisplayPerformance().getStartTime().getMinute();
        } else if (addPerformanceType instanceof New) {
            n = 0;
        } else if (addPerformanceType instanceof NewFromClick) {
            n = ((NewFromClick)this).getStartMinute();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            n = ((EditWithDragChanges)this).getDraggedChanges().getStartTime().getMinute();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @NotNull
    public final LocalDate endDayOfMonth(@NotNull FestivalDay festivalDay2) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            localDate = ((AddNext)this).getStartHour() == 23 ? LocalDateJvmKt.plus((LocalDate)((AddNext)this).getStartDay(), (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())) : ((AddNext)this).getStartDay();
        } else if (addPerformanceType instanceof Edit) {
            localDate = ((Edit)this).getDisplayPerformance().getEndTime().getDate();
        } else if (addPerformanceType instanceof New) {
            localDate = LocalDateTimeExtensionsKt.plus$default(festivalDay2.getStartTime(), 1, DateTimeUnit.Companion.getHOUR(), null, 4, null).getDate();
        } else if (addPerformanceType instanceof NewFromClick) {
            localDate = ((NewFromClick)this).getStartHour() == 23 && ((NewFromClick)this).getStartMinute() >= 30 ? LocalDateJvmKt.plus((LocalDate)((NewFromClick)this).getStartDay(), (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())) : ((NewFromClick)this).getStartDay();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            localDate = ((EditWithDragChanges)this).getDraggedChanges().getEndTime().getDate();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return localDate;
    }

    public final int endDayHour(@NotNull FestivalDay festivalDay2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)festivalDay2, (String)"festivalDay");
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            n = ((AddNext)this).getStartHour() == 23 ? 0 : ((AddNext)this).getStartHour() + 1;
        } else if (addPerformanceType instanceof Edit) {
            n = ((Edit)this).getDisplayPerformance().getEndTime().getHour();
        } else if (addPerformanceType instanceof New) {
            n = LocalDateTimeExtensionsKt.plus$default(festivalDay2.getStartTime(), 1, DateTimeUnit.Companion.getHOUR(), null, 4, null).getHour();
        } else if (addPerformanceType instanceof NewFromClick) {
            n = ((NewFromClick)this).getEndHour();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            n = ((EditWithDragChanges)this).getDraggedChanges().getEndTime().getHour();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public final int endDayMinute() {
        int n;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            n = ((AddNext)this).getStartMinute();
        } else if (addPerformanceType instanceof Edit) {
            n = ((Edit)this).getDisplayPerformance().getEndTime().getMinute();
        } else if (addPerformanceType instanceof New) {
            n = 0;
        } else if (addPerformanceType instanceof NewFromClick) {
            n = ((NewFromClick)this).getEndMinute();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            n = ((EditWithDragChanges)this).getDraggedChanges().getEndTime().getMinute();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @NotNull
    public final String genreList() {
        Object object;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            object = "";
        } else if (addPerformanceType instanceof Edit) {
            object = CollectionsKt.joinToString$default((Iterable)((Edit)this).getDisplayPerformance().getGenreList(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        } else if (addPerformanceType instanceof New) {
            object = "";
        } else if (addPerformanceType instanceof NewFromClick) {
            object = "";
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            object = ((EditWithDragChanges)this).getMatchingPerformance();
            if (object == null || (object = ((DisplayPerformance)object).getGenreList()) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)) == null) {
                object = "";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final List<String> socialList() {
        Object object;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            object = CollectionsKt.emptyList();
        } else if (addPerformanceType instanceof Edit) {
            object = ((Edit)this).getDisplayPerformance().getSocialList();
        } else if (addPerformanceType instanceof New) {
            object = CollectionsKt.emptyList();
        } else if (addPerformanceType instanceof NewFromClick) {
            object = CollectionsKt.emptyList();
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            object = ((EditWithDragChanges)this).getMatchingPerformance();
            if (object == null || (object = ((DisplayPerformance)object).getSocialList()) == null) {
                object = CollectionsKt.emptyList();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public final boolean isDeleted() {
        boolean bl;
        AddPerformanceType addPerformanceType = this;
        if (addPerformanceType instanceof AddNext) {
            bl = false;
        } else if (addPerformanceType instanceof Edit) {
            bl = ((Edit)this).getDisplayPerformance().isDeleted();
        } else if (addPerformanceType instanceof New) {
            bl = false;
        } else if (addPerformanceType instanceof NewFromClick) {
            bl = false;
        } else if (addPerformanceType instanceof EditWithDragChanges) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public /* synthetic */ AddPerformanceType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lui/screens/draftSchedule/AddPerformanceType$AddNext;", "Lui/screens/draftSchedule/AddPerformanceType;", "stageKey", "", "startDay", "Lkotlinx/datetime/LocalDate;", "startHour", "", "startMinute", "<init>", "(Ljava/lang/String;Lkotlinx/datetime/LocalDate;II)V", "getStageKey", "()Ljava/lang/String;", "getStartDay", "()Lkotlinx/datetime/LocalDate;", "getStartHour", "()I", "getStartMinute", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "shared"})
    @StabilityInferred(parameters=0)
    public static final class AddNext
    extends AddPerformanceType {
        @NotNull
        private final String stageKey;
        @NotNull
        private final LocalDate startDay;
        private final int startHour;
        private final int startMinute;
        public static final int $stable = 8;

        public AddNext(@NotNull String stageKey, @NotNull LocalDate startDay, int startHour, int startMinute) {
            Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
            Intrinsics.checkNotNullParameter((Object)startDay, (String)"startDay");
            super(null);
            this.stageKey = stageKey;
            this.startDay = startDay;
            this.startHour = startHour;
            this.startMinute = startMinute;
        }

        @NotNull
        public final String getStageKey() {
            return this.stageKey;
        }

        @NotNull
        public final LocalDate getStartDay() {
            return this.startDay;
        }

        public final int getStartHour() {
            return this.startHour;
        }

        public final int getStartMinute() {
            return this.startMinute;
        }

        @NotNull
        public final String component1() {
            return this.stageKey;
        }

        @NotNull
        public final LocalDate component2() {
            return this.startDay;
        }

        public final int component3() {
            return this.startHour;
        }

        public final int component4() {
            return this.startMinute;
        }

        @NotNull
        public final AddNext copy(@NotNull String stageKey, @NotNull LocalDate startDay, int startHour, int startMinute) {
            Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
            Intrinsics.checkNotNullParameter((Object)startDay, (String)"startDay");
            return new AddNext(stageKey, startDay, startHour, startMinute);
        }

        public static /* synthetic */ AddNext copy$default(AddNext addNext, String string2, LocalDate localDate, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string2 = addNext.stageKey;
            }
            if ((n3 & 2) != 0) {
                localDate = addNext.startDay;
            }
            if ((n3 & 4) != 0) {
                n = addNext.startHour;
            }
            if ((n3 & 8) != 0) {
                n2 = addNext.startMinute;
            }
            return addNext.copy(string2, localDate, n, n2);
        }

        @NotNull
        public String toString() {
            return "AddNext(stageKey=" + this.stageKey + ", startDay=" + this.startDay + ", startHour=" + this.startHour + ", startMinute=" + this.startMinute + ")";
        }

        public int hashCode() {
            int result = this.stageKey.hashCode();
            result = result * 31 + this.startDay.hashCode();
            result = result * 31 + Integer.hashCode(this.startHour);
            result = result * 31 + Integer.hashCode(this.startMinute);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddNext)) {
                return false;
            }
            AddNext addNext = (AddNext)other;
            if (!Intrinsics.areEqual((Object)this.stageKey, (Object)addNext.stageKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startDay, (Object)addNext.startDay)) {
                return false;
            }
            if (this.startHour != addNext.startHour) {
                return false;
            }
            return this.startMinute == addNext.startMinute;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lui/screens/draftSchedule/AddPerformanceType$Companion;", "", "<init>", "()V", "from", "Lui/screens/draftSchedule/AddPerformanceType;", "displayPerformance", "Lmodels/DisplayPerformance;", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AddPerformanceType from(@Nullable DisplayPerformance displayPerformance) {
            return displayPerformance == null ? (AddPerformanceType)new New(null, 1, null) : (AddPerformanceType)new Edit(displayPerformance);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lui/screens/draftSchedule/AddPerformanceType$Edit;", "Lui/screens/draftSchedule/AddPerformanceType;", "displayPerformance", "Lmodels/DisplayPerformance;", "<init>", "(Lmodels/DisplayPerformance;)V", "getDisplayPerformance", "()Lmodels/DisplayPerformance;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Edit
    extends AddPerformanceType {
        @NotNull
        private final DisplayPerformance displayPerformance;
        public static final int $stable;

        public Edit(@NotNull DisplayPerformance displayPerformance) {
            Intrinsics.checkNotNullParameter((Object)displayPerformance, (String)"displayPerformance");
            super(null);
            this.displayPerformance = displayPerformance;
        }

        @NotNull
        public final DisplayPerformance getDisplayPerformance() {
            return this.displayPerformance;
        }

        @NotNull
        public final DisplayPerformance component1() {
            return this.displayPerformance;
        }

        @NotNull
        public final Edit copy(@NotNull DisplayPerformance displayPerformance) {
            Intrinsics.checkNotNullParameter((Object)displayPerformance, (String)"displayPerformance");
            return new Edit(displayPerformance);
        }

        public static /* synthetic */ Edit copy$default(Edit edit, DisplayPerformance displayPerformance, int n, Object object) {
            if ((n & 1) != 0) {
                displayPerformance = edit.displayPerformance;
            }
            return edit.copy(displayPerformance);
        }

        @NotNull
        public String toString() {
            return "Edit(displayPerformance=" + this.displayPerformance + ")";
        }

        public int hashCode() {
            return this.displayPerformance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edit)) {
                return false;
            }
            Edit edit = (Edit)other;
            return Intrinsics.areEqual((Object)this.displayPerformance, (Object)edit.displayPerformance);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lui/screens/draftSchedule/AddPerformanceType$EditWithDragChanges;", "Lui/screens/draftSchedule/AddPerformanceType;", "draggedChanges", "Lui/screens/draftSchedule/grid/DraggedChanges;", "matchingPerformance", "Lmodels/DisplayPerformance;", "<init>", "(Lui/screens/draftSchedule/grid/DraggedChanges;Lmodels/DisplayPerformance;)V", "getDraggedChanges", "()Lui/screens/draftSchedule/grid/DraggedChanges;", "getMatchingPerformance", "()Lmodels/DisplayPerformance;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=0)
    public static final class EditWithDragChanges
    extends AddPerformanceType {
        @NotNull
        private final DraggedChanges draggedChanges;
        @Nullable
        private final DisplayPerformance matchingPerformance;
        public static final int $stable = 8;

        public EditWithDragChanges(@NotNull DraggedChanges draggedChanges, @Nullable DisplayPerformance matchingPerformance) {
            Intrinsics.checkNotNullParameter((Object)draggedChanges, (String)"draggedChanges");
            super(null);
            this.draggedChanges = draggedChanges;
            this.matchingPerformance = matchingPerformance;
        }

        @NotNull
        public final DraggedChanges getDraggedChanges() {
            return this.draggedChanges;
        }

        @Nullable
        public final DisplayPerformance getMatchingPerformance() {
            return this.matchingPerformance;
        }

        @NotNull
        public final DraggedChanges component1() {
            return this.draggedChanges;
        }

        @Nullable
        public final DisplayPerformance component2() {
            return this.matchingPerformance;
        }

        @NotNull
        public final EditWithDragChanges copy(@NotNull DraggedChanges draggedChanges, @Nullable DisplayPerformance matchingPerformance) {
            Intrinsics.checkNotNullParameter((Object)draggedChanges, (String)"draggedChanges");
            return new EditWithDragChanges(draggedChanges, matchingPerformance);
        }

        public static /* synthetic */ EditWithDragChanges copy$default(EditWithDragChanges editWithDragChanges, DraggedChanges draggedChanges, DisplayPerformance displayPerformance, int n, Object object) {
            if ((n & 1) != 0) {
                draggedChanges = editWithDragChanges.draggedChanges;
            }
            if ((n & 2) != 0) {
                displayPerformance = editWithDragChanges.matchingPerformance;
            }
            return editWithDragChanges.copy(draggedChanges, displayPerformance);
        }

        @NotNull
        public String toString() {
            return "EditWithDragChanges(draggedChanges=" + this.draggedChanges + ", matchingPerformance=" + this.matchingPerformance + ")";
        }

        public int hashCode() {
            int result = this.draggedChanges.hashCode();
            result = result * 31 + (this.matchingPerformance == null ? 0 : this.matchingPerformance.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EditWithDragChanges)) {
                return false;
            }
            EditWithDragChanges editWithDragChanges = (EditWithDragChanges)other;
            if (!Intrinsics.areEqual((Object)this.draggedChanges, (Object)editWithDragChanges.draggedChanges)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.matchingPerformance, (Object)editWithDragChanges.matchingPerformance);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lui/screens/draftSchedule/AddPerformanceType$New;", "Lui/screens/draftSchedule/AddPerformanceType;", "stage", "Ldata/account/model/Stage;", "<init>", "(Ldata/account/model/Stage;)V", "getStage", "()Ldata/account/model/Stage;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class New
    extends AddPerformanceType {
        @Nullable
        private final Stage stage;
        public static final int $stable;

        public New(@Nullable Stage stage) {
            super(null);
            this.stage = stage;
        }

        public /* synthetic */ New(Stage stage, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                stage = null;
            }
            this(stage);
        }

        @Nullable
        public final Stage getStage() {
            return this.stage;
        }

        @Nullable
        public final Stage component1() {
            return this.stage;
        }

        @NotNull
        public final New copy(@Nullable Stage stage) {
            return new New(stage);
        }

        public static /* synthetic */ New copy$default(New new_, Stage stage, int n, Object object) {
            if ((n & 1) != 0) {
                stage = new_.stage;
            }
            return new_.copy(stage);
        }

        @NotNull
        public String toString() {
            return "New(stage=" + this.stage + ")";
        }

        public int hashCode() {
            return this.stage == null ? 0 : this.stage.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof New)) {
                return false;
            }
            New new_ = (New)other;
            return Intrinsics.areEqual((Object)this.stage, (Object)new_.stage);
        }

        public New() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003JE\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006#"}, d2={"Lui/screens/draftSchedule/AddPerformanceType$NewFromClick;", "Lui/screens/draftSchedule/AddPerformanceType;", "stageKey", "", "startDay", "Lkotlinx/datetime/LocalDate;", "startHour", "", "startMinute", "endHour", "endMinute", "<init>", "(Ljava/lang/String;Lkotlinx/datetime/LocalDate;IIII)V", "getStageKey", "()Ljava/lang/String;", "getStartDay", "()Lkotlinx/datetime/LocalDate;", "getStartHour", "()I", "getStartMinute", "getEndHour", "getEndMinute", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "shared"})
    @StabilityInferred(parameters=0)
    public static final class NewFromClick
    extends AddPerformanceType {
        @NotNull
        private final String stageKey;
        @NotNull
        private final LocalDate startDay;
        private final int startHour;
        private final int startMinute;
        private final int endHour;
        private final int endMinute;
        public static final int $stable = 8;

        public NewFromClick(@NotNull String stageKey, @NotNull LocalDate startDay, int startHour, int startMinute, int endHour, int endMinute) {
            Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
            Intrinsics.checkNotNullParameter((Object)startDay, (String)"startDay");
            super(null);
            this.stageKey = stageKey;
            this.startDay = startDay;
            this.startHour = startHour;
            this.startMinute = startMinute;
            this.endHour = endHour;
            this.endMinute = endMinute;
        }

        @NotNull
        public final String getStageKey() {
            return this.stageKey;
        }

        @NotNull
        public final LocalDate getStartDay() {
            return this.startDay;
        }

        public final int getStartHour() {
            return this.startHour;
        }

        public final int getStartMinute() {
            return this.startMinute;
        }

        public final int getEndHour() {
            return this.endHour;
        }

        public final int getEndMinute() {
            return this.endMinute;
        }

        @NotNull
        public final String component1() {
            return this.stageKey;
        }

        @NotNull
        public final LocalDate component2() {
            return this.startDay;
        }

        public final int component3() {
            return this.startHour;
        }

        public final int component4() {
            return this.startMinute;
        }

        public final int component5() {
            return this.endHour;
        }

        public final int component6() {
            return this.endMinute;
        }

        @NotNull
        public final NewFromClick copy(@NotNull String stageKey, @NotNull LocalDate startDay, int startHour, int startMinute, int endHour, int endMinute) {
            Intrinsics.checkNotNullParameter((Object)stageKey, (String)"stageKey");
            Intrinsics.checkNotNullParameter((Object)startDay, (String)"startDay");
            return new NewFromClick(stageKey, startDay, startHour, startMinute, endHour, endMinute);
        }

        public static /* synthetic */ NewFromClick copy$default(NewFromClick newFromClick, String string2, LocalDate localDate, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string2 = newFromClick.stageKey;
            }
            if ((n5 & 2) != 0) {
                localDate = newFromClick.startDay;
            }
            if ((n5 & 4) != 0) {
                n = newFromClick.startHour;
            }
            if ((n5 & 8) != 0) {
                n2 = newFromClick.startMinute;
            }
            if ((n5 & 0x10) != 0) {
                n3 = newFromClick.endHour;
            }
            if ((n5 & 0x20) != 0) {
                n4 = newFromClick.endMinute;
            }
            return newFromClick.copy(string2, localDate, n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "NewFromClick(stageKey=" + this.stageKey + ", startDay=" + this.startDay + ", startHour=" + this.startHour + ", startMinute=" + this.startMinute + ", endHour=" + this.endHour + ", endMinute=" + this.endMinute + ")";
        }

        public int hashCode() {
            int result = this.stageKey.hashCode();
            result = result * 31 + this.startDay.hashCode();
            result = result * 31 + Integer.hashCode(this.startHour);
            result = result * 31 + Integer.hashCode(this.startMinute);
            result = result * 31 + Integer.hashCode(this.endHour);
            result = result * 31 + Integer.hashCode(this.endMinute);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NewFromClick)) {
                return false;
            }
            NewFromClick newFromClick = (NewFromClick)other;
            if (!Intrinsics.areEqual((Object)this.stageKey, (Object)newFromClick.stageKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startDay, (Object)newFromClick.startDay)) {
                return false;
            }
            if (this.startHour != newFromClick.startHour) {
                return false;
            }
            if (this.startMinute != newFromClick.startMinute) {
                return false;
            }
            if (this.endHour != newFromClick.endHour) {
                return false;
            }
            return this.endMinute == newFromClick.endMinute;
        }
    }
}

