/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.AngleUnit;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorKt;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.HueColorKt;
import com.github.ajalt.colormath.Illuminant;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LABColorSpaces;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabColorSpaces;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.RGBInt;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZColorSpaces;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001ab\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\u0018\b\u0002\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\u001ab\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\u0018\b\u0002\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0007\u001a4\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a4\u0010\u0015\u001a\u00020\u0001*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0018\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u001c\u001a\u00020\u0001*\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u0001*\u00020\u001f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010 \u001a\u00020\u0001*\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001aG\u0010\"\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020\u00012\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010%\"\u00020\u00012\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010&\u001a\u0014\u0010'\u001a\u00020\u0001*\u00020(2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a,\u0010)\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u001a \u0010*\u001a\u00020\u0001*\u00020+2\b\b\u0002\u0010,\u001a\u00020\b2\b\b\u0002\u0010-\u001a\u00020.H\u0002\"\u0018\u0010/\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"formatCssStringOrNull", "", "Lcom/github/ajalt/colormath/Color;", "hueUnit", "Lcom/github/ajalt/colormath/AngleUnit;", "renderAlpha", "Lcom/github/ajalt/colormath/RenderCondition;", "unitsPercent", "", "alphaPercent", "legacyName", "legacyFormat", "customColorSpaces", "", "Lcom/github/ajalt/colormath/ColorSpace;", "formatCssString", "renderSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "commas", "namedRgba", "rgbPercent", "renderHsl", "Lcom/github/ajalt/colormath/model/HSL;", "namedHsla", "renderLab", "Lcom/github/ajalt/colormath/model/LAB;", "renderLCH", "Lcom/github/ajalt/colormath/model/LCHab;", "renderHWB", "Lcom/github/ajalt/colormath/model/HWB;", "renderOklab", "Lcom/github/ajalt/colormath/model/Oklab;", "renderOklch", "Lcom/github/ajalt/colormath/model/Oklch;", "renderColorFn", "name", "components", "", "(Lcom/github/ajalt/colormath/Color;Ljava/lang/String;[Ljava/lang/String;ZLcom/github/ajalt/colormath/RenderCondition;Z)Ljava/lang/String;", "renderHue", "Lcom/github/ajalt/colormath/HueColor;", "renderFn", "render", "", "percent", "precision", "", "dashName", "getDashName", "(Lcom/github/ajalt/colormath/Color;)Ljava/lang/String;", "colormath"})
@SourceDebugExtension(value={"SMAP\nCssRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssRender.kt\ncom/github/ajalt/colormath/CssRenderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n295#2,2:363\n*S KotlinDebug\n*F\n+ 1 CssRender.kt\ncom/github/ajalt/colormath/CssRenderKt\n*L\n99#1:363,2\n*E\n"})
public final class CssRenderKt {
    @Nullable
    public static final String formatCssStringOrNull(@NotNull Color $this$formatCssStringOrNull, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent, boolean legacyName, boolean legacyFormat, @NotNull Map<String, ? extends ColorSpace<?>> customColorSpaces) {
        Object object;
        block6: {
            RGBColorSpace rGBColorSpace;
            Object object2;
            block5: {
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)$this$formatCssStringOrNull, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
                    Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
                    Intrinsics.checkNotNullParameter(customColorSpaces, (String)"customColorSpaces");
                    Iterable $this$firstOrNull$iv = customColorSpaces.entrySet();
                    boolean $i$f$firstOrNull = false;
                    object2 = $this$firstOrNull$iv.iterator();
                    while (object2.hasNext()) {
                        Object element$iv = object2.next();
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getValue(), $this$formatCssStringOrNull.getSpace())) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if ((object = (Map.Entry)v0) == null || (object = (String)object.getKey()) == null) break block5;
                Object spaceName = object;
                boolean bl = false;
                String string = CssRenderKt.renderFn($this$formatCssStringOrNull, (String)spaceName, unitsPercent, alphaPercent, renderAlpha);
                object = string;
                if (string != null) break block6;
            }
            object = (object2 = $this$formatCssStringOrNull) instanceof RGB ? (Intrinsics.areEqual((Object)(rGBColorSpace = ((RGB)$this$formatCssStringOrNull).getSpace()), (Object)SRGB.INSTANCE) ? CssRenderKt.renderSRGB((RGB)$this$formatCssStringOrNull, legacyFormat, legacyName, unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual((Object)rGBColorSpace, (Object)RGBColorSpaces.INSTANCE.getDisplayP3()) ? CssRenderKt.renderFn($this$formatCssStringOrNull, "display-p3", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual((Object)rGBColorSpace, (Object)RGBColorSpaces.INSTANCE.getAdobeRGB()) ? CssRenderKt.renderFn($this$formatCssStringOrNull, "a98-rgb", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual((Object)rGBColorSpace, (Object)RGBColorSpaces.INSTANCE.getROMM_RGB()) ? CssRenderKt.renderFn($this$formatCssStringOrNull, "prophoto-rgb", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual((Object)rGBColorSpace, (Object)RGBColorSpaces.INSTANCE.getBT2020()) ? CssRenderKt.renderFn($this$formatCssStringOrNull, "rec2020", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual((Object)rGBColorSpace, (Object)RGBColorSpaces.INSTANCE.getLinearSRGB()) ? CssRenderKt.renderFn($this$formatCssStringOrNull, "srgb-linear", unitsPercent, alphaPercent, renderAlpha) : null)))))) : (object2 instanceof HSL ? CssRenderKt.renderHsl((HSL)$this$formatCssStringOrNull, legacyFormat, legacyName, hueUnit, alphaPercent, renderAlpha) : (object2 instanceof LAB ? CssRenderKt.renderLab((LAB)ColorKt.convertTo($this$formatCssStringOrNull, LABColorSpaces.INSTANCE.getLAB50()), alphaPercent, renderAlpha) : (object2 instanceof LCHab ? CssRenderKt.renderLCH((LCHab)ColorKt.convertTo($this$formatCssStringOrNull, LCHabColorSpaces.INSTANCE.getLCHab50()), hueUnit, alphaPercent, renderAlpha) : (object2 instanceof HWB ? CssRenderKt.renderHWB((HWB)$this$formatCssStringOrNull, hueUnit, alphaPercent, renderAlpha) : (object2 instanceof Oklab ? CssRenderKt.renderOklab((Oklab)$this$formatCssStringOrNull, alphaPercent, renderAlpha) : (object2 instanceof Oklch ? CssRenderKt.renderOklch((Oklch)$this$formatCssStringOrNull, hueUnit, alphaPercent, renderAlpha) : (object2 instanceof XYZ ? (Intrinsics.areEqual((Object)((XYZ)$this$formatCssStringOrNull).getSpace().getWhitePoint(), (Object)Illuminant.INSTANCE.getD65()) ? CssRenderKt.renderFn($this$formatCssStringOrNull, "xyz-d65", unitsPercent, alphaPercent, renderAlpha) : CssRenderKt.renderFn(((XYZ)$this$formatCssStringOrNull).adaptTo(XYZColorSpaces.INSTANCE.getXYZ50()), "xyz", unitsPercent, alphaPercent, renderAlpha)) : null)))))));
        }
        return object;
    }

    public static /* synthetic */ String formatCssStringOrNull$default(Color color, AngleUnit angleUnit, RenderCondition renderCondition, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            angleUnit = AngleUnit.AUTO;
        }
        if ((n & 2) != 0) {
            renderCondition = RenderCondition.AUTO;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        return CssRenderKt.formatCssStringOrNull(color, angleUnit, renderCondition, bl, bl2, bl3, bl4, map);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent, boolean legacyName, boolean legacyFormat, @NotNull Map<String, ? extends ColorSpace<?>> customColorSpaces) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        Intrinsics.checkNotNullParameter(customColorSpaces, (String)"customColorSpaces");
        String string = CssRenderKt.formatCssStringOrNull($this$formatCssString, hueUnit, renderAlpha, unitsPercent, alphaPercent, legacyName, legacyFormat, customColorSpaces);
        if (string == null) {
            string = CssRenderKt.renderFn($this$formatCssString, CssRenderKt.getDashName($this$formatCssString), unitsPercent, alphaPercent, renderAlpha);
        }
        return string;
    }

    public static /* synthetic */ String formatCssString$default(Color color, AngleUnit angleUnit, RenderCondition renderCondition, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            angleUnit = AngleUnit.AUTO;
        }
        if ((n & 2) != 0) {
            renderCondition = RenderCondition.AUTO;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        return CssRenderKt.formatCssString(color, angleUnit, renderCondition, bl, bl2, bl3, bl4, map);
    }

    private static final String renderSRGB(RGB $this$renderSRGB, boolean commas, boolean namedRgba, boolean rgbPercent, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{rgbPercent ? CssRenderKt.render$default($this$renderSRGB.getR(), true, 0, 2, null) : UByte.toString-impl((byte)RGBInt.getR-w2LRezQ($this$renderSRGB.toRGBInt-RGiG7fk())), rgbPercent ? CssRenderKt.render$default($this$renderSRGB.getG(), true, 0, 2, null) : UByte.toString-impl((byte)RGBInt.getG-w2LRezQ($this$renderSRGB.toRGBInt-RGiG7fk())), rgbPercent ? CssRenderKt.render$default($this$renderSRGB.getB(), true, 0, 2, null) : UByte.toString-impl((byte)RGBInt.getB-w2LRezQ($this$renderSRGB.toRGBInt-RGiG7fk()))};
        return CssRenderKt.renderColorFn($this$renderSRGB, namedRgba ? "rgba" : "rgb", stringArray, alphaPercent, renderAlpha, commas);
    }

    private static final String renderHsl(HSL $this$renderHsl, boolean commas, boolean namedHsla, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.renderHue($this$renderHsl, hueUnit), CssRenderKt.render$default($this$renderHsl.getS(), true, 0, 2, null), CssRenderKt.render$default($this$renderHsl.getL(), true, 0, 2, null)};
        return CssRenderKt.renderColorFn($this$renderHsl, namedHsla ? "hsla" : "hsl", stringArray, alphaPercent, renderAlpha, commas);
    }

    private static final String renderLab(LAB $this$renderLab, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.render$default($this$renderLab.getL() / (float)100, true, 0, 2, null), CssRenderKt.render$default($this$renderLab.getA(), false, 0, 3, null), CssRenderKt.render$default($this$renderLab.getB(), false, 0, 3, null)};
        return CssRenderKt.renderColorFn$default($this$renderLab, "lab", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderLCH(LCHab $this$renderLCH, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.render$default($this$renderLCH.getL() / (float)100, true, 0, 2, null), CssRenderKt.render$default($this$renderLCH.getC(), false, 0, 3, null), CssRenderKt.renderHue($this$renderLCH, hueUnit)};
        return CssRenderKt.renderColorFn$default($this$renderLCH, "lch", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderHWB(HWB $this$renderHWB, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.renderHue($this$renderHWB, hueUnit), CssRenderKt.render$default($this$renderHWB.getW(), true, 0, 2, null), CssRenderKt.render$default($this$renderHWB.getB(), true, 0, 2, null)};
        return CssRenderKt.renderColorFn$default($this$renderHWB, "hwb", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderOklab(Oklab $this$renderOklab, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.render$default($this$renderOklab.getL(), true, 0, 2, null), CssRenderKt.render$default($this$renderOklab.getA(), false, 0, 3, null), CssRenderKt.render$default($this$renderOklab.getB(), false, 0, 3, null)};
        return CssRenderKt.renderColorFn$default($this$renderOklab, "oklab", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderOklch(Oklch $this$renderOklch, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.render$default($this$renderOklch.getL(), true, 0, 2, null), CssRenderKt.render$default($this$renderOklch.getC(), false, 0, 3, null), CssRenderKt.renderHue($this$renderOklch, hueUnit)};
        return CssRenderKt.renderColorFn$default($this$renderOklch, "oklch", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderColorFn(Color $this$renderColorFn, String name, String[] components, boolean alphaPercent, RenderCondition renderAlpha, boolean commas) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderColorFn_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String sep = commas ? ", " : " ";
        $this$renderColorFn_u24lambda_u242.append(name).append("(");
        ArraysKt.joinTo$default((Object[])components, (Appendable)$this$renderColorFn_u24lambda_u242, (CharSequence)sep, null, null, (int)0, null, null, (int)124, null);
        $this$renderColorFn_u24lambda_u242.append(CssRenderKt.renderAlpha($this$renderColorFn, commas, renderAlpha, alphaPercent));
        $this$renderColorFn_u24lambda_u242.append(")");
        return stringBuilder.toString();
    }

    static /* synthetic */ String renderColorFn$default(Color color, String string, String[] stringArray, boolean bl, RenderCondition renderCondition, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return CssRenderKt.renderColorFn(color, string, stringArray, bl, renderCondition, bl2);
    }

    private static final String renderHue(HueColor $this$renderHue, AngleUnit hueUnit) {
        String string;
        if (Float.isNaN($this$renderHue.getH())) {
            string = "none";
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[hueUnit.ordinal()]) {
                case 1: {
                    string = CssRenderKt.render$default($this$renderHue.getH(), false, 0, 3, null);
                    break;
                }
                case 2: {
                    string = CssRenderKt.render$default($this$renderHue.getH(), false, 0, 3, null) + "deg";
                    break;
                }
                case 3: {
                    string = CssRenderKt.render$default(HueColorKt.hueAsRad($this$renderHue), false, 0, 3, null) + "rad";
                    break;
                }
                case 4: {
                    string = CssRenderKt.render$default(HueColorKt.hueAsGrad($this$renderHue), false, 0, 3, null) + "grad";
                    break;
                }
                case 5: {
                    string = CssRenderKt.render$default(HueColorKt.hueAsTurns($this$renderHue), false, 0, 3, null) + "turn";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    private static final String renderFn(Color $this$renderFn, String name, boolean unitsPercent, boolean alphaPercent, RenderCondition renderAlpha) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderFn_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderFn_u24lambda_u244.append("color(").append(name).append(" ");
        CollectionsKt.joinTo$default((Iterable)ArraysKt.dropLast((float[])$this$renderFn.toArray(), (int)1), (Appendable)$this$renderFn_u24lambda_u244, (CharSequence)" ", null, null, (int)0, null, arg_0 -> CssRenderKt.renderFn$lambda$4$lambda$3(unitsPercent, arg_0), (int)60, null);
        $this$renderFn_u24lambda_u244.append(CssRenderKt.renderAlpha($this$renderFn, false, renderAlpha, alphaPercent));
        $this$renderFn_u24lambda_u244.append(")");
        return stringBuilder.toString();
    }

    private static final String renderAlpha(Color $this$renderAlpha, boolean commas, RenderCondition renderAlpha, boolean alphaPercent) {
        return renderAlpha == RenderCondition.ALWAYS || renderAlpha == RenderCondition.AUTO && !Float.isNaN($this$renderAlpha.getAlpha()) && !($this$renderAlpha.getAlpha() == 1.0f) ? (commas ? ", " : " / ") + CssRenderKt.render$default(InternalMathKt.nanToOne($this$renderAlpha.getAlpha()), alphaPercent, 0, 2, null) : "";
    }

    private static final String render(float $this$render, boolean percent, int precision) {
        String string;
        if (Float.isNaN($this$render)) {
            string = "none";
        } else if (percent) {
            string = "" + MathKt.roundToInt((float)($this$render * (float)100)) + '%';
        } else {
            float abs = Math.abs($this$render);
            int i = (int)abs;
            String sgn = $this$render < 0.0f ? "-" : "";
            int d = MathKt.roundToInt((double)((double)(abs - (float)i) * Math.pow(10.0, precision)));
            if (d == 0) {
                string = String.valueOf((int)$this$render);
            } else {
                char[] cArray = new char[]{'0'};
                string = sgn + i + '.' + StringsKt.trimEnd((String)StringsKt.padStart((String)String.valueOf(d), (int)precision, (char)'0'), (char[])cArray);
            }
        }
        return string;
    }

    static /* synthetic */ String render$default(float f, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        return CssRenderKt.render(f, bl, n);
    }

    private static final String getDashName(Color $this$dashName) {
        StringBuilder stringBuilder = new StringBuilder().append("--");
        CharSequence charSequence = $this$dashName.getSpace().getName();
        Regex regex = new Regex("\\W");
        String string = "-";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return stringBuilder.append(string2).toString();
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent, boolean legacyName, boolean legacyFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        return CssRenderKt.formatCssString$default($this$formatCssString, hueUnit, renderAlpha, unitsPercent, alphaPercent, legacyName, legacyFormat, null, 64, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent, boolean legacyName) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        return CssRenderKt.formatCssString$default($this$formatCssString, hueUnit, renderAlpha, unitsPercent, alphaPercent, legacyName, false, null, 96, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        return CssRenderKt.formatCssString$default($this$formatCssString, hueUnit, renderAlpha, unitsPercent, alphaPercent, false, false, null, 112, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        return CssRenderKt.formatCssString$default($this$formatCssString, hueUnit, renderAlpha, unitsPercent, false, false, false, null, 120, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)renderAlpha), (String)"renderAlpha");
        return CssRenderKt.formatCssString$default($this$formatCssString, hueUnit, renderAlpha, false, false, false, false, null, 124, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)hueUnit), (String)"hueUnit");
        return CssRenderKt.formatCssString$default($this$formatCssString, hueUnit, null, false, false, false, false, null, 126, null);
    }

    @JvmOverloads
    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString) {
        Intrinsics.checkNotNullParameter((Object)$this$formatCssString, (String)"<this>");
        return CssRenderKt.formatCssString$default($this$formatCssString, null, null, false, false, false, false, null, 127, null);
    }

    private static final CharSequence renderFn$lambda$4$lambda$3(boolean $unitsPercent, float it) {
        return CssRenderKt.render$default(it, $unitsPercent, 0, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AngleUnit.values().length];
            try {
                nArray[AngleUnit.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.DEGREES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.RADIANS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.GRADIANS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.TURNS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

