/*
 * Decompiled with CFR 0.152.
 */
package common;

import androidx.compose.runtime.internal.StabilityInferred;
import data.subscriptiontopics.SubscriptionTopic;
import data.subscriptiontopics.SubscriptionTopicType;
import dev.gitlive.firebase.messaging.FirebaseMessaging;
import di.MultiLogger;
import di.OSPlatform;
import di.SubscriptionTopicHelper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcommon/CommonSubscriptionTopicHelper;", "Ldi/SubscriptionTopicHelper;", "messaging", "Ldev/gitlive/firebase/messaging/FirebaseMessaging;", "logger", "Ldi/MultiLogger;", "platform", "Ldi/OSPlatform;", "<init>", "(Ldev/gitlive/firebase/messaging/FirebaseMessaging;Ldi/MultiLogger;Ldi/OSPlatform;)V", "subscribeToTopic", "", "topic", "Ldata/subscriptiontopics/SubscriptionTopic;", "unSubscribeTopic", "shared"})
@StabilityInferred(parameters=0)
public final class CommonSubscriptionTopicHelper
implements SubscriptionTopicHelper {
    @NotNull
    private final FirebaseMessaging messaging;
    @NotNull
    private final MultiLogger logger;
    @NotNull
    private final OSPlatform platform;
    public static final int $stable = 8;

    public CommonSubscriptionTopicHelper(@NotNull FirebaseMessaging messaging, @NotNull MultiLogger logger, @NotNull OSPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)messaging, (String)"messaging");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.messaging = messaging;
        this.logger = logger;
        this.platform = platform;
    }

    @Override
    public void subscribeToTopic(@NotNull SubscriptionTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        SubscriptionTopicType subscriptionTopicType = topic.getTopicType();
        if (Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.General.INSTANCE) || Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.ScheduleChanges.INSTANCE) || Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.Emergency.INSTANCE) || Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.Marketing.INSTANCE)) {
            String topicString = this.platform.getPlatformName() + topic.getTopicType().getTopic() + topic.getEventId();
            this.logger.i("Subscribed to: " + topicString);
            this.messaging.subscribeToTopic(topicString);
        } else if (Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.Unknown.INSTANCE)) {
            this.logger.e("Unable to subscribe to Unknown topic", new IllegalStateException());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void unSubscribeTopic(@NotNull SubscriptionTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        SubscriptionTopicType subscriptionTopicType = topic.getTopicType();
        if (Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.General.INSTANCE) || Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.ScheduleChanges.INSTANCE) || Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.Emergency.INSTANCE) || Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.Marketing.INSTANCE)) {
            String topicString = this.platform.getPlatformName() + topic.getTopicType().getTopic() + topic.getEventId();
            this.logger.i("Unsubscribed from to " + topicString);
            this.messaging.unsubscribeFromTopic(topicString);
        } else if (Intrinsics.areEqual((Object)subscriptionTopicType, (Object)SubscriptionTopicType.Unknown.INSTANCE)) {
            this.logger.e("Unable to subscribe to Unknown topic", new IllegalStateException());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

