/*
 * Decompiled with CFR 0.152.
 */
package common.states;

import androidx.compose.material.icons.Icons;
import androidx.compose.material.icons.filled.FavoriteBorderKt;
import androidx.compose.material.icons.filled.FavoriteKt;
import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.vector.ImageVector;
import data.artist.model.FavoritePerformance;
import data.artist.model.FavoriteRank;
import data.artist.model.Performance;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcommon/states/FavoriteState;", "", "icon", "Landroidx/compose/ui/graphics/vector/ImageVector;", "contentDescription", "", "alpha", "", "<init>", "(Landroidx/compose/ui/graphics/vector/ImageVector;Ljava/lang/String;F)V", "getIcon", "()Landroidx/compose/ui/graphics/vector/ImageVector;", "getContentDescription", "()Ljava/lang/String;", "getAlpha", "()F", "Favorite", "NotFavorite", "Companion", "Lcommon/states/FavoriteState$Favorite;", "Lcommon/states/FavoriteState$NotFavorite;", "shared"})
@Immutable
public abstract class FavoriteState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageVector icon;
    @NotNull
    private final String contentDescription;
    private final float alpha;
    public static final int $stable;

    private FavoriteState(ImageVector icon, String contentDescription, float alpha) {
        this.icon = icon;
        this.contentDescription = contentDescription;
        this.alpha = alpha;
    }

    @NotNull
    public final ImageVector getIcon() {
        return this.icon;
    }

    @NotNull
    public final String getContentDescription() {
        return this.contentDescription;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public /* synthetic */ FavoriteState(ImageVector icon, String contentDescription, float alpha, DefaultConstructorMarker $constructor_marker) {
        this(icon, contentDescription, alpha);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcommon/states/FavoriteState$Companion;", "", "<init>", "()V", "getFavoriteState", "Lcommon/states/FavoriteState;", "performance", "Ldata/artist/model/Performance;", "favoriteList", "", "Ldata/artist/model/FavoritePerformance;", "shared"})
    @SourceDebugExtension(value={"SMAP\nFavoriteState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FavoriteState.kt\ncommon/states/FavoriteState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n295#2,2:38\n*S KotlinDebug\n*F\n+ 1 FavoriteState.kt\ncommon/states/FavoriteState$Companion\n*L\n29#1:38,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FavoriteState getFavoriteState(@NotNull Performance performance, @NotNull List<FavoritePerformance> favoriteList) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)performance, (String)"performance");
                Intrinsics.checkNotNullParameter(favoriteList, (String)"favoriteList");
                Iterable $this$firstOrNull$iv = favoriteList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FavoritePerformance it = (FavoritePerformance)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPerformanceId(), (Object)performance.getPerformanceId())) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            FavoritePerformance favoriteResult = v0;
            return favoriteResult != null ? (FavoriteState)new Favorite(1.0f, favoriteResult.getRank()) : (FavoriteState)NotFavorite.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcommon/states/FavoriteState$Favorite;", "Lcommon/states/FavoriteState;", "alpha", "", "rank", "Ldata/artist/model/FavoriteRank;", "<init>", "(FLdata/artist/model/FavoriteRank;)V", "getAlpha", "()F", "getRank", "()Ldata/artist/model/FavoriteRank;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class Favorite
    extends FavoriteState {
        private final float alpha;
        @NotNull
        private final FavoriteRank rank;
        public static final int $stable;

        public Favorite(float alpha, @NotNull FavoriteRank rank) {
            Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
            super(FavoriteKt.getFavorite((Icons.Filled)Icons.Filled.INSTANCE), "Is Favorite", alpha, null);
            this.alpha = alpha;
            this.rank = rank;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @NotNull
        public final FavoriteRank getRank() {
            return this.rank;
        }

        public final float component1() {
            return this.alpha;
        }

        @NotNull
        public final FavoriteRank component2() {
            return this.rank;
        }

        @NotNull
        public final Favorite copy(float alpha, @NotNull FavoriteRank rank) {
            Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
            return new Favorite(alpha, rank);
        }

        public static /* synthetic */ Favorite copy$default(Favorite favorite, float f, FavoriteRank favoriteRank, int n, Object object) {
            if ((n & 1) != 0) {
                f = favorite.alpha;
            }
            if ((n & 2) != 0) {
                favoriteRank = favorite.rank;
            }
            return favorite.copy(f, favoriteRank);
        }

        @NotNull
        public String toString() {
            return "Favorite(alpha=" + this.alpha + ", rank=" + this.rank + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.alpha);
            result = result * 31 + this.rank.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Favorite)) {
                return false;
            }
            Favorite favorite = (Favorite)other;
            if (Float.compare(this.alpha, favorite.alpha) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rank, (Object)favorite.rank);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcommon/states/FavoriteState$NotFavorite;", "Lcommon/states/FavoriteState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "shared"})
    @StabilityInferred(parameters=1)
    public static final class NotFavorite
    extends FavoriteState {
        @NotNull
        public static final NotFavorite INSTANCE = new NotFavorite();
        public static final int $stable;

        private NotFavorite() {
            super(FavoriteBorderKt.getFavoriteBorder((Icons.Filled)Icons.Filled.INSTANCE), "Is Not Favorite", 0.65f, null);
        }

        @NotNull
        public String toString() {
            return "NotFavorite";
        }

        public int hashCode() {
            return 2030309357;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotFavorite)) {
                return false;
            }
            NotFavorite cfr_ignored_0 = (NotFavorite)other;
            return true;
        }
    }
}

