/*
 * Decompiled with CFR 0.152.
 */
package data.artist;

import androidx.compose.runtime.internal.StabilityInferred;
import com.russhwolf.settings.Settings;
import data.account.ResultOf;
import data.account.model.Account;
import data.account.model.YearData;
import data.artist.ArtistLocalApi;
import data.artist.ArtistRemoteApi;
import data.artist.ArtistRepository;
import data.artist.ArtistRepositoryApi;
import data.artist.CurrentVersionState;
import data.artist.model.Artist;
import data.artist.model.FavoritePerformance;
import data.artist.model.FavoriteRank;
import data.publishedevents.models.PublishedEvent;
import di.ContentSource;
import di.MultiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.datetime.LocalDateTime;
import models.DisplayPerformance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J:\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J2\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u001bJ*\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00150\u00142\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010 J\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010!J&\u0010\"\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010&J,\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010(J,\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010#J,\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010#J.\u0010*\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0096@\u00a2\u0006\u0002\u0010-J&\u0010.\u001a\u00020,2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010#JB\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u00102J4\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020,H\u0096@\u00a2\u0006\u0002\u00108J\u001e\u00109\u001a\u00020%2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010<J\u001c\u0010=\u001a\u00020%2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0096@\u00a2\u0006\u0002\u0010?J:\u0010@\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010BJ2\u0010C\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u00122\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\rH\u0096@\u00a2\u0006\u0002\u0010DJR\u0010E\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010F\u001a\u0004\u0018\u00010G2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\r2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010I\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010JJ\u001c\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0\r0\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010M\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010N\u001a\u0002012\u0006\u0010O\u001a\u00020PH\u0096@\u00a2\u0006\u0002\u0010QJ&\u0010R\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010N\u001a\u0002012\u0006\u0010S\u001a\u00020PH\u0096@\u00a2\u0006\u0002\u0010QJ\u001e\u0010T\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010N\u001a\u000201H\u0096@\u00a2\u0006\u0002\u0010UJ\u001c\u0010V\u001a\u00020%2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020L0\rH\u0096@\u00a2\u0006\u0002\u0010?J\u001e\u0010X\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020ZH\u0096@\u00a2\u0006\u0002\u0010[R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Ldata/artist/ArtistRepository;", "Ldata/artist/ArtistRepositoryApi;", "local", "Ldata/artist/ArtistLocalApi;", "remote", "Ldata/artist/ArtistRemoteApi;", "logger", "Ldi/MultiLogger;", "settings", "Lcom/russhwolf/settings/Settings;", "<init>", "(Ldata/artist/ArtistLocalApi;Ldata/artist/ArtistRemoteApi;Ldi/MultiLogger;Lcom/russhwolf/settings/Settings;)V", "getArtistList", "", "Ldata/artist/model/Artist;", "accountId", "", "yearData", "Ldata/account/model/YearData;", "getArtistListFlow", "Lkotlinx/coroutines/flow/Flow;", "Ldata/account/ResultOf;", "contentSource", "Ldi/ContentSource;", "currentVersionState", "Ldata/artist/CurrentVersionState;", "listenForRemoteEventUpdates", "(Ljava/lang/String;Ldata/account/model/YearData;Ldi/ContentSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listenForLocalEventUpdates", "eventId", "(Ljava/lang/String;Ldi/ContentSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentVersionState", "(Ldi/ContentSource;Ldata/account/model/YearData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ldi/ContentSource;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentVersionStateRemoteIfNoLocal", "(Ldi/ContentSource;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateCurrentVersionState", "", "(Ldata/artist/CurrentVersionState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRemoteCurrentVersionState", "(Ldi/ContentSource;Ljava/lang/String;Ldata/account/model/YearData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRemoteCurrentVersionStateWithoutCaching", "scheduleChangeAcknowledged", "versionAcknowledged", "", "(Ldi/ContentSource;Ljava/lang/String;Ldata/account/model/YearData;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastAcknowledgedScheduleChange", "checkForUpdates", "fullPerformanceList", "Lmodels/DisplayPerformance;", "(Ljava/util/List;Ldi/ContentSource;Ljava/lang/String;Ldata/account/model/YearData;Ldata/artist/CurrentVersionState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDraftChanges", "account", "Ldata/account/model/Account;", "currentVersion", "newVersion", "(Ldata/account/model/Account;Ldata/account/model/YearData;JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearArtistData", "loadedAccount", "activeYearData", "(Ldata/account/model/Account;Ldata/account/model/YearData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadArtistList", "festivalData", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateDraftSchedule", "artistList", "(Ldata/account/model/Account;Ldata/account/model/YearData;Ljava/util/List;Ldata/artist/CurrentVersionState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishDraftLineupToWebsite", "(Ldata/account/model/Account;Ldata/account/model/YearData;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishDraftToLive", "currentPublishedEvent", "Ldata/publishedevents/models/PublishedEvent;", "changedArtistList", "updatedCurrentVersionState", "(Ldata/account/model/Account;Ldata/account/model/YearData;Ldata/publishedevents/models/PublishedEvent;Ljava/util/List;Ljava/util/List;Ldata/artist/CurrentVersionState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFavoriteListFlow", "Ldata/artist/model/FavoritePerformance;", "addFavorite", "displayPerformance", "favoriteRank", "Ldata/artist/model/FavoriteRank;", "(Ldi/ContentSource;Lmodels/DisplayPerformance;Ldata/artist/model/FavoriteRank;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateFavoriteRank", "rank", "removeFavorite", "(Ldi/ContentSource;Lmodels/DisplayPerformance;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "migrateRoomFavorites", "favoriteList", "updateLastSeen", "newLastSeen", "Lkotlinx/datetime/LocalDateTime;", "(Ldata/artist/CurrentVersionState;Lkotlinx/datetime/LocalDateTime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nArtistRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtistRepository.kt\ndata/artist/ArtistRepository\n+ 2 CooperativeCatch.kt\nui/screens/accountoverview/CooperativeCatchKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,402:1\n7#2,6:403\n7#2,6:409\n7#2,6:415\n7#2,6:424\n7#2,6:430\n7#2,6:436\n774#3:421\n865#3,2:422\n*S KotlinDebug\n*F\n+ 1 ArtistRepository.kt\ndata/artist/ArtistRepository\n*L\n146#1:403,6\n156#1:409,6\n174#1:415,6\n326#1:424,6\n336#1:430,6\n353#1:436,6\n306#1:421\n306#1:422,2\n*E\n"})
public final class ArtistRepository
implements ArtistRepositoryApi {
    @NotNull
    private final ArtistLocalApi local;
    @NotNull
    private final ArtistRemoteApi remote;
    @NotNull
    private final MultiLogger logger;
    @NotNull
    private final Settings settings;
    public static final int $stable = 8;

    public ArtistRepository(@NotNull ArtistLocalApi local, @NotNull ArtistRemoteApi remote, @NotNull MultiLogger logger, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.local = local;
        this.remote = remote;
        this.logger = logger;
        this.settings = settings;
    }

    @Override
    @NotNull
    public List<Artist> getArtistList(@NotNull String accountId, @NotNull YearData yearData) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        return this.local.getArtists(yearData);
    }

    @Override
    @NotNull
    public Flow<ResultOf<List<Artist>>> getArtistListFlow(@NotNull ContentSource contentSource, @NotNull CurrentVersionState currentVersionState, @NotNull String accountId, @NotNull YearData yearData) {
        Intrinsics.checkNotNullParameter((Object)contentSource, (String)"contentSource");
        Intrinsics.checkNotNullParameter((Object)currentVersionState, (String)"currentVersionState");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        this.logger.i("getArtistListFlow: Current Artist Version " + currentVersionState.getArtistVersion());
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ResultOf<? extends List<? extends Artist>>>, Continuation<? super Unit>, Object>(this, yearData, contentSource, currentVersionState, accountId, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ArtistRepository this$0;
            final /* synthetic */ YearData $yearData;
            final /* synthetic */ ContentSource $contentSource;
            final /* synthetic */ CurrentVersionState $currentVersionState;
            final /* synthetic */ String $accountId;
            {
                this.this$0 = $receiver;
                this.$yearData = $yearData;
                this.$contentSource = $contentSource;
                this.$currentVersionState = $currentVersionState;
                this.$accountId = $accountId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                FlowCollector flowCollector = (FlowCollector)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$flow;
                        ResultKt.throwOnFailure((Object)$result);
                        Flow<List<Artist>> artistListFlow = ArtistRepository.access$getLocal$p(this.this$0).getArtistsFlow(this.$yearData);
                        this.L$0 = $this$flow;
                        this.L$1 = artistListFlow;
                        this.label = 1;
                        Object object2 = artistListFlow.collect(new FlowCollector((FlowCollector<? super ResultOf<? extends List<Artist>>>)$this$flow, this.$contentSource, this.$currentVersionState, this.this$0, this.$yearData, this.$accountId){
                            final /* synthetic */ FlowCollector<ResultOf<? extends List<Artist>>> $$this$flow;
                            final /* synthetic */ ContentSource $contentSource;
                            final /* synthetic */ CurrentVersionState $currentVersionState;
                            final /* synthetic */ ArtistRepository this$0;
                            final /* synthetic */ YearData $yearData;
                            final /* synthetic */ String $accountId;
                            {
                                this.$$this$flow = $$this$flow;
                                this.$contentSource = $contentSource;
                                this.$currentVersionState = $currentVersionState;
                                this.this$0 = $receiver;
                                this.$yearData = $yearData;
                                this.$accountId = $accountId;
                            }

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Unable to fully structure code
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object emit(List<Artist> artistList, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof getArtistListFlow.emit.1)) ** GOTO lbl-1000
                                var7_3 = $completion;
                                if ((var7_3.label & -2147483648) != 0) {
                                    var7_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        Object L$1;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ getArtistListFlow.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (((Collection)artistList).isEmpty() == false) {
                                            $continuation.L$0 = artistList;
                                            $continuation.label = 1;
                                            v0 = this.$$this$flow.emit(new ResultOf.Success<List>(artistList), (Continuation)$continuation);
                                            if (v0 != var8_5) return Unit.INSTANCE;
                                            return var8_5;
                                        }
                                        ** GOTO lbl24
                                    }
                                    case 1: {
                                        artistList = (List)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        return Unit.INSTANCE;
                                    }
lbl24:
                                    // 1 sources

                                    if (!(this.$contentSource instanceof ContentSource.Live) || this.$currentVersionState.getArtistVersion() == 0L) ** GOTO lbl61
                                    try {
                                        $continuation.L$0 = artistList;
                                        $continuation.label = 2;
                                        v1 = ArtistRepository.access$getRemote$p(this.this$0).getArtistListR2(this.$yearData, this.$currentVersionState, (Continuation<? super ResultOf<? extends List<Artist>>>)$continuation);
                                    }
                                    catch (Exception exception) {
                                        if (exception instanceof CancellationException) {
                                            throw exception;
                                        }
                                        ArtistRepository.access$getLogger$p(this.this$0).e("getArtistListFlow: Error Fetching Cloudflare Artist Data. Reverting to Firebase", exception);
                                        $continuation.L$0 = artistList;
                                        $continuation.L$1 = exception;
                                        $continuation.label = 3;
                                        v2 = ArtistRepository.access$getRemote$p(this.this$0).getArtistList(this.$accountId, this.$yearData, (Continuation<? super ResultOf<? extends List<Artist>>>)$continuation);
                                        if (v2 == var8_5) {
                                            return var8_5;
                                        }
                                        ** GOTO lbl58
                                    }
                                    v3 = v1;
                                    if (v1 == var8_5) {
                                        return var8_5;
                                    }
                                    ** GOTO lbl51
                                    case 2: {
                                        artistList = (List)$continuation.L$0;
                                        {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v3 = $result;
lbl51:
                                            // 2 sources

                                            var4_6 = (ResultOf)v3;
                                            ** GOTO lbl59
                                        }
                                    }
                                    case 3: {
                                        exception = (Exception)$continuation.L$1;
                                        artistList = (List)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl58:
                                        // 2 sources

                                        var4_6 = (ResultOf)v2;
lbl59:
                                        // 2 sources

                                        v4 = var4_6;
                                        ** GOTO lbl75
                                    }
lbl61:
                                    // 1 sources

                                    if (this.$currentVersionState.getYearDataVersion() == 0L) {
                                        ArtistRepository.access$getLogger$p(this.this$0).e("getArtistListFlow has a 0 artistVersion currentVersionState");
                                    }
                                    ArtistRepository.access$getLogger$p(this.this$0).i("getArtistListFlow: Getting Firebase Artist List");
                                    $continuation.L$0 = artistList;
                                    $continuation.label = 4;
                                    v5 = ArtistRepository.access$getRemote$p(this.this$0).getArtistList(this.$accountId, this.$yearData, (Continuation<? super ResultOf<? extends List<Artist>>>)$continuation);
                                    if (v5 == var8_5) {
                                        return var8_5;
                                    }
                                    ** GOTO lbl74
                                    case 4: {
                                        artistList = (List)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v5 = $result;
lbl74:
                                        // 2 sources

                                        v4 = (ResultOf)v5;
lbl75:
                                        // 2 sources

                                        var4_6 = remoteArtistList = v4;
                                        if (var4_6 instanceof ResultOf.Failure) {
                                            $continuation.L$0 = artistList;
                                            $continuation.L$1 = remoteArtistList;
                                            $continuation.label = 5;
                                            v6 = this.$$this$flow.emit((Object)new ResultOf.Failure(((ResultOf.Failure)remoteArtistList).getException()), (Continuation)$continuation);
                                            if (v6 != var8_5) return Unit.INSTANCE;
                                            return var8_5;
                                        }
                                        ** GOTO lbl90
                                    }
                                    case 5: {
                                        remoteArtistList = (ResultOf)$continuation.L$1;
                                        artistList = (List)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v6 = $result;
                                        return Unit.INSTANCE;
                                    }
lbl90:
                                    // 1 sources

                                    if (!(var4_6 instanceof ResultOf.Success)) {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                    if (((List)((ResultOf.Success)remoteArtistList).getResult()).isEmpty()) {
                                        $continuation.L$0 = artistList;
                                        $continuation.L$1 = remoteArtistList;
                                        $continuation.label = 6;
                                        v7 = this.$$this$flow.emit(new ResultOf.Success<List>(CollectionsKt.emptyList()), (Continuation)$continuation);
                                        if (v7 != var8_5) return Unit.INSTANCE;
                                        return var8_5;
                                    }
                                    ** GOTO lbl106
                                    case 6: {
                                        remoteArtistList = (ResultOf)$continuation.L$1;
                                        artistList = (List)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v7 = $result;
                                        return Unit.INSTANCE;
                                    }
lbl106:
                                    // 1 sources

                                    ArtistRepository.access$getLogger$p(this.this$0).i("Updating database with new changes");
                                    $continuation.L$0 = artistList;
                                    $continuation.L$1 = remoteArtistList;
                                    $continuation.label = 7;
                                    v8 = ArtistRepository.access$getLocal$p(this.this$0).updateArtistList((List)((ResultOf.Success)remoteArtistList).getResult(), (Continuation<? super Unit>)$continuation);
                                    if (v8 != var8_5) return Unit.INSTANCE;
                                    return var8_5;
                                    case 7: {
                                        remoteArtistList = (ResultOf)$continuation.L$1;
                                        artistList = (List)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v8 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Flow artistListFlow = (Flow)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super ResultOf<? extends List<Artist>>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @Nullable
    public Object listenForRemoteEventUpdates(@NotNull String accountId, @NotNull YearData yearData, @NotNull ContentSource contentSource, @NotNull Continuation<? super Flow<? extends ResultOf<CurrentVersionState>>> $completion) {
        return this.remote.listenForEventUpdates(accountId, yearData, contentSource, $completion);
    }

    @Override
    @Nullable
    public Object listenForLocalEventUpdates(@NotNull String eventId, @NotNull ContentSource contentSource, @NotNull Continuation<? super Flow<? extends ResultOf<CurrentVersionState>>> $completion) {
        return this.local.listenForEventUpdates(eventId, contentSource, $completion);
    }

    @Override
    @Nullable
    public Object getCurrentVersionState(@NotNull ContentSource contentSource, @NotNull YearData yearData, @NotNull Continuation<? super CurrentVersionState> $completion) {
        return this.getCurrentVersionState(contentSource, yearData.getEventId(), $completion);
    }

    @Override
    @Nullable
    public Object getCurrentVersionState(@NotNull ContentSource contentSource, @NotNull String eventId, @NotNull Continuation<? super CurrentVersionState> $completion) {
        return this.local.getCurrentVersionState(contentSource, eventId, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getCurrentVersionStateRemoteIfNoLocal(@NotNull ContentSource contentSource, @NotNull String accountId, @NotNull String eventId, @NotNull Continuation<? super CurrentVersionState> $completion) {
        if (!($completion instanceof getCurrentVersionStateRemoteIfNoLocal.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCurrentVersionStateRemoteIfNoLocal(null, null, null, (Continuation<? super CurrentVersionState>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = contentSource;
                $continuation.L$1 = accountId;
                $continuation.L$2 = eventId;
                $continuation.label = 1;
                v0 = this.local.getCurrentVersionState(contentSource, eventId, (Continuation<? super CurrentVersionState>)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                eventId = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                contentSource = (ContentSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((localVersion = (CurrentVersionState)v0).getYearDataVersion() != 0L) break;
                $continuation.L$0 = contentSource;
                $continuation.L$1 = accountId;
                $continuation.L$2 = eventId;
                $continuation.L$3 = localVersion;
                $continuation.label = 2;
                v1 = this.getRemoteCurrentVersionState(contentSource, accountId, eventId, (Continuation<? super ResultOf<CurrentVersionState>>)$continuation);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl43
            }
            case 2: {
                localVersion = (CurrentVersionState)$continuation.L$3;
                eventId = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                contentSource = (ContentSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                if ((var7_10 = (result = (ResultOf)v1)) instanceof ResultOf.Failure) {
                    v2 = localVersion;
                } else if (var7_10 instanceof ResultOf.Success) {
                    v2 = (CurrentVersionState)((ResultOf.Success)result).getResult();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return v2;
            }
        }
        return localVersion;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object updateCurrentVersionState(@NotNull CurrentVersionState currentVersionState, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.local.updateCurrentVersionState(currentVersionState, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getRemoteCurrentVersionState(@NotNull ContentSource contentSource, @NotNull String accountId, @NotNull YearData yearData, @NotNull Continuation<? super ResultOf<CurrentVersionState>> $completion) {
        if (!($completion instanceof getRemoteCurrentVersionState.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRemoteCurrentVersionState((ContentSource)null, (String)null, (YearData)null, (Continuation<? super ResultOf<CurrentVersionState>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$cooperativeCatch$iv = this;
                $i$f$cooperativeCatch = 0;
                $this$getRemoteCurrentVersionState_u24lambda_u240 = $this$cooperativeCatch$iv;
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$2 = 0;
                $continuation.L$0 = contentSource;
                $continuation.L$1 = accountId;
                $continuation.L$2 = yearData;
                $continuation.L$3 = $this$cooperativeCatch$iv;
                $continuation.L$4 = $this$getRemoteCurrentVersionState_u24lambda_u240;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$2;
                $continuation.label = 1;
                v0 = $this$getRemoteCurrentVersionState_u24lambda_u240.getRemoteCurrentVersionState(contentSource, accountId, yearData.getEventId(), (Continuation<? super ResultOf<CurrentVersionState>>)$continuation);
                ** if (v0 != var13_7) goto lbl29
lbl28:
                // 1 sources

                return var13_7;
lbl29:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$2 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                $this$getRemoteCurrentVersionState_u24lambda_u240 = (ArtistRepository)$continuation.L$4;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$3;
                yearData = (YearData)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                contentSource = (ContentSource)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl42:
                    // 2 sources

                    var9_16 = (ResultOf)v0;
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Exception e$iv) {
                    var9_16 = new ResultOf.Failure(e$iv);
                }
                return var9_16;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object getRemoteCurrentVersionState(@NotNull ContentSource contentSource, @NotNull String accountId, @NotNull String eventId, @NotNull Continuation<? super ResultOf<CurrentVersionState>> $completion) {
        if (!($completion instanceof getRemoteCurrentVersionState.3)) ** GOTO lbl-1000
        var14_5 = $completion;
        if ((var14_5.label & -2147483648) != 0) {
            var14_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRemoteCurrentVersionState((ContentSource)null, (String)null, (String)null, (Continuation<? super ResultOf<CurrentVersionState>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$cooperativeCatch$iv = this;
                $i$f$cooperativeCatch = 0;
                $this$getRemoteCurrentVersionState_u24lambda_u241 = $this$cooperativeCatch$iv;
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$4 = 0;
                $continuation.L$0 = contentSource;
                $continuation.L$1 = accountId;
                $continuation.L$2 = eventId;
                $continuation.L$3 = $this$cooperativeCatch$iv;
                $continuation.L$4 = $this$getRemoteCurrentVersionState_u24lambda_u241;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$4;
                $continuation.label = 1;
                v0 = $this$getRemoteCurrentVersionState_u24lambda_u241.remote.getCurrentVersionState(contentSource, accountId, eventId, (Continuation<? super ResultOf<CurrentVersionState>>)$continuation);
                ** if (v0 != var15_7) goto lbl29
lbl28:
                // 1 sources

                return var15_7;
lbl29:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$4 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                $this$getRemoteCurrentVersionState_u24lambda_u241 = (ArtistRepository)$continuation.L$4;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$3;
                eventId = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                contentSource = (ContentSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 2 sources

                if ((var10_17 = (remoteResult = (ResultOf)v0)) instanceof ResultOf.Failure) {
                    v1 = remoteResult;
                    return v1;
                }
                if (var10_17 instanceof ResultOf.Success == false) throw new NoWhenBranchMatchedException();
                $continuation.L$0 = contentSource;
                $continuation.L$1 = accountId;
                $continuation.L$2 = eventId;
                $continuation.L$3 = $this$cooperativeCatch$iv;
                $continuation.L$4 = $this$getRemoteCurrentVersionState_u24lambda_u241;
                $continuation.L$5 = remoteResult;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$4;
                $continuation.label = 2;
                v2 = $this$getRemoteCurrentVersionState_u24lambda_u241.local.updateCurrentVersionState((CurrentVersionState)((ResultOf.Success)remoteResult).getResult(), (Continuation<? super Unit>)$continuation);
                ** if (v2 != var15_7) goto lbl58
lbl57:
                // 1 sources

                return var15_7;
lbl58:
                // 1 sources

                ** GOTO lbl72
            }
            case 2: {
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionState$4 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                remoteResult = (ResultOf)$continuation.L$5;
                $this$getRemoteCurrentVersionState_u24lambda_u241 = (ArtistRepository)$continuation.L$4;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$3;
                eventId = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                contentSource = (ContentSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl72:
                // 2 sources

                v1 = remoteResult;
                return v1;
            }
        }
        catch (CancellationException e$iv) {
            throw e$iv;
        }
        catch (Exception e$iv) {
            return new ResultOf.Failure(e$iv);
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getRemoteCurrentVersionStateWithoutCaching(@NotNull ContentSource contentSource, @NotNull String accountId, @NotNull String eventId, @NotNull Continuation<? super ResultOf<CurrentVersionState>> $completion) {
        if (!($completion instanceof getRemoteCurrentVersionStateWithoutCaching.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRemoteCurrentVersionStateWithoutCaching(null, null, null, (Continuation<? super ResultOf<CurrentVersionState>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$cooperativeCatch$iv = this;
                $i$f$cooperativeCatch = 0;
                $this$getRemoteCurrentVersionStateWithoutCaching_u24lambda_u242 = $this$cooperativeCatch$iv;
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionStateWithoutCaching$2 = 0;
                $continuation.L$0 = contentSource;
                $continuation.L$1 = accountId;
                $continuation.L$2 = eventId;
                $continuation.L$3 = $this$cooperativeCatch$iv;
                $continuation.L$4 = $this$getRemoteCurrentVersionStateWithoutCaching_u24lambda_u242;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionStateWithoutCaching$2;
                $continuation.label = 1;
                v0 = $this$getRemoteCurrentVersionStateWithoutCaching_u24lambda_u242.remote.getCurrentVersionState(contentSource, accountId, eventId, (Continuation<? super ResultOf<CurrentVersionState>>)$continuation);
                ** if (v0 != var13_7) goto lbl29
lbl28:
                // 1 sources

                return var13_7;
lbl29:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                $i$a$-cooperativeCatch-ArtistRepository$getRemoteCurrentVersionStateWithoutCaching$2 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                $this$getRemoteCurrentVersionStateWithoutCaching_u24lambda_u242 = (ArtistRepository)$continuation.L$4;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$3;
                eventId = (String)$continuation.L$2;
                accountId = (String)$continuation.L$1;
                contentSource = (ContentSource)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl42:
                    // 2 sources

                    var9_16 = (ResultOf)v0;
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Exception e$iv) {
                    var9_16 = new ResultOf.Failure(e$iv);
                }
                return var9_16;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object scheduleChangeAcknowledged(@NotNull ContentSource contentSource, @NotNull String accountId, @NotNull YearData yearData, long versionAcknowledged, @NotNull Continuation<? super Unit> $completion) {
        String lastAcknowledgedKey = contentSource.getNamed() + yearData.getEventId() + "ScheduledUpdatedKey";
        this.logger.i("******* About to Update acknowledge latest version update " + versionAcknowledged);
        this.settings.putLong(lastAcknowledgedKey, versionAcknowledged);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLastAcknowledgedScheduleChange(@NotNull ContentSource contentSource, @NotNull String accountId, @NotNull String eventId, @NotNull Continuation<? super Long> $completion) {
        String lastAcknowledgedKey = contentSource.getNamed() + eventId + "ScheduledUpdatedKey";
        return Boxing.boxLong((long)this.settings.getLong(lastAcknowledgedKey, 0L));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object checkForUpdates(@NotNull List<DisplayPerformance> fullPerformanceList, @NotNull ContentSource contentSource, @NotNull String accountId, @NotNull YearData yearData, @NotNull CurrentVersionState currentVersionState, @NotNull Continuation<? super List<Artist>> $completion) {
        block19: {
            block17: {
                block18: {
                    if (!($completion instanceof checkForUpdates.1)) ** GOTO lbl-1000
                    var14_7 = $completion;
                    if ((var14_7.label & -2147483648) != 0) {
                        var14_7.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            long J$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ ArtistRepository this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.checkForUpdates(null, null, null, null, null, (Continuation<? super List<Artist>>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var15_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            lastAcknowledgedKey = contentSource.getNamed() + yearData.getEventId() + "ScheduledUpdatedKey";
                            lastAcknowledgedVersion = this.settings.getLong((String)lastAcknowledgedKey, 0L);
                            this.logger.i("AAA Current Loaded " + contentSource.getNamed() + ": " + lastAcknowledgedVersion);
                            this.logger.i("AAA Remote " + contentSource.getNamed() + ": " + currentVersionState.getVersion());
                            if (lastAcknowledgedVersion != 0L) break;
                            $continuation.L$0 = fullPerformanceList;
                            $continuation.L$1 = contentSource;
                            $continuation.L$2 = accountId;
                            $continuation.L$3 = yearData;
                            $continuation.L$4 = currentVersionState;
                            $continuation.L$5 = lastAcknowledgedKey;
                            $continuation.J$0 = lastAcknowledgedVersion;
                            $continuation.label = 1;
                            v0 = this.scheduleChangeAcknowledged(contentSource, accountId, yearData, currentVersionState.getArtistVersion(), (Continuation<? super Unit>)$continuation);
                            if (v0 == var15_9) {
                                return var15_9;
                            }
                            ** GOTO lbl39
                        }
                        case 1: {
                            lastAcknowledgedVersion = $continuation.J$0;
                            lastAcknowledgedKey = (String)$continuation.L$5;
                            currentVersionState = (CurrentVersionState)$continuation.L$4;
                            yearData = (YearData)$continuation.L$3;
                            accountId = (String)$continuation.L$2;
                            contentSource = (ContentSource)$continuation.L$1;
                            fullPerformanceList = (List)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl39:
                            // 2 sources

                            return CollectionsKt.emptyList();
                        }
                    }
                    if (currentVersionState.getArtistVersion() == 0L) {
                        this.logger.i("First Load, ignore version updates");
                        return CollectionsKt.emptyList();
                    }
                    if (currentVersionState.getArtistVersion() == lastAcknowledgedVersion) {
                        this.logger.i("No need to fetch new data");
                        return CollectionsKt.emptyList();
                    }
                    this.logger.i("returning remote results");
                    if (!(contentSource instanceof ContentSource.Live)) break block17;
                    $continuation.L$0 = fullPerformanceList;
                    $continuation.L$1 = contentSource;
                    $continuation.L$2 = accountId;
                    $continuation.L$3 = yearData;
                    $continuation.L$4 = currentVersionState;
                    $continuation.L$5 = lastAcknowledgedKey;
                    $continuation.J$0 = lastAcknowledgedVersion;
                    $continuation.label = 2;
                    v1 = this.remote.getNewChangesR2(fullPerformanceList, accountId, yearData, lastAcknowledgedVersion, currentVersionState, (Continuation<? super ResultOf<? extends List<Artist>>>)$continuation);
                    if (v1 == var15_9) {
                        return var15_9;
                    }
                    ** GOTO lbl70
                    {
                        case 2: {
                            lastAcknowledgedVersion = $continuation.J$0;
                            lastAcknowledgedKey = (String)$continuation.L$5;
                            currentVersionState = (CurrentVersionState)$continuation.L$4;
                            yearData = (YearData)$continuation.L$3;
                            accountId = (String)$continuation.L$2;
                            contentSource = (ContentSource)$continuation.L$1;
                            fullPerformanceList = (List)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl70:
                            // 2 sources

                            if (!((var12_17 = (result = (ResultOf)v1)) instanceof ResultOf.Failure)) break;
                            this.logger.e("checkForUpdates R2: Error Fetching Cloudflare Artist Data. Reverting to Firebase", ((ResultOf.Failure)result).getException());
                            $continuation.L$0 = fullPerformanceList;
                            $continuation.L$1 = contentSource;
                            $continuation.L$2 = accountId;
                            $continuation.L$3 = yearData;
                            $continuation.L$4 = currentVersionState;
                            $continuation.L$5 = lastAcknowledgedKey;
                            $continuation.L$6 = result;
                            $continuation.J$0 = lastAcknowledgedVersion;
                            $continuation.label = 3;
                            v2 = this.remote.getNewChanges(accountId, yearData, lastAcknowledgedVersion, currentVersionState.getArtistVersion(), (Continuation<? super ResultOf<? extends List<Artist>>>)$continuation);
                            if (v2 == var15_9) {
                                return var15_9;
                            }
                            ** GOTO lbl96
                        }
                        case 3: {
                            lastAcknowledgedVersion = $continuation.J$0;
                            result = (ResultOf)$continuation.L$6;
                            lastAcknowledgedKey = (String)$continuation.L$5;
                            currentVersionState = (CurrentVersionState)$continuation.L$4;
                            yearData = (YearData)$continuation.L$3;
                            accountId = (String)$continuation.L$2;
                            contentSource = (ContentSource)$continuation.L$1;
                            fullPerformanceList = (List)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl96:
                            // 2 sources

                            v3 = (ResultOf)v2;
                            ** GOTO lbl127
                        }
                    }
                    if (!(var12_17 instanceof ResultOf.Success)) break block18;
                    v3 = result;
                    ** GOTO lbl127
                }
                throw new NoWhenBranchMatchedException();
            }
            $continuation.L$0 = fullPerformanceList;
            $continuation.L$1 = contentSource;
            $continuation.L$2 = accountId;
            $continuation.L$3 = yearData;
            $continuation.L$4 = currentVersionState;
            $continuation.L$5 = lastAcknowledgedKey;
            $continuation.J$0 = lastAcknowledgedVersion;
            $continuation.label = 4;
            v4 = this.remote.getNewChanges(accountId, yearData, lastAcknowledgedVersion, currentVersionState.getArtistVersion(), (Continuation<? super ResultOf<? extends List<Artist>>>)$continuation);
            if (v4 == var15_9) {
                return var15_9;
            }
            ** GOTO lbl126
            {
                case 4: {
                    lastAcknowledgedVersion = $continuation.J$0;
                    lastAcknowledgedKey = (String)$continuation.L$5;
                    currentVersionState = (CurrentVersionState)$continuation.L$4;
                    yearData = (YearData)$continuation.L$3;
                    accountId = (String)$continuation.L$2;
                    contentSource = (ContentSource)$continuation.L$1;
                    fullPerformanceList = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl126:
                    // 2 sources

                    v3 = (ResultOf)v4;
lbl127:
                    // 3 sources

                    var11_16 = newArtistList = v3;
                    if (!(var11_16 instanceof ResultOf.Failure)) ** GOTO lbl132
                    this.logger.e("Error checking for updates " + ((ResultOf.Failure)newArtistList).getException(), ((ResultOf.Failure)newArtistList).getException());
                    v5 = CollectionsKt.emptyList();
                    break block19;
lbl132:
                    // 1 sources

                    if (!(var11_16 instanceof ResultOf.Success)) break;
                    if (!((List)((ResultOf.Success)newArtistList).getResult()).isEmpty()) ** GOTO lbl139
                    this.logger.i("Success But No Changes Found");
                    this.settings.putLong("lastVersionNotified" + yearData.getEventId(), currentVersionState.getArtistVersion());
                    this.settings.putLong((String)lastAcknowledgedKey, currentVersionState.getArtistVersion());
                    v5 = CollectionsKt.emptyList();
                    break block19;
lbl139:
                    // 1 sources

                    this.logger.i("Success Found " + ((ResultOf.Success)newArtistList).getResult());
                    $continuation.L$0 = fullPerformanceList;
                    $continuation.L$1 = contentSource;
                    $continuation.L$2 = accountId;
                    $continuation.L$3 = yearData;
                    $continuation.L$4 = currentVersionState;
                    $continuation.L$5 = lastAcknowledgedKey;
                    $continuation.L$6 = newArtistList;
                    $continuation.J$0 = lastAcknowledgedVersion;
                    $continuation.label = 5;
                    v6 = this.local.updateArtistList((List)((ResultOf.Success)newArtistList).getResult(), (Continuation<? super Unit>)$continuation);
                    if (v6 == var15_9) {
                        return var15_9;
                    }
                    ** GOTO lbl164
                }
                case 5: {
                    lastAcknowledgedVersion = $continuation.J$0;
                    newArtistList = (ResultOf)$continuation.L$6;
                    lastAcknowledgedKey = (String)$continuation.L$5;
                    currentVersionState = (CurrentVersionState)$continuation.L$4;
                    yearData = (YearData)$continuation.L$3;
                    accountId = (String)$continuation.L$2;
                    contentSource = (ContentSource)$continuation.L$1;
                    fullPerformanceList = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl164:
                    // 2 sources

                    v5 = (List)((ResultOf.Success)newArtistList).getResult();
                    break block19;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getDraftChanges(@NotNull Account account, @NotNull YearData yearData, long currentVersion, long newVersion, @NotNull Continuation<? super List<Artist>> $completion) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.local.getArtists(yearData);
        boolean $i$f$filter = false;
        void var10_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Artist it = (Artist)element$iv$iv;
            boolean bl = false;
            if (!((long)it.getVersion() > currentVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object clearArtistData(@NotNull Account loadedAccount, @NotNull YearData activeYearData, @NotNull Continuation<? super Unit> $completion) {
        this.local.clearArtists(loadedAccount, activeYearData);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object uploadArtistList(@NotNull List<Artist> festivalData, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object updateDraftSchedule(@NotNull Account account, @NotNull YearData yearData, @NotNull List<Artist> artistList, @NotNull CurrentVersionState currentVersionState, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        if (!($completion instanceof updateDraftSchedule.1)) ** GOTO lbl-1000
        var13_6 = $completion;
        if ((var13_6.label & -2147483648) != 0) {
            var13_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateDraftSchedule(null, null, null, null, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$cooperativeCatch$iv = this;
                $i$f$cooperativeCatch = 0;
                $this$updateDraftSchedule_u24lambda_u244 = $this$cooperativeCatch$iv;
                $i$a$-cooperativeCatch-ArtistRepository$updateDraftSchedule$2 = 0;
                $continuation.L$0 = account;
                $continuation.L$1 = yearData;
                $continuation.L$2 = artistList;
                $continuation.L$3 = currentVersionState;
                $continuation.L$4 = $this$cooperativeCatch$iv;
                $continuation.L$5 = $this$updateDraftSchedule_u24lambda_u244;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$updateDraftSchedule$2;
                $continuation.label = 1;
                v0 = $this$updateDraftSchedule_u24lambda_u244.remote.updateDraftSchedule(account, yearData, artistList, currentVersionState, (Continuation<? super ResultOf<Unit>>)$continuation);
                ** if (v0 != var14_8) goto lbl30
lbl29:
                // 1 sources

                return var14_8;
lbl30:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                $i$a$-cooperativeCatch-ArtistRepository$updateDraftSchedule$2 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                $this$updateDraftSchedule_u24lambda_u244 = (ArtistRepository)$continuation.L$5;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$4;
                currentVersionState = (CurrentVersionState)$continuation.L$3;
                artistList = (List)$continuation.L$2;
                yearData = (YearData)$continuation.L$1;
                account = (Account)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl44:
                    // 2 sources

                    var10_17 = (ResultOf)v0;
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Exception e$iv) {
                    var10_17 = new ResultOf.Failure(e$iv);
                }
                return var10_17;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object publishDraftLineupToWebsite(@NotNull Account account, @NotNull YearData yearData, @NotNull List<DisplayPerformance> fullPerformanceList, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        if (!($completion instanceof publishDraftLineupToWebsite.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.publishDraftLineupToWebsite(null, null, null, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$cooperativeCatch$iv = this;
                $i$f$cooperativeCatch = 0;
                $this$publishDraftLineupToWebsite_u24lambda_u245 = $this$cooperativeCatch$iv;
                $i$a$-cooperativeCatch-ArtistRepository$publishDraftLineupToWebsite$2 = 0;
                $continuation.L$0 = account;
                $continuation.L$1 = yearData;
                $continuation.L$2 = fullPerformanceList;
                $continuation.L$3 = $this$cooperativeCatch$iv;
                $continuation.L$4 = $this$publishDraftLineupToWebsite_u24lambda_u245;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$publishDraftLineupToWebsite$2;
                $continuation.label = 1;
                v0 = $this$publishDraftLineupToWebsite_u24lambda_u245.remote.publishDraftLineupToWebsite(account, yearData, fullPerformanceList, (Continuation<? super ResultOf<Unit>>)$continuation);
                ** if (v0 != var13_7) goto lbl29
lbl28:
                // 1 sources

                return var13_7;
lbl29:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                $i$a$-cooperativeCatch-ArtistRepository$publishDraftLineupToWebsite$2 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                $this$publishDraftLineupToWebsite_u24lambda_u245 = (ArtistRepository)$continuation.L$4;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$3;
                fullPerformanceList = (List)$continuation.L$2;
                yearData = (YearData)$continuation.L$1;
                account = (Account)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl43:
                    // 2 sources

                    var9_16 = (ResultOf)v0;
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Exception e$iv) {
                    var9_16 = new ResultOf.Failure(e$iv);
                }
                return var9_16;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object publishDraftToLive(@NotNull Account account, @NotNull YearData yearData, @Nullable PublishedEvent currentPublishedEvent, @NotNull List<DisplayPerformance> fullPerformanceList, @NotNull List<Artist> changedArtistList, @NotNull CurrentVersionState updatedCurrentVersionState, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        if (!($completion instanceof publishDraftToLive.1)) ** GOTO lbl-1000
        var15_8 = $completion;
        if ((var15_8.label & -2147483648) != 0) {
            var15_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ArtistRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.publishDraftToLive(null, null, null, null, null, null, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$cooperativeCatch$iv = this;
                $i$f$cooperativeCatch = 0;
                $this$publishDraftToLive_u24lambda_u246 = $this$cooperativeCatch$iv;
                $i$a$-cooperativeCatch-ArtistRepository$publishDraftToLive$2 = 0;
                $continuation.L$0 = account;
                $continuation.L$1 = yearData;
                $continuation.L$2 = currentPublishedEvent;
                $continuation.L$3 = fullPerformanceList;
                $continuation.L$4 = changedArtistList;
                $continuation.L$5 = updatedCurrentVersionState;
                $continuation.L$6 = $this$cooperativeCatch$iv;
                $continuation.L$7 = $this$publishDraftToLive_u24lambda_u246;
                $continuation.I$0 = $i$f$cooperativeCatch;
                $continuation.I$1 = $i$a$-cooperativeCatch-ArtistRepository$publishDraftToLive$2;
                $continuation.label = 1;
                v0 = $this$publishDraftToLive_u24lambda_u246.remote.publishDraftToLive(account, yearData, currentPublishedEvent, fullPerformanceList, changedArtistList, updatedCurrentVersionState, (Continuation<? super ResultOf<Unit>>)$continuation);
                ** if (v0 != var16_10) goto lbl32
lbl31:
                // 1 sources

                return var16_10;
lbl32:
                // 1 sources

                ** GOTO lbl49
            }
            case 1: {
                $i$a$-cooperativeCatch-ArtistRepository$publishDraftToLive$2 = $continuation.I$1;
                $i$f$cooperativeCatch = $continuation.I$0;
                $this$publishDraftToLive_u24lambda_u246 = (ArtistRepository)$continuation.L$7;
                $this$cooperativeCatch$iv = (ArtistRepository)$continuation.L$6;
                updatedCurrentVersionState = (CurrentVersionState)$continuation.L$5;
                changedArtistList = (List)$continuation.L$4;
                fullPerformanceList = (List)$continuation.L$3;
                currentPublishedEvent = (PublishedEvent)$continuation.L$2;
                yearData = (YearData)$continuation.L$1;
                account = (Account)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl49:
                    // 2 sources

                    var12_19 = (ResultOf)v0;
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Exception e$iv) {
                    var12_19 = new ResultOf.Failure(e$iv);
                }
                return var12_19;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public Flow<List<FavoritePerformance>> getFavoriteListFlow(@NotNull ContentSource contentSource) {
        Intrinsics.checkNotNullParameter((Object)contentSource, (String)"contentSource");
        return this.local.getFavoriteListFlow(contentSource);
    }

    @Override
    @Nullable
    public Object addFavorite(@NotNull ContentSource contentSource, @NotNull DisplayPerformance displayPerformance, @NotNull FavoriteRank favoriteRank, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.local.addFavorite(contentSource, displayPerformance, favoriteRank, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object updateFavoriteRank(@NotNull ContentSource contentSource, @NotNull DisplayPerformance displayPerformance, @NotNull FavoriteRank rank, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.local.updateFavoriteRank(contentSource, displayPerformance, rank, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object removeFavorite(@NotNull ContentSource contentSource, @NotNull DisplayPerformance displayPerformance, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.local.removeFavorite(contentSource, displayPerformance, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object migrateRoomFavorites(@NotNull List<FavoritePerformance> favoriteList, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.local.migrateRoomFavorites(favoriteList, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object updateLastSeen(@NotNull CurrentVersionState currentVersionState, @NotNull LocalDateTime newLastSeen, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.local.updateLastSeen(currentVersionState, newLastSeen, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ArtistLocalApi access$getLocal$p(ArtistRepository $this) {
        return $this.local;
    }

    public static final /* synthetic */ ArtistRemoteApi access$getRemote$p(ArtistRepository $this) {
        return $this.remote;
    }

    public static final /* synthetic */ MultiLogger access$getLogger$p(ArtistRepository $this) {
        return $this.logger;
    }
}

