/*
 * Decompiled with CFR 0.152.
 */
package data.messaging.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.shambatimes.database.NotificationMessageLocal;
import common.RandomUUID_desktopKt;
import data.LocalMapper;
import data.account.model.FirestoreMapper;
import data.messaging.model.NotificationMessageNetwork;
import data.messaging.model.NotificationMessageTypes;
import dev.gitlive.firebase.firestore.Timestamp;
import dev.gitlive.firebase.firestore.TimestampKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003Bk\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0006\u0010%\u001a\u00020&J!\u0010'\u001a\u00020\u00022\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060)\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010*J!\u0010+\u001a\u00020\u00042\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060)\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010,J\t\u0010-\u001a\u00020\u0006H\u00c6\u0003J\t\u0010.\u001a\u00020\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\u000bH\u00c6\u0003J\t\u00102\u001a\u00020\u0006H\u00c6\u0003J\t\u00103\u001a\u00020\u0006H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\u0010H\u00c6\u0003J\t\u00106\u001a\u00020\u0012H\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003Jy\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\u0013\u00109\u001a\u00020&2\b\u0010:\u001a\u0004\u0018\u00010;H\u00d6\u0003J\t\u0010<\u001a\u00020=H\u00d6\u0001J\t\u0010>\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!\u00a8\u0006?"}, d2={"Ldata/messaging/model/NotificationMessage;", "Ldata/account/model/FirestoreMapper;", "Ldata/messaging/model/NotificationMessageNetwork;", "Ldata/LocalMapper;", "Lcom/shambatimes/database/NotificationMessageLocal;", "id", "", "name", "accountId", "eventId", "selectedMessageType", "Ldata/messaging/model/NotificationMessageTypes;", "subject", "body", "additionalContent", "timeSent", "Lkotlinx/datetime/LocalDateTime;", "zoneId", "Lkotlinx/datetime/TimeZone;", "futureSendDate", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ldata/messaging/model/NotificationMessageTypes;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/datetime/LocalDateTime;Lkotlinx/datetime/TimeZone;Lkotlinx/datetime/LocalDateTime;)V", "getId", "()Ljava/lang/String;", "getName", "getAccountId", "getEventId", "getSelectedMessageType", "()Ldata/messaging/model/NotificationMessageTypes;", "getSubject", "getBody", "getAdditionalContent", "getTimeSent", "()Lkotlinx/datetime/LocalDateTime;", "getZoneId", "()Lkotlinx/datetime/TimeZone;", "getFutureSendDate", "isValidMessage", "", "mapToFirestore", "param", "", "([Ljava/lang/String;)Ldata/messaging/model/NotificationMessageNetwork;", "mapToLocal", "([Ljava/lang/String;)Lcom/shambatimes/database/NotificationMessageLocal;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "", "hashCode", "", "toString", "shared"})
@StabilityInferred(parameters=0)
public final class NotificationMessage
implements FirestoreMapper<NotificationMessageNetwork>,
LocalMapper<NotificationMessageLocal> {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String accountId;
    @NotNull
    private final String eventId;
    @NotNull
    private final NotificationMessageTypes selectedMessageType;
    @NotNull
    private final String subject;
    @NotNull
    private final String body;
    @NotNull
    private final String additionalContent;
    @NotNull
    private final LocalDateTime timeSent;
    @NotNull
    private final TimeZone zoneId;
    @Nullable
    private final LocalDateTime futureSendDate;
    public static final int $stable = 8;

    public NotificationMessage(@NotNull String id, @NotNull String name, @NotNull String accountId, @NotNull String eventId, @NotNull NotificationMessageTypes selectedMessageType, @NotNull String subject, @NotNull String body, @NotNull String additionalContent, @NotNull LocalDateTime timeSent, @NotNull TimeZone zoneId, @Nullable LocalDateTime futureSendDate) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)selectedMessageType, (String)"selectedMessageType");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)additionalContent, (String)"additionalContent");
        Intrinsics.checkNotNullParameter((Object)timeSent, (String)"timeSent");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.id = id;
        this.name = name;
        this.accountId = accountId;
        this.eventId = eventId;
        this.selectedMessageType = selectedMessageType;
        this.subject = subject;
        this.body = body;
        this.additionalContent = additionalContent;
        this.timeSent = timeSent;
        this.zoneId = zoneId;
        this.futureSendDate = futureSendDate;
    }

    public /* synthetic */ NotificationMessage(String object, String string2, String string3, String string4, NotificationMessageTypes notificationMessageTypes, String string5, String string6, String string7, LocalDateTime localDateTime, TimeZone timeZone, LocalDateTime localDateTime2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            object = "NID-" + RandomUUID_desktopKt.randomUUID();
        }
        if ((n & 0x20) != 0) {
            string5 = "";
        }
        if ((n & 0x40) != 0) {
            string6 = "";
        }
        if ((n & 0x80) != 0) {
            string7 = "";
        }
        if ((n & 0x400) != 0) {
            localDateTime2 = null;
        }
        this((String)object, string2, string3, string4, notificationMessageTypes, string5, string6, string7, localDateTime, timeZone, localDateTime2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getAccountId() {
        return this.accountId;
    }

    @NotNull
    public final String getEventId() {
        return this.eventId;
    }

    @NotNull
    public final NotificationMessageTypes getSelectedMessageType() {
        return this.selectedMessageType;
    }

    @NotNull
    public final String getSubject() {
        return this.subject;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public final String getAdditionalContent() {
        return this.additionalContent;
    }

    @NotNull
    public final LocalDateTime getTimeSent() {
        return this.timeSent;
    }

    @NotNull
    public final TimeZone getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public final LocalDateTime getFutureSendDate() {
        return this.futureSendDate;
    }

    public final boolean isValidMessage() {
        return this.subject.length() + this.body.length() <= 160 && !StringsKt.isBlank((CharSequence)this.subject) && !StringsKt.isBlank((CharSequence)this.body) && this.additionalContent.length() <= 5000;
    }

    @Override
    @NotNull
    public NotificationMessageNetwork mapToFirestore(String ... param) {
        Timestamp timestamp;
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        String string2 = this.id;
        String string3 = this.name;
        String string4 = this.accountId;
        String string5 = this.eventId;
        String string6 = this.selectedMessageType.getTopicType().getTopic();
        String string7 = this.subject;
        String string8 = this.body;
        String string9 = this.additionalContent;
        String string10 = this.selectedMessageType.getTopicType().getTopic() + this.eventId;
        Timestamp timestamp2 = TimestampKt.fromMilliseconds((Timestamp.Companion)Timestamp.Companion, (double)TimeZoneKt.toInstant((LocalDateTime)this.timeSent, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
        String string11 = this.zoneId.getId();
        String string12 = this.selectedMessageType.getTopicType().getChannelId();
        LocalDateTime localDateTime = this.futureSendDate;
        if (localDateTime != null) {
            LocalDateTime it = localDateTime;
            boolean bl = false;
            timestamp = TimestampKt.fromMilliseconds((Timestamp.Companion)Timestamp.Companion, (double)TimeZoneKt.toInstant((LocalDateTime)this.futureSendDate, (TimeZone)this.zoneId).toEpochMilliseconds());
        } else {
            timestamp = null;
        }
        Timestamp timestamp3 = timestamp;
        return new NotificationMessageNetwork(string2, string3, string4, string5, string6, string10, string7, string8, string9, timestamp2, string11, string12, timestamp3);
    }

    @Override
    @NotNull
    public NotificationMessageLocal mapToLocal(String ... param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        LocalDateTime localDateTime = this.futureSendDate;
        return new NotificationMessageLocal(this.id, this.name, this.accountId, this.eventId, this.selectedMessageType.getTopicType().getTopic(), this.subject, this.body, this.additionalContent, this.timeSent.toString(), this.zoneId.getId(), localDateTime != null ? localDateTime.toString() : null);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.accountId;
    }

    @NotNull
    public final String component4() {
        return this.eventId;
    }

    @NotNull
    public final NotificationMessageTypes component5() {
        return this.selectedMessageType;
    }

    @NotNull
    public final String component6() {
        return this.subject;
    }

    @NotNull
    public final String component7() {
        return this.body;
    }

    @NotNull
    public final String component8() {
        return this.additionalContent;
    }

    @NotNull
    public final LocalDateTime component9() {
        return this.timeSent;
    }

    @NotNull
    public final TimeZone component10() {
        return this.zoneId;
    }

    @Nullable
    public final LocalDateTime component11() {
        return this.futureSendDate;
    }

    @NotNull
    public final NotificationMessage copy(@NotNull String id, @NotNull String name, @NotNull String accountId, @NotNull String eventId, @NotNull NotificationMessageTypes selectedMessageType, @NotNull String subject, @NotNull String body, @NotNull String additionalContent, @NotNull LocalDateTime timeSent, @NotNull TimeZone zoneId, @Nullable LocalDateTime futureSendDate) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)selectedMessageType, (String)"selectedMessageType");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)additionalContent, (String)"additionalContent");
        Intrinsics.checkNotNullParameter((Object)timeSent, (String)"timeSent");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return new NotificationMessage(id, name, accountId, eventId, selectedMessageType, subject, body, additionalContent, timeSent, zoneId, futureSendDate);
    }

    public static /* synthetic */ NotificationMessage copy$default(NotificationMessage notificationMessage, String string2, String string3, String string4, String string5, NotificationMessageTypes notificationMessageTypes, String string6, String string7, String string8, LocalDateTime localDateTime, TimeZone timeZone, LocalDateTime localDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = notificationMessage.id;
        }
        if ((n & 2) != 0) {
            string3 = notificationMessage.name;
        }
        if ((n & 4) != 0) {
            string4 = notificationMessage.accountId;
        }
        if ((n & 8) != 0) {
            string5 = notificationMessage.eventId;
        }
        if ((n & 0x10) != 0) {
            notificationMessageTypes = notificationMessage.selectedMessageType;
        }
        if ((n & 0x20) != 0) {
            string6 = notificationMessage.subject;
        }
        if ((n & 0x40) != 0) {
            string7 = notificationMessage.body;
        }
        if ((n & 0x80) != 0) {
            string8 = notificationMessage.additionalContent;
        }
        if ((n & 0x100) != 0) {
            localDateTime = notificationMessage.timeSent;
        }
        if ((n & 0x200) != 0) {
            timeZone = notificationMessage.zoneId;
        }
        if ((n & 0x400) != 0) {
            localDateTime2 = notificationMessage.futureSendDate;
        }
        return notificationMessage.copy(string2, string3, string4, string5, notificationMessageTypes, string6, string7, string8, localDateTime, timeZone, localDateTime2);
    }

    @NotNull
    public String toString() {
        return "NotificationMessage(id=" + this.id + ", name=" + this.name + ", accountId=" + this.accountId + ", eventId=" + this.eventId + ", selectedMessageType=" + this.selectedMessageType + ", subject=" + this.subject + ", body=" + this.body + ", additionalContent=" + this.additionalContent + ", timeSent=" + this.timeSent + ", zoneId=" + this.zoneId + ", futureSendDate=" + this.futureSendDate + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.accountId.hashCode();
        result = result * 31 + this.eventId.hashCode();
        result = result * 31 + this.selectedMessageType.hashCode();
        result = result * 31 + this.subject.hashCode();
        result = result * 31 + this.body.hashCode();
        result = result * 31 + this.additionalContent.hashCode();
        result = result * 31 + this.timeSent.hashCode();
        result = result * 31 + this.zoneId.hashCode();
        result = result * 31 + (this.futureSendDate == null ? 0 : this.futureSendDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationMessage)) {
            return false;
        }
        NotificationMessage notificationMessage = (NotificationMessage)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)notificationMessage.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)notificationMessage.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.accountId, (Object)notificationMessage.accountId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.eventId, (Object)notificationMessage.eventId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selectedMessageType, (Object)notificationMessage.selectedMessageType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subject, (Object)notificationMessage.subject)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)notificationMessage.body)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.additionalContent, (Object)notificationMessage.additionalContent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timeSent, (Object)notificationMessage.timeSent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.zoneId, (Object)notificationMessage.zoneId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.futureSendDate, (Object)notificationMessage.futureSendDate);
    }
}

