/*
 * Decompiled with CFR 0.152.
 */
package data.subscriptiontopics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.shambatimes.database.SubscriptionTopicLocal;
import com.shambatimes.database.SubscriptionTopicQueries;
import data.account.ResultOf;
import data.subscriptiontopics.SubscriptionTopic;
import data.subscriptiontopics.SubscriptionTopicsLocalApi;
import data.subscriptiontopics.SubscriptionTopicsLocalApiKt;
import di.MultiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\tH\u0096@\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldata/subscriptiontopics/SubscriptionTopicsLocalSource;", "Ldata/subscriptiontopics/SubscriptionTopicsLocalApi;", "subscriptionTopicDao", "Lcom/shambatimes/database/SubscriptionTopicQueries;", "logger", "Ldi/MultiLogger;", "<init>", "(Lcom/shambatimes/database/SubscriptionTopicQueries;Ldi/MultiLogger;)V", "subscribeToEvent", "Ldata/account/ResultOf;", "", "topic", "Ldata/subscriptiontopics/SubscriptionTopic;", "(Ldata/subscriptiontopics/SubscriptionTopic;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unSubscribeToEvent", "getSubscriptionTopicList", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "eventId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSubscriptionTopticsLocalSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionTopticsLocalSource.kt\ndata/subscriptiontopics/SubscriptionTopicsLocalSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1563#2:69\n1634#2,3:70\n1563#2:73\n1634#2,3:74\n*S KotlinDebug\n*F\n+ 1 SubscriptionTopticsLocalSource.kt\ndata/subscriptiontopics/SubscriptionTopicsLocalSource\n*L\n41#1:69\n41#1:70,3\n57#1:73\n57#1:74,3\n*E\n"})
public final class SubscriptionTopicsLocalSource
implements SubscriptionTopicsLocalApi {
    @NotNull
    private final SubscriptionTopicQueries subscriptionTopicDao;
    @NotNull
    private final MultiLogger logger;
    public static final int $stable = 8;

    public SubscriptionTopicsLocalSource(@NotNull SubscriptionTopicQueries subscriptionTopicDao, @NotNull MultiLogger logger) {
        Intrinsics.checkNotNullParameter((Object)((Object)subscriptionTopicDao), (String)"subscriptionTopicDao");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.subscriptionTopicDao = subscriptionTopicDao;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Object subscribeToEvent(@NotNull SubscriptionTopic topic, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        ResultOf resultOf;
        try {
            this.subscriptionTopicDao.insert(topic.getTopicKey(), topic.getEventId(), topic.getAccountId(), topic.getTopicType().getTopic());
            resultOf = new ResultOf.Success<Unit>(Unit.INSTANCE);
        }
        catch (Exception exception) {
            this.logger.e("subscribeToEvent", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }

    @Override
    @Nullable
    public Object unSubscribeToEvent(@NotNull SubscriptionTopic topic, @NotNull Continuation<? super ResultOf<Unit>> $completion) {
        ResultOf resultOf;
        try {
            this.subscriptionTopicDao.delete(topic.getTopicKey());
            resultOf = new ResultOf.Success<Unit>(Unit.INSTANCE);
        }
        catch (Exception exception) {
            this.logger.e("unSubscribeToEvent", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getSubscriptionTopicList(@NotNull Continuation<? super ResultOf<? extends List<SubscriptionTopic>>> $completion) {
        ResultOf resultOf;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.subscriptionTopicDao.selectAll().executeAsList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SubscriptionTopicLocal subscriptionTopicLocal = (SubscriptionTopicLocal)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SubscriptionTopicsLocalApiKt.mapToDomain((SubscriptionTopicLocal)it));
            }
            List result = (List)destination$iv$iv;
            resultOf = new ResultOf.Success<List>(result);
        }
        catch (Exception exception) {
            this.logger.e("getSubscriptionTopicList", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getSubscriptionTopicList(@NotNull String eventId, @NotNull Continuation<? super ResultOf<? extends List<SubscriptionTopic>>> $completion) {
        ResultOf resultOf;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.subscriptionTopicDao.selectAllForEvent(eventId).executeAsList();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SubscriptionTopicLocal subscriptionTopicLocal = (SubscriptionTopicLocal)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SubscriptionTopicsLocalApiKt.mapToDomain((SubscriptionTopicLocal)it));
            }
            List result = (List)destination$iv$iv;
            resultOf = new ResultOf.Success<List>(result);
        }
        catch (Exception exception) {
            this.logger.e("getSubscriptionTopicList", exception);
            resultOf = new ResultOf.Failure(exception);
        }
        return resultOf;
    }
}

