/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.accountoverview;

import androidx.compose.runtime.internal.StabilityInferred;
import common.RandomUUID_desktopKt;
import common.TimeProvider;
import data.account.model.Account;
import data.account.model.AdditionalContentType;
import data.account.model.Directions;
import data.account.model.EventReference;
import data.account.model.Faq;
import data.account.model.Stage;
import data.account.model.TagColor;
import data.account.model.YearData;
import extensions.LocalDateTimeExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.screens.accountoverview.DataValidityCheck;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0003J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020'J\u000e\u0010-\u001a\u00020'2\u0006\u0010,\u001a\u00020'J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\tH\u00c6\u0003J\t\u00107\u001a\u00020\tH\u00c6\u0003J\t\u00108\u001a\u00020\fH\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\u000f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u00c6\u0003J\u0083\u0001\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00032\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u00c6\u0001J\u0013\u0010=\u001a\u00020%2\b\u0010>\u001a\u0004\u0018\u00010?H\u00d6\u0003J\t\u0010@\u001a\u00020AH\u00d6\u0001J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"\u00a8\u0006C"}, d2={"Lui/screens/accountoverview/FestivalCreationData;", "Lui/screens/accountoverview/DataValidityCheck;", "festivalName", "", "websiteUrl", "storeUrl", "bannerImageUrl", "iconImageUrl", "startDate", "Lkotlinx/datetime/LocalDate;", "endDate", "startOfDay", "Lkotlinx/datetime/LocalTime;", "timeZone", "stageList", "", "Ldata/account/model/Stage;", "tagColorList", "Ldata/account/model/TagColor;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalTime;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getFestivalName", "()Ljava/lang/String;", "getWebsiteUrl", "getStoreUrl", "getBannerImageUrl", "getIconImageUrl", "getStartDate", "()Lkotlinx/datetime/LocalDate;", "getEndDate", "getStartOfDay", "()Lkotlinx/datetime/LocalTime;", "getTimeZone", "getStageList", "()Ljava/util/List;", "getTagColorList", "isSaveValid", "", "toYearData", "Ldata/account/model/YearData;", "eventId", "updateEventReference", "Ldata/account/model/EventReference;", "eventReference", "yearData", "updateYearData", "toAccount", "Ldata/account/model/Account;", "userId", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "", "hashCode", "", "toString", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFestivalCreationData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FestivalCreationData.kt\nui/screens/accountoverview/FestivalCreationData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1563#2:180\n1634#2,3:181\n1573#2:184\n1604#2,4:185\n774#2:189\n865#2,2:190\n1573#2:192\n1604#2,4:193\n774#2:197\n865#2,2:198\n*S KotlinDebug\n*F\n+ 1 FestivalCreationData.kt\nui/screens/accountoverview/FestivalCreationData\n*L\n50#1:180\n50#1:181,3\n74#1:184\n74#1:185,4\n81#1:189\n81#1:190,2\n123#1:192\n123#1:193,4\n130#1:197\n130#1:198,2\n*E\n"})
public final class FestivalCreationData
implements DataValidityCheck {
    @NotNull
    private final String festivalName;
    @NotNull
    private final String websiteUrl;
    @NotNull
    private final String storeUrl;
    @NotNull
    private final String bannerImageUrl;
    @NotNull
    private final String iconImageUrl;
    @NotNull
    private final LocalDate startDate;
    @NotNull
    private final LocalDate endDate;
    @NotNull
    private final LocalTime startOfDay;
    @NotNull
    private final String timeZone;
    @NotNull
    private final List<Stage> stageList;
    @NotNull
    private final List<TagColor> tagColorList;
    public static final int $stable = 8;

    public FestivalCreationData(@NotNull String festivalName, @NotNull String websiteUrl, @NotNull String storeUrl, @NotNull String bannerImageUrl, @NotNull String iconImageUrl, @NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull LocalTime startOfDay, @NotNull String timeZone, @NotNull List<Stage> stageList, @NotNull List<TagColor> tagColorList) {
        Intrinsics.checkNotNullParameter((Object)festivalName, (String)"festivalName");
        Intrinsics.checkNotNullParameter((Object)websiteUrl, (String)"websiteUrl");
        Intrinsics.checkNotNullParameter((Object)storeUrl, (String)"storeUrl");
        Intrinsics.checkNotNullParameter((Object)bannerImageUrl, (String)"bannerImageUrl");
        Intrinsics.checkNotNullParameter((Object)iconImageUrl, (String)"iconImageUrl");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)startOfDay, (String)"startOfDay");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Intrinsics.checkNotNullParameter(stageList, (String)"stageList");
        Intrinsics.checkNotNullParameter(tagColorList, (String)"tagColorList");
        this.festivalName = festivalName;
        this.websiteUrl = websiteUrl;
        this.storeUrl = storeUrl;
        this.bannerImageUrl = bannerImageUrl;
        this.iconImageUrl = iconImageUrl;
        this.startDate = startDate;
        this.endDate = endDate;
        this.startOfDay = startOfDay;
        this.timeZone = timeZone;
        this.stageList = stageList;
        this.tagColorList = tagColorList;
    }

    public /* synthetic */ FestivalCreationData(String string2, String string3, String string4, String string5, String string6, LocalDate localDate, LocalDate localDate2, LocalTime localTime, String string7, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            string4 = "";
        }
        if ((n & 8) != 0) {
            string5 = "";
        }
        if ((n & 0x10) != 0) {
            string6 = "";
        }
        if ((n & 0x20) != 0) {
            localDate = TimeProvider.INSTANCE.getLocalDate();
        }
        if ((n & 0x40) != 0) {
            localDate2 = TimeProvider.INSTANCE.getLocalDate();
        }
        if ((n & 0x80) != 0) {
            localTime = new LocalTime(0, 0, 0, 0, 12, null);
        }
        if ((n & 0x100) != 0) {
            string7 = TimeZone.Companion.currentSystemDefault().getId();
        }
        if ((n & 0x200) != 0) {
            list = CollectionsKt.listOf((Object)new Stage(Stage.Companion.newStageId(), "", 0, "#808080"));
        }
        if ((n & 0x400) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string2, string3, string4, string5, string6, localDate, localDate2, localTime, string7, list, list2);
    }

    @NotNull
    public final String getFestivalName() {
        return this.festivalName;
    }

    @NotNull
    public final String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @NotNull
    public final String getStoreUrl() {
        return this.storeUrl;
    }

    @NotNull
    public final String getBannerImageUrl() {
        return this.bannerImageUrl;
    }

    @NotNull
    public final String getIconImageUrl() {
        return this.iconImageUrl;
    }

    @NotNull
    public final LocalDate getStartDate() {
        return this.startDate;
    }

    @NotNull
    public final LocalDate getEndDate() {
        return this.endDate;
    }

    @NotNull
    public final LocalTime getStartOfDay() {
        return this.startOfDay;
    }

    @NotNull
    public final String getTimeZone() {
        return this.timeZone;
    }

    @NotNull
    public final List<Stage> getStageList() {
        return this.stageList;
    }

    @NotNull
    public final List<TagColor> getTagColorList() {
        return this.tagColorList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSaveValid() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.stageList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Stage stage = (Stage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CharSequence)it.getName()).length() == 0 || ((CharSequence)it.getColor()).length() == 0);
        }
        boolean isNameOrColorEmpty = !((List)destination$iv$iv).contains(true);
        boolean result = ((CharSequence)this.festivalName).length() > 0 && this.startDate.compareTo(this.endDate) <= 0 && ((CharSequence)this.timeZone).length() > 0 && !((Collection)this.stageList).isEmpty() && isNameOrColorEmpty;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YearData toYearData(@Nullable String eventId) {
        void $this$filterTo$iv$iv;
        void $this$mapIndexedTo$iv$iv;
        LocalDateTime start = new LocalDateTime(this.startDate, this.startOfDay);
        LocalDateTime end = new LocalDateTime(this.endDate, this.startOfDay);
        List dateList = new ArrayList();
        while (start.compareTo(end) <= 0) {
            dateList.add(start);
            start = LocalDateTimeExtensionsKt.plus$default(start, 24, DateTimeUnit.Companion.getHOUR(), null, 4, null);
        }
        Object object = eventId;
        if (object == null) {
            object = "EID-" + RandomUUID_desktopKt.randomUUID();
        }
        String string2 = object;
        int n = start.getYear();
        Iterable $this$mapIndexed$iv = this.stageList;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void stage;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Stage stage2 = (Stage)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CharSequence)stage.getKey()).length() == 0 ? Stage.copy$default((Stage)stage, Stage.Companion.newStageId(), null, (int)index, null, 10, null) : Stage.copy$default((Stage)stage, null, null, (int)index, null, 11, null));
        }
        List list = (List)destination$iv$iv;
        Iterable $this$filter$iv = this.tagColorList;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TagColor it = (TagColor)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it.getTag());
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv2;
        TimeZone timeZone = TimeZone.Companion.of(this.timeZone);
        List list3 = CollectionsKt.emptyList();
        List list4 = CollectionsKt.emptyList();
        return new YearData(string2, n, list, dateList, list2, null, null, list4, list3, timeZone, 1L, "", null, null, false);
    }

    @NotNull
    public final EventReference updateEventReference(@NotNull EventReference eventReference, @NotNull YearData yearData) {
        Intrinsics.checkNotNullParameter((Object)eventReference, (String)"eventReference");
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        LocalDateTime start = new LocalDateTime(this.startDate, this.startOfDay);
        LocalDateTime end = new LocalDateTime(this.endDate, this.startOfDay);
        return new EventReference(yearData.getEventId(), start, end, TimeZone.Companion.of(this.timeZone), eventReference.isPublished());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YearData updateYearData(@NotNull YearData yearData) {
        void $this$filterTo$iv$iv;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)yearData, (String)"yearData");
        LocalDateTime start = new LocalDateTime(this.startDate, this.startOfDay);
        LocalDateTime end = new LocalDateTime(this.endDate, this.startOfDay);
        List dateList = new ArrayList();
        while (start.compareTo(end) <= 0) {
            dateList.add(start);
            start = LocalDateTimeExtensionsKt.plus$default(start, 24, DateTimeUnit.Companion.getHOUR(), null, 4, null);
        }
        String string2 = yearData.getEventId();
        int n = start.getYear();
        Iterable $this$mapIndexed$iv = this.stageList;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void stage;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Stage stage2 = (Stage)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CharSequence)stage.getKey()).length() == 0 ? Stage.copy$default((Stage)stage, Stage.Companion.newStageId(), null, (int)index, null, 10, null) : Stage.copy$default((Stage)stage, null, null, (int)index, null, 11, null));
        }
        List list = (List)destination$iv$iv;
        Iterable $this$filter$iv = this.tagColorList;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TagColor it = (TagColor)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it.getTag());
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv2;
        String string3 = yearData.getMapUrl();
        TimeZone timeZone = TimeZone.Companion.of(this.timeZone);
        List<Faq> list3 = yearData.getFaqList();
        long l = yearData.getVersion();
        Directions directions = yearData.getDirections();
        String string4 = yearData.getAbout();
        List<AdditionalContentType> list4 = yearData.getAdditionalContentTypeList();
        String string5 = yearData.getSponsorImageUrl();
        String string6 = yearData.getSponsorClickUrl();
        boolean bl = yearData.isForcedSingleStageView();
        return new YearData(string2, n, list, dateList, list2, string3, directions, list4, list3, timeZone, l, string4, string5, string6, bl);
    }

    @NotNull
    public final Account toAccount(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        LocalDateTime start = new LocalDateTime(this.startDate, this.startOfDay);
        LocalDateTime end = new LocalDateTime(this.endDate, this.startOfDay);
        List dateList = new ArrayList();
        while (start.compareTo(end) <= 0) {
            dateList.add(start);
            start = LocalDateTimeExtensionsKt.plus$default(start, 24, DateTimeUnit.Companion.getHOUR(), null, 4, null);
        }
        String eventId = "EID-" + RandomUUID_desktopKt.randomUUID();
        return new Account("ACID-" + RandomUUID_desktopKt.randomUUID(), userId, this.festivalName, CollectionsKt.listOf((Object)new EventReference(eventId, (LocalDateTime)CollectionsKt.first((List)dateList), (LocalDateTime)CollectionsKt.last((List)dateList), TimeZone.Companion.of(this.timeZone), false)), null, this.websiteUrl, this.bannerImageUrl, this.iconImageUrl, "", null, false, 528, null);
    }

    @NotNull
    public final String component1() {
        return this.festivalName;
    }

    @NotNull
    public final String component2() {
        return this.websiteUrl;
    }

    @NotNull
    public final String component3() {
        return this.storeUrl;
    }

    @NotNull
    public final String component4() {
        return this.bannerImageUrl;
    }

    @NotNull
    public final String component5() {
        return this.iconImageUrl;
    }

    @NotNull
    public final LocalDate component6() {
        return this.startDate;
    }

    @NotNull
    public final LocalDate component7() {
        return this.endDate;
    }

    @NotNull
    public final LocalTime component8() {
        return this.startOfDay;
    }

    @NotNull
    public final String component9() {
        return this.timeZone;
    }

    @NotNull
    public final List<Stage> component10() {
        return this.stageList;
    }

    @NotNull
    public final List<TagColor> component11() {
        return this.tagColorList;
    }

    @NotNull
    public final FestivalCreationData copy(@NotNull String festivalName, @NotNull String websiteUrl, @NotNull String storeUrl, @NotNull String bannerImageUrl, @NotNull String iconImageUrl, @NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull LocalTime startOfDay, @NotNull String timeZone, @NotNull List<Stage> stageList, @NotNull List<TagColor> tagColorList) {
        Intrinsics.checkNotNullParameter((Object)festivalName, (String)"festivalName");
        Intrinsics.checkNotNullParameter((Object)websiteUrl, (String)"websiteUrl");
        Intrinsics.checkNotNullParameter((Object)storeUrl, (String)"storeUrl");
        Intrinsics.checkNotNullParameter((Object)bannerImageUrl, (String)"bannerImageUrl");
        Intrinsics.checkNotNullParameter((Object)iconImageUrl, (String)"iconImageUrl");
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)startOfDay, (String)"startOfDay");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Intrinsics.checkNotNullParameter(stageList, (String)"stageList");
        Intrinsics.checkNotNullParameter(tagColorList, (String)"tagColorList");
        return new FestivalCreationData(festivalName, websiteUrl, storeUrl, bannerImageUrl, iconImageUrl, startDate, endDate, startOfDay, timeZone, stageList, tagColorList);
    }

    public static /* synthetic */ FestivalCreationData copy$default(FestivalCreationData festivalCreationData, String string2, String string3, String string4, String string5, String string6, LocalDate localDate, LocalDate localDate2, LocalTime localTime, String string7, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = festivalCreationData.festivalName;
        }
        if ((n & 2) != 0) {
            string3 = festivalCreationData.websiteUrl;
        }
        if ((n & 4) != 0) {
            string4 = festivalCreationData.storeUrl;
        }
        if ((n & 8) != 0) {
            string5 = festivalCreationData.bannerImageUrl;
        }
        if ((n & 0x10) != 0) {
            string6 = festivalCreationData.iconImageUrl;
        }
        if ((n & 0x20) != 0) {
            localDate = festivalCreationData.startDate;
        }
        if ((n & 0x40) != 0) {
            localDate2 = festivalCreationData.endDate;
        }
        if ((n & 0x80) != 0) {
            localTime = festivalCreationData.startOfDay;
        }
        if ((n & 0x100) != 0) {
            string7 = festivalCreationData.timeZone;
        }
        if ((n & 0x200) != 0) {
            list = festivalCreationData.stageList;
        }
        if ((n & 0x400) != 0) {
            list2 = festivalCreationData.tagColorList;
        }
        return festivalCreationData.copy(string2, string3, string4, string5, string6, localDate, localDate2, localTime, string7, list, list2);
    }

    @NotNull
    public String toString() {
        return "FestivalCreationData(festivalName=" + this.festivalName + ", websiteUrl=" + this.websiteUrl + ", storeUrl=" + this.storeUrl + ", bannerImageUrl=" + this.bannerImageUrl + ", iconImageUrl=" + this.iconImageUrl + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", startOfDay=" + this.startOfDay + ", timeZone=" + this.timeZone + ", stageList=" + this.stageList + ", tagColorList=" + this.tagColorList + ")";
    }

    public int hashCode() {
        int result = this.festivalName.hashCode();
        result = result * 31 + this.websiteUrl.hashCode();
        result = result * 31 + this.storeUrl.hashCode();
        result = result * 31 + this.bannerImageUrl.hashCode();
        result = result * 31 + this.iconImageUrl.hashCode();
        result = result * 31 + this.startDate.hashCode();
        result = result * 31 + this.endDate.hashCode();
        result = result * 31 + this.startOfDay.hashCode();
        result = result * 31 + this.timeZone.hashCode();
        result = result * 31 + ((Object)this.stageList).hashCode();
        result = result * 31 + ((Object)this.tagColorList).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FestivalCreationData)) {
            return false;
        }
        FestivalCreationData festivalCreationData = (FestivalCreationData)other;
        if (!Intrinsics.areEqual((Object)this.festivalName, (Object)festivalCreationData.festivalName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.websiteUrl, (Object)festivalCreationData.websiteUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.storeUrl, (Object)festivalCreationData.storeUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bannerImageUrl, (Object)festivalCreationData.bannerImageUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.iconImageUrl, (Object)festivalCreationData.iconImageUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)festivalCreationData.startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDate, (Object)festivalCreationData.endDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startOfDay, (Object)festivalCreationData.startOfDay)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timeZone, (Object)festivalCreationData.timeZone)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stageList, festivalCreationData.stageList)) {
            return false;
        }
        return Intrinsics.areEqual(this.tagColorList, festivalCreationData.tagColorList);
    }

    public FestivalCreationData() {
        this(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
    }
}

