/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.eventinfo;

import androidx.compose.runtime.internal.StabilityInferred;
import cafe.adriel.voyager.core.model.ScreenModel;
import cafe.adriel.voyager.core.model.ScreenModelKt;
import common.analytics.AnalyticsLogger;
import common.states.EnabledState;
import data.account.ResultOf;
import data.myevents.MyEventRepositoryApi;
import data.publishedevents.PublishedEventRepositoryApi;
import data.publishedevents.models.PublishedEvent;
import data.subscriptiontopics.SubscriptionTopic;
import data.subscriptiontopics.SubscriptionTopicType;
import data.subscriptiontopics.SubscriptionTopicsRepositoryApi;
import di.MultiLogger;
import di.OSPlatform;
import di.StoreLauncher;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import ui.screens.eventinfo.EventInfoOpenType;
import ui.screens.eventinfo.EventInfoUiState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\"J\u0016\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020!J\u000e\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lui/screens/eventinfo/EventInfoViewModel;", "Lcafe/adriel/voyager/core/model/ScreenModel;", "eventInfoType", "Lui/screens/eventinfo/EventInfoOpenType;", "platform", "Ldi/OSPlatform;", "isNotificationsEnabledAtCreate", "", "myEventRepo", "Ldata/myevents/MyEventRepositoryApi;", "subscriptionTopicsRepo", "Ldata/subscriptiontopics/SubscriptionTopicsRepositoryApi;", "publishedEventRepo", "Ldata/publishedevents/PublishedEventRepositoryApi;", "logger", "Ldi/MultiLogger;", "storeLauncher", "Ldi/StoreLauncher;", "analytics", "Lcommon/analytics/AnalyticsLogger;", "osPlatform", "<init>", "(Lui/screens/eventinfo/EventInfoOpenType;Ldi/OSPlatform;ZLdata/myevents/MyEventRepositoryApi;Ldata/subscriptiontopics/SubscriptionTopicsRepositoryApi;Ldata/publishedevents/PublishedEventRepositoryApi;Ldi/MultiLogger;Ldi/StoreLauncher;Lcommon/analytics/AnalyticsLogger;Ldi/OSPlatform;)V", "getEventInfoType", "()Lui/screens/eventinfo/EventInfoOpenType;", "_eventInfoUiStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lui/screens/eventinfo/EventInfoUiState;", "eventInfoUiStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getEventInfoUiStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "fetchPublishedEvent", "", "Lui/screens/eventinfo/EventInfoOpenType$QRCode;", "openEventClicked", "publishedEvent", "Ldata/publishedevents/models/PublishedEvent;", "isNotificationsSubscribed", "openStorePage", "onResumed", "isNotificationsEnabled", "shared"})
@StabilityInferred(parameters=0)
public final class EventInfoViewModel
implements ScreenModel {
    @NotNull
    private final EventInfoOpenType eventInfoType;
    @NotNull
    private final MyEventRepositoryApi myEventRepo;
    @NotNull
    private final SubscriptionTopicsRepositoryApi subscriptionTopicsRepo;
    @NotNull
    private final PublishedEventRepositoryApi publishedEventRepo;
    @NotNull
    private final MultiLogger logger;
    @NotNull
    private final StoreLauncher storeLauncher;
    @NotNull
    private final AnalyticsLogger analytics;
    @NotNull
    private final OSPlatform osPlatform;
    @NotNull
    private final MutableStateFlow<EventInfoUiState> _eventInfoUiStateFlow;
    @NotNull
    private final StateFlow<EventInfoUiState> eventInfoUiStateFlow;
    public static final int $stable = 8;

    public EventInfoViewModel(@NotNull EventInfoOpenType eventInfoType, @NotNull OSPlatform platform, boolean isNotificationsEnabledAtCreate, @NotNull MyEventRepositoryApi myEventRepo, @NotNull SubscriptionTopicsRepositoryApi subscriptionTopicsRepo, @NotNull PublishedEventRepositoryApi publishedEventRepo, @NotNull MultiLogger logger, @NotNull StoreLauncher storeLauncher, @NotNull AnalyticsLogger analytics, @NotNull OSPlatform osPlatform) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)eventInfoType, (String)"eventInfoType");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)myEventRepo, (String)"myEventRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionTopicsRepo, (String)"subscriptionTopicsRepo");
        Intrinsics.checkNotNullParameter((Object)publishedEventRepo, (String)"publishedEventRepo");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)storeLauncher, (String)"storeLauncher");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)osPlatform, (String)"osPlatform");
        this.eventInfoType = eventInfoType;
        this.myEventRepo = myEventRepo;
        this.subscriptionTopicsRepo = subscriptionTopicsRepo;
        this.publishedEventRepo = publishedEventRepo;
        this.logger = logger;
        this.storeLauncher = storeLauncher;
        this.analytics = analytics;
        this.osPlatform = osPlatform;
        EventInfoOpenType eventInfoOpenType = this.eventInfoType;
        if (eventInfoOpenType instanceof EventInfoOpenType.QRCode) {
            this.fetchPublishedEvent((EventInfoOpenType.QRCode)this.eventInfoType);
            mutableStateFlow = StateFlowKt.MutableStateFlow((Object)EventInfoUiState.Loading.INSTANCE);
        } else if (eventInfoOpenType instanceof EventInfoOpenType.SearchResult) {
            mutableStateFlow = ((EventInfoOpenType.SearchResult)this.eventInfoType).getPublishedEvent().getVersionCode() > 1L ? StateFlowKt.MutableStateFlow((Object)new EventInfoUiState.UpgradeRequired(((EventInfoOpenType.SearchResult)this.eventInfoType).getPublishedEvent(), platform)) : StateFlowKt.MutableStateFlow((Object)new EventInfoUiState.Loaded(((EventInfoOpenType.SearchResult)this.eventInfoType).getPublishedEvent(), EnabledState.Companion.fromBool(isNotificationsEnabledAtCreate), platform));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this._eventInfoUiStateFlow = mutableStateFlow;
        this.eventInfoUiStateFlow = (StateFlow)this._eventInfoUiStateFlow;
        this.logger.i("EventInfoViewModel");
    }

    @NotNull
    public final EventInfoOpenType getEventInfoType() {
        return this.eventInfoType;
    }

    @NotNull
    public final StateFlow<EventInfoUiState> getEventInfoUiStateFlow() {
        return this.eventInfoUiStateFlow;
    }

    public final void fetchPublishedEvent(@NotNull EventInfoOpenType.QRCode eventInfoType) {
        Intrinsics.checkNotNullParameter((Object)eventInfoType, (String)"eventInfoType");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, eventInfoType, null){
            int label;
            final /* synthetic */ EventInfoViewModel this$0;
            final /* synthetic */ EventInfoOpenType.QRCode $eventInfoType;
            {
                this.this$0 = $receiver;
                this.$eventInfoType = $eventInfoType;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = EventInfoViewModel.access$getPublishedEventRepo$p(this.this$0).getPublishedEvent(this.$eventInfoType.getAccountId(), (Continuation<? super ResultOf<PublishedEvent>>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((var3_4 = (result = (ResultOf)v0)) instanceof ResultOf.Failure)) {
                            if (var3_4 instanceof ResultOf.Success) {
                                EventInfoViewModel.access$get_eventInfoUiStateFlow$p(this.this$0).setValue((Object)new EventInfoUiState.Loaded((PublishedEvent)((ResultOf.Success)result).getResult(), EnabledState.Companion.fromBool(true), EventInfoViewModel.access$getOsPlatform$p(this.this$0)));
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void openEventClicked(@NotNull PublishedEvent publishedEvent, boolean isNotificationsSubscribed) {
        Intrinsics.checkNotNullParameter((Object)publishedEvent, (String)"publishedEvent");
        this.logger.i(publishedEvent.getAccountName() + " (" + publishedEvent.getEventId() + ") opened");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isNotificationsSubscribed, publishedEvent, this, null){
            Object L$0;
            int label;
            final /* synthetic */ boolean $isNotificationsSubscribed;
            final /* synthetic */ PublishedEvent $publishedEvent;
            final /* synthetic */ EventInfoViewModel this$0;
            {
                this.$isNotificationsSubscribed = $isNotificationsSubscribed;
                this.$publishedEvent = $publishedEvent;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block13: {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (!this.$isNotificationsSubscribed) break;
                            if (!this.$publishedEvent.isCommunityEvent()) break;
                            this.label = 1;
                            v0 = EventInfoViewModel.access$getSubscriptionTopicsRepo$p(this.this$0).subscribeToEvent(new SubscriptionTopic(this.$publishedEvent.getEventId(), this.$publishedEvent.getAccountId(), SubscriptionTopicType.ScheduleChanges.INSTANCE), (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            v1 = (ResultOf)v0;
                            ** GOTO lbl36
                        }
                    }
                    this.label = 2;
                    v2 = EventInfoViewModel.access$getSubscriptionTopicsRepo$p(this.this$0).subscribeAllToEvent(this.$publishedEvent, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                    if (v2 == var3_2) {
                        return var3_2;
                    }
                    ** GOTO lbl25
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl25:
                            // 2 sources

                            v1 = (ResultOf)v2;
                            ** GOTO lbl36
                        }
                    }
                    this.label = 3;
                    v3 = EventInfoViewModel.access$getSubscriptionTopicsRepo$p(this.this$0).subscribeToEvent(new SubscriptionTopic(this.$publishedEvent.getEventId(), this.$publishedEvent.getAccountId(), SubscriptionTopicType.Emergency.INSTANCE), (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                    if (v3 == var3_2) {
                        return var3_2;
                    }
                    ** GOTO lbl35
                    {
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl35:
                            // 2 sources

                            v1 = new ResultOf.Success<Unit>(Unit.INSTANCE);
lbl36:
                            // 3 sources

                            scheduleResult = v1;
                            EventInfoViewModel.access$getAnalytics$p(this.this$0).logEventJoined(this.$publishedEvent);
                            if (!(scheduleResult instanceof ResultOf.Success)) break;
                            this.L$0 = scheduleResult;
                            this.label = 4;
                            v4 = EventInfoViewModel.access$getMyEventRepo$p(this.this$0).setActiveEvent(this.$publishedEvent, (Continuation<? super Unit>)((Continuation)this));
                            if (v4 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl49
                        }
                        case 4: {
                            scheduleResult = (ResultOf)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl49:
                            // 2 sources

                            this.L$0 = scheduleResult;
                            this.label = 5;
                            v5 = EventInfoViewModel.access$getMyEventRepo$p(this.this$0).addToMyEvents(this.$publishedEvent, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                            if (v5 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl59
                        }
                        case 5: {
                            scheduleResult = (ResultOf)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl59:
                            // 2 sources

                            EventInfoViewModel.access$get_eventInfoUiStateFlow$p(this.this$0).setValue((Object)EventInfoUiState.Selected.INSTANCE);
                            break block13;
                        }
                    }
                    EventInfoViewModel.access$get_eventInfoUiStateFlow$p(this.this$0).setValue((Object)EventInfoUiState.Selected.INSTANCE);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void openStorePage() {
        this.storeLauncher.openToStore();
    }

    public final void onResumed(boolean isNotificationsEnabled) {
        block1: {
            EventInfoUiState.Loaded uiStateLoaded;
            Object object = this._eventInfoUiStateFlow.getValue();
            EventInfoUiState.Loaded loaded = uiStateLoaded = object instanceof EventInfoUiState.Loaded ? (EventInfoUiState.Loaded)object : null;
            if (loaded == null) break block1;
            EventInfoUiState.Loaded it = loaded;
            boolean bl = false;
            if (it.isAppNotificationsEnabled().getValue() != isNotificationsEnabled) {
                this._eventInfoUiStateFlow.setValue((Object)EventInfoUiState.Loaded.copy$default(uiStateLoaded, null, it.isAppNotificationsEnabled().toggleState(), null, 5, null));
            }
        }
    }

    public void onDispose() {
        ScreenModel.DefaultImpls.onDispose((ScreenModel)this);
    }

    public static final /* synthetic */ PublishedEventRepositoryApi access$getPublishedEventRepo$p(EventInfoViewModel $this) {
        return $this.publishedEventRepo;
    }

    public static final /* synthetic */ MutableStateFlow access$get_eventInfoUiStateFlow$p(EventInfoViewModel $this) {
        return $this._eventInfoUiStateFlow;
    }

    public static final /* synthetic */ OSPlatform access$getOsPlatform$p(EventInfoViewModel $this) {
        return $this.osPlatform;
    }

    public static final /* synthetic */ SubscriptionTopicsRepositoryApi access$getSubscriptionTopicsRepo$p(EventInfoViewModel $this) {
        return $this.subscriptionTopicsRepo;
    }

    public static final /* synthetic */ AnalyticsLogger access$getAnalytics$p(EventInfoViewModel $this) {
        return $this.analytics;
    }

    public static final /* synthetic */ MyEventRepositoryApi access$getMyEventRepo$p(EventInfoViewModel $this) {
        return $this.myEventRepo;
    }
}

