/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.signin;

import androidx.compose.runtime.internal.StabilityInferred;
import cafe.adriel.voyager.core.model.ScreenModel;
import cafe.adriel.voyager.core.model.ScreenModelKt;
import com.russhwolf.settings.Settings;
import data.account.ResultOf;
import data.myevents.MyEventRepositoryApi;
import data.myevents.model.MyEvent;
import data.user.EmailNotVerified;
import data.user.FirebaseSignupResponse;
import data.user.NetworkException;
import data.user.User;
import data.user.UserRemoteSource;
import data.user.UserRepositoryApi;
import di.MultiLogger;
import di.OSPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import ui.screens.signin.AuthenticationState;
import ui.screens.signin.CreateAccountState;
import ui.screens.signin.SignInError;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010\"\u001a\u00020\u001bJ\u0006\u0010#\u001a\u00020\u001bJ\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001dJ\u0006\u0010&\u001a\u00020\u001bJ\u0006\u0010'\u001a\u00020\u001bJ\u0016\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u001bJ\u0006\u0010-\u001a\u00020\u001bJ\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u001dH\u0002J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lui/screens/signin/AuthenticationViewModel;", "Lcafe/adriel/voyager/core/model/ScreenModel;", "platform", "Ldi/OSPlatform;", "userRepo", "Ldata/user/UserRepositoryApi;", "myEvents", "Ldata/myevents/MyEventRepositoryApi;", "settings", "Lcom/russhwolf/settings/Settings;", "logger", "Ldi/MultiLogger;", "<init>", "(Ldi/OSPlatform;Ldata/user/UserRepositoryApi;Ldata/myevents/MyEventRepositoryApi;Lcom/russhwolf/settings/Settings;Ldi/MultiLogger;)V", "isMyEvents", "", "()Z", "setMyEvents", "(Z)V", "_authenticationstate", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lui/screens/signin/AuthenticationState;", "authenticationState", "Lkotlinx/coroutines/flow/StateFlow;", "getAuthenticationState", "()Lkotlinx/coroutines/flow/StateFlow;", "signIn", "", "email", "", "password", "signOut", "signInComplete", "showSignInScreen", "showChoiceScreen", "showForgotPasswordScreen", "sendPasswordResetEmail", "value", "clearForgotPasswordDialog", "onSignUpClicked", "createAccount", "resendEmailVerification", "firebaseSignupResponse", "Ldata/user/FirebaseSignupResponse;", "closeCreateErrorDialog", "closeEmailNotVerifiedDialog", "isRepeatingPattern", "s", "containsEmailParts", "hasLongNumericSequence", "input", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAuthenticationViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationViewModel.kt\nui/screens/signin/AuthenticationViewModel\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,355:1\n2540#2,7:356\n*S KotlinDebug\n*F\n+ 1 AuthenticationViewModel.kt\nui/screens/signin/AuthenticationViewModel\n*L\n327#1:356,7\n*E\n"})
public final class AuthenticationViewModel
implements ScreenModel {
    @NotNull
    private final OSPlatform platform;
    @NotNull
    private final UserRepositoryApi userRepo;
    @NotNull
    private final MyEventRepositoryApi myEvents;
    @NotNull
    private final Settings settings;
    @NotNull
    private final MultiLogger logger;
    private boolean isMyEvents;
    @NotNull
    private final MutableStateFlow<AuthenticationState> _authenticationstate;
    @NotNull
    private final StateFlow<AuthenticationState> authenticationState;
    public static final int $stable = 8;

    public AuthenticationViewModel(@NotNull OSPlatform platform, @NotNull UserRepositoryApi userRepo, @NotNull MyEventRepositoryApi myEvents, @NotNull Settings settings, @NotNull MultiLogger logger) {
        boolean isAccountAlreadyChosen;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)userRepo, (String)"userRepo");
        Intrinsics.checkNotNullParameter((Object)myEvents, (String)"myEvents");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.platform = platform;
        this.userRepo = userRepo;
        this.myEvents = myEvents;
        this.settings = settings;
        this.logger = logger;
        this._authenticationstate = StateFlowKt.MutableStateFlow((Object)new AuthenticationState.SignedOut(this.isMyEvents));
        this.authenticationState = (StateFlow)this._authenticationstate;
        User user = this.userRepo.getSignedInUser();
        boolean bl = isAccountAlreadyChosen = this.settings.getStringOrNull("activeAccount") != null;
        if (user == null) {
            if (isAccountAlreadyChosen) {
                this._authenticationstate.setValue((Object)AuthenticationState.UserNameAndPassword.INSTANCE);
            } else {
                this._authenticationstate.setValue((Object)new AuthenticationState.SignedOut(false));
                BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ AuthenticationViewModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = AuthenticationViewModel.access$getMyEvents$p(this.this$0).getMyEventList((Continuation<? super ResultOf<? extends List<MyEvent>>>)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if ((var3_4 = (list = (ResultOf)v0)) instanceof ResultOf.Failure) {
                                    v1 = false;
                                } else if (var3_4 instanceof ResultOf.Success) {
                                    v1 = !((Collection)((ResultOf.Success)list).getResult()).isEmpty();
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                this.this$0.setMyEvents(v1);
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.SignedOut(this.this$0.isMyEvents()));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        } else {
            this._authenticationstate.setValue((Object)new AuthenticationState.SignedIn(user));
        }
    }

    public final boolean isMyEvents() {
        return this.isMyEvents;
    }

    public final void setMyEvents(boolean bl) {
        this.isMyEvents = bl;
    }

    @NotNull
    public final StateFlow<AuthenticationState> getAuthenticationState() {
        return this.authenticationState;
    }

    public final void signIn(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, email, password, null){
            Object L$0;
            int label;
            final /* synthetic */ AuthenticationViewModel this$0;
            final /* synthetic */ String $email;
            final /* synthetic */ String $password;
            {
                this.this$0 = $receiver;
                this.$email = $email;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block13: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)AuthenticationState.SigningIn.INSTANCE);
                            this.label = 1;
                            v0 = AuthenticationViewModel.access$getUserRepo$p(this.this$0).signIn(StringsKt.trim((CharSequence)this.$email).toString(), this.$password, (Continuation<? super ResultOf<User>>)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            if (!((result = (ResultOf)v0) instanceof ResultOf.Failure)) break;
                            this.L$0 = result;
                            this.label = 2;
                            v1 = DelayKt.delay((long)1500L, (Continuation)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl25
                        }
                        case 2: {
                            result = (ResultOf)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl25:
                            // 2 sources

                            System.out.println((Object)("Sign In error " + ((ResultOf.Failure)result).getException()));
                            var3_4 = ((ResultOf.Failure)result).getException();
                            if (var3_4 instanceof NetworkException) {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.Error(SignInError.NetworkError.INSTANCE));
                            } else if (var3_4 instanceof EmailNotVerified) {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)AuthenticationState.EmailNotVerified.INSTANCE);
                            } else {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.Error(SignInError.Other.INSTANCE));
                            }
                            break block13;
                        }
                    }
                    if (result instanceof ResultOf.Success) {
                        System.out.println((Object)"Sign In Success");
                        AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.SignedIn((User)((ResultOf.Success)result).getResult()));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void signOut() {
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AuthenticationViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        AuthenticationViewModel.access$getSettings$p(this.this$0).putBoolean("isDemoOpened", false);
                        this.label = 1;
                        v0 = AuthenticationViewModel.access$getUserRepo$p(this.this$0).signOut((Continuation<? super ResultOf<Unit>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if ((result = (ResultOf)v0) instanceof ResultOf.Failure) {
                            System.out.println((Object)("Sign In error " + ((ResultOf.Failure)result).getException()));
                        } else if (result instanceof ResultOf.Success) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.SignedOut(this.this$0.isMyEvents()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void signInComplete() {
        this._authenticationstate.setValue((Object)AuthenticationState.SignInComplete.INSTANCE);
    }

    public final void showSignInScreen() {
        this._authenticationstate.setValue((Object)AuthenticationState.UserNameAndPassword.INSTANCE);
    }

    public final void showChoiceScreen() {
        this._authenticationstate.setValue((Object)new AuthenticationState.SignedOut(this.isMyEvents));
    }

    public final void showForgotPasswordScreen() {
        this._authenticationstate.setValue((Object)AuthenticationState.ForgotPassword.INSTANCE);
    }

    public final void sendPasswordResetEmail(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ AuthenticationViewModel this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)AuthenticationState.ForgotPasswordProcessing.INSTANCE);
                        this.label = 1;
                        v0 = DelayKt.delay((long)200L, (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.label = 2;
                        v1 = AuthenticationViewModel.access$getUserRepo$p(this.this$0).forgotPassword(this.$value, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        if ((var3_4 = (result = (ResultOf)v1)) instanceof ResultOf.Failure) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)AuthenticationState.ForgotPasswordError.INSTANCE);
                        } else if (var3_4 instanceof ResultOf.Success) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)AuthenticationState.ForgotPasswordComplete.INSTANCE);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void clearForgotPasswordDialog() {
        this._authenticationstate.setValue((Object)AuthenticationState.ForgotPassword.INSTANCE);
    }

    public final void onSignUpClicked() {
        this._authenticationstate.setValue((Object)new AuthenticationState.CreateAccount(CreateAccountState.Creation.INSTANCE));
    }

    public final void createAccount(@NotNull String email, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(password, this, email, null){
            int label;
            final /* synthetic */ String $password;
            final /* synthetic */ AuthenticationViewModel this$0;
            final /* synthetic */ String $email;
            {
                this.$password = $password;
                this.this$0 = $receiver;
                this.$email = $email;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.$password.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                        if (StringsKt.toSet((CharSequence)v0).size() <= 1) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Password cannot all be same character")));
                            return Unit.INSTANCE;
                        }
                        v1 = this.$password.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                        if (StringsKt.toSet((CharSequence)v1).size() <= 5) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Password Must Be More Than 5 Unique Characters")));
                            return Unit.INSTANCE;
                        }
                        if (AuthenticationViewModel.access$isRepeatingPattern(this.this$0, this.$password)) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Password Cannot Be A Repetition")));
                            return Unit.INSTANCE;
                        }
                        if (AuthenticationViewModel.access$containsEmailParts(this.this$0, this.$password, this.$email)) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Password Cannot Contain Email Prefix or Domain")));
                            return Unit.INSTANCE;
                        }
                        if (AuthenticationViewModel.access$hasLongNumericSequence(this.this$0, this.$password)) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Password Cannot Contain Numeric Sequences Longer than 2 numbers")));
                            return Unit.INSTANCE;
                        }
                        AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(CreateAccountState.Processing.INSTANCE));
                        this.label = 1;
                        v2 = AuthenticationViewModel.access$getUserRepo$p(this.this$0).createAccount(StringsKt.trim((CharSequence)this.$email).toString(), StringsKt.trim((CharSequence)this.$password).toString(), (Continuation<? super ResultOf<FirebaseSignupResponse>>)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl33
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl33:
                        // 2 sources

                        if ((result = (ResultOf)v2) instanceof ResultOf.Failure) {
                            var3_4 = ((ResultOf.Failure)result).getException();
                            if (var3_4 instanceof NetworkException) {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Check Your Internet And Try Again")));
                            } else if (var3_4 instanceof UserRemoteSource.CreateAccountPasswordRuleException) {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("Minimum Password Requirements Not Met:\n\n16 chars, 1 upper, 1 lower")));
                            } else {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.CreateAccountError("An Error Occurred")));
                            }
                        } else if (result instanceof ResultOf.Success) {
                            if (((FirebaseSignupResponse)((ResultOf.Success)result).getResult()).getDidSendPasswordSucceed()) {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.PendingConfirmation((FirebaseSignupResponse)((ResultOf.Success)result).getResult())));
                            } else {
                                AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.ConfirmationError((FirebaseSignupResponse)((ResultOf.Success)result).getResult())));
                            }
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void resendEmailVerification(@NotNull FirebaseSignupResponse firebaseSignupResponse) {
        Intrinsics.checkNotNullParameter((Object)firebaseSignupResponse, (String)"firebaseSignupResponse");
        this._authenticationstate.setValue((Object)new AuthenticationState.CreateAccount(CreateAccountState.Processing.INSTANCE));
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, firebaseSignupResponse, null){
            int label;
            final /* synthetic */ AuthenticationViewModel this$0;
            final /* synthetic */ FirebaseSignupResponse $firebaseSignupResponse;
            {
                this.this$0 = $receiver;
                this.$firebaseSignupResponse = $firebaseSignupResponse;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AuthenticationViewModel.access$getUserRepo$p(this.this$0).sendVerificationEmail(this.$firebaseSignupResponse, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((var2_3 = (ResultOf)v0) instanceof ResultOf.Failure) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.ConfirmationError(this.$firebaseSignupResponse)));
                        } else if (var2_3 instanceof ResultOf.Success) {
                            AuthenticationViewModel.access$get_authenticationstate$p(this.this$0).setValue((Object)new AuthenticationState.CreateAccount(new CreateAccountState.PendingConfirmation(this.$firebaseSignupResponse)));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void closeCreateErrorDialog() {
        this._authenticationstate.setValue((Object)new AuthenticationState.CreateAccount(CreateAccountState.Creation.INSTANCE));
    }

    public final void closeEmailNotVerifiedDialog() {
        this._authenticationstate.setValue((Object)AuthenticationState.UserNameAndPassword.INSTANCE);
    }

    private final boolean isRepeatingPattern(String s) {
        if (s.length() < 2) {
            return false;
        }
        String doubled = s + s;
        String string2 = doubled.substring(1, doubled.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String trimmed = string2;
        return StringsKt.contains$default((CharSequence)trimmed, (CharSequence)s, (boolean)false, (int)2, null);
    }

    private final boolean containsEmailParts(String password, String email) {
        String string2 = password.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String pw = string2;
        int at = StringsKt.indexOf$default((CharSequence)email, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (at <= 0) {
            return false;
        }
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)email, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDot <= at + 1) {
            return false;
        }
        String string3 = email.substring(0, at);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String local = string4;
        String string5 = email.substring(at + 1, lastDot);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String string6 = string5.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        String domain = string6;
        if (local.length() >= 3 && StringsKt.contains$default((CharSequence)pw, (CharSequence)local, (boolean)false, (int)2, null)) {
            return true;
        }
        return domain.length() >= 3 && StringsKt.contains$default((CharSequence)pw, (CharSequence)domain, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasLongNumericSequence(String input) {
        int increasingCount = 0;
        increasingCount = 1;
        int decreasingCount = 0;
        decreasingCount = 1;
        CharSequence $this$zipWithNext$iv = input;
        boolean $i$f$zipWithNext = false;
        int size$iv = $this$zipWithNext$iv.length() - 1;
        if (size$iv < 1) {
            v0 = CollectionsKt.emptyList();
        } else {
            ArrayList<Unit> result$iv = new ArrayList<Unit>(size$iv);
            for (int index$iv = 0; index$iv < size$iv; ++index$iv) {
                void curr;
                void prev;
                char c = $this$zipWithNext$iv.charAt(index$iv + 1);
                char c2 = $this$zipWithNext$iv.charAt(index$iv);
                ArrayList<Unit> arrayList = result$iv;
                boolean bl = false;
                if (Character.isDigit((char)prev) && Character.isDigit((char)curr)) {
                    void var12_12 = curr;
                    if (var12_12 == (char)(prev + true)) {
                        ++increasingCount;
                        decreasingCount = 1;
                    } else if (var12_12 == (char)(prev - true)) {
                        ++decreasingCount;
                        increasingCount = 1;
                    } else {
                        increasingCount = 1;
                        decreasingCount = 1;
                    }
                    if (increasingCount >= 3 || decreasingCount >= 3) {
                        return true;
                    }
                } else {
                    increasingCount = 1;
                    decreasingCount = 1;
                }
                arrayList.add(Unit.INSTANCE);
            }
            v0 = result$iv;
        }
        return false;
    }

    public void onDispose() {
        ScreenModel.DefaultImpls.onDispose((ScreenModel)this);
    }

    public static final /* synthetic */ MutableStateFlow access$get_authenticationstate$p(AuthenticationViewModel $this) {
        return $this._authenticationstate;
    }

    public static final /* synthetic */ UserRepositoryApi access$getUserRepo$p(AuthenticationViewModel $this) {
        return $this.userRepo;
    }

    public static final /* synthetic */ Settings access$getSettings$p(AuthenticationViewModel $this) {
        return $this.settings;
    }

    public static final /* synthetic */ boolean access$isRepeatingPattern(AuthenticationViewModel $this, String s) {
        return $this.isRepeatingPattern(s);
    }

    public static final /* synthetic */ boolean access$containsEmailParts(AuthenticationViewModel $this, String password, String email) {
        return $this.containsEmailParts(password, email);
    }

    public static final /* synthetic */ boolean access$hasLongNumericSequence(AuthenticationViewModel $this, String input) {
        return $this.hasLongNumericSequence(input);
    }

    public static final /* synthetic */ MyEventRepositoryApi access$getMyEvents$p(AuthenticationViewModel $this) {
        return $this.myEvents;
    }
}

