/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.google.firebase.FirebasePlatform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public final class Log {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final int LOG_ID_MAIN = 0;
    public static final int LOG_ID_RADIO = 1;
    public static final int LOG_ID_EVENTS = 2;
    public static final int LOG_ID_SYSTEM = 3;
    public static final int LOG_ID_CRASH = 4;

    private Log() {
    }

    public static int v(String tag, String msg) {
        return Log.println(0, 2, tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return Log.println(0, 2, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static int d(String tag, String msg) {
        return Log.println(0, 3, tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return Log.println(0, 3, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static int i(String tag, String msg) {
        return Log.println(0, 4, tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return Log.println(0, 4, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static int w(String tag, String msg) {
        return Log.println(0, 5, tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return Log.println(0, 5, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static int w(String tag, Throwable tr) {
        return Log.println(0, 5, tag, Log.getStackTraceString(tr));
    }

    public static int e(String tag, String msg) {
        return Log.println(0, 6, tag, msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return Log.println(0, 6, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static int wtf(String tag, String msg) {
        return Log.println(0, 7, tag, msg);
    }

    public static int wtf(String tag, String msg, Throwable tr) {
        return Log.println(0, 7, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static int wtf(String tag, Throwable tr) {
        return Log.println(0, 7, tag, Log.getStackTraceString(tr));
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static int println(int priority, String tag, String msg) {
        return Log.println(0, priority, tag, msg);
    }

    public static int println(int bufID, int priority, String tag, String msg) {
        FirebasePlatform.firebasePlatform.log(tag + " " + msg);
        return 0;
    }

    public static boolean isLoggable(String var0, int var1) {
        return true;
    }
}

