/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.SnapshotHolder;
import com.google.firebase.database.core.SyncTree;
import com.google.firebase.database.core.ValueProvider;
import com.google.firebase.database.core.utilities.Clock;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import java.util.HashMap;
import java.util.Map;

public class ServerValues {
    public static final String NAME_SUBKEY_SERVERVALUE = ".sv";
    public static final String NAME_OP_TIMESTAMP = "timestamp";
    public static final String NAME_OP_INCREMENT = "increment";

    public static Map<String, Object> generateServerValues(Clock clock) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(NAME_OP_TIMESTAMP, clock.millis());
        return values;
    }

    public static Object resolveDeferredLeafValue(Object value, ValueProvider existing, Map<String, Object> serverValues) {
        if (!(value instanceof Map)) {
            return value;
        }
        Map mapValue = (Map)value;
        if (!mapValue.containsKey(NAME_SUBKEY_SERVERVALUE)) {
            return value;
        }
        Object op = mapValue.get(NAME_SUBKEY_SERVERVALUE);
        Object res = null;
        if (op instanceof String) {
            res = ServerValues.resolveScalarDeferredValue((String)op, serverValues);
        } else if (op instanceof Map) {
            res = ServerValues.resolveComplexDeferredValue((Map)op, existing, serverValues);
        }
        if (res == null) {
            return value;
        }
        return res;
    }

    static Object resolveScalarDeferredValue(String op, Map<String, Object> serverValues) {
        if (NAME_OP_TIMESTAMP.equals(op) && serverValues.containsKey(op)) {
            return serverValues.get(op);
        }
        return null;
    }

    static Object resolveComplexDeferredValue(Map<String, Object> op, ValueProvider existing, Map<String, Object> serverValues) {
        long y;
        long r;
        long x;
        if (!op.containsKey(NAME_OP_INCREMENT)) {
            return null;
        }
        Object incrObject = op.get(NAME_OP_INCREMENT);
        if (!(incrObject instanceof Number)) {
            return null;
        }
        Number increment = (Number)incrObject;
        Node existingNode = existing.node();
        if (!existingNode.isLeafNode() || !(existingNode.getValue() instanceof Number)) {
            return increment;
        }
        Number existingVal = (Number)existingNode.getValue();
        if (ServerValues.canBeRepresentedAsLong(increment) && ServerValues.canBeRepresentedAsLong(existingVal) && (((x = increment.longValue()) ^ (r = x + (y = existingVal.longValue()))) & (y ^ r)) >= 0L) {
            return r;
        }
        return increment.doubleValue() + existingVal.doubleValue();
    }

    public static Node resolveDeferredValueSnapshot(Node data, Node existing, Map<String, Object> serverValues) {
        return ServerValues.resolveDeferredValueSnapshot(data, new ValueProvider.ExistingValueProvider(existing), serverValues);
    }

    public static Node resolveDeferredValueSnapshot(Node data, SyncTree syncTree, Path path, Map<String, Object> serverValues) {
        return ServerValues.resolveDeferredValueSnapshot(data, new ValueProvider.DeferredValueProvider(syncTree, path), serverValues);
    }

    private static Node resolveDeferredValueSnapshot(Node data, final ValueProvider existing, final Map<String, Object> serverValues) {
        Object rawPriority = data.getPriority().getValue();
        Object priority = ServerValues.resolveDeferredLeafValue(rawPriority, existing.getImmediateChild(ChildKey.fromString(".priority")), serverValues);
        if (data.isLeafNode()) {
            Object value = ServerValues.resolveDeferredLeafValue(data.getValue(), existing, serverValues);
            if (!value.equals(data.getValue()) || !Utilities.equals(priority, rawPriority)) {
                return NodeUtilities.NodeFromJSON(value, PriorityUtilities.parsePriority(priority));
            }
            return data;
        }
        if (data.isEmpty()) {
            return data;
        }
        ChildrenNode childNode = (ChildrenNode)data;
        final SnapshotHolder holder = new SnapshotHolder(childNode);
        childNode.forEachChild(new ChildrenNode.ChildVisitor(){

            @Override
            public void visitChild(ChildKey name, Node child) {
                Node newChildNode = ServerValues.resolveDeferredValueSnapshot(child, existing.getImmediateChild(name), (Map<String, Object>)serverValues);
                if (newChildNode != child) {
                    holder.update(new Path(name.asString()), newChildNode);
                }
            }
        });
        if (!holder.getRootNode().getPriority().equals(priority)) {
            return holder.getRootNode().updatePriority(PriorityUtilities.parsePriority(priority));
        }
        return holder.getRootNode();
    }

    public static CompoundWrite resolveDeferredValueMerge(CompoundWrite merge, SyncTree syncTree, Path path, Map<String, Object> serverValues) {
        CompoundWrite write = CompoundWrite.emptyWrite();
        for (Map.Entry<Path, Node> entry : merge) {
            ValueProvider.DeferredValueProvider deferredValue = new ValueProvider.DeferredValueProvider(syncTree, path.child(entry.getKey()));
            write = write.addWrite(entry.getKey(), ServerValues.resolveDeferredValueSnapshot(entry.getValue(), deferredValue, serverValues));
        }
        return write;
    }

    private static boolean canBeRepresentedAsLong(Number x) {
        return !(x instanceof Double) && !(x instanceof Float);
    }
}

