/*
 * Decompiled with CFR 0.152.
 */
package sh.calvin.autolinktext;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.UrlAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import sh.calvin.autolinktext.ContextData;
import sh.calvin.autolinktext.SimpleTextMatchResult;
import sh.calvin.autolinktext.TextMatchResult;
import sh.calvin.autolinktext.TextRule;
import sh.calvin.autolinktext.TextRuleDefaultsInterface;
import sh.calvin.autolinktext.TextRuleKt;
import sh.calvin.autolinktext.TextRule_jvmKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a&\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00100\u000f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a2\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00100\u000f\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a*\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00100\u000f\"\u0004\b\u0000\u0010\n*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00100\u000fH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"NullContextData", "Lsh/calvin/autolinktext/ContextData;", "getNullContextData", "()Lsh/calvin/autolinktext/ContextData;", "TextRuleDefaults", "Lsh/calvin/autolinktext/TextRuleDefaultsInterface;", "getTextRuleDefaults", "()Lsh/calvin/autolinktext/TextRuleDefaultsInterface;", "annotateString", "Landroidx/compose/ui/text/AnnotatedString;", "T", "", "Lsh/calvin/autolinktext/TextRule;", "text", "", "", "Lsh/calvin/autolinktext/TextMatchResult;", "getAllMatches", "pruneOverlaps", "autolinktext"})
@SourceDebugExtension(value={"SMAP\nTextRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRule.kt\nsh/calvin/autolinktext/TextRuleKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1360#2:208\n1446#2,2:209\n1549#2:211\n1620#2,3:212\n1448#2,3:215\n1855#2,2:218\n*S KotlinDebug\n*F\n+ 1 TextRule.kt\nsh/calvin/autolinktext/TextRuleKt\n*L\n128#1:208\n128#1:209,2\n129#1:211\n129#1:212,3\n128#1:215,3\n186#1:218,2\n*E\n"})
public final class TextRuleKt {
    @NotNull
    private static final ContextData NullContextData = new ContextData(){};
    @NotNull
    private static final TextRuleDefaultsInterface TextRuleDefaults = TextRule_jvmKt.getTextRuleDefaults();

    @NotNull
    public static final ContextData getNullContextData() {
        return NullContextData;
    }

    @NotNull
    public static final TextRuleDefaultsInterface getTextRuleDefaults() {
        return TextRuleDefaults;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<TextMatchResult<T>> getAllMatches(@NotNull Collection<TextRule<T>> $this$getAllMatches, @NotNull String text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getAllMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$flatMap$iv = $this$getAllMatches;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TextRule rule = (TextRule)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = rule.getTextMatcher().apply(text);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void match;
                SimpleTextMatchResult simpleTextMatchResult = (SimpleTextMatchResult)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new TextMatchResult(rule, text, match));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return TextRuleKt.pruneOverlaps((List)destination$iv$iv);
    }

    private static final <T> List<TextMatchResult<T>> pruneOverlaps(List<TextMatchResult<T>> $this$pruneOverlaps) {
        List sortedList2 = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$pruneOverlaps, (arg_0, arg_1) -> TextRuleKt.pruneOverlaps$lambda$2(pruneOverlaps.sortedList.1.INSTANCE, arg_0, arg_1)));
        int len = sortedList2.size();
        int i = 0;
        while (i < len - 1) {
            TextMatchResult a = (TextMatchResult)sortedList2.get(i);
            TextMatchResult b = (TextMatchResult)sortedList2.get(i + 1);
            int remove = -1;
            if (a.getStart() <= b.getStart() && a.getEndExclusive() > b.getStart()) {
                if (b.getEndExclusive() <= a.getEndExclusive()) {
                    remove = i + 1;
                } else if (a.getEndExclusive() - a.getStart() > b.getEndExclusive() - b.getStart()) {
                    remove = i + 1;
                } else if (a.getEndExclusive() - a.getStart() < b.getEndExclusive() - b.getStart()) {
                    remove = i;
                }
                if (remove != -1) {
                    sortedList2.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
        return sortedList2;
    }

    @NotNull
    public static final <T> AnnotatedString annotateString(@NotNull List<TextMatchResult<T>> $this$annotateString, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$annotateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        AnnotatedString.Builder annotatedString = new AnnotatedString.Builder(text);
        Iterable $this$forEach$iv = $this$annotateString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            TextMatchResult match = (TextMatchResult)element$iv;
            boolean bl = false;
            SpanStyle style = (SpanStyle)match.getRule().getStyleProvider().invoke((Object)match);
            if (style != null) {
                annotatedString.addStyle(style, match.getStart().intValue(), match.getEndExclusive().intValue());
            }
            if ((String)match.getRule().getAnnotationProvider().invoke((Object)match) == null) continue;
            String annotation = string;
            boolean bl2 = false;
            annotatedString.addUrlAnnotation(new UrlAnnotation(annotation), match.getStart().intValue(), match.getEndExclusive().intValue());
        }
        return annotatedString.toAnnotatedString();
    }

    @NotNull
    public static final <T> AnnotatedString annotateString(@NotNull Collection<TextRule<T>> $this$annotateString, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$annotateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<TextMatchResult<T>> matches = TextRuleKt.getAllMatches($this$annotateString, text);
        return TextRuleKt.annotateString(matches, text);
    }

    private static final int pruneOverlaps$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

