/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.grid;

import androidx.compose.runtime.Immutable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Instant;
import models.GridOrientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u001e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003Jc\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u00c6\u0001J\u0013\u0010,\u001a\u00020\f2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\bH\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001b\u00a8\u00061"}, d2={"Lui/screens/grid/GridState;", "", "gridOrientation", "Lmodels/GridOrientation;", "offsetX", "", "offsetY", "zoomX", "", "zoomY", "nonFavoriteOpacity", "hasClearedRowColumnFilters", "", "isFirstGridVisit", "isFirstGridAdminVisit", "<init>", "(Lmodels/GridOrientation;FFIIFZZZ)V", "getGridOrientation", "()Lmodels/GridOrientation;", "getOffsetX", "()F", "getOffsetY", "getZoomX", "()I", "getZoomY", "getNonFavoriteOpacity", "getHasClearedRowColumnFilters", "()Z", "getAdjustedNow", "Lkotlinx/datetime/Instant;", "startInstant", "getAdjustedEnd", "viewHeight", "screenWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "", "shared"})
@Immutable
public final class GridState {
    @NotNull
    private final GridOrientation gridOrientation;
    private final float offsetX;
    private final float offsetY;
    private final int zoomX;
    private final int zoomY;
    private final float nonFavoriteOpacity;
    private final boolean hasClearedRowColumnFilters;
    private final boolean isFirstGridVisit;
    private final boolean isFirstGridAdminVisit;
    public static final int $stable;

    public GridState(@NotNull GridOrientation gridOrientation, float offsetX, float offsetY, int zoomX, int zoomY, float nonFavoriteOpacity, boolean hasClearedRowColumnFilters, boolean isFirstGridVisit, boolean isFirstGridAdminVisit) {
        Intrinsics.checkNotNullParameter((Object)gridOrientation, (String)"gridOrientation");
        this.gridOrientation = gridOrientation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.zoomX = zoomX;
        this.zoomY = zoomY;
        this.nonFavoriteOpacity = nonFavoriteOpacity;
        this.hasClearedRowColumnFilters = hasClearedRowColumnFilters;
        this.isFirstGridVisit = isFirstGridVisit;
        this.isFirstGridAdminVisit = isFirstGridAdminVisit;
    }

    public /* synthetic */ GridState(GridOrientation gridOrientation, float f, float f2, int n, int n2, float f3, boolean bl, boolean bl2, boolean bl3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            f = 0.0f;
        }
        if ((n3 & 4) != 0) {
            f2 = 0.0f;
        }
        this(gridOrientation, f, f2, n, n2, f3, bl, bl2, bl3);
    }

    @NotNull
    public final GridOrientation getGridOrientation() {
        return this.gridOrientation;
    }

    public final float getOffsetX() {
        return this.offsetX;
    }

    public final float getOffsetY() {
        return this.offsetY;
    }

    public final int getZoomX() {
        return this.zoomX;
    }

    public final int getZoomY() {
        return this.zoomY;
    }

    public final float getNonFavoriteOpacity() {
        return this.nonFavoriteOpacity;
    }

    public final boolean getHasClearedRowColumnFilters() {
        return this.hasClearedRowColumnFilters;
    }

    public final boolean isFirstGridVisit() {
        return this.isFirstGridVisit;
    }

    public final boolean isFirstGridAdminVisit() {
        return this.isFirstGridAdminVisit;
    }

    @NotNull
    public final Instant getAdjustedNow(@NotNull Instant startInstant) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)startInstant, (String)"startInstant");
        GridOrientation gridOrientation = this.gridOrientation;
        if (gridOrientation instanceof GridOrientation.Portrait) {
            f2 = (float)((((GridOrientation.Portrait)this.gridOrientation).getHourHeight() + this.zoomY) * 24) / (float)48 / (float)30 / (float)60;
        } else if (gridOrientation instanceof GridOrientation.Landscape) {
            f2 = (float)((((GridOrientation.Landscape)this.gridOrientation).getColumnWidth() + this.zoomX) * 48) / (float)48 / (float)30 / (float)60;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float secondsPerPixel = f2;
        GridOrientation gridOrientation2 = this.gridOrientation;
        if (gridOrientation2 instanceof GridOrientation.Portrait) {
            f = this.offsetY / secondsPerPixel;
        } else if (gridOrientation2 instanceof GridOrientation.Landscape) {
            f = this.offsetX / secondsPerPixel;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float startSecond = f;
        return startInstant.plus-LRDsOJo(Duration.times-UwyO8pc((long)DurationKt.toDuration((long)MathKt.roundToLong((float)startSecond), (DurationUnit)DurationUnit.SECONDS), (int)-1));
    }

    @NotNull
    public final Instant getAdjustedEnd(@NotNull Instant startInstant, int viewHeight, int screenWidth) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)startInstant, (String)"startInstant");
        GridOrientation gridOrientation = this.gridOrientation;
        if (gridOrientation instanceof GridOrientation.Portrait) {
            f2 = (float)((((GridOrientation.Portrait)this.gridOrientation).getHourHeight() + this.zoomY) * 24) / (float)48 / (float)30 / (float)60;
        } else if (gridOrientation instanceof GridOrientation.Landscape) {
            f2 = (float)((((GridOrientation.Landscape)this.gridOrientation).getColumnWidth() + this.zoomX) * 48) / (float)48 / (float)30 / (float)60;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float secondsPerPixel = f2;
        float offsetYBottom = this.offsetY - (float)viewHeight;
        float offsetXEnd = this.offsetX - (float)screenWidth + (float)this.gridOrientation.getColumnWidth();
        GridOrientation gridOrientation2 = this.gridOrientation;
        if (gridOrientation2 instanceof GridOrientation.Portrait) {
            f = offsetYBottom / secondsPerPixel;
        } else if (gridOrientation2 instanceof GridOrientation.Landscape) {
            f = offsetXEnd / secondsPerPixel;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        float bottomSecond = f;
        return startInstant.plus-LRDsOJo(Duration.times-UwyO8pc((long)DurationKt.toDuration((long)MathKt.roundToLong((float)bottomSecond), (DurationUnit)DurationUnit.SECONDS), (int)-1));
    }

    @NotNull
    public final GridOrientation component1() {
        return this.gridOrientation;
    }

    public final float component2() {
        return this.offsetX;
    }

    public final float component3() {
        return this.offsetY;
    }

    public final int component4() {
        return this.zoomX;
    }

    public final int component5() {
        return this.zoomY;
    }

    public final float component6() {
        return this.nonFavoriteOpacity;
    }

    public final boolean component7() {
        return this.hasClearedRowColumnFilters;
    }

    public final boolean component8() {
        return this.isFirstGridVisit;
    }

    public final boolean component9() {
        return this.isFirstGridAdminVisit;
    }

    @NotNull
    public final GridState copy(@NotNull GridOrientation gridOrientation, float offsetX, float offsetY, int zoomX, int zoomY, float nonFavoriteOpacity, boolean hasClearedRowColumnFilters, boolean isFirstGridVisit, boolean isFirstGridAdminVisit) {
        Intrinsics.checkNotNullParameter((Object)gridOrientation, (String)"gridOrientation");
        return new GridState(gridOrientation, offsetX, offsetY, zoomX, zoomY, nonFavoriteOpacity, hasClearedRowColumnFilters, isFirstGridVisit, isFirstGridAdminVisit);
    }

    public static /* synthetic */ GridState copy$default(GridState gridState, GridOrientation gridOrientation, float f, float f2, int n, int n2, float f3, boolean bl, boolean bl2, boolean bl3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            gridOrientation = gridState.gridOrientation;
        }
        if ((n3 & 2) != 0) {
            f = gridState.offsetX;
        }
        if ((n3 & 4) != 0) {
            f2 = gridState.offsetY;
        }
        if ((n3 & 8) != 0) {
            n = gridState.zoomX;
        }
        if ((n3 & 0x10) != 0) {
            n2 = gridState.zoomY;
        }
        if ((n3 & 0x20) != 0) {
            f3 = gridState.nonFavoriteOpacity;
        }
        if ((n3 & 0x40) != 0) {
            bl = gridState.hasClearedRowColumnFilters;
        }
        if ((n3 & 0x80) != 0) {
            bl2 = gridState.isFirstGridVisit;
        }
        if ((n3 & 0x100) != 0) {
            bl3 = gridState.isFirstGridAdminVisit;
        }
        return gridState.copy(gridOrientation, f, f2, n, n2, f3, bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "GridState(gridOrientation=" + this.gridOrientation + ", offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + ", zoomX=" + this.zoomX + ", zoomY=" + this.zoomY + ", nonFavoriteOpacity=" + this.nonFavoriteOpacity + ", hasClearedRowColumnFilters=" + this.hasClearedRowColumnFilters + ", isFirstGridVisit=" + this.isFirstGridVisit + ", isFirstGridAdminVisit=" + this.isFirstGridAdminVisit + ")";
    }

    public int hashCode() {
        int result = this.gridOrientation.hashCode();
        result = result * 31 + Float.hashCode(this.offsetX);
        result = result * 31 + Float.hashCode(this.offsetY);
        result = result * 31 + Integer.hashCode(this.zoomX);
        result = result * 31 + Integer.hashCode(this.zoomY);
        result = result * 31 + Float.hashCode(this.nonFavoriteOpacity);
        result = result * 31 + Boolean.hashCode(this.hasClearedRowColumnFilters);
        result = result * 31 + Boolean.hashCode(this.isFirstGridVisit);
        result = result * 31 + Boolean.hashCode(this.isFirstGridAdminVisit);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GridState)) {
            return false;
        }
        GridState gridState = (GridState)other;
        if (!Intrinsics.areEqual((Object)this.gridOrientation, (Object)gridState.gridOrientation)) {
            return false;
        }
        if (Float.compare(this.offsetX, gridState.offsetX) != 0) {
            return false;
        }
        if (Float.compare(this.offsetY, gridState.offsetY) != 0) {
            return false;
        }
        if (this.zoomX != gridState.zoomX) {
            return false;
        }
        if (this.zoomY != gridState.zoomY) {
            return false;
        }
        if (Float.compare(this.nonFavoriteOpacity, gridState.nonFavoriteOpacity) != 0) {
            return false;
        }
        if (this.hasClearedRowColumnFilters != gridState.hasClearedRowColumnFilters) {
            return false;
        }
        if (this.isFirstGridVisit != gridState.isFirstGridVisit) {
            return false;
        }
        return this.isFirstGridAdminVisit == gridState.isFirstGridAdminVisit;
    }
}

