/*
 * Decompiled with CFR 0.152.
 */
package ui.screens.myevents;

import androidx.compose.runtime.internal.StabilityInferred;
import cafe.adriel.voyager.core.model.ScreenModel;
import cafe.adriel.voyager.core.model.ScreenModelKt;
import common.TimeProvider;
import common.analytics.AnalyticsLogger;
import data.account.ResultOf;
import data.myevents.MyEventRepositoryApi;
import data.myevents.model.MyEvent;
import data.subscriptiontopics.SubscriptionTopicsRepositoryApi;
import di.MultiLogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import myapplication.shared.generated.resources.Res;
import myapplication.shared.generated.resources.String3_commonMainKt;
import myapplication.shared.generated.resources.String4_commonMainKt;
import org.jetbrains.annotations.NotNull;
import ui.screens.myevents.MyEventUiState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lui/screens/myevents/MyEventViewModel;", "Lcafe/adriel/voyager/core/model/ScreenModel;", "myEventsRepo", "Ldata/myevents/MyEventRepositoryApi;", "subscriptionTopicsRepo", "Ldata/subscriptiontopics/SubscriptionTopicsRepositoryApi;", "logger", "Ldi/MultiLogger;", "analytics", "Lcommon/analytics/AnalyticsLogger;", "<init>", "(Ldata/myevents/MyEventRepositoryApi;Ldata/subscriptiontopics/SubscriptionTopicsRepositoryApi;Ldi/MultiLogger;Lcommon/analytics/AnalyticsLogger;)V", "_myEventUiStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lui/screens/myevents/MyEventUiState;", "myEventUiStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getMyEventUiStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "_showDeleteDialogStateFlow", "Ldata/myevents/model/MyEvent;", "showDeleteDialogStateFlow", "getShowDeleteDialogStateFlow", "loadMyEvents", "", "eventSelected", "myEvent", "removeEventClicked", "event", "removeEventCancelled", "removeEventConfirmed", "shared"})
@StabilityInferred(parameters=0)
public final class MyEventViewModel
implements ScreenModel {
    @NotNull
    private final MyEventRepositoryApi myEventsRepo;
    @NotNull
    private final SubscriptionTopicsRepositoryApi subscriptionTopicsRepo;
    @NotNull
    private final MultiLogger logger;
    @NotNull
    private final AnalyticsLogger analytics;
    @NotNull
    private final MutableStateFlow<MyEventUiState> _myEventUiStateFlow;
    @NotNull
    private final StateFlow<MyEventUiState> myEventUiStateFlow;
    @NotNull
    private final MutableStateFlow<MyEvent> _showDeleteDialogStateFlow;
    @NotNull
    private final StateFlow<MyEvent> showDeleteDialogStateFlow;
    public static final int $stable = 8;

    public MyEventViewModel(@NotNull MyEventRepositoryApi myEventsRepo, @NotNull SubscriptionTopicsRepositoryApi subscriptionTopicsRepo, @NotNull MultiLogger logger, @NotNull AnalyticsLogger analytics) {
        Intrinsics.checkNotNullParameter((Object)myEventsRepo, (String)"myEventsRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionTopicsRepo, (String)"subscriptionTopicsRepo");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        this.myEventsRepo = myEventsRepo;
        this.subscriptionTopicsRepo = subscriptionTopicsRepo;
        this.logger = logger;
        this.analytics = analytics;
        this._myEventUiStateFlow = StateFlowKt.MutableStateFlow((Object)MyEventUiState.Loading.INSTANCE);
        this.myEventUiStateFlow = (StateFlow)this._myEventUiStateFlow;
        this._showDeleteDialogStateFlow = StateFlowKt.MutableStateFlow(null);
        this.showDeleteDialogStateFlow = (StateFlow)this._showDeleteDialogStateFlow;
        this.logger.i("MyEventViewModel Loaded");
    }

    @NotNull
    public final StateFlow<MyEventUiState> getMyEventUiStateFlow() {
        return this.myEventUiStateFlow;
    }

    @NotNull
    public final StateFlow<MyEvent> getShowDeleteDialogStateFlow() {
        return this.showDeleteDialogStateFlow;
    }

    public final void loadMyEvents() {
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MyEventViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = MyEventViewModel.access$getMyEventsRepo$p(this.this$0).getMyEventList((Continuation<? super ResultOf<? extends List<MyEvent>>>)((Continuation)this));
                        if (v0 == var20_2) {
                            return var20_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        eventListResult = (ResultOf)v0;
                        v1 = MyEventViewModel.access$get_myEventUiStateFlow$p(this.this$0);
                        var3_4 = eventListResult;
                        if (var3_4 instanceof ResultOf.Failure) {
                            v2 = new MyEventUiState.Error(String3_commonMainKt.getEvent_search_error_message(Res.string.INSTANCE), ((ResultOf.Failure)eventListResult).getException());
                        } else if (var3_4 instanceof ResultOf.Success) {
                            if (((List)((ResultOf.Success)eventListResult).getResult()).isEmpty()) {
                                v2 = MyEventUiState.NoResultsFound.INSTANCE;
                            } else {
                                $this$sortedByDescending$iv = (Iterable)((ResultOf.Success)eventListResult).getResult();
                                $i$f$sortedByDescending = false;
                                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                                    public final int compare(T a, T b) {
                                        MyEvent it = (MyEvent)b;
                                        boolean bl = false;
                                        Comparable comparable = (Comparable)it.getStartDate();
                                        it = (MyEvent)a;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getStartDate()));
                                    }
                                });
                                var19_7 = v1;
                                $i$f$groupBy = false;
                                var7_8 = $this$groupBy$iv;
                                destination$iv$iv = new LinkedHashMap<K, V>();
                                $i$f$groupByTo = false;
                                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                                    it = (MyEvent)element$iv$iv;
                                    $i$a$-groupBy-MyEventViewModel$loadMyEvents$1$groupedEvents$2 = false;
                                    key$iv$iv = Boxing.boxBoolean((boolean)(it.getEndDate().compareTo(TimeProvider.INSTANCE.getLocalDate()) >= 0));
                                    $this$getOrPut$iv$iv$iv = destination$iv$iv;
                                    $i$f$getOrPut = false;
                                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                                    if (value$iv$iv$iv == null) {
                                        $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                                        answer$iv$iv$iv = new ArrayList<E>();
                                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                        v3 /* !! */  = answer$iv$iv$iv;
                                    } else {
                                        v3 /* !! */  = value$iv$iv$iv;
                                    }
                                    list$iv$iv = (List)v3 /* !! */ ;
                                    list$iv$iv.add(element$iv$iv);
                                }
                                v1 = var19_7;
                                groupedEvents = destination$iv$iv;
                                v4 = (List)groupedEvents.get(Boxing.boxBoolean((boolean)true));
                                if (v4 == null) {
                                    v4 = CollectionsKt.emptyList();
                                }
                                if ((v5 = (List)groupedEvents.get(Boxing.boxBoolean((boolean)false))) == null) {
                                    v5 = CollectionsKt.emptyList();
                                }
                                v2 = new MyEventUiState.EventsLoaded(v4, v5);
                            }
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        v1.setValue((Object)v2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void eventSelected(@NotNull MyEvent myEvent) {
        Intrinsics.checkNotNullParameter((Object)myEvent, (String)"myEvent");
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, myEvent, null){
            int label;
            final /* synthetic */ MyEventViewModel this$0;
            final /* synthetic */ MyEvent $myEvent;
            {
                this.this$0 = $receiver;
                this.$myEvent = $myEvent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = MyEventViewModel.access$getMyEventsRepo$p(this.this$0).setActiveEvent(this.$myEvent, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        MyEventViewModel.access$get_myEventUiStateFlow$p(this.this$0).setValue((Object)MyEventUiState.EventSelected.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void removeEventClicked(@NotNull MyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this._showDeleteDialogStateFlow.setValue((Object)event);
    }

    public final void removeEventCancelled() {
        this._showDeleteDialogStateFlow.setValue(null);
    }

    public final void removeEventConfirmed(@NotNull MyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this._showDeleteDialogStateFlow.setValue(null);
        BuildersKt.launch$default((CoroutineScope)ScreenModelKt.getScreenModelScope((ScreenModel)this), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            Object L$0;
            int label;
            final /* synthetic */ MyEventViewModel this$0;
            final /* synthetic */ MyEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = MyEventViewModel.access$getSubscriptionTopicsRepo$p(this.this$0).unSubscribeFromEvent(this.$event, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (!((result = (ResultOf)v0) instanceof ResultOf.Failure)) ** GOTO lbl16
                            MyEventViewModel.access$get_myEventUiStateFlow$p(this.this$0).setValue((Object)new MyEventUiState.Error(String4_commonMainKt.getMy_events_error_unsubscribing_message(Res.string.INSTANCE), ((ResultOf.Failure)result).getException()));
                            break block7;
lbl16:
                            // 1 sources

                            if (!(result instanceof ResultOf.Success)) break;
                            this.L$0 = result;
                            this.label = 2;
                            v1 = MyEventViewModel.access$getMyEventsRepo$p(this.this$0).removeEvent(this.$event, (Continuation<? super ResultOf<Unit>>)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl27
                        }
                        case 2: {
                            result = (ResultOf)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl27:
                            // 2 sources

                            if (!((removeResult = (ResultOf)v1) instanceof ResultOf.Failure)) ** GOTO lbl30
                            MyEventViewModel.access$get_myEventUiStateFlow$p(this.this$0).setValue((Object)new MyEventUiState.Error(String4_commonMainKt.getMy_events_error_removing_event(Res.string.INSTANCE), ((ResultOf.Failure)removeResult).getException()));
                            break block7;
lbl30:
                            // 1 sources

                            if (!(removeResult instanceof ResultOf.Success)) ** GOTO lbl34
                            MyEventViewModel.access$getAnalytics$p(this.this$0).logEventRemoved(this.$event);
                            this.this$0.loadMyEvents();
                            break block7;
lbl34:
                            // 1 sources

                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onDispose() {
        ScreenModel.DefaultImpls.onDispose((ScreenModel)this);
    }

    public static final /* synthetic */ MyEventRepositoryApi access$getMyEventsRepo$p(MyEventViewModel $this) {
        return $this.myEventsRepo;
    }

    public static final /* synthetic */ MutableStateFlow access$get_myEventUiStateFlow$p(MyEventViewModel $this) {
        return $this._myEventUiStateFlow;
    }

    public static final /* synthetic */ SubscriptionTopicsRepositoryApi access$getSubscriptionTopicsRepo$p(MyEventViewModel $this) {
        return $this.subscriptionTopicsRepo;
    }

    public static final /* synthetic */ AnalyticsLogger access$getAnalytics$p(MyEventViewModel $this) {
        return $this.analytics;
    }
}

