/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.DatePickerFormatter;
import androidx.compose.material3.internal.CalendarModel_skikoKt;
import androidx.compose.runtime.Immutable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/compose/material3/DatePickerFormatterImpl;", "Landroidx/compose/material3/DatePickerFormatter;", "yearSelectionSkeleton", "", "selectedDateSkeleton", "selectedDateDescriptionSkeleton", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getYearSelectionSkeleton", "()Ljava/lang/String;", "getSelectedDateSkeleton", "getSelectedDateDescriptionSkeleton", "formatterCache", "", "", "formatMonthYear", "monthMillis", "", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/lang/Long;Ljava/util/Locale;)Ljava/lang/String;", "formatDate", "dateMillis", "forContentDescription", "", "(Ljava/lang/Long;Ljava/util/Locale;Z)Ljava/lang/String;", "equals", "other", "hashCode", "", "material3"})
@Immutable
final class DatePickerFormatterImpl
implements DatePickerFormatter {
    @NotNull
    private final String yearSelectionSkeleton;
    @NotNull
    private final String selectedDateSkeleton;
    @NotNull
    private final String selectedDateDescriptionSkeleton;
    @NotNull
    private final Map<String, Object> formatterCache;

    public DatePickerFormatterImpl(@NotNull String yearSelectionSkeleton, @NotNull String selectedDateSkeleton, @NotNull String selectedDateDescriptionSkeleton) {
        Intrinsics.checkNotNullParameter((Object)yearSelectionSkeleton, (String)"yearSelectionSkeleton");
        Intrinsics.checkNotNullParameter((Object)selectedDateSkeleton, (String)"selectedDateSkeleton");
        Intrinsics.checkNotNullParameter((Object)selectedDateDescriptionSkeleton, (String)"selectedDateDescriptionSkeleton");
        this.yearSelectionSkeleton = yearSelectionSkeleton;
        this.selectedDateSkeleton = selectedDateSkeleton;
        this.selectedDateDescriptionSkeleton = selectedDateDescriptionSkeleton;
        this.formatterCache = new LinkedHashMap();
    }

    @NotNull
    public final String getYearSelectionSkeleton() {
        return this.yearSelectionSkeleton;
    }

    @NotNull
    public final String getSelectedDateSkeleton() {
        return this.selectedDateSkeleton;
    }

    @NotNull
    public final String getSelectedDateDescriptionSkeleton() {
        return this.selectedDateDescriptionSkeleton;
    }

    @Override
    @Nullable
    public String formatMonthYear(@Nullable Long monthMillis, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (monthMillis == null) {
            return null;
        }
        return CalendarModel_skikoKt.formatWithSkeleton(monthMillis, this.yearSelectionSkeleton, locale, this.formatterCache);
    }

    @Override
    @Nullable
    public String formatDate(@Nullable Long dateMillis, @NotNull Locale locale, boolean forContentDescription) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (dateMillis == null) {
            return null;
        }
        return CalendarModel_skikoKt.formatWithSkeleton(dateMillis, forContentDescription ? this.selectedDateDescriptionSkeleton : this.selectedDateSkeleton, locale, this.formatterCache);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DatePickerFormatterImpl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.yearSelectionSkeleton, (Object)((DatePickerFormatterImpl)other).yearSelectionSkeleton)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selectedDateSkeleton, (Object)((DatePickerFormatterImpl)other).selectedDateSkeleton)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.selectedDateDescriptionSkeleton, (Object)((DatePickerFormatterImpl)other).selectedDateDescriptionSkeleton);
    }

    public int hashCode() {
        int result = this.yearSelectionSkeleton.hashCode();
        result = 31 * result + this.selectedDateSkeleton.hashCode();
        result = 31 * result + this.selectedDateDescriptionSkeleton.hashCode();
        return result;
    }
}

