/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.internal.Matrix;
import com.github.ajalt.colormath.internal.MatrixKt;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import com.github.ajalt.colormath.transform.RGBToRGBConverter;
import com.github.ajalt.colormath.transform.RGBToRGBConverterImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"converterTo", "Lcom/github/ajalt/colormath/transform/RGBToRGBConverter;", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "destination", "rgbToRgbMatrix", "Lcom/github/ajalt/colormath/internal/Matrix;", "src", "dst", "(Lcom/github/ajalt/colormath/model/RGBColorSpace;Lcom/github/ajalt/colormath/model/RGBColorSpace;)[F", "colormath"})
public final class RGBToRGBConverterKt {
    @NotNull
    public static final RGBToRGBConverter converterTo(@NotNull RGBColorSpace $this$converterTo, @NotNull RGBColorSpace destination) {
        Intrinsics.checkNotNullParameter((Object)$this$converterTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return new RGBToRGBConverterImpl($this$converterTo, destination, RGBToRGBConverterKt.rgbToRgbMatrix($this$converterTo, destination), null);
    }

    @NotNull
    public static final float[] rgbToRgbMatrix(@NotNull RGBColorSpace src, @NotNull RGBColorSpace dst) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (Intrinsics.areEqual((Object)src.getWhitePoint(), (Object)dst.getWhitePoint())) {
            fArray = MatrixKt.dot-sRJ3GRI(Matrix.constructor-impl(dst.getMatrixFromXyz()), Matrix.constructor-impl(src.getMatrixToXyz()));
        } else {
            float[] adaptation = XYZKt.chromaticAdaptationMatrix-8v-9jzY$default(XYZKt.XYZColorSpace(dst.getWhitePoint()), src.getWhitePoint().getChromaticity(), null, null, 6, null);
            fArray = MatrixKt.dot-sRJ3GRI(MatrixKt.dot-sRJ3GRI(Matrix.constructor-impl(dst.getMatrixFromXyz()), adaptation), Matrix.constructor-impl(src.getMatrixToXyz()));
        }
        return fArray;
    }
}

